/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNet;
import jpcsp.HLE.modules.sceNetAdhocctl;
import jpcsp.HLE.modules.sceWlan;
import jpcsp.Memory;
import jpcsp.hardware.Wlan;
import jpcsp.memory.IntArrayMemory;
import jpcsp.memory.mmio.MMIOHandlerBaseMemoryStick;
import jpcsp.memory.mmio.MMIOHandlerDdr;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlanFirmware;
import jpcsp.network.IWlanAdapter;
import jpcsp.network.WlanAdapterFactory;
import jpcsp.network.accesspoint.AccessPoint;
import jpcsp.network.accesspoint.IAccessPointCallback;
import jpcsp.network.protocols.EtherFrame;
import jpcsp.scheduler.Scheduler;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;

public class MMIOHandlerWlan
extends MMIOHandlerBaseMemoryStick
implements IAccessPointCallback {
    private static final int STATE_VERSION = 0;
    public static final int CMD_GET_HW_SPEC = 3;
    public static final int CMD_EEPROM_UPDATE = 4;
    public static final int CMD_802_11_RESET = 5;
    public static final int CMD_802_11_SCAN = 6;
    public static final int CMD_802_11_GET_LOG = 11;
    public static final int CMD_MAC_MULTICAST_ADR = 16;
    public static final int CMD_802_11_AUTHENTICATE = 17;
    public static final int CMD_UNKNOWN_0012 = 18;
    public static final int CMD_802_11_SET_WEP = 19;
    public static final int CMD_802_11_GET_STAT = 20;
    public static final int CMD_802_3_GET_STAT = 21;
    public static final int CMD_802_11_SNMP_MIB = 22;
    public static final int CMD_MAC_REG_MAP = 23;
    public static final int CMD_BBP_REG_MAP = 24;
    public static final int CMD_MAC_REG_ACCESS = 25;
    public static final int CMD_BBP_REG_ACCESS = 26;
    public static final int CMD_RF_REG_ACCESS = 27;
    public static final int CMD_802_11_RADIO_CONTROL = 28;
    public static final int CMD_802_11_RF_CHANNEL = 29;
    public static final int CMD_802_11_RF_TX_POWER = 30;
    public static final int CMD_802_11_RSSI = 31;
    public static final int CMD_802_11_RF_ANTENNA = 32;
    public static final int CMD_802_11_PS_MODE = 33;
    public static final int CMD_802_11_DATA_RATE = 34;
    public static final int CMD_RF_REG_MAP = 35;
    public static final int CMD_802_11_DEAUTHENTICATE = 36;
    public static final int CMD_802_11_REASSOCIATE = 37;
    public static final int CMD_UNKNOWN_0026 = 38;
    public static final int CMD_MAC_CONTROL = 40;
    public static final int CMD_UNKNOWN_002A = 42;
    public static final int CMD_802_11_AD_HOC_START = 43;
    public static final int CMD_802_11_AD_HOC_JOIN = 44;
    public static final int CMD_802_11_QUERY_TKIP_REPLY_CNTRS = 46;
    public static final int CMD_802_11_ENABLE_RSN = 47;
    public static final int CMD_UNKNOWN_0030 = 48;
    public static final int CMD_UNKNOWN_0032 = 50;
    public static final int CMD_UNKNOWN_0034 = 52;
    public static final int CMD_UNKNOWN_0035 = 53;
    public static final int CMD_802_11_SET_AFC = 60;
    public static final int CMD_802_11_GET_AFC = 61;
    public static final int CMD_802_11_DEEP_SLEEP = 62;
    public static final int CMD_802_11_AD_HOC_STOP = 64;
    public static final int CMD_UNKNOWN_0041 = 65;
    public static final int CMD_UNKNOWN_0042 = 66;
    public static final int CMD_802_11_HOST_SLEEP_CFG = 67;
    public static final int CMD_802_11_WAKEUP_CONFIRM = 68;
    public static final int CMD_802_11_HOST_SLEEP_ACTIVATE = 69;
    public static final int CMD_UNKNOWN_0047 = 71;
    public static final int CMD_802_11_BEACON_STOP = 73;
    public static final int CMD_802_11_MAC_ADDRESS = 77;
    public static final int CMD_802_11_LED_GPIO_CTRL = 78;
    public static final int CMD_802_11_ASSOCIATE = 80;
    public static final int CMD_802_11_BAND_CONFIG = 88;
    public static final int CMD_802_11_EEPROM_ACCESS = 89;
    public static final int CMD_GSPI_BUS_CONFIG = 90;
    public static final int CMD_802_11D_DOMAIN_INFO = 91;
    public static final int CMD_802_11_KEY_MATERIAL = 94;
    public static final int CMD_802_11_SLEEP_PARAMS = 102;
    public static final int CMD_802_11_INACTIVITY_TIMEOUT = 103;
    public static final int CMD_802_11_SLEEP_PERIOD = 104;
    public static final int CMD_802_11_TPC_CFG = 114;
    public static final int CMD_802_11_PA_CFG = 115;
    public static final int CMD_802_11_FW_WAKE_METHOD = 116;
    public static final int CMD_802_11_SUBSCRIBE_EVENT = 117;
    public static final int CMD_802_11_RATE_ADAPT_RATESET = 118;
    public static final int CMD_UNKNOWN_0079 = 121;
    public static final int CMD_UNKNOWN_007A = 122;
    public static final int CMD_UNKNOWN_007B = 123;
    public static final int CMD_UNKNOWN_007C = 124;
    public static final int CMD_UNKNOWN_007D = 125;
    public static final int CMD_802_11_TX_RATE_QUERY = 127;
    public static final int CMD_GET_TSF = 128;
    public static final int CMD_BT_ACCESS = 135;
    public static final int CMD_FWT_ACCESS = 149;
    public static final int CMD_802_11_MONITOR_MODE = 152;
    public static final int CMD_MESH_ACCESS = 155;
    public static final int CMD_MESH_CONFIG_OLD = 163;
    public static final int CMD_MESH_CONFIG = 172;
    public static final int CMD_SET_BOOT2_VER = 165;
    public static final int CMD_FUNC_INIT = 169;
    public static final int CMD_FUNC_SHUTDOWN = 170;
    public static final int CMD_802_11_BEACON_CTRL = 176;
    public static final int RX_RATE_11_MBPS = 3;
    public static final int BSS_TYPE_INFRASTRUCTURE = 1;
    public static final int BSS_TYPE_ADHOC = 2;
    public static final int DATA_ADDRESS_CMD = 256;
    public static final int DATA_ADDRESS_PACKET = 258;
    public static final int WLAN_DDR_FLUSH = 0;
    private static MMIOHandlerWlan instance;
    public static final int BASE_ADDRESS = -1120927744;
    public static final boolean useWlanFirmwareEmulation = false;
    private final IntArrayMemory attributesMemory = new IntArrayMemory(new int[16]);
    private final IntArrayMemory commandPacket = new IntArrayMemory(new int[768]);
    private final TPointer commandPacketPtr = this.commandPacket.getPointer();
    private final IntArrayMemory sendDataPacket = new IntArrayMemory(new int[768]);
    private final TPointer sendDataPacketPtr = this.sendDataPacket.getPointer();
    private final IntArrayMemory receiveDataPacket = new IntArrayMemory(new int[768]);
    private final TPointer receiveDataPacketPtr = this.receiveDataPacket.getPointer();
    private static final int DUMMY_ATTRIBUTE_ENTRY = 4660;
    public static final int WLAN_REG_RECEIVED_PACKET_LENGTH = 64;
    public static final int WLAN_REG_OUTPUT_PACKET_SIZE = 68;
    public static final int WLAN_REG_CMD_RESPONSE_PACKET_LENGTH = 74;
    public static final int WLAN_REG_INPUT_PACKET_SIZE = 76;
    public static final int WLAN_REG_EVENT_INFORMATION = 78;
    public static final int WLAN_REG_RESULT = 84;
    public static final int WLAN_RESULT_READY_TO_SEND_DATA = 1;
    public static final int WLAN_RESULT_DATA_PACKET_RECEIVED = 2;
    public static final int WLAN_RESULT_READY_TO_SEND_COMMAND = 4;
    public static final int WLAN_RESULT_EVENT_RECEIVED = 8;
    public static final int WLAN_RESULT_COMMAND_RESPONSE_AVAILABLE = 16;
    public static final int WLAN_RESULT_UNKNOWN_80 = 128;
    public static final int WLAN_EVENT_UNKNOWN_40 = 64;
    public static final int WLAN_EVENT_GAMEMODE_SEND_MASTER = 128;
    private final byte[] firmwareBootCode = new byte[2152];
    private final byte[] firmwareData = new byte[95228];
    private int firmwareBootCodeIndex;
    private int firmwareDataIndex;
    private boolean booting;
    private boolean adhocStarted;
    private boolean adhocJoined;
    private boolean gameMode;
    private long gameModeEventSendMaster;
    private long gameModeEvent_40;
    private String adhocSsid;
    private AccessPoint accessPoint;
    private IWlanAdapter wlanAdapter;
    private final byte[] otherMacAddress = new byte[6];
    private final byte[] gameModeGroupAddress = new byte[6];
    private final byte[] gameModeMasterAddress = new byte[6];
    private MMIOHandlerWlanFirmware handlerWlanFirmware;

    public static MMIOHandlerWlan getInstance() {
        if (instance == null) {
            instance = new MMIOHandlerWlan(-1120927744);
        }
        return instance;
    }

    private MMIOHandlerWlan(int baseAddress) {
        super(baseAddress);
        this.log = sceWlan.log;
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        stream.readBytes(this.firmwareBootCode);
        stream.readBytes(this.firmwareData);
        this.firmwareDataIndex = stream.readInt();
        this.firmwareBootCodeIndex = stream.readInt();
        this.booting = stream.readBoolean();
        this.adhocStarted = stream.readBoolean();
        this.adhocJoined = stream.readBoolean();
        this.adhocSsid = stream.readString();
        this.attributesMemory.read(stream);
        this.commandPacket.read(stream);
        this.sendDataPacket.read(stream);
        this.receiveDataPacket.read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeBytes(this.firmwareBootCode);
        stream.writeBytes(this.firmwareData);
        stream.writeInt(this.firmwareDataIndex);
        stream.writeInt(this.firmwareBootCodeIndex);
        stream.writeBoolean(this.booting);
        stream.writeBoolean(this.adhocStarted);
        stream.writeBoolean(this.adhocJoined);
        stream.writeString(this.adhocSsid);
        this.attributesMemory.write(stream);
        this.commandPacket.write(stream);
        this.sendDataPacket.write(stream);
        this.receiveDataPacket.write(stream);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.attributesMemory.writeUnsigned16(0, 17);
        this.attributesMemory.writeUnsigned16(2, 1);
        this.attributesMemory.writeUnsigned16(4, 1);
        for (int i = 1; i < 8; ++i) {
            int offset = i * 8;
            this.attributesMemory.writeUnsigned16(offset + 0, i);
            this.attributesMemory.writeUnsigned16(offset + 2, 4660);
            this.attributesMemory.writeUnsigned16(offset + 4, 64);
        }
        MMIOHandlerWlan.swapData32(this.attributesMemory, 0, 64);
        this.registers[4] = 1;
        this.registers[16] = 128;
        this.setRegisterValue(34, 36);
        this.commandPacketPtr.clear(this.commandPacket.getSize());
        this.sendDataPacketPtr.clear(this.sendDataPacket.getSize());
        this.receiveDataPacketPtr.clear(this.receiveDataPacket.getSize());
        this.firmwareDataIndex = -1;
        this.firmwareBootCodeIndex = 0;
        this.booting = true;
    }

    private void createAccessPoint() {
        if (this.accessPoint == null) {
            this.accessPoint = new AccessPoint(this);
        }
    }

    public IWlanAdapter getWlanAdapter() {
        return this.wlanAdapter;
    }

    private void createNetworkAdapter() {
        if (this.wlanAdapter == null) {
            this.wlanAdapter = WlanAdapterFactory.createWlanAdapter();
            try {
                this.wlanAdapter.start();
            }
            catch (IOException e) {
                this.log.error((Object)"createNetworkAdapter", (Throwable)e);
            }
        }
    }

    public String getSsid() {
        return this.adhocSsid;
    }

    private void setSsid(String ssid) {
        this.adhocSsid = ssid;
        if (ssid != null) {
            String groupName;
            String productId;
            int productType;
            Pattern p = Pattern.compile("PSP_([AXS])(.........)_([LG])_(.*)");
            Matcher m = p.matcher(ssid);
            if (m.matches()) {
                switch (m.group(1)) {
                    case "A": {
                        productType = 0;
                        break;
                    }
                    case "X": {
                        productType = 1;
                        break;
                    }
                    case "S": {
                        productType = 2;
                        break;
                    }
                    default: {
                        this.log.error((Object)String.format("Unknown product type '%s' in SSID='%s'", m.group(1), ssid));
                        return;
                    }
                }
                productId = m.group(2);
                this.gameMode = "G".equals(m.group(3));
                groupName = m.group(4);
            } else {
                productType = 2;
                productId = "000000001";
                this.gameMode = false;
                groupName = ssid;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("productId=%s, productType=%d, gameMode=%b, groupName=%s", productId, productType, this.gameMode, groupName));
            }
            Modules.sceNetAdhocctlModule.setGroupName(groupName, this.gameMode ? 1 : 0);
        } else {
            Modules.sceNetAdhocctlModule.setGroupName(null, -1);
        }
    }

    private static int swap32(int value) {
        return value >>> 16 | value << 16;
    }

    private static void swapData32(Memory mem, int address, int length) {
        for (int i = 0; i < length; i += 4) {
            mem.write32(address + i, MMIOHandlerWlan.swap32(mem.read32(address + i)));
        }
    }

    @Override
    protected void initMsproAttributeMemory() {
        this.log.error((Object)String.format("MMIOHandlerWlan.initMsproAttributeMemory not supported", new Object[0]));
    }

    @Override
    protected int getInterruptNumber() {
        return 8;
    }

    @Override
    protected int getInterruptBit() {
        return 112;
    }

    private boolean hasPendingResult() {
        return this.hasResultFlag(31);
    }

    private void checkResultInterrupt() {
        if (this.hasPendingResult()) {
            this.setInterrupt();
        }
    }

    @Override
    protected int getStatus() {
        int status = super.getStatus();
        if (this.hasInterrupt() && (status & 0xF) == 8 && this.hasPendingResult()) {
            status = Utilities.setFlag(status, 2);
        }
        return status;
    }

    private void addResultFlag(int flag) {
        if (!this.hasResultFlag(flag)) {
            this.registers[84] = this.registers[84] | flag;
            this.checkResultInterrupt();
        }
    }

    private void clearResultFlag(int flag) {
        if (this.hasResultFlag(flag)) {
            this.registers[84] = this.registers[84] & ~flag;
            this.checkResultInterrupt();
        }
    }

    private boolean hasResultFlag(int flag) {
        return Utilities.hasFlag(this.registers[84], flag);
    }

    private void setCardEvent(int cardEvent) {
        cardEvent &= 0xFF;
        if (this.hasResultFlag(8)) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("setCardEvent ignoring 0x%02X", cardEvent));
            }
        } else {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)String.format("setCardEvent 0x%02X", cardEvent));
            }
            this.setRegisterValue(78, 4, 0x10 | cardEvent << 8);
            this.addResultFlag(8);
            this.setInterrupt();
        }
    }

    private int getWlanOutputPacketSize() {
        return this.getRegisterValue(68, 2);
    }

    private void setWlanInputPacketSize(int inputPacketSize) {
        this.setRegisterValue(76, 2, inputPacketSize);
    }

    public byte[] getGameModeGroupAddress() {
        return this.gameModeGroupAddress;
    }

    public byte[] getGameModeMasterAddress() {
        return this.gameModeMasterAddress;
    }

    public boolean isGameModeMaster() {
        return pspNetMacAddress.isMyMacAddress(this.gameModeMasterAddress);
    }

    private void memcpyToFirmware(int dest, TPointer src, int length) {
        Memory firmwareMemory = this.handlerWlanFirmware.getMemory();
        if (((src.getAddress() | dest | length) & 3) == 0) {
            for (int i = 0; i < length; i += 4) {
                firmwareMemory.write32(dest + i, src.getValue32(i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                firmwareMemory.write8(dest + i, src.getValue8(i));
            }
        }
    }

    private void memcpyFromFirmware(TPointer dest, int src, int length) {
        Memory firmwareMemory = this.handlerWlanFirmware.getMemory();
        if (((dest.getAddress() | src | length) & 3) == 0) {
            for (int i = 0; i < length; i += 4) {
                dest.setValue32(i, firmwareMemory.read32(src + i));
            }
        } else {
            for (int i = 0; i < length; ++i) {
                dest.setUnsignedValue8(i, firmwareMemory.read8(src + i));
            }
        }
    }

    private void sendGameModeEvents() {
        if (!this.gameMode) {
            return;
        }
        long now = Scheduler.getNow();
        if (this.gameModeEvent_40 != 0L) {
            if (now >= this.gameModeEvent_40) {
                this.setCardEvent(64);
                this.gameModeEventSendMaster = now + 1000L;
                this.gameModeEvent_40 = 0L;
            }
        } else if (this.gameModeEventSendMaster != 0L && now >= this.gameModeEventSendMaster) {
            this.setCardEvent(128);
            if (!this.isGameModeMaster()) {
                // empty if block
            }
            this.gameModeEvent_40 = now + 26000L;
        }
    }

    private void checkWlanFirmwareResult() {
        int commandResponseLength;
        if (!this.hasResultFlag(16) && (commandResponseLength = this.handlerWlanFirmware.getLengthE810()) > 0) {
            int commandResponseAddr = this.handlerWlanFirmware.getAddrE810();
            this.memcpyFromFirmware(this.commandPacketPtr, commandResponseAddr, commandResponseLength);
            this.handlerWlanFirmware.clearLengthE810();
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("checkWlanFirmwareResult response cmd=0x%X, length=0x%X, resultCode=0x%X: %s", this.commandPacket.read16(0) & Short.MAX_VALUE, commandResponseLength, this.commandPacket.read16(6), Utilities.getMemoryDump(this.commandPacket, 0, commandResponseLength)));
            }
            this.setRegisterValue(74, 2, Utilities.alignUp(commandResponseLength, 7));
            Utilities.endianSwap32(this.commandPacket, 0, commandResponseLength);
            this.addResultFlag(16);
        }
    }

    @Override
    protected int getRegisterValue(int register) {
        switch (register) {
            case 74: {
                if (!this.booting) break;
                this.setRegisterValue(74, 4, Utilities.endianSwap32(1179993941));
                this.firmwareDataIndex = -1;
                this.booting = false;
                break;
            }
            case 84: {
                this.receiveMessage();
                this.sendGameModeEvents();
            }
        }
        return super.getRegisterValue(register);
    }

    @Override
    protected void setRegisterValue(int register, int value) {
        switch (register) {
            case 84: {
                this.clearResultFlag(~value);
                break;
            }
            default: {
                super.setRegisterValue(register, value);
            }
        }
        switch (register) {
            case 86: {
                this.addResultFlag(4);
                break;
            }
            case 94: {
                if (Utilities.hasFlag(value, 128)) {
                    this.addResultFlag(128);
                    break;
                }
                this.clearResultFlag(128);
            }
        }
    }

    @Override
    protected int readData16(int dataAddress, int dataIndex, boolean endOfCommand) {
        int value = 0;
        block0 : switch (this.cmd) {
            case 178: {
                if (dataAddress == 0 && dataIndex < this.attributesMemory.getSize()) {
                    value = this.attributesMemory.read16(dataIndex);
                    break;
                }
                if (dataAddress == 4660) {
                    value = 0;
                    break;
                }
                this.log.error((Object)String.format("MMIOHandlerWlan.readData16 unimplemented cmd=0x%X(%s), dataAddress=0x%X, dataIndex=0x%X", this.cmd, MMIOHandlerWlan.getCommandName(this.cmd), dataAddress, dataIndex));
                break;
            }
            case 179: {
                value = this.getReceivePacket(dataAddress).read16(dataIndex);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("MMIOHandlerWlan.readData16 MSPRO_CMD_IN_IO_FIFO, dataAddress=0x%X, dataIndex=0x%X, endOfCommand=%b, value=0x%04X", dataAddress, dataIndex, endOfCommand, value));
                }
                if (!endOfCommand) break;
                switch (dataAddress) {
                    case 256: {
                        if (this.log.isTraceEnabled()) {
                            int bufferLength = dataIndex + 2;
                            byte[] buffer = this.commandPacketPtr.getArray8(bufferLength);
                            Utilities.endianSwap32(buffer, 0, bufferLength);
                            this.log.trace((Object)String.format("MMIOHandlerWlan.readData16 finished reading command packet: %s", Utilities.getMemoryDump(buffer, 0, bufferLength)));
                        }
                        this.clearResultFlag(16);
                        this.addResultFlag(4);
                        break block0;
                    }
                    case 258: {
                        if (this.log.isTraceEnabled()) {
                            int bufferLength = dataIndex + 2;
                            byte[] buffer = this.receiveDataPacketPtr.getArray8(bufferLength);
                            Utilities.endianSwap32(buffer, 0, bufferLength);
                            this.log.trace((Object)String.format("MMIOHandlerWlan.readData16 finished reading data packet: %s", Utilities.getMemoryDump(buffer, 0, bufferLength)));
                        }
                        this.clearResultFlag(2);
                        break block0;
                    }
                }
                this.log.error((Object)String.format("MMIOHandlerWlan.readData16 unimplemented dataAddress=0x%X", dataAddress));
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerWlan.readData16 unimplemented cmd=0x%X(%s), dataAddress=0x%X, dataIndex=0x%X", this.cmd, MMIOHandlerWlan.getCommandName(this.cmd), dataAddress, dataIndex));
            }
        }
        return value;
    }

    @Override
    protected void readPageBuffer() {
        this.log.error((Object)String.format("MMIOHandlerWlan.readPageBuffer unimplemented", new Object[0]));
    }

    @Override
    protected void writePageBuffer() {
        this.log.error((Object)String.format("MMIOHandlerWlan.writePageBuffer unimplemented", new Object[0]));
    }

    private void sendCommandResponse(int size) {
        int cmd = this.commandPacket.read16(0);
        this.commandPacket.writeUnsigned16(0, cmd | 0x8000);
        this.setRegisterValue(74, 2, Utilities.alignUp(size, 7));
        Utilities.endianSwap32(this.commandPacket, 0, size);
        this.addResultFlag(16);
    }

    private boolean isForMe(byte[] destMacAddress, int destMacAddressOffset, byte[] fromMacAddress, int fromMacAddressOffset) {
        if (pspNetMacAddress.isMyMacAddress(fromMacAddress, fromMacAddressOffset)) {
            return false;
        }
        if (pspNetMacAddress.isMulticastMacAddress(destMacAddress, destMacAddressOffset)) {
            if (pspNetMacAddress.isAnyMacAddress(destMacAddress, destMacAddressOffset)) {
                return true;
            }
            return pspNetMacAddress.equals(this.gameModeGroupAddress, 0, destMacAddress, destMacAddressOffset);
        }
        return pspNetMacAddress.isMyMacAddress(destMacAddress, destMacAddressOffset);
    }

    private void receiveMessage() {
        int totalDataPacketLength;
        int receivedMessageLength;
        if (this.wlanAdapter == null) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("receiveMessage no wlanAdapter", new Object[0]));
            }
            return;
        }
        if (this.hasResultFlag(2)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("receiveMessage data packet already received", new Object[0]));
            }
            return;
        }
        byte[] receivedMessage = new byte[10000];
        try {
            receivedMessageLength = this.wlanAdapter.receiveWlanPacket(receivedMessage, 0, receivedMessage.length);
        }
        catch (IOException e) {
            this.log.error((Object)"receiveMessage", (Throwable)e);
            return;
        }
        if (receivedMessageLength < 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("receiveMessage no message available", new Object[0]));
            }
            return;
        }
        if (receivedMessageLength < 12 || !this.isForMe(receivedMessage, 0, receivedMessage, 6)) {
            if (this.log.isDebugEnabled()) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace((Object)String.format("Received message not for me: %s", Utilities.getMemoryDump(receivedMessage, 0, receivedMessageLength)));
                } else {
                    this.log.debug((Object)String.format("Received message not for me: destMacAddress=%s, sourceMacAddress=%s", pspNetMacAddress.toString(receivedMessage, 0), pspNetMacAddress.toString(receivedMessage, 6)));
                }
            }
            return;
        }
        if (this.log.isDebugEnabled() && receivedMessageLength >= 18 && Utilities.endianSwap16(Utilities.readUnaligned16(receivedMessage, 12)) == 35016) {
            int subtype = Utilities.endianSwap16(Utilities.readUnaligned16(receivedMessage, 14));
            if (subtype == 1) {
                int controlType = Utilities.read8(receivedMessage, 17);
                this.log.debug((Object)String.format("Receiving Control packet controlType=%d", controlType));
            } else if (subtype == 2) {
                this.log.debug((Object)String.format("Receiving Data packet", new Object[0]));
            }
        }
        if (Utilities.memcmp(receivedMessage, 6, Wlan.getMacAddress(), 0, 6) != 0) {
            System.arraycopy(receivedMessage, 6, this.otherMacAddress, 0, 6);
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("receiveMessage received message: %s", Utilities.getMemoryDump(receivedMessage, 0, receivedMessageLength)));
        }
        if (pspNetMacAddress.equals(receivedMessage, this.gameModeGroupAddress)) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("Identified packet sent to GameMode Group Address %s", sceNet.convertMacAddressToString(this.gameModeGroupAddress)));
            }
            totalDataPacketLength = receivedMessageLength + 28;
            this.receiveDataPacket.writeUnsigned16(0, 1283);
            this.receiveDataPacket.write8(2, (byte)0);
            this.receiveDataPacket.write8(3, (byte)0);
            this.receiveDataPacket.writeUnsigned16(4, receivedMessageLength + 12);
            this.receiveDataPacketPtr.clear(6, 10);
            this.receiveDataPacket.writeUnsigned16(16, receivedMessageLength + 8);
            this.receiveDataPacket.writeUnsigned16(18, 1);
            this.receiveDataPacketPtr.setArray(20, receivedMessage, 0, 12);
            this.receiveDataPacket.writeUnsigned16(32, 2561);
            this.receiveDataPacket.writeUnsigned16(34, 43690);
            this.receiveDataPacket.write32(36, 3);
            this.receiveDataPacketPtr.setArray(40, receivedMessage, 12, receivedMessageLength - 12);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("processReceiveDataPacket GameMode totalDataPacketLength=0x%X, data:%s", totalDataPacketLength, Utilities.getMemoryDump(this.receiveDataPacket, 0, totalDataPacketLength)));
            }
        } else {
            int rxPacketLocation = 24;
            totalDataPacketLength = 24 + receivedMessageLength;
            int rxStatus = 0;
            int signalToNoiseRatio = 0;
            int rxControl = 0;
            int rxPacketLength = receivedMessageLength;
            int noiseFloor = 0;
            int rxRate = 3;
            int reserved1 = 0;
            int priority = 0;
            int reserved2 = 0;
            int reserved3 = 0;
            this.receiveDataPacket.writeUnsigned16(0, rxStatus);
            this.receiveDataPacket.write8(2, (byte)signalToNoiseRatio);
            this.receiveDataPacket.write8(3, (byte)rxControl);
            this.receiveDataPacket.writeUnsigned16(4, rxPacketLength);
            this.receiveDataPacket.write8(6, (byte)noiseFloor);
            this.receiveDataPacket.write8(7, (byte)rxRate);
            this.receiveDataPacket.write32(8, 24);
            this.receiveDataPacket.write32(12, reserved1);
            this.receiveDataPacket.write8(16, (byte)priority);
            this.receiveDataPacket.write8(17, (byte)reserved2);
            this.receiveDataPacket.writeUnsigned16(18, reserved3);
            this.receiveDataPacketPtr.clear(20, 4);
            this.receiveDataPacketPtr.setArray(24, receivedMessage, 0, receivedMessageLength);
            this.receiveDataPacketPtr.setArray(16, receivedMessage, 0, 12);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("processReceiveDataPacket totalDataPacketLength=0x%X, rxStatus=0x%X, SNR=0x%X, rxControl=0x%X, rxPacketLength=0x%X, NF=0x%X, rxRate=0x%X, rxPacketLocation=0x%X, reserved1=0x%X, priority=0x%X, reserved2=0x%X, reserved3=0x%X, data:%s", totalDataPacketLength, rxStatus, signalToNoiseRatio, rxControl, rxPacketLength, noiseFloor, rxRate, 24, reserved1, priority, reserved2, reserved3, Utilities.getMemoryDump(this.receiveDataPacket, 24, rxPacketLength)));
            }
        }
        this.processReceiveDataPacket(totalDataPacketLength);
    }

    private void sendAdhocDataPacket(byte[] buffer, int bufferLength) {
        if (this.log.isDebugEnabled() && bufferLength >= 18 && Utilities.endianSwap16(Utilities.readUnaligned16(buffer, 12)) == 35016) {
            int subtype = Utilities.endianSwap16(Utilities.readUnaligned16(buffer, 14));
            if (subtype == 1) {
                int controlType = Utilities.read8(buffer, 17);
                this.log.debug((Object)String.format("Sending Control packet controlType=%d", controlType));
            } else if (subtype == 2) {
                this.log.debug((Object)String.format("Sending Data packet", new Object[0]));
            }
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("sendAdhocDataPacket %s", Utilities.getMemoryDump(buffer, 0, bufferLength)));
        }
        try {
            this.wlanAdapter.sendWlanPacket(buffer, 0, bufferLength);
        }
        catch (IOException e) {
            this.log.error((Object)"sendAdhocDataPacket", (Throwable)e);
        }
    }

    private void sendDataPacketToAccessPoint(byte[] txPacket, int txPacketLength) {
        this.createAccessPoint();
        byte[] buffer = new byte[txPacketLength + 1 + 32];
        int offset = 0;
        buffer[offset] = 0;
        ++offset;
        System.arraycopy(txPacket, 0, buffer, offset += 32, txPacketLength);
        int bufferLength = offset += txPacketLength;
        try {
            this.wlanAdapter.sendAccessPointPacket(buffer, 0, bufferLength, null);
        }
        catch (IOException e) {
            this.log.error((Object)"sendDataPacketToAccessPoint", (Throwable)e);
        }
    }

    private void processTransmitDataPacket(int size) {
        int txStatus = this.sendDataPacket.read32(0);
        int txControl = this.sendDataPacket.read32(4);
        int txPacketLocation = this.sendDataPacket.read32(8);
        int txPacketLength = this.sendDataPacket.read16(12);
        pspNetMacAddress txDestAddr = new pspNetMacAddress();
        txDestAddr.read(this.sendDataPacket, 14);
        int priority = this.sendDataPacket.read8(20);
        int flags = this.sendDataPacket.read8(21);
        int reserved = this.sendDataPacket.read16(22);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("processTransmitDataPacket size=0x%X, txStatus=0x%X, txControl=0x%X, txPacketLocation=0x%X, txPacketLength=0x%X, txDestAddr=%s, priority=0x%X, flags=0x%X, reserved=0x%X, data:%s", size, txStatus, txControl, txPacketLocation, txPacketLength, txDestAddr, priority, flags, reserved, Utilities.getMemoryDump(this.sendDataPacket, txPacketLocation, txPacketLength)));
        }
        byte[] txPacket = this.sendDataPacketPtr.getArray8(txPacketLocation, txPacketLength);
        if (this.adhocStarted || this.adhocJoined) {
            this.sendAdhocDataPacket(txPacket, txPacketLength);
        } else {
            this.sendDataPacketToAccessPoint(txPacket, txPacketLength);
        }
        this.addResultFlag(1);
    }

    private void processReceiveDataPacket(int size) {
        this.setRegisterValue(64, 2, size);
        Utilities.endianSwap32(this.receiveDataPacket, 0, size);
        this.addResultFlag(2);
    }

    private void processCommandPacket(int size) {
        int cmd = this.commandPacket.read16(0);
        int bodySize = this.commandPacket.read16(2);
        int sequenceNumber = this.commandPacket.read16(4);
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("processCommandPacket cmd=0x%X, bodySize=0x%X, sequenceNumber=0x%X, %s", cmd, bodySize, sequenceNumber, Utilities.getMemoryDump(this.commandPacket, 0, size)));
        }
        int resultCode = 0;
        int responseSize = Math.min(size, bodySize);
        switch (cmd) {
            case 3: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_GET_HW_SPEC bodySize=0x%X", bodySize));
                }
                this.commandPacket.writeUnsigned16(8, 0);
                this.commandPacket.writeUnsigned16(10, 0);
                this.commandPacket.writeUnsigned16(12, 0);
                this.commandPacket.writeUnsigned16(14, 1);
                this.commandPacketPtr.setArray(16, Wlan.getMacAddress());
                this.commandPacket.writeUnsigned16(22, 0);
                this.commandPacket.writeUnsigned16(24, 0);
                Utilities.writeUnaligned32(this.commandPacket, 26, 0x1000000);
                Utilities.writeUnaligned32(this.commandPacket, 42, 0);
                responseSize = Math.min(size, bodySize + 2);
                break;
            }
            case 32: {
                int action = this.commandPacket.read16(8);
                int antennaNumber = this.commandPacket.read16(10);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_RF_ANTENNA bodySize=0x%X, action=0x%X, antennaNumber=0x%X", bodySize, action, antennaNumber));
                }
                if (action == 1 && antennaNumber == 1 || action == 2 && antennaNumber == 1) break;
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_RF_ANTENNA unimplemented action=0x%X, antennaNumber=0x%X", action, antennaNumber));
                resultCode = -1;
                break;
            }
            case 28: {
                int action = this.commandPacket.read16(8);
                int control = this.commandPacket.read16(10);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_RADIO_CONTROL bodySize=0x%X, action=0x%X, control=0x%X", bodySize, action, control));
                }
                if (action == 1 && (control == 1 || control == 3)) break;
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_RADIO_CONTROL unimplemented action=0x%X, control=0x%X", action, control));
                resultCode = -1;
                break;
            }
            case 30: {
                int action = this.commandPacket.read16(8);
                int currentPowerLevel = this.commandPacket.read16(10);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_RF_TX_POWER bodySize=0x%X, action=0x%X, currentPowerLevel=0x%X", bodySize, action, currentPowerLevel));
                }
                if (action == 1 && currentPowerLevel == 10) {
                    this.commandPacket.write8(12, (byte)20);
                    this.commandPacket.write8(13, (byte)0);
                    break;
                }
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_RF_TX_POWER unimplemented action=0x%X, currentPowerLevel=0x%X", action, currentPowerLevel));
                resultCode = -1;
                break;
            }
            case 34: {
                int action = this.commandPacket.read16(8);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_DATA_RATE bodySize=0x%X, action=0x%X", bodySize, action));
                }
                if (action == 0) {
                    this.commandPacket.write8(12, (byte)1);
                    this.commandPacket.write8(12, (byte)0);
                    break;
                }
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_DATA_RATE unimplemented action=0x%X", action));
                resultCode = -1;
                break;
            }
            case 22: {
                int action = this.commandPacket.read16(8);
                int oid = this.commandPacket.read16(10);
                int oidValueSize = this.commandPacket.read16(12);
                if (action == 1 && oid == 5 && oidValueSize == 2) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SNMP_MIB set RTS Threshold=%d", this.commandPacket.read16(14)));
                    break;
                }
                if (action == 1 && oid == 6 && oidValueSize == 2) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SNMP_MIB set Short Retry Limit=%d", this.commandPacket.read16(14)));
                    break;
                }
                if (action == 1 && oid == 8 && oidValueSize == 2) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SNMP_MIB set Fragment Threshold=%d", this.commandPacket.read16(14)));
                    break;
                }
                if (action == 1 && oid == 0 && oidValueSize == 1) {
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SNMP_MIB set Desired BSS Type=0x%X", this.commandPacket.read8(14)));
                    break;
                }
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_SNMP_MIB unimplemented action=0x%X, oid=0x%X, oidValueSize=0x%X, %s", action, Utilities.getMemoryDump(this.commandPacket, 0, size)));
                resultCode = -1;
                break;
            }
            case 122: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_UNKNOWN_007A bodySize=0x%X, %s", bodySize, Utilities.getMemoryDump(this.commandPacket, 0, size)));
                break;
            }
            case 40: {
                boolean wepType104;
                int action = this.commandPacket.read16(8);
                boolean rxOn = (action & 1) != 0;
                boolean txOn = (action & 2) != 0;
                boolean wepOn = (action & 8) != 0;
                boolean unknown20 = (action & 0x20) != 0;
                boolean unknown40 = (action & 0x40) != 0;
                boolean promiscousOn = (action & 0x80) != 0;
                boolean multicastOn = (action & 0x100) != 0;
                boolean enableProtection = (action & 0x400) != 0;
                boolean enableWMM = (action & 0x800) != 0;
                boolean bl = wepType104 = (action & 0x8000) != 0;
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_MAC_CONTROL bodySize=0x%X, action=0x%X, rxOn=%b, txOn=%b, wepOn=%b, unknown20=%b, unknown40=%b, promiscousOn=%b, multicastOn=%b, enableProtection=%b, enableWMM=%b, wepType104=%b", bodySize, action, rxOn, txOn, wepOn, unknown20, unknown40, promiscousOn, multicastOn, enableProtection, enableWMM, wepType104));
                break;
            }
            case 6: {
                int n;
                int bssType = this.commandPacket.read8(10);
                pspNetMacAddress macAddressFilter = new pspNetMacAddress();
                macAddressFilter.read(this.commandPacket, 11);
                String ssid = null;
                int[] channels = null;
                if (bssType == 2) {
                    int channel;
                    ssid = this.commandPacketPtr.getStringNZ(17, 32);
                    for (int i = 0; i < 14 && (channel = this.commandPacketPtr.getUnsignedValue8(52 + i)) != 0; ++i) {
                        channels = Utilities.add(channels, channel);
                    }
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SCAN bodySize=0x%X, bssType=0x%X, macAddressFilter=%s, channels=%s, unknown=%s", bodySize, bssType, macAddressFilter, channels, Utilities.getMemoryDump(this.commandPacket, 17, size - 17)));
                }
                this.commandPacketPtr.clear(11, 21);
                int count = 0;
                List<sceNetAdhocctl.AdhocctlNetwork> networks = null;
                List<sceNetAdhocctl.AdhocctlPeer> peers = null;
                switch (bssType) {
                    case 1: {
                        count = 2;
                        break;
                    }
                    case 2: {
                        this.createNetworkAdapter();
                        if (!this.adhocStarted && !this.adhocJoined) {
                            try {
                                this.wlanAdapter.wlanScan(ssid, channels);
                            }
                            catch (IOException e) {
                                this.log.error((Object)"CMD_802_11_SCAN", (Throwable)e);
                            }
                            networks = Modules.sceNetAdhocctlModule.getNetworks();
                            count = networks.size();
                            if (pspNetMacAddress.isEmptyMacAddress(this.otherMacAddress)) break;
                            ++count;
                            break;
                        }
                        peers = Modules.sceNetAdhocctlModule.getPeers();
                        count = peers.size();
                    }
                }
                this.commandPacketPtr.setUnsignedValue8(32, count);
                int offset = 33;
                int rssi = 40;
                boolean channel = true;
                byte[] ibss = null;
                for (n = 0; n < count; ++n) {
                    this.commandPacketPtr.setValue8(14 + n, (byte)40);
                    int capabilities = 32;
                    switch (bssType) {
                        case 1: {
                            capabilities |= 1;
                            ibss = String.format("Jpcsp%d", n).getBytes();
                            ssid = String.format("Jpcsp SSID %d", n + 1);
                            break;
                        }
                        case 2: {
                            capabilities |= 2;
                            if (networks != null) {
                                if (n >= networks.size()) {
                                    ibss = this.otherMacAddress;
                                    if (!this.log.isDebugEnabled()) break;
                                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SCAN returning other PSP MAC address: %s", sceNet.convertMacAddressToString(ibss)));
                                    break;
                                }
                                if (this.log.isDebugEnabled()) {
                                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SCAN returning network#%d: %s", n, networks.get(n)));
                                }
                                ibss = networks.get((int)n).ibss;
                                ssid = networks.get((int)n).ssid;
                                break;
                            }
                            if (n >= peers.size()) {
                                ibss = Wlan.getMacAddress();
                                if (!this.log.isDebugEnabled()) break;
                                this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SCAN returning myself: %s", sceNet.convertMacAddressToString(ibss)));
                                break;
                            }
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SCAN returning peer#%d: %s", n, peers.get(n)));
                            }
                            ibss = peers.get((int)n).macAddress;
                        }
                    }
                    this.commandPacketPtr.setArray(offset + 2, ibss, 6);
                    long packetTimestamp = 0L;
                    this.commandPacketPtr.setUnalignedValue64(offset + 8, packetTimestamp);
                    int beaconInterval = 100;
                    this.commandPacketPtr.setUnalignedValue16(offset + 16, beaconInterval);
                    this.commandPacketPtr.setUnalignedValue16(offset + 18, capabilities);
                    int params = offset + 20;
                    if (bssType == 1) {
                        this.commandPacketPtr.setUnsignedValue8(params + 0, 2);
                        this.commandPacketPtr.setUnsignedValue8(params + 1, 5);
                        this.commandPacketPtr.setUnalignedValue16(params + 2, 0);
                        this.commandPacketPtr.setUnsignedValue8(params + 4, 0);
                        this.commandPacketPtr.setUnsignedValue8(params + 5, 0);
                        this.commandPacketPtr.setUnsignedValue8(params + 6, 0);
                        params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    }
                    this.commandPacketPtr.setUnsignedValue8(params + 0, 3);
                    this.commandPacketPtr.setUnsignedValue8(params + 1, 1);
                    this.commandPacketPtr.setUnsignedValue8(params + 2, 1);
                    params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    int ssidLength = ssid == null ? 0 : ssid.length();
                    this.commandPacketPtr.setUnsignedValue8(params + 0, 0);
                    this.commandPacketPtr.setUnsignedValue8(params + 1, ssidLength);
                    this.commandPacketPtr.setStringNZ(params + 2, ssidLength, ssid);
                    params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    int[] rates = new int[]{130, 132, 11, 22};
                    this.commandPacketPtr.setUnsignedValue8(params + 0, 1);
                    this.commandPacketPtr.setUnsignedValue8(params + 1, rates.length);
                    for (int i = 0; i < rates.length; ++i) {
                        this.commandPacketPtr.setUnsignedValue8(params + 2 + i, rates[i]);
                    }
                    params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    if (bssType == 1) {
                        int[] extendedRates = new int[]{12, 18};
                        this.commandPacketPtr.setUnsignedValue8(params + 0, 50);
                        this.commandPacketPtr.setUnsignedValue8(params + 1, extendedRates.length);
                        for (int i = 0; i < extendedRates.length; ++i) {
                            this.commandPacketPtr.setUnsignedValue8(params + 2 + i, extendedRates[i]);
                        }
                        params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    }
                    this.commandPacketPtr.setUnsignedValue8(params + 0, 6);
                    this.commandPacketPtr.setUnsignedValue8(params + 1, 2);
                    this.commandPacketPtr.setUnalignedValue16(params + 2, 0);
                    params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    if (bssType == 1) {
                        this.commandPacketPtr.setUnsignedValue8(params + 0, 48);
                        this.commandPacketPtr.setUnsignedValue8(params + 1, 18);
                        this.commandPacketPtr.setUnalignedValue16(params + 2, 1);
                        this.commandPacketPtr.setUnsignedValue8(params + 4, 0);
                        this.commandPacketPtr.setUnsignedValue8(params + 5, 15);
                        this.commandPacketPtr.setUnsignedValue8(params + 6, 172);
                        this.commandPacketPtr.setUnsignedValue8(params + 7, 5);
                        this.commandPacketPtr.setUnalignedValue16(params + 8, 1);
                        this.commandPacketPtr.setUnsignedValue8(params + 10, 0);
                        this.commandPacketPtr.setUnsignedValue8(params + 11, 15);
                        this.commandPacketPtr.setUnsignedValue8(params + 12, 172);
                        this.commandPacketPtr.setUnsignedValue8(params + 13, 5);
                        this.commandPacketPtr.setUnalignedValue16(params + 14, 1);
                        this.commandPacketPtr.setUnsignedValue8(params + 16, 0);
                        this.commandPacketPtr.setUnsignedValue8(params + 17, 15);
                        this.commandPacketPtr.setUnsignedValue8(params + 18, 172);
                        this.commandPacketPtr.setUnsignedValue8(params + 19, 5);
                        params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                        this.commandPacketPtr.setUnsignedValue8(params + 0, 221);
                        this.commandPacketPtr.setUnsignedValue8(params + 1, 22);
                        this.commandPacketPtr.setArray(params + 2, new byte[]{0, 80, -14, 1});
                        this.commandPacketPtr.setUnalignedValue16(params + 6, 0);
                        this.commandPacketPtr.setArray(params + 8, new byte[]{0, 80, -14, 1});
                        this.commandPacketPtr.setUnalignedValue16(params + 12, 1);
                        this.commandPacketPtr.setArray(params + 14, new byte[]{0, 80, -14, 2});
                        this.commandPacketPtr.setUnalignedValue16(params + 18, 1);
                        this.commandPacketPtr.setArray(params + 20, new byte[]{0, 80, -14, 1});
                        params += 2 + this.commandPacketPtr.getUnsignedValue8(params + 1);
                    }
                    this.commandPacketPtr.setUnalignedValue16(offset + 0, params - offset - 2);
                    offset = params;
                }
                for (n = 0; n < count; ++n) {
                    long tsfTimestamp = 0L;
                    this.commandPacketPtr.setUnalignedValue64(offset, tsfTimestamp);
                    offset += 8;
                }
                this.commandPacketPtr.setUnalignedValue16(30, offset - 33);
                responseSize = offset;
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SCAN response: %s", Utilities.getMemoryDump(this.commandPacket, 0, responseSize)));
                break;
            }
            case 29: {
                int action = this.commandPacket.read16(8);
                int channelNumber = this.commandPacket.read16(10);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_RF_CHANNEL bodySize=0x%X, action=0x%X, channelNumber=0x%X", bodySize, action, channelNumber));
                }
                if (action == 1 && (channelNumber == 1 || channelNumber == 11)) break;
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_RF_CHANNEL unimplemented action=0x%X, channelNumber=0x%X", action, channelNumber));
                resultCode = -1;
                break;
            }
            case 19: {
                int action = this.commandPacket.read16(8);
                int transmitKeyIndex = this.commandPacket.read16(10);
                int[] keyWepTypes = new int[4];
                byte[][] keyWep = new byte[4][16];
                for (int i = 0; i < 4; ++i) {
                    keyWepTypes[i] = this.commandPacketPtr.getUnsignedValue8(12 + i);
                    keyWep[i] = this.commandPacketPtr.getArray8(16 + i * 16, 16);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_SET_WEP bodySize=0x%X, action=0x%X, transmitKeyIndex=0x%X", bodySize, action, transmitKeyIndex));
                }
                if (action == 4 && transmitKeyIndex == 0) break;
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_SET_WEP unimplemented action=0x%X, transmitKeyIndex=0x%X", action, transmitKeyIndex));
                resultCode = -1;
                break;
            }
            case 124: {
                int wlanCardVersion;
                int unknown8 = this.commandPacket.read16(8);
                int unknown10 = this.commandPacket.read16(10);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_UNKNOWN_007C bodySize=0x%X, unknown8=0x%X, unknown10=0x%X", bodySize, unknown8, unknown10));
                }
                if ((wlanCardVersion = this.attributesMemory.read16(4)) != 6929 && wlanCardVersion != 6936) {
                    this.log.error((Object)String.format("processCommandPacket CMD_UNKNOWN_007C unimplemented for wlanCardVersion 0x%04X: %s", wlanCardVersion, Utilities.getMemoryDump(this.commandPacket, 0, size)));
                    resultCode = -1;
                    break;
                }
                if (bodySize == 12 && unknown8 == 1 && unknown10 == 1 || bodySize == 12 && unknown8 == 1 && unknown10 == 0) break;
                this.log.error((Object)String.format("processCommandPacket CMD_UNKNOWN_007C unimplemented %s", Utilities.getMemoryDump(this.commandPacket, 0, size)));
                resultCode = -1;
                break;
            }
            case 43: {
                String ssid = this.commandPacketPtr.getStringNZ(8, 32);
                int bssType = this.commandPacketPtr.getUnsignedValue8(40);
                short beaconPeriod = this.commandPacketPtr.getUnalignedValue16(41);
                int atimWindow = this.commandPacketPtr.getUnsignedValue8(43);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_AD_HOC_START bodySize=0x%X, ssid='%s', bssType=0x%X, beaconPeriod=0x%X, ATIM Window=0x%X", bodySize, ssid, bssType, (int)beaconPeriod, atimWindow));
                }
                this.commandPacketPtr.setArray(8, Wlan.getMacAddress());
                this.setSsid(ssid);
                this.adhocStarted = true;
                break;
            }
            case 64: {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_AD_HOC_STOP bodySize=0x%X", bodySize));
                }
                this.adhocStarted = false;
                this.adhocJoined = false;
                this.setSsid(null);
                if (this.wlanAdapter != null) {
                    try {
                        this.wlanAdapter.stop();
                    }
                    catch (IOException e) {
                        this.log.error((Object)"CMD_802_11_AD_HOC_STOP", (Throwable)e);
                    }
                    this.wlanAdapter = null;
                }
                this.gameMode = false;
                this.gameModeEvent_40 = 0L;
                this.gameModeEventSendMaster = 0L;
                break;
            }
            case 44: {
                byte[] ibss = this.commandPacketPtr.getArray8(8, 6);
                String ssid = this.commandPacketPtr.getStringNZ(14, 32);
                int bssType = this.commandPacketPtr.getUnsignedValue8(46);
                short beaconPeriod = this.commandPacketPtr.getUnalignedValue16(47);
                int dtimPeriod = this.commandPacketPtr.getUnsignedValue8(49);
                long timestamp = this.commandPacketPtr.getUnalignedValue64(50);
                long startTimestamp = this.commandPacketPtr.getUnalignedValue64(58);
                short capabilities = this.commandPacketPtr.getUnalignedValue16(81);
                byte[] dataRates = this.commandPacketPtr.getArray8(83, 8);
                short failTimeout = this.commandPacketPtr.getUnalignedValue16(91);
                short probeDelay = this.commandPacketPtr.getUnalignedValue16(93);
                if (this.log.isDebugEnabled()) {
                    StringBuilder dataRatesString = new StringBuilder();
                    for (int i = 0; i < dataRates.length; ++i) {
                        if (dataRates[i] == 0) continue;
                        if (dataRatesString.length() > 0) {
                            dataRatesString.append(", ");
                        }
                        dataRatesString.append(String.format("0x%02X", dataRates[i] & 0xFF));
                    }
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_AD_HOC_JOIN bodySize=0x%X, bssid=%s, ssid='%s', bssType=0x%X, beaconPeriod=0x%X, dtimPeriod=0x%X, timestamp=0x%X, startTimestamp=0x%X, capabilities=0x%X, failTimeout=0x%X, probeDelay=0x%X, dataRates=%s", bodySize, sceNet.convertMacAddressToString(ibss), ssid, bssType, (int)beaconPeriod, dtimPeriod, timestamp, startTimestamp, (int)capabilities, (int)failTimeout, (int)probeDelay, dataRatesString));
                }
                this.setSsid(ssid);
                this.adhocJoined = true;
                break;
            }
            case 17: {
                pspNetMacAddress peerMacAddress = new pspNetMacAddress();
                peerMacAddress.read(this.commandPacket, 8);
                int authType = this.commandPacket.read8(14);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_802_11_AUTHENTICATE bodySize=0x%X, peerMacAddress=%s, authType=0x%X", bodySize, peerMacAddress, authType));
                break;
            }
            case 18: {
                pspNetMacAddress peerMacAddress = new pspNetMacAddress();
                peerMacAddress.read(this.commandPacket, 8);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_UNKNOWN_0012 bodySize=0x%X, peerMacAddress=%s, unknown %s", bodySize, peerMacAddress, Utilities.getMemoryDump(this.commandPacket, 14, bodySize - 14)));
                }
                this.commandPacket.writeUnsigned16(10, 0);
                break;
            }
            case 125: {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_UNKNOWN_007D bodySize=0x%X, unknown %s", bodySize, Utilities.getMemoryDump(this.commandPacket, 8, bodySize - 8)));
                break;
            }
            case 31: {
                int N = this.commandPacket.read16(8);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_802_11_RSSI bodySize=0x%X, N=0x%X", bodySize, N));
                }
                if (N == 0) {
                    this.commandPacket.writeUnsigned16(8, 40);
                    this.commandPacket.writeUnsigned16(10, 0);
                    this.commandPacket.writeUnsigned16(12, 0);
                    this.commandPacket.writeUnsigned16(14, 0);
                    break;
                }
                this.log.error((Object)String.format("processCommandPacket CMD_802_11_RSSI unimplemented N=0x%X", N));
                break;
            }
            case 16: {
                int action = this.commandPacket.read16(8);
                if (action == 1) {
                    int i;
                    int numberOfMulticastAddresses = this.commandPacket.read16(10);
                    pspNetMacAddress[] multicastAddresses = new pspNetMacAddress[numberOfMulticastAddresses];
                    for (i = 0; i < numberOfMulticastAddresses; ++i) {
                        multicastAddresses[i] = new pspNetMacAddress();
                        multicastAddresses[i].read(this.commandPacket, 12 + 6 * i);
                    }
                    if (!this.log.isDebugEnabled()) break;
                    this.log.debug((Object)String.format("processCommandPacket CMD_MAC_MULTICAST_ADR bodySize=0x%X, action=0x%X, numberOfMulticastAddresses=0x%X", bodySize, action, numberOfMulticastAddresses));
                    for (i = 0; i < numberOfMulticastAddresses; ++i) {
                        this.log.debug((Object)String.format("processCommandPacket CMD_MAC_MULTICAST_ADR multicastAddress#%d=%s", i, multicastAddresses[i]));
                    }
                    break;
                }
                this.log.error((Object)String.format("processCommandPacket CMD_MAC_MULTICAST_ADR unimplemented action=0x%X", action));
                break;
            }
            case 38: {
                pspNetMacAddress peerMacAddress = new pspNetMacAddress();
                peerMacAddress.read(this.commandPacket, 8);
                int unknown = this.commandPacket.read16(14);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_UNKNOWN_0026 bodySize=0x%X, peerMacAddress=%s, unknown=0x%X", bodySize, peerMacAddress, unknown));
                break;
            }
            case 36: {
                pspNetMacAddress peerMacAddress = new pspNetMacAddress();
                peerMacAddress.read(this.commandPacket, 8);
                int reasonCode = this.commandPacket.read16(14);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_802_11_DEAUTHENTICATE bodySize=0x%X, peerMacAddress=%s, reasonCode=0x%X", bodySize, peerMacAddress, reasonCode));
                break;
            }
            case 73: {
                int unknown06 = this.commandPacket.read16(6);
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)String.format("processCommandPacket CMD_802_11_BEACON_STOP bodySize=0x%X, unknown=0x%X", bodySize, unknown06));
                break;
            }
            case 42: {
                int unknown8 = this.commandPacket.read32(8);
                int unknown16 = this.commandPacket.read8(16);
                int unknown17 = this.commandPacket.read8(17);
                int unknown18 = this.commandPacket.read8(18);
                int unknown19 = this.commandPacket.read8(19);
                int unknown20 = this.commandPacket.read8(20);
                int unknown21 = this.commandPacket.read8(21);
                int unknown22 = this.commandPacket.read8(22);
                int unknown23 = this.commandPacket.read8(23);
                int unknown24 = this.commandPacket.read32(24);
                int unknown28 = this.commandPacket.read32(28);
                int unknown32 = this.commandPacket.read16(32);
                String ssid = this.commandPacketPtr.getStringNZ(34, 32);
                pspNetMacAddress macAddress66 = new pspNetMacAddress(this.commandPacketPtr.getArray8(66, 6));
                int unknown72 = this.commandPacket.read16(72);
                byte[] unknown74 = this.commandPacketPtr.getArray8(72, unknown72);
                int unknown90 = this.commandPacket.read16(90);
                int unknown92 = this.commandPacket.read16(92);
                pspNetMacAddress macAddressGameMode = new pspNetMacAddress(this.commandPacketPtr.getArray8(94, 6));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_UNKNOWN_002A unknown8=0x%X, unknown16=0x%X, unknown17=0x%X, unknown18=0x%X, unknown19=0x%X, unknown20=0x%X, unknown21=0x%X, unknown22=0x%X, unknown23=0x%X, unknown24=0x%X, unknown28=0x%X, unknown32=0x%X, ssid='%s', macAddress66=%s, unknown72=0x%X, unknown74=%s, unknown90=0x%X, unknown92=0x%X, macAddressGameMode=%s", unknown8, unknown16, unknown17, unknown18, unknown19, unknown20, unknown21, unknown22, unknown23, unknown24, unknown28, unknown32, ssid, macAddress66, unknown72, unknown74, unknown90, unknown92, macAddressGameMode));
                }
                this.commandPacket.write32(8, unknown8);
                responseSize = 12;
                if (!this.gameMode) break;
                if (unknown8 == 1) {
                    System.arraycopy(macAddressGameMode.macAddress, 0, this.gameModeGroupAddress, 0, 6);
                    System.arraycopy(this.gameModeGroupAddress, 0, this.gameModeMasterAddress, 0, 6);
                    this.gameModeMasterAddress[0] = (byte)(this.gameModeMasterAddress[0] & 0xFC);
                    this.gameModeEventSendMaster = 0L;
                    this.gameModeEvent_40 = Scheduler.getNow() + 14000L;
                    break;
                }
                if (unknown8 == 4 || unknown8 == 9 || unknown8 == 10 || unknown8 == 11) break;
                if (unknown8 == 0) {
                    Arrays.fill(this.gameModeGroupAddress, (byte)0);
                    Arrays.fill(this.gameModeMasterAddress, (byte)0);
                    this.clearResultFlag(2);
                    this.gameModeEventSendMaster = 0L;
                    this.gameModeEvent_40 = 0L;
                    break;
                }
                this.log.error((Object)String.format("processCommandPacket CMD_UNKNOWN_002A unknown unknown8=0x%X, unknown16=0x%X, unknown17=0x%X, unknown18=0x%X, unknown19=0x%X, unknown20=0x%X, unknown21=0x%X, unknown22=0x%X, unknown23=0x%X, unknown24=0x%X, unknown28=0x%X, unknown32=0x%X, ssid='%s', macAddress66=%s, unknown72=0x%X, unknown74=%s, unknown90=0x%X, unknown92=0x%X, macAddressGameMode=%s", unknown8, unknown16, unknown17, unknown18, unknown19, unknown20, unknown21, unknown22, unknown23, unknown24, unknown28, unknown32, ssid, macAddress66, unknown72, unknown74, unknown90, unknown92, macAddressGameMode));
                break;
            }
            case 26: {
                int action = this.commandPacket.read16(8);
                int registerNumber = this.commandPacket.read16(10);
                int registerValue = this.commandPacket.read32(12);
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)String.format("processCommandPacket CMD_BBP_REG_ACCESS action=%d(%s), registerNumber=0x%X, registerValue=0x%X", action, action == 1 ? "SET" : "GET", registerNumber, registerValue));
                }
                if (!(action == 1 && registerNumber == 44 && registerValue == 56 || action == 1 && registerNumber == 45 && registerValue == 4)) {
                    this.log.error((Object)String.format("processCommandPacket CMD_BBP_REG_ACCESS unimplemented action=%d(%s), registerNumber=0x%X, registerValue=0x%X", action, action == 1 ? "SET" : "GET", registerNumber, registerValue));
                }
                this.gameModeEvent_40 = Scheduler.getNow() + 100000L;
                break;
            }
            default: {
                this.log.error((Object)String.format("processCommandPacket unimplemented cmd=0x%X, size=0x%X, %s", cmd, size, Utilities.getMemoryDump(this.commandPacket, 0, size)));
                resultCode = -1;
            }
        }
        this.commandPacket.writeUnsigned16(6, resultCode);
        if (responseSize >= 0) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)String.format("processCommandPacket resultCode=0x%X, responseSize=0x%X, %s", resultCode, responseSize, Utilities.getMemoryDump(this.commandPacket, 0, responseSize)));
            }
            this.sendCommandResponse(responseSize);
        }
    }

    private IntArrayMemory getSendPacket(int dataAddress) {
        switch (dataAddress) {
            case 256: {
                return this.commandPacket;
            }
            case 258: {
                return this.sendDataPacket;
            }
        }
        this.log.error((Object)String.format("getSendPacket unimplemented dataAddress=0x%X", dataAddress));
        return this.commandPacket;
    }

    private IntArrayMemory getReceivePacket(int dataAddress) {
        switch (dataAddress) {
            case 256: {
                return this.commandPacket;
            }
            case 258: {
                return this.receiveDataPacket;
            }
        }
        this.log.error((Object)String.format("getReceivePacket unimplemented dataAddress=0x%X", dataAddress));
        return this.commandPacket;
    }

    private void writeDataEndOfCommand(int dataAddress, int size) {
        Utilities.endianSwap32(this.getSendPacket(dataAddress), 0, size);
        switch (dataAddress) {
            case 256: {
                this.processCommandPacket(size);
                break;
            }
            case 258: {
                this.processTransmitDataPacket(size);
                break;
            }
            default: {
                this.log.error((Object)String.format("MMIOHandlerWlan.writeDataEndOfCommand unimplemented dataAddress=0x%X, size=0x%X", dataAddress, size));
            }
        }
    }

    @Override
    protected void writeData16(int dataAddress, int dataIndex, int value, boolean endOfCommand) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerWlan.writeData16 dataAddress=0x%X, dataIndex=0x%X, outputPacketSize=0x%X, chipCodeIndex=0x%X, value=0x%04X, endOfCommand=%b", dataAddress, dataIndex, this.getWlanOutputPacketSize(), this.firmwareDataIndex, value, endOfCommand));
        }
        if (this.booting) {
            this.log.error((Object)String.format("MMIOHandlerWlan.writeData16 unimplemented while booting", new Object[0]));
        } else {
            this.getSendPacket(dataAddress).write16(dataIndex, (short)value);
            if (endOfCommand) {
                this.writeDataEndOfCommand(dataAddress, dataIndex + 2);
            }
        }
    }

    @Override
    protected void writeData32(int dataAddress, int dataIndex, int value, boolean endOfCommand) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)String.format("MMIOHandlerWlan.writeData32 dataAddress=0x%X, dataIndex=0x%X, outputPacketSize=0x%X, chipCodeIndex=0x%X, value=0x%08X, endOfCommand=%b", dataAddress, dataIndex, this.getWlanOutputPacketSize(), this.firmwareDataIndex, value, endOfCommand));
        }
        if (this.booting) {
            if (this.getWlanOutputPacketSize() == 0 && dataIndex == 12) {
                this.firmwareBootCodeIndex = -1;
                this.firmwareDataIndex = 0;
                this.setWlanInputPacketSize(1536);
            } else if (this.firmwareBootCodeIndex >= 0) {
                Utilities.writeUnaligned32(this.firmwareBootCode, this.firmwareBootCodeIndex, Utilities.endianSwap32(value));
                this.firmwareBootCodeIndex += 4;
            } else if (this.firmwareDataIndex >= 0) {
                Utilities.writeUnaligned32(this.firmwareData, this.firmwareDataIndex, Utilities.endianSwap32(value));
                this.firmwareDataIndex += 4;
            }
        } else {
            this.getSendPacket(dataAddress).write32(dataIndex, value);
            if (endOfCommand) {
                this.writeDataEndOfCommand(dataAddress, dataIndex + 4);
            }
        }
    }

    @Override
    protected void startCmd(int cmd) {
        switch (cmd) {
            case 18: {
                this.setCardEvent(64);
            }
        }
        super.startCmd(cmd);
    }

    @Override
    protected void startTPC(int tpc) {
        super.startTPC(tpc);
        switch (this.getTPCCode()) {
            case 10: {
                MMIOHandlerDdr.getInstance().doFlush(0);
                break;
            }
            case 9: 
            case 14: {
                MMIOHandlerDdr.getInstance().clearFlushDone(0);
            }
        }
    }

    @Override
    public void sendPacketFromAccessPoint(byte[] buffer, int bufferLength, EtherFrame etherFrame) {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)String.format("sendPacketFromAccessPoint bufferLength=0x%X, etherFrame=%s, buffer: %s", bufferLength, etherFrame, Utilities.getMemoryDump(buffer, 0, bufferLength)));
        }
        try {
            this.wlanAdapter.sendAccessPointPacket(buffer, 0, bufferLength, etherFrame);
        }
        catch (IOException e) {
            this.log.error((Object)"sendPacketFromAccessPoint", (Throwable)e);
        }
    }
}

