/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import java.io.IOException;
import java.util.Arrays;
import jpcsp.HLE.modules.sceWlan;
import jpcsp.Memory;
import jpcsp.hardware.Model;
import jpcsp.hardware.Wlan;
import jpcsp.memory.mmio.wlan.MMIOARMHandlerBase;
import jpcsp.memory.mmio.wlan.WlanEmulator;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class MMIOHandlerWlanFirmware
extends MMIOARMHandlerBase {
    public static Logger log = sceWlan.log;
    private static final int STATE_VERSION = 0;
    private static final int STATUS_COMPLETED = 4;
    public static final int INTERRUPT_UNKNOWN_4 = 4;
    public static final int INTERRUPT_UNKNOWN_8 = 8;
    public static final int INTERRUPT_UNKNOWN_10 = 10;
    public static final int INTERRUPT_UNKNOWN_15 = 15;
    public static final int INTERRUPT_UNKNOWN_16 = 16;
    private static int EEPROM_ADDRESS_SIZE = 3;
    private int addr;
    private int status;
    private int length;
    private int interrupt;
    private int addr0038;
    private int addr0040;
    private int addr0044;
    private int unknown2030;
    private int unknown3024;
    private int addrA000;
    private int addrA004;
    private int addrA008;
    private int lengthA3F4;
    private int addrA3F4;
    private int lengthA3FC;
    private int addrA3FC;
    private int lengthA404;
    private int addrA404;
    private int lengthA40C;
    private int addrA40C;
    private int lengthA414;
    private int addrA414;
    private int lengthA41C;
    private int addrA41C;
    private int unknownA510;
    private int unknownA53C;
    private int lengthE810;
    private int addrE810;
    private int addrE820;
    protected int eepromMode;
    private int eepromIndex;
    private int eepromCmd;
    private final byte[] eepromData = new byte[512];
    private final byte[] macAddress = new byte[6];
    private volatile byte[] data;
    private volatile int dataOffset;
    private volatile int dataLength;

    public MMIOHandlerWlanFirmware(int baseAddress) {
        super(baseAddress);
        if (Model.getGeneration() >= 2) {
            EEPROM_ADDRESS_SIZE = 2;
        }
        Arrays.fill(this.macAddress, (byte)0);
        this.initEEPROM();
    }

    public void test() {
        this.interrupt = Utilities.setBit(this.interrupt, 4);
        this.interrupt = Utilities.setBit(this.interrupt, 8);
        this.interrupt = Utilities.setBit(this.interrupt, 10);
        this.interrupt = Utilities.setBit(this.interrupt, 15);
        this.interrupt = Utilities.setBit(this.interrupt, 16);
        this.unknown3024 = 1;
        this.unknownA510 = 1864550591;
        this.status |= 4;
        Memory mem = this.getMemory();
        mem.write16(this.addr + 0, (short)3);
        mem.write16(this.addr + 2, (short)46);
        mem.write16(this.addr + 4, (short)0);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        EEPROM_ADDRESS_SIZE = stream.readInt();
        this.addr = stream.readInt();
        this.status = stream.readInt();
        this.length = stream.readInt();
        this.interrupt = stream.readInt();
        this.addr0038 = stream.readInt();
        this.addr0040 = stream.readInt();
        this.addr0044 = stream.readInt();
        this.unknown2030 = stream.readInt();
        this.unknown3024 = stream.readInt();
        this.addrA000 = stream.readInt();
        this.addrA004 = stream.readInt();
        this.addrA008 = stream.readInt();
        this.lengthA3F4 = stream.readInt();
        this.addrA3F4 = stream.readInt();
        this.lengthA3FC = stream.readInt();
        this.addrA3FC = stream.readInt();
        this.lengthA404 = stream.readInt();
        this.addrA404 = stream.readInt();
        this.lengthA40C = stream.readInt();
        this.addrA40C = stream.readInt();
        this.lengthA414 = stream.readInt();
        this.addrA414 = stream.readInt();
        this.lengthA41C = stream.readInt();
        this.addrA41C = stream.readInt();
        this.unknownA510 = stream.readInt();
        this.unknownA53C = stream.readInt();
        this.lengthE810 = stream.readInt();
        this.addrE810 = stream.readInt();
        this.addrE820 = stream.readInt();
        this.eepromMode = stream.readInt();
        this.eepromIndex = stream.readInt();
        this.eepromCmd = stream.readInt();
        stream.readBytes(this.eepromData);
        stream.readBytes(this.macAddress);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        stream.writeInt(EEPROM_ADDRESS_SIZE);
        stream.writeInt(this.addr);
        stream.writeInt(this.status);
        stream.writeInt(this.length);
        stream.writeInt(this.interrupt);
        stream.writeInt(this.addr0038);
        stream.writeInt(this.addr0040);
        stream.writeInt(this.addr0044);
        stream.writeInt(this.unknown2030);
        stream.writeInt(this.unknown3024);
        stream.writeInt(this.addrA000);
        stream.writeInt(this.addrA004);
        stream.writeInt(this.addrA008);
        stream.writeInt(this.lengthA3F4);
        stream.writeInt(this.addrA3F4);
        stream.writeInt(this.lengthA3FC);
        stream.writeInt(this.addrA3FC);
        stream.writeInt(this.lengthA404);
        stream.writeInt(this.addrA404);
        stream.writeInt(this.lengthA40C);
        stream.writeInt(this.addrA40C);
        stream.writeInt(this.lengthA414);
        stream.writeInt(this.addrA414);
        stream.writeInt(this.lengthA41C);
        stream.writeInt(this.addrA41C);
        stream.writeInt(this.unknownA510);
        stream.writeInt(this.unknownA53C);
        stream.writeInt(this.lengthE810);
        stream.writeInt(this.addrE810);
        stream.writeInt(this.addrE820);
        stream.writeInt(this.eepromMode);
        stream.writeInt(this.eepromIndex);
        stream.writeInt(this.eepromCmd);
        stream.writeBytes(this.eepromData);
        stream.writeBytes(this.macAddress);
        super.write(stream);
    }

    private void checksumEEPROM(int offset, int length) {
        int checksum = 0;
        for (int i = 0; i < length; ++i) {
            checksum += this.eepromData[offset + i] & 0xFF;
        }
        Utilities.writeUnaligned32(this.eepromData, offset + length - 4, checksum);
    }

    private void initEEPROM() {
        Arrays.fill(this.eepromData, (byte)0);
        int offset1 = 128;
        int length1 = 64;
        int offset2 = offset1 + length1;
        int length2 = 132;
        int offset3 = 32;
        int length3 = 0;
        int offset4 = 80;
        Utilities.writeUnaligned32(this.eepromData, 0, 942878808);
        Utilities.writeUnaligned32(this.eepromData, 4, length2);
        Utilities.writeUnaligned32(this.eepromData, 8, offset2);
        System.arraycopy(Wlan.getMacAddress(), 0, this.eepromData, 12, 6);
        Utilities.write8(this.eepromData, 18, 2);
        Utilities.write8(this.eepromData, 19, 0);
        Utilities.writeUnaligned32(this.eepromData, 20, length3);
        Utilities.writeUnaligned32(this.eepromData, 24, offset3);
        Utilities.writeUnaligned32(this.eepromData, 28, 0);
        Utilities.writeUnaligned32(this.eepromData, offset3 + length3 + 4, Utilities.setBit(0, 0));
        Utilities.writeUnaligned32(this.eepromData, 72, 4);
        Utilities.writeUnaligned32(this.eepromData, 76, offset4 & 0xFFFF);
        int value1 = 4;
        int value2 = 12;
        int checksum = 257 - ((value1 & 0xFF) + (value1 >> 8 & 0xFF) + (value2 & 0xFF));
        Utilities.writeUnaligned32(this.eepromData, offset4, value1 << 16 | checksum << 8 | value2);
        Utilities.writeUnaligned32(this.eepromData, offset4 + 4, -1);
        this.eepromData[offset2 + 2] = 0;
        this.eepromData[offset2 + 3] = 20;
        this.checksumEEPROM(offset1, length1);
        this.checksumEEPROM(offset2, length2);
    }

    public void setData(byte[] data, int dataLength) {
        this.data = data;
        this.dataLength = dataLength;
        this.dataOffset = 0;
    }

    public int getLength() {
        return this.length;
    }

    public int getAddr() {
        return this.addr;
    }

    public int getAddrE810() {
        return this.addrE810;
    }

    public int getLengthE810() {
        return this.lengthE810;
    }

    public void clearLengthE810() {
        this.lengthE810 = 0;
    }

    private int getStatus() {
        int returnedStatus = this.status;
        if (this.data != null && this.length > 0) {
            Memory mem = this.getMemory();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reading 0x%X / 0x%X", this.dataOffset, this.dataLength));
            }
            for (int i = 0; i < this.length; ++i) {
                if (this.dataOffset < this.dataLength) {
                    mem.write8(this.addr + i, this.data[this.dataOffset++]);
                    continue;
                }
                mem.write8(this.addr + i, (byte)0);
            }
            if (log.isDebugEnabled() && this.length == 16 && mem.read32(this.addr + 0) == 1) {
                log.debug((Object)String.format("Reading data to 0x%08X, length=0x%X", mem.read32(this.addr + 4), mem.read32(this.addr + 8) - 4));
            }
            if (this.dataOffset >= this.dataLength) {
                this.dataOffset = 0;
                this.dataLength = 0;
                this.data = null;
            }
            returnedStatus |= 4;
        }
        return returnedStatus;
    }

    private void clearStatus(int mask) {
        this.status &= mask;
    }

    public int getInterrupt() {
        return this.interrupt;
    }

    private void checkInterrupt() {
        if (this.interrupt != 0) {
            WlanEmulator.getInstance().getTxManager().triggerIrqException();
        }
    }

    private void clearInterrupt(int flags) {
        this.interrupt = Utilities.clearFlag(this.interrupt, flags);
    }

    public void setInterrupt(int interruptBit) {
        this.interrupt = Utilities.setBit(this.interrupt, interruptBit);
        if (interruptBit == 4) {
            this.unknown3024 = Utilities.setBit(this.unknown3024, 0);
        }
        if (interruptBit == 8) {
            this.status = Utilities.setFlag(this.status, 4);
        }
        if (interruptBit == 10) {
            this.unknownA510 = 1864550591;
        }
        this.checkInterrupt();
    }

    private void clearUnknown3024(int mask) {
        this.unknown3024 &= mask;
        if (Utilities.hasBit(mask, 0)) {
            this.clearInterrupt(4);
        }
    }

    private int getUnknown2030() {
        int value4 = 0;
        boolean flag = false;
        return flag ? 0x2000 | value4 << 5 : value4;
    }

    private void writeEEPROMCmdMode54(int value, boolean highByte) {
        switch (this.eepromIndex) {
            case 0: 
            case 1: {
                if (highByte) {
                    this.eepromCmd = this.eepromCmd & 0xFFFF | value << 16;
                    break;
                }
                this.eepromCmd = this.eepromCmd & 0xFF7FFF | (value & 0x80) << 8;
                break;
            }
            case 2: 
            case 3: {
                this.eepromCmd = highByte ? this.eepromCmd & 0xFF80FF | (value & 0x7F) << 8 : this.eepromCmd & 0xFFFF00 | value;
            }
        }
        ++this.eepromIndex;
        if (this.eepromIndex >= 4) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("writeEEPROMCmdMode54 unknown eepromCmd=0x%06X", this.eepromCmd));
            }
            this.eepromCmd = 0;
            this.eepromIndex = 0;
        }
    }

    private void writeEEPROMCmdMode58(int value, boolean highByte) {
        if (value == 0 && highByte) {
            this.eepromCmd = -2046820352;
            this.eepromIndex = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("writeEEPROMCmdMode58 value=0x%02X", value, highByte));
            }
        } else if (value == 1 && highByte) {
            this.eepromCmd = 0;
            this.eepromIndex = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("writeEEPROMCmdMode58 value=0x%02X", value, highByte));
            }
        } else if (value == 12 && highByte) {
            this.eepromCmd = 0;
            this.eepromIndex = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("writeEEPROMCmdMode58 value=0x%02X", value, highByte));
            }
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("writeEEPROMCmdMode58 unknown value=0x%02X, highByte=%b", value, highByte));
        }
    }

    private void writeEEPROMCmdMode82(int value) {
        switch (this.eepromIndex) {
            case 0: {
                this.eepromCmd = this.eepromCmd & 0xFFFFFF | value << 24;
                break;
            }
            case 1: {
                this.eepromCmd = this.eepromCmd & 0xFF00FFFF | value << 16;
                break;
            }
            case 2: {
                this.eepromCmd = this.eepromCmd & 0xFFFF00FF | value << 8;
                break;
            }
            case 3: {
                this.eepromCmd = this.eepromCmd & 0xFFFFFF00 | value;
            }
        }
        ++this.eepromIndex;
        if (this.eepromIndex == EEPROM_ADDRESS_SIZE + 1) {
            int addr;
            int cmd;
            switch (EEPROM_ADDRESS_SIZE) {
                case 2: {
                    cmd = this.eepromCmd >> 24 & 0xFF;
                    addr = (this.eepromCmd & 0xFFFF00) >> 8;
                    break;
                }
                case 3: {
                    cmd = this.eepromCmd >> 24 & 0xFF;
                    addr = this.eepromCmd & 0xFFFFFF;
                    break;
                }
                default: {
                    log.error((Object)String.format("Unknown EEPROM_ADDRESS_SIZE=%d", EEPROM_ADDRESS_SIZE));
                    cmd = 0;
                    addr = 0;
                }
            }
            if (cmd == 3) {
                this.eepromCmd = Utilities.readUnaligned32(this.eepromData, addr);
            } else {
                log.error((Object)String.format("writeEEPROMData8 unknown cmd=0x%02X", cmd));
                this.eepromCmd = 0;
            }
            this.eepromIndex = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("writeEEPROMCmd8 cmd=0x%02X, addr=0x%X returning 0x%08X", cmd, addr, this.eepromCmd));
            }
        }
    }

    public void writeEEPROMCmdHigh8(int value) {
        switch (this.eepromMode) {
            case 84: {
                this.writeEEPROMCmdMode54(value, true);
                break;
            }
            case 88: {
                this.writeEEPROMCmdMode58(value, true);
                break;
            }
            default: {
                log.error((Object)String.format("writeEEPROMCmdHigh8 unknown eepromMode=0x%X, value=0x%X", this.eepromMode, value));
            }
        }
    }

    public void writeEEPROMCmdLow8(int value) {
        switch (this.eepromMode) {
            case 84: {
                this.writeEEPROMCmdMode54(value, false);
                break;
            }
            case 88: {
                this.writeEEPROMCmdMode58(value, false);
                break;
            }
            case 130: {
                this.writeEEPROMCmdMode82(value);
                break;
            }
            default: {
                log.error((Object)String.format("writeEEPROMCmdLow8 unknown eepromMode=0x%X, value=0x%X", this.eepromMode, value));
            }
        }
    }

    public int readEEPROMCmd8() {
        int value = 0;
        switch (this.eepromIndex) {
            case 0: {
                value = this.eepromCmd >> 24;
                break;
            }
            case 1: {
                value = this.eepromCmd >> 16;
                break;
            }
            case 2: {
                value = this.eepromCmd >> 8;
                break;
            }
            case 3: {
                value = this.eepromCmd;
            }
        }
        value &= 0xFF;
        ++this.eepromIndex;
        if (this.eepromIndex == 4) {
            this.eepromCmd = 0;
            this.eepromIndex = 0;
        }
        return value;
    }

    private int getEEPROMConfig() {
        int config = 0;
        if (EEPROM_ADDRESS_SIZE == 2) {
            config = Utilities.setBit(config, 4);
        }
        return config;
    }

    @Override
    public int read8(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 41216: {
                value = 0;
                break;
            }
            case 41220: {
                value = 0;
                break;
            }
            case 41224: {
                value = 0;
                break;
            }
            case 41228: {
                value = 0;
                break;
            }
            case 41232: {
                value = 0;
                break;
            }
            case 41236: {
                value = 0;
                break;
            }
            case 41240: {
                value = 0;
                break;
            }
            case 41244: {
                value = 0;
                break;
            }
            case 41248: {
                value = 0;
                break;
            }
            case 41252: {
                value = 0;
                break;
            }
            case 41256: {
                value = 0;
                break;
            }
            case 41260: {
                value = 0;
                break;
            }
            case 41264: {
                value = 0;
                break;
            }
            case 41268: {
                value = 0;
                break;
            }
            case 49408: {
                value = 0;
                break;
            }
            case 49412: {
                value = 0;
                break;
            }
            case 49436: {
                value = 0;
                break;
            }
            case 49444: {
                value = this.readEEPROMCmd8();
                break;
            }
            default: {
                value = super.read8(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read8(0x%08X) returning 0x%02X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public int read16(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 8192: {
                value = this.getEEPROMConfig();
                break;
            }
            case 8216: {
                value = 3;
                break;
            }
            case 8240: {
                value = this.getUnknown2030() & 0xFFFF;
                break;
            }
            case 42284: {
                value = Utilities.readUnaligned16(this.macAddress, 4);
                break;
            }
            default: {
                value = super.read16(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read16(0x%08X) returning 0x%04X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 12: {
                value = this.length;
                break;
            }
            case 16: {
                value = 0;
                break;
            }
            case 36: {
                value = this.getStatus();
                break;
            }
            case 52: {
                value = 0;
                break;
            }
            case 8192: {
                value = 0;
                break;
            }
            case 8204: {
                value = 0;
                break;
            }
            case 8216: {
                value = 0;
                break;
            }
            case 8240: {
                value = this.getUnknown2030();
                break;
            }
            case 8260: {
                value = 0;
                break;
            }
            case 8268: {
                value = 0;
                break;
            }
            case 8288: {
                value = 0;
                break;
            }
            case 8292: {
                value = 0;
                break;
            }
            case 8304: {
                value = 131072;
                break;
            }
            case 8312: {
                value = 0;
                break;
            }
            case 10240: {
                value = this.getInterrupt();
                break;
            }
            case 10248: {
                value = 0;
                break;
            }
            case 12324: {
                value = this.unknown3024;
                break;
            }
            case 40960: {
                value = 0;
                break;
            }
            case 40976: {
                value = 0;
                break;
            }
            case 40980: {
                value = 0;
                break;
            }
            case 41024: {
                value = 0;
                break;
            }
            case 41028: {
                value = 0;
                break;
            }
            case 41032: {
                value = 0;
                break;
            }
            case 41036: {
                value = 0;
                break;
            }
            case 41076: {
                value = 0;
                break;
            }
            case 41084: {
                value = 0;
                break;
            }
            case 41216: {
                value = 0;
                break;
            }
            case 41220: {
                value = 0;
                break;
            }
            case 41224: {
                value = 0;
                break;
            }
            case 41228: {
                value = 0;
                break;
            }
            case 41232: {
                value = 0;
                break;
            }
            case 41236: {
                value = 0;
                break;
            }
            case 41240: {
                value = 0;
                break;
            }
            case 41244: {
                value = 0;
                break;
            }
            case 41248: {
                value = 0;
                break;
            }
            case 41252: {
                value = 0;
                break;
            }
            case 41256: {
                value = 0;
                break;
            }
            case 41260: {
                value = 0;
                break;
            }
            case 41264: {
                value = 0;
                break;
            }
            case 41268: {
                value = 0;
                break;
            }
            case 41272: {
                value = 0;
                break;
            }
            case 41680: {
                value = 0;
                break;
            }
            case 41684: {
                value = 0;
                break;
            }
            case 41728: {
                value = 0;
                break;
            }
            case 41968: {
                value = 0;
                break;
            }
            case 41972: {
                value = 0;
                break;
            }
            case 41976: {
                value = 0;
                break;
            }
            case 41980: {
                value = 0;
                break;
            }
            case 41984: {
                value = 0;
                break;
            }
            case 41988: {
                value = 0;
                break;
            }
            case 41992: {
                value = 0;
                break;
            }
            case 41996: {
                value = 0;
                break;
            }
            case 42000: {
                value = 0;
                break;
            }
            case 42004: {
                value = 0;
                break;
            }
            case 42012: {
                value = 0;
                break;
            }
            case 42032: {
                value = 0;
                break;
            }
            case 42048: {
                value = 0;
                break;
            }
            case 42052: {
                value = 0;
                break;
            }
            case 42056: {
                value = 0;
                break;
            }
            case 42060: {
                value = 0;
                break;
            }
            case 42064: {
                value = 0;
                break;
            }
            case 42068: {
                value = 0;
                break;
            }
            case 42072: {
                value = 0;
                break;
            }
            case 42076: {
                value = 0;
                break;
            }
            case 42092: {
                value = 0;
                break;
            }
            case 42256: {
                value = this.unknownA510;
                break;
            }
            case 42260: {
                value = 0;
                break;
            }
            case 42280: {
                value = Utilities.readUnaligned32(this.macAddress, 0);
                break;
            }
            case 42284: {
                value = Utilities.readUnaligned16(this.macAddress, 4);
                break;
            }
            case 42288: {
                value = 0;
                break;
            }
            case 42292: {
                value = 0;
                break;
            }
            case 42300: {
                value = this.unknownA53C;
                break;
            }
            case 42480: {
                value = 0;
                break;
            }
            case 42496: {
                value = 0;
                break;
            }
            case 42500: {
                value = 0;
                break;
            }
            case 42504: {
                value = 0;
                break;
            }
            case 42508: {
                value = 0;
                break;
            }
            case 42512: {
                value = 0;
                break;
            }
            case 42516: {
                value = 0;
                break;
            }
            case 42520: {
                value = 0;
                break;
            }
            case 42524: {
                value = 0;
                break;
            }
            case 42528: {
                value = 0;
                break;
            }
            case 42532: {
                value = 0;
                break;
            }
            case 42536: {
                value = 0;
                break;
            }
            case 42540: {
                value = 0;
                break;
            }
            case 42564: {
                value = 0;
                break;
            }
            case 42576: {
                value = 0;
                break;
            }
            case 42584: {
                value = 0;
                break;
            }
            case 43236: {
                value = 0;
                break;
            }
            case 43044: {
                value = 0;
                break;
            }
            case 43080: {
                value = 0;
                break;
            }
            case 43152: {
                value = 0;
                break;
            }
            case 43312: {
                value = 0;
                break;
            }
            case 53260: {
                value = 0;
                break;
            }
            case 59392: {
                value = this.lengthE810;
                break;
            }
            case 59456: {
                value = 0;
                break;
            }
            case 59464: {
                value = 0;
                break;
            }
            case 59552: {
                value = 0;
                break;
            }
            case 59556: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write8(int address, byte value) {
        int value8 = value & 0xFF;
        switch (address - this.baseAddress) {
            case 42320: {
                if (value8 == 17) break;
                super.write8(address, value);
                break;
            }
            case 49152: {
                if (value8 == 1) break;
                super.write8(address, value);
                break;
            }
            case 49156: {
                if (value8 == 0) break;
                super.write8(address, value);
                break;
            }
            case 49408: {
                if (value8 == 0) break;
                super.write8(address, value);
                break;
            }
            case 49412: {
                this.eepromMode = value8;
                if (value8 == 0 || value8 == 130 || value8 == 84 || value8 == 88) break;
                super.write8(address, value);
                break;
            }
            case 49444: {
                this.writeEEPROMCmdLow8(value8);
                break;
            }
            case 49448: {
                this.writeEEPROMCmdHigh8(value8);
                break;
            }
            default: {
                super.write8(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write8(0x%08X, 0x%02X) on %s", this.getPc(), address, value8, this));
        }
    }

    @Override
    public void write16(int address, short value) {
        int value16 = value & 0xFFFF;
        switch (address - this.baseAddress) {
            case 12: {
                this.length = value16;
                break;
            }
            case 8204: {
                if (value16 == 30591 || value16 == 65535) break;
                super.write16(address, value);
                break;
            }
            case 8240: {
                this.unknown2030 = value16;
                break;
            }
            case 42560: {
                if (value16 == 2) break;
                super.write16(address, value);
                break;
            }
            case 49408: {
                if (value16 == 2 || value16 == 4 || value16 == 8) break;
                super.write16(address, value);
                break;
            }
            case 49416: {
                if (value16 == 1410) break;
                super.write16(address, value);
                break;
            }
            default: {
                super.write16(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write16(0x%08X, 0x%04X) on %s", this.getPc(), address, value16, this));
        }
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 12: {
                this.length = value;
                break;
            }
            case 16: {
                if (value == 0 || value == 16400) break;
                super.write32(address, value);
                break;
            }
            case 32: {
                if (value == 0 || value == 1) break;
                super.write32(address, value);
                break;
            }
            case 36: {
                this.clearStatus(value);
                break;
            }
            case 40: {
                if (value == 255) break;
                super.write32(address, value);
                break;
            }
            case 44: {
                if (value == 255) break;
                super.write32(address, value);
                break;
            }
            case 48: {
                if (value == 255) break;
                super.write32(address, value);
                break;
            }
            case 52: {
                if (value == 4 || value == 5 || value == 8 || value == 16) break;
                super.write32(address, value);
                break;
            }
            case 56: {
                this.addr0038 = value;
                break;
            }
            case 60: {
                this.addr = value;
                break;
            }
            case 64: {
                this.addr0040 = value;
                break;
            }
            case 68: {
                this.addr0044 = value;
                break;
            }
            case 72: {
                if (value == -1073741824) break;
                super.write32(address, value);
                break;
            }
            case 100: {
                if (value == 512) break;
                super.write32(address, value);
                break;
            }
            case 8204: {
                if (value == -1 || value == 269513706 || value == 8 || value == 0) break;
                super.write32(address, value);
                break;
            }
            case 8240: {
                this.unknown2030 = value;
                break;
            }
            case 8260: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 8268: {
                if (value == 0 || value == 32) break;
                super.write32(address, value);
                break;
            }
            case 8288: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 8292: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 8308: {
                if (value == Integer.MIN_VALUE || value == -2147483647 || value == 3 || value == 4 || value == 5 || value == 6 || value == 7 || value == 8 || value == 9 || value == 10 || value == 11 || value == 12 || value == 13 || value == 14) break;
                super.write32(address, value);
                break;
            }
            case 8312: {
                if (value == -16777209 || value == 5) break;
                super.write32(address, value);
                break;
            }
            case 10248: {
                if (value == 0 || value == 16 || value == 99824 || value == 0x800000 || value == 256 || value == 1024 || value == 32768 || value == 65536) break;
                super.write32(address, value);
                break;
            }
            case 10252: {
                this.clearInterrupt(value);
                break;
            }
            case 12288: {
                if (value == 10) break;
                super.write32(address, value);
                break;
            }
            case 12304: {
                if (value == 11) break;
                super.write32(address, value);
                break;
            }
            case 12324: {
                this.clearUnknown3024(value);
                break;
            }
            case 12328: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            case 40960: {
                this.addrA000 = value;
                break;
            }
            case 40964: {
                this.addrA004 = value;
                break;
            }
            case 40968: {
                this.addrA008 = value;
                break;
            }
            case 40976: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 40980: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 40984: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 40988: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 40992: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 40996: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41000: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41004: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41024: {
                if (value == 0 || value == 4) break;
                super.write32(address, value);
                break;
            }
            case 41028: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41032: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41036: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41040: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41044: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41048: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41052: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41056: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41060: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41064: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41068: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41072: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41076: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41080: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41084: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41104: {
                if (value == 255 || value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41120: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41124: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41128: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41132: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41136: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41140: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41144: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41148: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41152: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41156: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41160: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41164: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41168: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41172: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41176: {
                if (value == 7) break;
                super.write32(address, value);
                break;
            }
            case 41180: {
                if (value == 31) break;
                super.write32(address, value);
                break;
            }
            case 41184: {
                if (value == 31 || value == 91) break;
                super.write32(address, value);
                break;
            }
            case 41216: {
                if (value == 0 || value == 20) break;
                super.write32(address, value);
                break;
            }
            case 41220: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41224: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41228: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41232: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41236: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41240: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41244: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41248: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41252: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41256: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41260: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41264: {
                if (value == 0 || value == 256 || value == 4096) break;
                super.write32(address, value);
                break;
            }
            case 41268: {
                if (value == 0 || value == 256 || value == 4096 || value == 10) break;
                super.write32(address, value);
                break;
            }
            case 41272: {
                if (value == 20 || value == 1390) break;
                super.write32(address, value);
                break;
            }
            case 41312: {
                if (value == 32) break;
                super.write32(address, value);
                break;
            }
            case 41316: {
                if (value == 32) break;
                super.write32(address, value);
                break;
            }
            case 41344: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41348: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41352: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41356: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41360: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41408: {
                if (value == 314) break;
                super.write32(address, value);
                break;
            }
            case 41412: {
                if (value == 162 || value == 258) break;
                super.write32(address, value);
                break;
            }
            case 41416: {
                if (value == 126 || value == 222) break;
                super.write32(address, value);
                break;
            }
            case 41420: {
                if (value == 116 || value == 212) break;
                super.write32(address, value);
                break;
            }
            case 41424: {
                if (value == 207) break;
                super.write32(address, value);
                break;
            }
            case 41428: {
                if (value == 52) break;
                super.write32(address, value);
                break;
            }
            case 41432: {
                if (value == 45) break;
                super.write32(address, value);
                break;
            }
            case 41436: {
                if (value == 42) break;
                super.write32(address, value);
                break;
            }
            case 41440: {
                if (value == 39) break;
                super.write32(address, value);
                break;
            }
            case 41444: {
                if (value == 38) break;
                super.write32(address, value);
                break;
            }
            case 41448: {
                if (value == 36) break;
                super.write32(address, value);
                break;
            }
            case 41452: {
                if (value == 35) break;
                super.write32(address, value);
                break;
            }
            case 41456: {
                if (value == 35) break;
                super.write32(address, value);
                break;
            }
            case 41460: {
                if (value == 35) break;
                super.write32(address, value);
                break;
            }
            case 41476: {
                if (value == 10) break;
                super.write32(address, value);
                break;
            }
            case 41480: {
                if (value == 10) break;
                super.write32(address, value);
                break;
            }
            case 41488: {
                if (value == 336) break;
                super.write32(address, value);
                break;
            }
            case 41492: {
                if (value == 336) break;
                super.write32(address, value);
                break;
            }
            case 41496: {
                if (value == 336) break;
                super.write32(address, value);
                break;
            }
            case 41536: {
                if (value == 671824 || value == 12288) break;
                super.write32(address, value);
                break;
            }
            case 41540: {
                if (value == 1343496224) break;
                super.write32(address, value);
                break;
            }
            case 41568: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41572: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41576: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41580: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41584: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41588: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41592: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41596: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 41648: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41652: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41656: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41660: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41664: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41668: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41672: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41676: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41680: {
                if (value == 0 || value == 32768) break;
                super.write32(address, value);
                break;
            }
            case 41684: {
                if (value == 0 || value == 16) break;
                super.write32(address, value);
                break;
            }
            case 41728: {
                if (value == 0 || value == 8 || value == 10 || value == 12) break;
                super.write32(address, value);
                break;
            }
            case 41952: {
                if (value == 96) break;
                super.write32(address, value);
                break;
            }
            case 41968: {
                this.lengthA3F4 = value;
                break;
            }
            case 41972: {
                this.addrA3F4 = value;
                break;
            }
            case 41976: {
                this.lengthA3FC = value;
                break;
            }
            case 41980: {
                this.addrA3FC = value;
                break;
            }
            case 41984: {
                this.lengthA404 = value;
                break;
            }
            case 41988: {
                this.addrA404 = value;
                break;
            }
            case 41992: {
                this.lengthA40C = value;
                break;
            }
            case 41996: {
                this.addrA40C = value;
                break;
            }
            case 42000: {
                this.lengthA414 = value;
                break;
            }
            case 42004: {
                this.addrA414 = value;
                break;
            }
            case 42008: {
                this.lengthA41C = value;
                break;
            }
            case 42012: {
                this.addrA41C = value;
                break;
            }
            case 42032: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42036: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42040: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42044: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42048: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42076: {
                if (value == 512) break;
                super.write32(address, value);
                break;
            }
            case 42088: {
                if (value == 30) break;
                super.write32(address, value);
                break;
            }
            case 42092: {
                if (value == -35786731 || value == -2232299 || value == 64 || value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42096: {
                if (value == -1) break;
                super.write32(address, value);
                break;
            }
            case 42240: {
                if (value == 0 || value == 2) break;
                super.write32(address, value);
                break;
            }
            case 42256: {
                this.unknownA510 &= value;
                break;
            }
            case 42260: {
                if (value == 0 || value == 1865600191 || value == 1863486655 || value == 0x2000000 || value == 0x8000000) break;
                super.write32(address, value);
                break;
            }
            case 42264: {
                if (value == -1) break;
                super.write32(address, value);
                break;
            }
            case 42280: {
                Utilities.writeUnaligned32(this.macAddress, 0, value);
                break;
            }
            case 42284: {
                Utilities.writeUnaligned16(this.macAddress, 4, value & 0xFFFF);
                break;
            }
            case 42288: {
                if (value == 0 || (value & 0xFF) == 2) break;
                super.write32(address, value);
                break;
            }
            case 42292: {
                if (value == 0 || (value & 0xFFFF0000) == 0) break;
                super.write32(address, value);
                break;
            }
            case 42300: {
                this.unknownA53C = value;
                if (value == 4 || value == 263172) break;
                super.write32(address, value);
                break;
            }
            case 42324: {
                if (value == 1599099728) break;
                super.write32(address, value);
                break;
            }
            case 42328: {
                if (value == 1162630465) break;
                super.write32(address, value);
                break;
            }
            case 42332: {
                if (value == 959459411) break;
                super.write32(address, value);
                break;
            }
            case 42336: {
                if (value == 1281306936) break;
                super.write32(address, value);
                break;
            }
            case 42340: {
                if (value == 95) break;
                super.write32(address, value);
                break;
            }
            case 42344: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42348: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42352: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42376: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            case 42380: {
                if (value == 98304) break;
                super.write32(address, value);
                break;
            }
            case 42480: {
                if (value == 1 || value == 0x40000000) break;
                super.write32(address, value);
                break;
            }
            case 42496: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42500: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42504: {
                if (value == 204800) break;
                super.write32(address, value);
                break;
            }
            case 42508: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42512: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42516: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42520: {
                if (value == 100) break;
                super.write32(address, value);
                break;
            }
            case 42524: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42528: {
                if (value == 255) break;
                super.write32(address, value);
                break;
            }
            case 42532: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42536: {
                if (value == 0 || value == 1 || value == 255) break;
                super.write32(address, value);
                break;
            }
            case 42540: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42560: {
                if (value == 1 || value == 128 || value == 256 || value == 511) break;
                super.write32(address, value);
                break;
            }
            case 42564: {
                if (value == 0 || value == 1) break;
                super.write32(address, value);
                break;
            }
            case 42576: {
                if (value == 0 || value == 4) break;
                super.write32(address, value);
                break;
            }
            case 42584: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 42592: {
                if (value == 40 || value == 44) break;
                super.write32(address, value);
                break;
            }
            case 42608: {
                if (value == 20) break;
                super.write32(address, value);
                break;
            }
            case 42612: {
                if (value == 10) break;
                super.write32(address, value);
                break;
            }
            case 42616: {
                if (value == 16) break;
                super.write32(address, value);
                break;
            }
            case 42620: {
                if (value == 16 || value == 80) break;
                super.write32(address, value);
                break;
            }
            case 42624: {
                if (value == 22) break;
                super.write32(address, value);
                break;
            }
            case 42628: {
                if (value == 22) break;
                super.write32(address, value);
                break;
            }
            case 42632: {
                if (value == 22) break;
                super.write32(address, value);
                break;
            }
            case 42636: {
                if (value == 22) break;
                super.write32(address, value);
                break;
            }
            case 42640: {
                if (value == 22) break;
                super.write32(address, value);
                break;
            }
            case 42644: {
                if (value == 22) break;
                super.write32(address, value);
                break;
            }
            case 42648: {
                if (value == 22 || value == 25 || value == 50) break;
                super.write32(address, value);
                break;
            }
            case 42652: {
                if (value == 22 || value == 50) break;
                super.write32(address, value);
                break;
            }
            case 43008: {
                if (value == 1 || value == 4 || value == 2) break;
                super.write32(address, value);
                break;
            }
            case 43040: {
                if (value == 66048 || value == 68608) break;
                super.write32(address, value);
                break;
            }
            case 43044: {
                if (value == 0x1000008 || value == 0 || value == 128 || value == 524296 || value == 1024) break;
                super.write32(address, value);
                break;
            }
            case 43116: {
                if (value == 20 || value == 31) break;
                super.write32(address, value);
                break;
            }
            case 43124: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            case 43128: {
                if (value == 131072) break;
                super.write32(address, value);
                break;
            }
            case 43132: {
                if (value == 200 || value == 511) break;
                super.write32(address, value);
                break;
            }
            case 43216: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 43220: {
                if (value == -1) break;
                super.write32(address, value);
                break;
            }
            case 43236: {
                if (value == 0 || value == 2) break;
                super.write32(address, value);
                break;
            }
            case 53260: {
                if (value == 16) break;
                super.write32(address, value);
                break;
            }
            case 59392: {
                this.lengthE810 = value;
                break;
            }
            case 59408: {
                this.addrE810 = value;
                break;
            }
            case 59424: {
                this.addrE820 = value;
                break;
            }
            case 59440: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 59456: {
                if (value == 0 || value == 0x100000 || value == 7104) break;
                super.write32(address, value);
                break;
            }
            case 59460: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 59552: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 59556: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

