/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan.threadx.hle;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.arm.ARMInterpreter;
import jpcsp.arm.ARMProcessor;
import jpcsp.arm.IARMHLECall;
import jpcsp.hardware.Model;
import jpcsp.memory.mmio.wlan.HLENullCall;
import jpcsp.memory.mmio.wlan.threadx.TXEventFlagsCreate;
import jpcsp.memory.mmio.wlan.threadx.TXEventFlagsGet;
import jpcsp.memory.mmio.wlan.threadx.TXEventFlagsSet;
import jpcsp.memory.mmio.wlan.threadx.TXExecutionISRExit;
import jpcsp.memory.mmio.wlan.threadx.TXInterruptControl;
import jpcsp.memory.mmio.wlan.threadx.TXJumpCall;
import jpcsp.memory.mmio.wlan.threadx.TXKernelEnter;
import jpcsp.memory.mmio.wlan.threadx.TXQueueCreate;
import jpcsp.memory.mmio.wlan.threadx.TXQueueReceive;
import jpcsp.memory.mmio.wlan.threadx.TXQueueSend;
import jpcsp.memory.mmio.wlan.threadx.TXSemaphoreCreate;
import jpcsp.memory.mmio.wlan.threadx.TXSemaphoreGet;
import jpcsp.memory.mmio.wlan.threadx.TXSemaphorePut;
import jpcsp.memory.mmio.wlan.threadx.TXThreadCreate;
import jpcsp.memory.mmio.wlan.threadx.TXThreadResume;
import jpcsp.memory.mmio.wlan.threadx.TXThreadSleep;
import jpcsp.memory.mmio.wlan.threadx.TXTimeGet;
import jpcsp.memory.mmio.wlan.threadx.TXTimerCreate;
import jpcsp.memory.mmio.wlan.threadx.hle.TXEventFlagsGroup;
import jpcsp.memory.mmio.wlan.threadx.hle.TXQueue;
import jpcsp.memory.mmio.wlan.threadx.hle.TXSemaphore;
import jpcsp.memory.mmio.wlan.threadx.hle.TXThread;
import jpcsp.memory.mmio.wlan.threadx.hle.TXTimer;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class TXManager {
    public static final Logger log = Logger.getLogger((String)"threadx");
    public static final int TX_READY = 0;
    public static final int TX_COMPLETED = 1;
    public static final int TX_TERMINATED = 2;
    public static final int TX_SUSPENDED = 3;
    public static final int TX_SLEEP = 4;
    public static final int TX_QUEUE_SUSP = 5;
    public static final int TX_SEMAPHORE_SUSP = 6;
    public static final int TX_EVENT_FLAG = 7;
    public static final int TX_BLOCK_MEMORY = 8;
    public static final int TX_BYTE_MEMORY = 9;
    public static final int TX_IO_DRIVER = 10;
    public static final int TX_FILE = 11;
    public static final int TX_TCP_IP = 12;
    public static final int TX_MUTEX_SUSP = 13;
    public static final int TX_PRIORITY_CHANGE = 14;
    public static final int TX_SUCCESS = 0;
    public static final int TX_DELETED = 1;
    public static final int TX_NO_MEMORY = 16;
    public static final int TX_POOL_ERROR = 2;
    public static final int TX_PTR_ERROR = 3;
    public static final int TX_WAIT_ERROR = 4;
    public static final int TX_SIZE_ERROR = 5;
    public static final int TX_GROUP_ERROR = 6;
    public static final int TX_NO_EVENTS = 7;
    public static final int TX_OPTION_ERROR = 8;
    public static final int TX_QUEUE_ERROR = 9;
    public static final int TX_QUEUE_EMPTY = 10;
    public static final int TX_QUEUE_FULL = 11;
    public static final int TX_SEMAPHORE_ERROR = 12;
    public static final int TX_NO_INSTANCE = 13;
    public static final int TX_THREAD_ERROR = 14;
    public static final int TX_PRIORITY_ERROR = 15;
    public static final int TX_START_ERROR = 16;
    public static final int TX_DELETE_ERROR = 17;
    public static final int TX_RESUME_ERROR = 18;
    public static final int TX_CALLER_ERROR = 19;
    public static final int TX_SUSPEND_ERROR = 20;
    public static final int TX_TIMER_ERROR = 21;
    public static final int TX_TICK_ERROR = 22;
    public static final int TX_ACTIVATE_ERROR = 23;
    public static final int TX_THRESH_ERROR = 24;
    public static final int TX_SUSPEND_LIFTED = 25;
    public static final int TX_WAIT_ABORTED = 26;
    public static final int TX_WAIT_ABORT_ERROR = 27;
    public static final int TX_MUTEX_ERROR = 28;
    public static final int TX_NOT_AVAILABLE = 29;
    public static final int TX_NOT_OWNED = 30;
    public static final int TX_INHERIT_ERROR = 31;
    public static final int TX_NOT_DONE = 32;
    public static final int TX_CEILING_EXCEEDED = 33;
    public static final int TX_INVALID_CEILING = 34;
    public static final int TX_FEATURE_NOT_ENABLED = 255;
    public static final int TX_AND = 2;
    public static final int TX_CLEAR = 1;
    public static final int TX_NO_WAIT = 0;
    public static final int TX_WAIT_FOREVER = -1;
    private final Map<Integer, TXThread> txThreads = new HashMap<Integer, TXThread>();
    private final Map<Integer, TXTimer> txTimers = new HashMap<Integer, TXTimer>();
    private final List<TXTimer> activatedTimers = new LinkedList<TXTimer>();
    private final Map<Integer, TXEventFlagsGroup> txEventFlags = new HashMap<Integer, TXEventFlagsGroup>();
    private final Map<Integer, TXQueue> txQueues = new HashMap<Integer, TXQueue>();
    private final Map<Integer, TXSemaphore> txSemaphores = new HashMap<Integer, TXSemaphore>();
    private int systemTick;
    private static final int TICK_NANOS = 10000000;
    private TXThread currentThread;
    private TXThread nextThread;
    private int txIrqHandler;
    private int hleCallIndex;
    public static final int TX_INITIALIZE_IN_PROGRESS = -252645136;
    public static final int TX_INITIALIZE_ALMOST_DONE = -252645135;
    public static final int TX_INITIALIZE_IS_FINISHED = 0;
    public int threadSystemState = -252645136;
    private boolean pendingIrqException;

    public void installHLECalls(ARMInterpreter interpreter) {
        RuntimeContext.setLog4jMDC("TX_boot");
        this.installHLECall(interpreter, -54407, -56515, new TXKernelEnter(3689, 3905, 51577), new TXKernelEnter(3929, 4157, 61401));
        this.installHLECall(interpreter, -58367, -60443, new TXEventFlagsCreate());
        this.installHLECall(interpreter, -65536, -60295, new TXEventFlagsGet());
        this.installHLECall(interpreter, -58055, -60135, new TXEventFlagsSet());
        this.installHLECall(interpreter, -56511, -58595, new TXQueueCreate());
        this.installHLECall(interpreter, -65536, -58143, new TXQueueReceive());
        this.installHLECall(interpreter, -65536, -58067, new TXQueueSend());
        this.installHLECall(interpreter, -55899, -57991, new TXSemaphoreCreate());
        this.installHLECall(interpreter, -55747, -57843, new TXSemaphoreGet());
        this.installHLECall(interpreter, -55611, -57707, new TXSemaphorePut());
        this.installHLECall(interpreter, -55527, -57623, new TXThreadCreate());
        this.installHLECall(interpreter, -54971, -57071, new TXTimerCreate());
        this.installHLECall(interpreter, -65536, -56887, new TXThreadResume());
        this.installHLECall(interpreter, -65536, -50715, new TXTimeGet());
        this.installHLECall(interpreter, -65536, -49319, new TXThreadSleep());
        this.installHLECall(interpreter, -45975, -48119, new TXJumpCall(0));
        this.installHLECall(interpreter, -45973, -48117, new TXJumpCall(1));
        this.installHLECall(interpreter, -45971, -48115, new TXJumpCall(2));
        this.installHLECall(interpreter, -45969, -48113, new TXJumpCall(3));
        this.installHLECall(interpreter, -45959, -48103, new TXExecutionISRExit());
        this.installHLECall(interpreter, -65536, -47719, new HLENullCall(0));
        this.installHLECall(interpreter, -45219, -47363, new TXInterruptControl());
    }

    private void installHLECall(ARMInterpreter interpreter, int address1, int address2, IARMHLECall hleCall) {
        this.installHLECall(interpreter, address1, address2, hleCall, hleCall);
    }

    private void installHLECall(ARMInterpreter interpreter, int address1, int address2, IARMHLECall hleCall1, IARMHLECall hleCall2) {
        ++this.hleCallIndex;
        if (Model.getGeneration() >= 2) {
            interpreter.registerHLECall(address2, this.hleCallIndex, hleCall2);
        } else {
            interpreter.registerHLECall(address1, this.hleCallIndex, hleCall1);
        }
    }

    private void clear(ARMProcessor processor, int address, int size) {
        processor.mem.memset(address, (byte)0, size);
    }

    public void setTxIrqHandler(int txIrqHandler) {
        this.txIrqHandler = txIrqHandler;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("setTxIrqHandler txIrqHandler=0x%08X", this.txIrqHandler));
        }
    }

    public void threadSchedule(ARMProcessor processor) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Entering threadSchedule", new Object[0]));
        }
        boolean testIrq = true;
        long previousSystemTickNanos = System.nanoTime();
        while (!Emulator.pause) {
            long nowNanos = System.nanoTime();
            for (int elapseNanos = (int)(nowNanos - previousSystemTickNanos); elapseNanos >= 10000000; elapseNanos -= 10000000) {
                this.incrementSystemTick(processor);
                previousSystemTickNanos += 10000000L;
            }
            if (this.pendingIrqException) {
                this.pendingIrqException = false;
                this.triggerIrqException(processor);
            }
            if (this.nextThread == null) {
                if (this.currentThread != null) {
                    this.threadContextSave(processor, this.currentThread);
                    this.currentThread = null;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("No thread to be executed", new Object[0]));
                }
                Utilities.sleep(1);
                if (testIrq) {
                    processor.mem.getHandlerWlanFirmware().test();
                    this.triggerIrqException(processor);
                    testIrq = false;
                }
            } else if (this.nextThread != this.currentThread) {
                this.threadContextSave(processor, this.currentThread);
                this.threadContextRestore(processor, this.nextThread);
                this.currentThread = this.nextThread;
                RuntimeContext.setLog4jMDC("TX_" + this.currentThread.threadName);
            }
            if (this.currentThread == null) continue;
            this.threadRun(processor, this.currentThread);
        }
    }

    private void checkWaitingThreads(ARMProcessor processor) {
        boolean systemReturn = false;
        for (TXThread txThread : this.txThreads.values()) {
            if (!txThread.isWaiting() || txThread.waitOption == -1 || txThread.waitStartTicks + txThread.waitOption > this.systemTick || !this.threadResume(processor, txThread)) continue;
            systemReturn = true;
        }
        if (systemReturn) {
            this.threadSystemReturn(processor);
        }
    }

    public int threadCreate(ARMProcessor processor, int threadPtr, String threadName, int entryFunction, int entryInput, int stackStart, int stackSize, int priority, int preemptThreshold, int timeSlice, int autoStart) {
        this.clear(processor, threadPtr, 148);
        TXThread txThread = new TXThread();
        txThread.threadPtr = threadPtr;
        txThread.threadName = threadName;
        txThread.entryFunction = entryFunction;
        txThread.entryInput = entryInput;
        txThread.stackStart = stackStart;
        txThread.stackSize = stackSize;
        txThread.priority = priority;
        txThread.preemptyThreshold = preemptThreshold;
        txThread.timeSlice = timeSlice;
        txThread.initRegisters();
        this.txThreads.put(threadPtr, txThread);
        if (autoStart != 0 && this.threadResume(processor, txThread)) {
            this.threadSystemReturn(processor);
        }
        return 0;
    }

    public int threadResume(ARMProcessor processor, int threadPtr) {
        TXThread txThread = this.txThreads.get(threadPtr);
        if (txThread == null) {
            log.error((Object)String.format("threadResume unknown threadPtr=0x%08X", threadPtr));
            return 3;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TXThreadResume %s", txThread));
        }
        if (this.threadResume(processor, txThread)) {
            this.threadSystemReturn(processor);
        }
        return 0;
    }

    public boolean threadResume(ARMProcessor processor, TXThread txThread) {
        if (txThread.state != 0) {
            txThread.state = 0;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("threadResume %s", txThread));
            }
        }
        if (this.currentThread == null) {
            this.nextThread = txThread;
        } else if (txThread.priority < this.currentThread.priority) {
            this.nextThread = txThread;
        }
        boolean preemption = false;
        if (this.currentThread != this.nextThread) {
            preemption = true;
        }
        return preemption;
    }

    public int threadSleep(ARMProcessor processor, int timerTicks) {
        TXThread txThread = this.currentThread;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TXThreadSleep %s", txThread));
        }
        this.setThreadWait(processor, txThread, 4, 0, timerTicks);
        return 0;
    }

    private void rescheduleThread(ARMProcessor processor, TXThread changedThread) {
        this.nextThread = null;
        for (TXThread txThread : this.txThreads.values()) {
            if (txThread.state != 0) continue;
            if (this.nextThread == null) {
                this.nextThread = txThread;
                continue;
            }
            if (this.nextThread.priority <= txThread.priority) continue;
            this.nextThread = txThread;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("rescheduleThread nextThread=%s", this.nextThread));
        }
    }

    public void threadSuspend(ARMProcessor processor, TXThread txThread) {
        this.rescheduleThread(processor, txThread);
        this.threadSystemReturn(processor);
    }

    private void threadSystemReturn(ARMProcessor processor) {
        if (this.threadSystemState == 0) {
            processor.interpreter.exitInterpreter();
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("threadSystemReturn threadSystemState=0x%X", this.threadSystemState));
        }
    }

    private void setThreadWait(ARMProcessor processor, TXThread txThread, int state, int waitObjectPtr, int waitOption) {
        txThread.state = state;
        txThread.waitObjectPtr = waitObjectPtr;
        txThread.waitOption = waitOption;
        txThread.waitStartTicks = this.systemTick + 1;
        this.threadSuspend(processor, txThread);
    }

    private void threadRun(ARMProcessor processor, TXThread txThread) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("threadRun %s", txThread));
        }
        processor.interpreter.run();
    }

    private void threadContextSave(ARMProcessor processor, TXThread txThread) {
        if (txThread == null) {
            return;
        }
        txThread.savedCpsr = processor.getCpsr();
        for (int i = 0; i < 15; ++i) {
            txThread.savedRegisters[i] = processor.getRegister(i);
        }
        txThread.savedRegisters[15] = processor.getNextInstructionPc();
    }

    private void threadContextRestore(ARMProcessor processor, TXThread txThread) {
        if (txThread == null) {
            return;
        }
        processor.setCpsr(txThread.savedCpsr);
        for (int i = 0; i < 16; ++i) {
            processor.setRegister(i, txThread.savedRegisters[i]);
        }
    }

    private void incrementSystemTick(ARMProcessor processor) {
        ++this.systemTick;
        this.checkExpiredTimers(processor);
        this.checkWaitingThreads(processor);
    }

    private void checkExpiredTimers(ARMProcessor processor) {
        LinkedList<TXTimer> expiredTimers = null;
        for (TXTimer txTimer : this.activatedTimers) {
            if (txTimer.expirationTicks > this.systemTick) continue;
            if (expiredTimers == null) {
                expiredTimers = new LinkedList<TXTimer>();
            }
            expiredTimers.add(txTimer);
        }
        if (expiredTimers != null) {
            this.activatedTimers.removeAll(expiredTimers);
            this.threadContextSave(processor, this.currentThread);
            for (TXTimer txTimer : expiredTimers) {
                this.processExpiredTimer(processor, txTimer);
            }
            this.threadContextRestore(processor, this.currentThread);
        }
    }

    private void processExpiredTimer(ARMProcessor processor, TXTimer txTimer) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting CodeBlock 0x%08X for %s", Utilities.clearBit(txTimer.expirationFunction, 0), txTimer));
        }
        processor.setRegister(0, txTimer.expirationInput);
        processor.setLr(-4);
        processor.jumpWithMode(txTimer.expirationFunction);
        processor.interpreter.run();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Returning from CodeBlock 0x%08X for %s", Utilities.clearBit(txTimer.expirationFunction, 0), txTimer));
        }
        txTimer.remainingTicks = txTimer.rescheduleTicks;
        this.timerActivate(processor, txTimer);
    }

    public int timerCreate(ARMProcessor processor, int timerPtr, String timerName, int expirationFunction, int expirationInput, int initialTicks, int rescheduleTicks, int autoActivate) {
        this.clear(processor, timerPtr, 44);
        TXTimer txTimer = new TXTimer();
        txTimer.timerPtr = timerPtr;
        txTimer.timerName = timerName;
        txTimer.expirationFunction = expirationFunction;
        txTimer.expirationInput = expirationInput;
        txTimer.remainingTicks = initialTicks;
        txTimer.rescheduleTicks = rescheduleTicks;
        this.txTimers.put(timerPtr, txTimer);
        if (autoActivate != 0) {
            this.timerActivate(processor, txTimer);
        }
        return 0;
    }

    public void timerActivate(ARMProcessor processor, TXTimer txTimer) {
        if (txTimer.remainingTicks > 0) {
            txTimer.expirationTicks = this.systemTick + txTimer.remainingTicks;
            this.activatedTimers.add(txTimer);
        }
    }

    public void triggerIrqException() {
        this.pendingIrqException = true;
    }

    private void triggerIrqException(ARMProcessor processor) {
        if (this.currentThread != null) {
            this.threadContextSave(processor, this.currentThread);
        }
        ++this.threadSystemState;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Starting CodeBlock 0x%08X for IRQ Handler", Utilities.clearBit(this.txIrqHandler, 0)));
        }
        processor.setLr(-4);
        processor.jumpWithMode(this.txIrqHandler);
        processor.interpreter.run();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Returning from CodeBlock 0x%08X for IRQ Handler", Utilities.clearBit(this.txIrqHandler, 0)));
        }
        --this.threadSystemState;
        if (this.currentThread != null) {
            this.threadContextRestore(processor, this.currentThread);
        }
    }

    public int eventFlagsCreate(ARMProcessor processor, int groupPtr, String groupName) {
        this.clear(processor, groupPtr, 32);
        TXEventFlagsGroup txEventFlagsGroup = new TXEventFlagsGroup();
        txEventFlagsGroup.groupPtr = groupPtr;
        txEventFlagsGroup.groupName = groupName;
        this.txEventFlags.put(groupPtr, txEventFlagsGroup);
        return 0;
    }

    private boolean checkEventFlagsGet(ARMProcessor processor, int requestedFlags, int getOption, int actualFlagsPtr, TXEventFlagsGroup txEventFlagsGroup) {
        boolean retrieved = Utilities.hasFlag(getOption, 2) ? (txEventFlagsGroup.current & requestedFlags) == requestedFlags : Utilities.hasFlag(txEventFlagsGroup.current, requestedFlags);
        if (retrieved) {
            int retrievedFlags = txEventFlagsGroup.current & requestedFlags;
            if (Utilities.hasFlag(getOption, 1)) {
                txEventFlagsGroup.current = Utilities.clearFlag(txEventFlagsGroup.current, retrievedFlags);
            }
            processor.mem.write32(actualFlagsPtr, retrievedFlags);
        }
        return retrieved;
    }

    private void checkThreadsWaitingOnEventFlags(ARMProcessor processor, TXEventFlagsGroup txEventFlagsGroup) {
        boolean systemReturn = false;
        for (TXThread txThread : this.txThreads.values()) {
            if (txThread.state != 7 || txThread.waitObjectPtr != txEventFlagsGroup.groupPtr || !this.checkEventFlagsGet(processor, txThread.waitEventFlagsRequestedFlags, txThread.waitEventFlagsGetOption, txThread.waitEventFlagsActualFlagsPtr, txEventFlagsGroup)) continue;
            txThread.savedRegisters[0] = 0;
            if (!this.threadResume(processor, txThread)) continue;
            systemReturn = true;
        }
        if (systemReturn) {
            this.threadSystemReturn(processor);
        }
    }

    public int eventFlagsSet(ARMProcessor processor, int groupPtr, int flagsToSet, int setOption) {
        TXEventFlagsGroup txEventFlagsGroup = this.txEventFlags.get(groupPtr);
        if (txEventFlagsGroup == null) {
            log.error((Object)String.format("eventFlagsSet unknown groupPtr=0x%08X", groupPtr));
            return 3;
        }
        txEventFlagsGroup.current = Utilities.hasFlag(setOption, 2) ? (txEventFlagsGroup.current &= flagsToSet) : (txEventFlagsGroup.current |= flagsToSet);
        this.checkThreadsWaitingOnEventFlags(processor, txEventFlagsGroup);
        return 0;
    }

    public int eventFlagsGet(ARMProcessor processor, int groupPtr, int requestedFlags, int getOption, int actualFlagsPtr, int waitOption) {
        int result;
        TXEventFlagsGroup txEventFlagsGroup = this.txEventFlags.get(groupPtr);
        if (txEventFlagsGroup == null) {
            log.error((Object)String.format("eventFlagsGet unknown groupPtr=0x%08X", groupPtr));
            return 3;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("TXEventFlagsGet txEventFlagsGroup=%s", txEventFlagsGroup));
        }
        if (this.checkEventFlagsGet(processor, requestedFlags, getOption, actualFlagsPtr, txEventFlagsGroup)) {
            result = 0;
        } else if (waitOption == 0) {
            result = 7;
        } else {
            TXThread txThread = this.currentThread;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("TXEventFlagsGet suspending %s", txThread));
            }
            this.setThreadWait(processor, txThread, 7, groupPtr, waitOption);
            txThread.waitEventFlagsRequestedFlags = requestedFlags;
            txThread.waitEventFlagsGetOption = getOption;
            txThread.waitEventFlagsActualFlagsPtr = actualFlagsPtr;
            result = 7;
        }
        return result;
    }

    public int queueCreate(ARMProcessor processor, int queuePtr, String queueName, int messageSize, int queueStart, int queueSize) {
        this.clear(processor, queuePtr, 56);
        TXQueue txQueue = new TXQueue();
        txQueue.queuePtr = queuePtr;
        txQueue.queueName = queueName;
        txQueue.messageSize = messageSize;
        txQueue.queueStart = queueStart;
        txQueue.capacity = queueSize / (messageSize << 2);
        txQueue.init();
        this.txQueues.put(queuePtr, txQueue);
        return 0;
    }

    private void checkThreadsWaitingOnQueueReceive(ARMProcessor processor, TXQueue txQueue) {
        boolean systemReturn = false;
        for (TXThread txThread : this.txThreads.values()) {
            if (txThread.state != 5 || txThread.waitObjectPtr != txQueue.queuePtr || !txThread.waitQueueReceive || !this.checkQueueReceive(processor, txThread.waitQueueDestinationPtr, txThread.waitOption, txQueue)) continue;
            txThread.savedRegisters[0] = 0;
            if (!this.threadResume(processor, txThread)) continue;
            systemReturn = true;
        }
        if (systemReturn) {
            this.threadSystemReturn(processor);
        }
    }

    private void checkThreadsWaitingOnQueueSend(ARMProcessor processor, TXQueue txQueue) {
        boolean systemReturn = false;
        for (TXThread txThread : this.txThreads.values()) {
            if (txThread.state != 5 || txThread.waitObjectPtr != txQueue.queuePtr || txThread.waitQueueReceive || !this.checkQueueSend(processor, txThread.waitQueueSourcePtr, txThread.waitOption, txQueue)) continue;
            txThread.savedRegisters[0] = 0;
            if (!this.threadResume(processor, txThread)) continue;
            systemReturn = true;
        }
        if (systemReturn) {
            this.threadSystemReturn(processor);
        }
    }

    private boolean checkQueueReceive(ARMProcessor processor, int destinationPtr, int waitOption, TXQueue txQueue) {
        if (txQueue.enqueued <= 0) {
            return false;
        }
        int sizeInBytes = txQueue.messageSize << 2;
        processor.mem.memcpy(destinationPtr, txQueue.queueRead, sizeInBytes);
        txQueue.queueRead += sizeInBytes;
        if (txQueue.queueRead == txQueue.queueEnd) {
            txQueue.queueRead = txQueue.queueStart;
        }
        ++txQueue.availableStorage;
        --txQueue.enqueued;
        this.checkThreadsWaitingOnQueueSend(processor, txQueue);
        return true;
    }

    private boolean checkQueueSend(ARMProcessor processor, int sourcePtr, int waitOption, TXQueue txQueue) {
        if (txQueue.availableStorage <= 0) {
            return false;
        }
        int sizeInBytes = txQueue.messageSize << 2;
        processor.mem.memcpy(txQueue.queueWrite, sourcePtr, sizeInBytes);
        txQueue.queueWrite += sizeInBytes;
        if (txQueue.queueWrite == txQueue.queueEnd) {
            txQueue.queueWrite = txQueue.queueStart;
        }
        --txQueue.availableStorage;
        ++txQueue.enqueued;
        this.checkThreadsWaitingOnQueueReceive(processor, txQueue);
        return true;
    }

    public int queueReceive(ARMProcessor processor, int queuePtr, int destinationPtr, int waitOption) {
        int result;
        TXQueue txQueue = this.txQueues.get(queuePtr);
        if (txQueue == null) {
            log.error((Object)String.format("queueReceive unknown queuePtr=0x%08X", queuePtr));
            return 3;
        }
        if (this.checkQueueReceive(processor, destinationPtr, waitOption, txQueue)) {
            result = 0;
        } else if (waitOption == 0) {
            result = 10;
        } else {
            TXThread txThread = this.currentThread;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("TXQueueReceive suspending %s", txThread));
            }
            this.setThreadWait(processor, txThread, 5, queuePtr, waitOption);
            txThread.waitQueueReceive = true;
            txThread.waitQueueDestinationPtr = destinationPtr;
            result = 10;
        }
        return result;
    }

    public int queueSend(ARMProcessor processor, int queuePtr, int sourcePtr, int waitOption) {
        int result;
        TXQueue txQueue = this.txQueues.get(queuePtr);
        if (txQueue == null) {
            log.error((Object)String.format("queueSend unknown queuePtr=0x%08X", queuePtr));
            return 3;
        }
        if (this.checkQueueSend(processor, sourcePtr, waitOption, txQueue)) {
            result = 0;
        } else if (waitOption == 0) {
            result = 11;
        } else {
            TXThread txThread = this.currentThread;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("TXQueueSend suspending %s", txThread));
            }
            this.setThreadWait(processor, txThread, 5, queuePtr, waitOption);
            txThread.waitQueueReceive = false;
            txThread.waitQueueSourcePtr = sourcePtr;
            result = 11;
        }
        return result;
    }

    public int semaphoreCreate(ARMProcessor processor, int semaphorePtr, String semaphoreName, int initialCount) {
        this.clear(processor, semaphorePtr, 28);
        TXSemaphore txSemaphore = new TXSemaphore();
        txSemaphore.semaphorePtr = semaphorePtr;
        txSemaphore.semaphoreName = semaphoreName;
        txSemaphore.count = initialCount;
        this.txSemaphores.put(semaphorePtr, txSemaphore);
        return 0;
    }

    private boolean checkSemaphoreGet(ARMProcessor processor, int waitOption, TXSemaphore txSemaphore) {
        if (txSemaphore.count <= 0) {
            return false;
        }
        --txSemaphore.count;
        return true;
    }

    private void checkThreadsWaitingOnSemaphoreGet(ARMProcessor processor, TXSemaphore txSemaphore) {
        boolean systemReturn = false;
        for (TXThread txThread : this.txThreads.values()) {
            if (txThread.state != 6 || txThread.waitObjectPtr != txSemaphore.semaphorePtr || !this.checkSemaphoreGet(processor, txThread.waitOption, txSemaphore)) continue;
            txThread.savedRegisters[0] = 0;
            if (!this.threadResume(processor, txThread)) continue;
            systemReturn = true;
        }
        if (systemReturn) {
            this.threadSystemReturn(processor);
        }
    }

    public int semaphoreGet(ARMProcessor processor, int semaphorePtr, int waitOption) {
        int result;
        TXSemaphore txSemaphore = this.txSemaphores.get(semaphorePtr);
        if (txSemaphore == null) {
            log.error((Object)String.format("semaphoreGet unknown semaphorePtr=0x%08X", semaphorePtr));
            return 3;
        }
        if (this.checkSemaphoreGet(processor, waitOption, txSemaphore)) {
            result = 0;
        } else if (waitOption == 0) {
            result = 13;
        } else {
            TXThread txThread = this.currentThread;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("TXSemaphoreGet suspending %s", txThread));
            }
            this.setThreadWait(processor, txThread, 6, semaphorePtr, waitOption);
            result = 13;
        }
        return result;
    }

    public int semaphorePut(ARMProcessor processor, int semaphorePtr) {
        TXSemaphore txSemaphore = this.txSemaphores.get(semaphorePtr);
        if (txSemaphore == null) {
            log.error((Object)String.format("semaphorePut unknown semaphorePtr=0x%08X", semaphorePtr));
            return 3;
        }
        ++txSemaphore.count;
        this.checkThreadsWaitingOnSemaphoreGet(processor, txSemaphore);
        return 0;
    }

    public int timeGet(ARMProcessor processor) {
        return this.systemTick;
    }
}

