/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.io.IOException;
import java.net.InetAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.Memory;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.AdhocMessage;
import jpcsp.network.adhoc.AdhocServerStreamSocket;
import jpcsp.network.adhoc.AdhocSocket;
import jpcsp.network.adhoc.AdhocStreamSocket;
import jpcsp.network.adhoc.PtpObject;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;

public class ProOnlinePtpObject
extends PtpObject {
    protected final ProOnlineNetworkAdapter proOnline;
    private static final String socketProtocol = "TCP";
    protected boolean isServerSocket;

    public ProOnlinePtpObject(ProOnlinePtpObject ptpObject) {
        super(ptpObject);
        this.proOnline = ptpObject.proOnline;
    }

    public ProOnlinePtpObject(INetworkAdapter networkAdapter) {
        super(networkAdapter);
        this.proOnline = (ProOnlineNetworkAdapter)networkAdapter;
    }

    @Override
    protected boolean pollAccept(int peerMacAddr, int peerPortAddr, SceKernelThreadInfo thread) {
        boolean acceptCompleted = false;
        try {
            byte[] destMacAddress;
            AdhocSocket acceptedSocket = this.socket.accept();
            if (acceptedSocket != null && (destMacAddress = this.proOnline.getMacAddress(acceptedSocket.getReceivedAddress())) != null) {
                pspNetMacAddress peerMacAddress = new pspNetMacAddress(destMacAddress);
                int peerPort = acceptedSocket.getReceivedPort();
                Memory mem = Memory.getInstance();
                if (peerMacAddr != 0) {
                    peerMacAddress.write(mem, peerMacAddr);
                }
                if (peerPortAddr != 0) {
                    mem.write16(peerPortAddr, (short)peerPort);
                }
                ProOnlinePtpObject ptpObject = new ProOnlinePtpObject(this);
                ptpObject.setDestMacAddress(peerMacAddress);
                ptpObject.setDestPort(peerPort);
                ptpObject.setSocket(acceptedSocket);
                Modules.sceNetAdhocModule.hleAddPtpObject(ptpObject);
                ProOnlinePtpObject.setReturnValue(thread, ptpObject.getId());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("accept completed, creating new Ptp object %s", ptpObject));
                }
                acceptCompleted = true;
            }
        }
        catch (SocketTimeoutException acceptedSocket) {
        }
        catch (IOException e) {
            log.error((Object)"pollAccept", (Throwable)e);
        }
        return acceptCompleted;
    }

    @Override
    protected boolean pollConnect(SceKernelThreadInfo thread) {
        return true;
    }

    @Override
    public boolean canAccept() {
        return true;
    }

    @Override
    public boolean canConnect() {
        return true;
    }

    @Override
    protected AdhocSocket createSocket() throws UnknownHostException, IOException {
        return this.isServerSocket ? new AdhocServerStreamSocket() : new AdhocStreamSocket();
    }

    @Override
    public int open() {
        this.proOnline.sceNetPortOpen(socketProtocol, this.getPort());
        this.isServerSocket = false;
        return super.open();
    }

    @Override
    public int listen() {
        this.proOnline.sceNetPortOpen(socketProtocol, this.getPort());
        this.isServerSocket = true;
        return super.listen();
    }

    @Override
    public void delete() {
        this.proOnline.sceNetPortClose(socketProtocol, this.getPort());
        super.delete();
    }

    @Override
    protected boolean isForMe(AdhocMessage adhocMessage, int port, InetAddress address) {
        return true;
    }
}

