/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.protocols;

import java.io.EOFException;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.network.protocols.NetPacket;

public class EtherFrame {
    public static final int ETHER_TYPE_IPv4 = 2048;
    public static final int ETHER_TYPE_ARP = 2054;
    public pspNetMacAddress dstMac;
    public pspNetMacAddress srcMac;
    public int type;

    public EtherFrame() {
    }

    public EtherFrame(EtherFrame frame) {
        this.dstMac = frame.dstMac;
        this.srcMac = frame.srcMac;
        this.type = frame.type;
    }

    public void swapSourceAndDestination() {
        pspNetMacAddress mac = this.srcMac;
        this.srcMac = this.dstMac;
        this.dstMac = mac;
    }

    public void read(NetPacket packet) throws EOFException {
        this.dstMac = packet.readMacAddress();
        this.srcMac = packet.readMacAddress();
        this.type = packet.read16();
    }

    public NetPacket write(NetPacket packet) throws EOFException {
        packet.writeMacAddress(this.dstMac);
        packet.writeMacAddress(this.srcMac);
        packet.write16(this.type);
        return packet;
    }

    public NetPacket write() throws EOFException {
        return this.write(new NetPacket(EtherFrame.sizeOf()));
    }

    public static int sizeOf() {
        return 14;
    }

    public String toString() {
        return String.format("dstMac=%s, srcMac=%s, type/length=0x%04X", this.dstMac, this.srcMac, this.type);
    }
}

