/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.upnp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.DatagramPacket;
import java.net.HttpURLConnection;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.MulticastSocket;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jpcsp.State;
import jpcsp.network.upnp.IGD;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UPnP {
    public static Logger log = Logger.getLogger((String)"upnp");
    protected IGD igd;
    private volatile boolean end;
    public static final int discoveryTimeoutMillis = 2000;
    public static final int discoveryPort = 1900;
    public static final int discoverySearchPort = 1901;
    public static final String multicastIp = "239.255.255.250";
    private static final String[] deviceList = new String[]{"urn:schemas-upnp-org:device:InternetGatewayDevice:1", "urn:schemas-upnp-org:service:WANIPConnection:1", "urn:schemas-upnp-org:service:WANPPPConnection:1", "upnp:rootdevice"};

    public void discoverInBackground() {
        DiscoverThread discoverThread = new DiscoverThread();
        discoverThread.setName("UPnP Discover Thread");
        discoverThread.setDaemon(true);
        discoverThread.start();
    }

    public void stop() {
        this.end = true;
    }

    public void discover() {
        try {
            this.igd = new IGD();
            ListenerThread listener = new ListenerThread(this, this.igd);
            listener.setDaemon(true);
            listener.setName("UPnP Discovery Listener");
            listener.start();
            while (!listener.isReady()) {
                Utilities.sleep(100);
            }
            for (String device : deviceList) {
                String discoveryRequest = String.format("M-SEARCH * HTTP/1.1\r\nHOST: %s:%d\r\nST: %s\r\nMAN: \"ssdp:discover\"\r\nMX: %d\r\n\r\n", multicastIp, 1900, device, 2);
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements()) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    if (!networkInterface.isUp() || !networkInterface.supportsMulticast()) continue;
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements()) {
                        InetAddress address = addresses.nextElement();
                        if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                        MulticastSocket socket = new MulticastSocket(new InetSocketAddress(address, 1901));
                        InetSocketAddress socketAddress = new InetSocketAddress(multicastIp, 1900);
                        DatagramPacket packet = new DatagramPacket(discoveryRequest.getBytes(), discoveryRequest.length(), socketAddress);
                        socket.send(packet);
                        socket.disconnect();
                        socket.close();
                    }
                }
            }
            for (int i = 0; i < 200 && !this.end && !listener.isDone(); ++i) {
                Utilities.sleep(10, 0);
            }
            listener.setDone(true);
            while (!listener.isReady() && !listener.isEnded()) {
                Utilities.sleep(100);
            }
        }
        catch (IOException e) {
            log.error((Object)"discover", (Throwable)e);
        }
    }

    public IGD getIGD() {
        return this.igd;
    }

    protected HashMap<String, String> executeSimpleUPnPcommand(String controlUrl, String serviceType, String action, HashMap<String, String> arguments) {
        HashMap<String, String> result;
        block11: {
            result = null;
            StringBuilder body = new StringBuilder();
            body.append(String.format("<?xml version=\"1.0\"?>\r\n", new Object[0]));
            body.append(String.format("<s:Envelope xmlns:s=\"http://schemas.xmlsoap.org/soap/envelope/\" s:encodingStyle=\"http://schemas.xmlsoap.org/soap/encoding/\">\r\n", new Object[0]));
            body.append(String.format("<s:Body>\r\n", new Object[0]));
            body.append(String.format("  <u:%s xmlns:u=\"%s\">\r\n", action, serviceType));
            if (arguments != null) {
                for (String name : arguments.keySet()) {
                    String value = arguments.get(name);
                    if (value == null || value.isEmpty()) {
                        body.append(String.format("    <%s />\r\n", name));
                        continue;
                    }
                    body.append(String.format("    <%s>%s</%s>\r\n", name, value, name));
                }
            }
            body.append(String.format("  </u:%s>\r\n", action));
            body.append(String.format("</s:Body>\r\n", new Object[0]));
            body.append(String.format("</s:Envelope>\r\n", new Object[0]));
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("Sending UPnP command: %s", body.toString()));
            }
            byte[] bodyBytes = body.toString().getBytes();
            try {
                String errorCode;
                int n;
                URL url = new URL(controlUrl);
                URLConnection connection = url.openConnection();
                if (connection instanceof HttpURLConnection) {
                    HttpURLConnection httpURLConnection = (HttpURLConnection)connection;
                    httpURLConnection.setRequestMethod("POST");
                }
                connection.setRequestProperty("SOAPAction", String.format("%s#%s", serviceType, action));
                connection.setRequestProperty("Content-Type", "text/xml");
                connection.setRequestProperty("Content-Length", Integer.toString(bodyBytes.length));
                connection.setDoOutput(true);
                OutputStream output = connection.getOutputStream();
                output.write(bodyBytes);
                output.flush();
                output.close();
                connection.connect();
                InputStream response = connection.getInputStream();
                StringBuilder content = new StringBuilder();
                byte[] buffer = new byte[1024];
                do {
                    if ((n = response.read(buffer)) <= 0) continue;
                    content.append(new String(buffer, 0, n));
                } while (n >= 0);
                response.close();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("UPnP command serviceType %s, action %s, result: %s", serviceType, action, content.toString()));
                }
                result = this.parseSimpleUPnPCommand(content.toString());
                if (log.isDebugEnabled() && (errorCode = result.get("errorCode")) != null) {
                    log.debug((Object)String.format("UPnP command %s: errorCode = %s", action, errorCode));
                }
            }
            catch (MalformedURLException e) {
                log.error((Object)"executeUPnPcommand", (Throwable)e);
            }
            catch (IOException e) {
                if (!log.isDebugEnabled()) break block11;
                log.debug((Object)"executeUPnPcommand", (Throwable)e);
            }
        }
        return result;
    }

    public HashMap<String, String> parseSimpleUPnPCommand(String content) {
        HashMap<String, String> result = null;
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        documentBuilderFactory.setIgnoringComments(true);
        documentBuilderFactory.setCoalescing(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document response = documentBuilder.parse(new ByteArrayInputStream(content.getBytes()));
            result = new HashMap<String, String>();
            this.parseElement(response.getDocumentElement(), result, null);
        }
        catch (ParserConfigurationException e) {
            log.error((Object)"parseSimpleUPnPCommand", (Throwable)e);
        }
        catch (SAXException e) {
            log.error((Object)"parseSimpleUPnPCommand", (Throwable)e);
        }
        catch (MalformedURLException e) {
            log.error((Object)"parseSimpleUPnPCommand", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"parseSimpleUPnPCommand", (Throwable)e);
        }
        return result;
    }

    protected void parseElement(Element element, HashMap<String, String> result, String name) {
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node node = children.item(i);
            if (node instanceof Element) {
                this.parseElement((Element)node, result, node.getNodeName());
                continue;
            }
            if (name == null || node.getTextContent() == null) continue;
            String value = node.getTextContent();
            if (result.containsKey(name)) {
                value = result.get(name) + value;
            }
            result.put(name, value);
        }
    }

    public String getStatusInfo(String controlUrl, String serviceType) {
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "GetStatusInfo", null);
        return result.get("NewConnectionStatus");
    }

    public String getExternalIPAddress(String controlUrl, String serviceType) {
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "GetExternalIPAddress", null);
        if (result == null) {
            return null;
        }
        return result.get("NewExternalIPAddress");
    }

    public void addPortMapping(String controlUrl, String serviceType, String remoteHost, int externalPort, String protocol, int internalPort, String internalClient, String description, int leaseDuration) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("NewRemoteHost", remoteHost);
        arguments.put("NewExternalPort", Integer.toString(externalPort));
        arguments.put("NewProtocol", this.getProtocol(protocol));
        arguments.put("NewInternalPort", Integer.toString(internalPort));
        arguments.put("NewInternalClient", internalClient);
        arguments.put("NewEnabled", "1");
        arguments.put("NewPortMappingDescription", description != null ? description : String.format("Jpcsp-%s", State.discId));
        arguments.put("NewLeaseDuration", Integer.toString(leaseDuration));
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "AddPortMapping", arguments);
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)String.format("addPortMapping errorCode=%s", result.get("errorCode")));
        }
    }

    public void deletePortMapping(String controlUrl, String serviceType, String remoteHost, int externalPort, String protocol) {
        HashMap<String, String> arguments = new HashMap<String, String>();
        arguments.put("NewRemoteHost", remoteHost);
        arguments.put("NewExternalPort", Integer.toString(externalPort));
        arguments.put("NewProtocol", this.getProtocol(protocol));
        HashMap<String, String> result = this.executeSimpleUPnPcommand(controlUrl, serviceType, "DeletePortMapping", arguments);
        if (log.isDebugEnabled() && result != null) {
            log.debug((Object)String.format("deletePortMapping errorCode=%s", result.get("errorCode")));
        }
    }

    protected String getProtocol(String protocol) {
        if (protocol != null && !(protocol = protocol.toUpperCase()).equals("TCP") && !protocol.equals("UDP")) {
            protocol = null;
        }
        return protocol;
    }

    private static class ListenerThread
    extends Thread {
        private UPnP upnp;
        private IGD igd;
        private boolean done;
        private volatile boolean ready;
        private volatile boolean end;

        public ListenerThread(UPnP upnp, IGD igd) {
            this.upnp = upnp;
            this.igd = igd;
        }

        @Override
        public void run() {
            MulticastSocket[] sockets = new MulticastSocket[100];
            int numberSockets = 0;
            try {
                Enumeration<NetworkInterface> networkInterfaces = NetworkInterface.getNetworkInterfaces();
                while (networkInterfaces.hasMoreElements() && numberSockets < sockets.length) {
                    NetworkInterface networkInterface = networkInterfaces.nextElement();
                    if (!networkInterface.isUp() || !networkInterface.supportsMulticast() || networkInterface.isLoopback()) continue;
                    Enumeration<InetAddress> addresses = networkInterface.getInetAddresses();
                    while (addresses.hasMoreElements() && numberSockets < sockets.length) {
                        InetAddress address = addresses.nextElement();
                        if (!(address instanceof Inet4Address) || address.isLoopbackAddress()) continue;
                        sockets[numberSockets] = new MulticastSocket(new InetSocketAddress(address, 1901));
                        sockets[numberSockets].setSoTimeout(1);
                        ++numberSockets;
                    }
                }
            }
            catch (SocketException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            HashSet<String> processedUrls = new HashSet<String>();
            this.ready = true;
            byte[] buffer = new byte[1536];
            while (!this.isDone()) {
                for (int i = 0; i < numberSockets && !this.isDone(); ++i) {
                    try {
                        DatagramPacket responsePacket = new DatagramPacket(buffer, buffer.length);
                        sockets[i].receive(responsePacket);
                        if (responsePacket.getLength() <= 0) continue;
                        String reply = new String(responsePacket.getData(), responsePacket.getOffset(), responsePacket.getLength());
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Discovery: %s", reply));
                        }
                        String location = null;
                        Pattern pLocation = Pattern.compile("^location: *(\\S+)$", 42);
                        Matcher mLocation = pLocation.matcher(reply);
                        if (mLocation.find()) {
                            location = mLocation.group(1);
                        }
                        String st = null;
                        Pattern pSt = Pattern.compile("^st: *(\\S+)$", 42);
                        Matcher mSt = pSt.matcher(reply);
                        if (mSt.find()) {
                            st = mSt.group(1);
                        }
                        if (location != null && st != null) {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("Location: '%s', st: '%s'", location, st));
                            }
                            if (processedUrls.contains(location)) continue;
                            this.igd.discover(location);
                            processedUrls.add(location);
                            if (!this.igd.isValid() || !this.igd.isConnected(this.upnp)) continue;
                            if (log.isDebugEnabled()) {
                                log.debug((Object)String.format("IGD connected with external IP: %s", this.igd.getExternalIPAddress(this.upnp)));
                            }
                            this.setDone(true);
                            continue;
                        }
                        log.error((Object)String.format("Could not parse discovery response: %s", reply));
                        continue;
                    }
                    catch (SocketTimeoutException socketTimeoutException) {
                        continue;
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            for (int i = 0; i < numberSockets; ++i) {
                sockets[i].disconnect();
                sockets[i].close();
            }
            this.ready = true;
            this.end = true;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
            this.ready = false;
        }

        public boolean isReady() {
            return this.ready;
        }

        public boolean isEnded() {
            return this.end;
        }
    }

    private class DiscoverThread
    extends Thread {
        private DiscoverThread() {
        }

        @Override
        public void run() {
            UPnP.this.discover();
        }
    }
}

