/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.sound;

import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.MemoryReader;
import jpcsp.sound.ISampleSource;
import jpcsp.sound.SoftwareSynthesizer;
import jpcsp.sound.SoundVoice;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SampleSourceVAG
implements ISampleSource {
    private static Logger log = SoftwareSynthesizer.log;
    private SoundVoice voice;
    private int address;
    private int numberSamples;
    private IMemoryReader memoryReader;
    private final int[] unpackedSamples = new int[28];
    private final short[] samples = new short[28];
    private int sampleIndex = this.samples.length;
    private int numberVGABlocks;
    private int currentVAGBlock;
    private int currentSampleIndex;
    private int hist1;
    private int hist2;
    private boolean loopMode;
    private int loopStartVAGBlock;
    private boolean loopAtNextVAGBlock;
    private static final double[][] VAG_f = new double[][]{{0.0, 0.0}, {0.9375, 0.0}, {1.796875, -0.8125}, {1.53125, -0.859375}, {1.90625, -0.9375}};

    public SampleSourceVAG(SoundVoice voice, int address, int size, boolean loopMode) {
        this.voice = voice;
        this.address = address;
        this.loopMode = loopMode;
        if (address == 0) {
            this.numberSamples = 0;
            this.numberVGABlocks = 0;
        } else {
            this.readHeader();
            this.numberVGABlocks = size / 16;
            this.numberSamples = this.numberVGABlocks * 28;
            this.currentSampleIndex = -1;
            this.setSampleIndex(0);
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("VAG numberVGABlocks=%d, numberSamples=%d", this.numberVGABlocks, this.numberSamples));
            }
        }
    }

    private void readHeader() {
        Memory mem = Memory.getInstance();
        int header = mem.read32(this.address);
        if ((header & 0xFFFFFF) == 4669782) {
            int version = Integer.reverseBytes(mem.read32(this.address + 4));
            int dataSize = Integer.reverseBytes(mem.read32(this.address + 12));
            int sampleRate = Integer.reverseBytes(mem.read32(this.address + 16));
            String dataName = new StringBuffer(Utilities.readStringNZ(this.address + 32, 16)).reverse().toString();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("SampleSourceVAG found VAG/ADPCM data: version=%d, size=%d, sampleRate=%d, dataName='%s'", version, dataSize, sampleRate, dataName));
            }
            this.address += 48;
        }
    }

    private boolean unpackNextVAGBlock() {
        int j;
        if (this.currentVAGBlock >= this.numberVGABlocks) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("VAG reached end of blocks currentVAGBlock=%d, numberVAGBlocks=%d", this.currentVAGBlock, this.numberVGABlocks));
            }
            return false;
        }
        this.sampleIndex = 0;
        int n = this.memoryReader.readNext();
        int predict_nr = n >> 4;
        if (predict_nr >= VAG_f.length) {
            predict_nr = 0;
        }
        int shift_factor = n & 0xF;
        int flag = this.memoryReader.readNext();
        if (flag == 3) {
            if (this.loopMode && this.voice.isOn()) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("SampleSourceVAG loop at next VAG Block[%d], voice=0x%X", this.currentVAGBlock, this.voice.getIndex()));
                }
                this.loopAtNextVAGBlock = true;
            }
        } else if (flag == 6) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("SampleSourceVAG loop start VAG Block[%d], voice=0x%X", this.currentVAGBlock, this.voice.getIndex()));
            }
            this.loopStartVAGBlock = this.currentVAGBlock;
        } else if (flag == 7) {
            this.numberVGABlocks = this.currentVAGBlock;
            this.numberSamples = this.numberVGABlocks * 28;
            this.sampleIndex = this.samples.length;
            return false;
        }
        for (j = 0; j < 28; j += 2) {
            int d = this.memoryReader.readNext();
            short s = (short)((d & 0xF) << 12);
            this.unpackedSamples[j] = s >> shift_factor;
            s = (short)((d & 0xF0) << 8);
            this.unpackedSamples[j + 1] = s >> shift_factor;
        }
        for (j = 0; j < 28; ++j) {
            int sample = (int)((double)this.unpackedSamples[j] + (double)this.hist1 * VAG_f[predict_nr][0] + (double)this.hist2 * VAG_f[predict_nr][1]);
            this.hist2 = this.hist1;
            this.hist1 = sample;
            this.samples[j] = sample < Short.MIN_VALUE ? Short.MIN_VALUE : (sample > Short.MAX_VALUE ? Short.MAX_VALUE : (short)sample);
        }
        ++this.currentVAGBlock;
        return true;
    }

    @Override
    public int getNextSample() {
        if (this.sampleIndex >= this.samples.length && !this.unpackNextVAGBlock()) {
            return 0;
        }
        short sample = this.samples[this.sampleIndex];
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("SampleSourceVAG.getNextSample[%d/%d]=0x%04X, voice=0x%X", this.sampleIndex, this.currentVAGBlock, sample & 0xFFFF, this.voice.getIndex()));
        }
        ++this.sampleIndex;
        ++this.currentSampleIndex;
        if (this.loopAtNextVAGBlock && this.sampleIndex >= this.samples.length) {
            this.loopAtNextVAGBlock = false;
            this.setSampleIndex(this.loopStartVAGBlock * 28);
        }
        return sample & 0xFFFF;
    }

    private void setSampleIndex(int index) {
        this.currentSampleIndex = index;
        this.currentVAGBlock = index / 28;
        if (this.currentVAGBlock >= this.numberVGABlocks) {
            this.sampleIndex = this.samples.length;
        } else {
            int restSamples = this.numberSamples - index;
            this.memoryReader = MemoryReader.getMemoryReader(this.address + (this.currentVAGBlock << 4), restSamples << 2, 1);
            if (this.unpackNextVAGBlock()) {
                this.sampleIndex = index % 28;
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("SampleSourceVAG.setSampleIndex %d = %d/%d, voice=0x%X", index, this.sampleIndex, this.currentVAGBlock, this.voice.getIndex()));
        }
    }

    @Override
    public void resetToStart() {
        this.currentSampleIndex = -1;
        this.setSampleIndex(0);
    }

    @Override
    public boolean isEnded() {
        if (this.currentVAGBlock > this.numberVGABlocks) {
            return true;
        }
        return this.currentVAGBlock == this.numberVGABlocks && this.sampleIndex >= this.samples.length;
    }

    public String toString() {
        return String.format("SampleSourceVAG[index=%d,VAG=%d[%d],loopStart=%d,loop at next=%b]", this.currentSampleIndex, this.currentVAGBlock, this.sampleIndex, this.loopStartVAGBlock, this.loopAtNextVAGBlock);
    }
}

