/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.io.File;
import java.net.URL;
import jpcsp.util.FileUtil;
import jpcsp.util.OS;

public class LWJGLFixer {
    private static boolean fixed = false;

    public static void fixOnce() {
        if (!fixed) {
            fixed = true;
            LWJGLFixer.fix();
        }
    }

    private static void fix() {
        try {
            LWJGLFixer.fixInternal();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }

    private static String[] getLibrariesToLoad() {
        if (OS.isWindows) {
            return new String[]{"lwjgl.dll", "lwjgl64.dll", "OpenAL32.dll", "OpenAL64.dll", "jinput-dx8.dll", "jinput-dx8_64.dll", "jinput-raw.dll", "jinput-raw_64.dll", "jinput-wintab.dll"};
        }
        if (OS.isLinux) {
            return new String[]{"liblwjgl.so", "liblwjgl64.so", "libopenal.so", "libopenal64.so", "libjinput-linux.so", "libjinput-linux64.so"};
        }
        if (OS.isMac) {
            return new String[]{"liblwjgl.dylib", "openal.dylib", "libjinput-osx.jnilib"};
        }
        return new String[0];
    }

    public static void fixInternal() throws Throwable {
        ClassLoader systemClassLoader = ClassLoader.getSystemClassLoader();
        String[] libraries = LWJGLFixer.getLibrariesToLoad();
        try {
            File folder = new File(System.getProperty("java.io.tmpdir") + "/lwgl-2.9.3/" + System.getProperty("user.name"));
            folder.mkdirs();
            for (String library : libraries) {
                URL libUrl = systemClassLoader.getResource(library);
                String basename = FileUtil.getURLBaseName(libUrl);
                File outFile = new File(folder, basename);
                if (outFile.exists()) continue;
                FileUtil.writeBytes(outFile, FileUtil.readURL(libUrl));
            }
            System.setProperty("org.lwjgl.librarypath", folder.getAbsolutePath());
            System.setProperty("net.java.games.input.librarypath", folder.getAbsolutePath());
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
    }
}

