/*
 * Decompiled with CFR 0.152.
 */
package com.xuggle.xuggler.demos;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IContainer;
import com.xuggle.xuggler.IPacket;
import com.xuggle.xuggler.IPixelFormat;
import com.xuggle.xuggler.IRational;
import com.xuggle.xuggler.IStream;
import com.xuggle.xuggler.IStreamCoder;
import com.xuggle.xuggler.IVideoPicture;
import com.xuggle.xuggler.video.ConverterFactory;
import com.xuggle.xuggler.video.IConverter;
import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;

public class CaptureScreenToFile {
    private final IContainer outContainer;
    private final IStream outStream;
    private final IStreamCoder outStreamCoder;
    private final IRational frameRate;
    private final Robot robot;
    private final Toolkit toolkit;
    private final Rectangle screenBounds;
    private long firstTimeStamp = -1L;

    public static void main(String[] args) {
        String outFile = null;
        if (args.length < 1) {
            outFile = "output.mp4";
        } else if (args.length == 1) {
            outFile = args[0];
        } else if (args.length > 1) {
            System.err.println("Must pass in an output file name");
            return;
        }
        try {
            CaptureScreenToFile videoEncoder = new CaptureScreenToFile(outFile);
            int index = 0;
            while ((double)index < 15.0 * videoEncoder.frameRate.getDouble()) {
                System.out.println("encoded image");
                videoEncoder.encodeImage(videoEncoder.takeSingleSnapshot());
                try {
                    Thread.sleep((long)(1000.0 / videoEncoder.frameRate.getDouble()));
                }
                catch (InterruptedException e) {
                    e.printStackTrace(System.out);
                }
                ++index;
            }
            videoEncoder.closeStreams();
        }
        catch (RuntimeException e) {
            System.err.println("we can't get permission to capture the screen");
        }
    }

    public CaptureScreenToFile(String outFile) {
        try {
            this.robot = new Robot();
        }
        catch (AWTException e) {
            System.out.println(e.getMessage());
            throw new RuntimeException(e);
        }
        this.toolkit = Toolkit.getDefaultToolkit();
        this.screenBounds = new Rectangle(this.toolkit.getScreenSize());
        this.frameRate = IRational.make(3, 1);
        this.outContainer = IContainer.make();
        int retval = this.outContainer.open(outFile, IContainer.Type.WRITE, null);
        if (retval < 0) {
            throw new RuntimeException("could not open output file");
        }
        ICodec codec = ICodec.guessEncodingCodec(null, null, outFile, null, ICodec.Type.CODEC_TYPE_VIDEO);
        if (codec == null) {
            throw new RuntimeException("could not guess a codec");
        }
        this.outStream = this.outContainer.addNewStream(codec);
        this.outStreamCoder = this.outStream.getStreamCoder();
        this.outStreamCoder.setNumPicturesInGroupOfPictures(30);
        this.outStreamCoder.setCodec(codec);
        this.outStreamCoder.setBitRate(25000);
        this.outStreamCoder.setBitRateTolerance(9000);
        int width = this.toolkit.getScreenSize().width;
        int height = this.toolkit.getScreenSize().height;
        this.outStreamCoder.setPixelType(IPixelFormat.Type.YUV420P);
        this.outStreamCoder.setHeight(height);
        this.outStreamCoder.setWidth(width);
        this.outStreamCoder.setFlag(IStreamCoder.Flags.FLAG_QSCALE, true);
        this.outStreamCoder.setGlobalQuality(0);
        this.outStreamCoder.setFrameRate(this.frameRate);
        this.outStreamCoder.setTimeBase(IRational.make(this.frameRate.getDenominator(), this.frameRate.getNumerator()));
        retval = this.outStreamCoder.open(null, null);
        if (retval < 0) {
            throw new RuntimeException("could not open input decoder");
        }
        retval = this.outContainer.writeHeader();
        if (retval < 0) {
            throw new RuntimeException("could not write file header");
        }
    }

    public void encodeImage(BufferedImage originalImage) {
        BufferedImage worksWithXugglerBufferedImage = CaptureScreenToFile.convertToType(originalImage, 5);
        IPacket packet = IPacket.make();
        long now = System.currentTimeMillis();
        if (this.firstTimeStamp == -1L) {
            this.firstTimeStamp = now;
        }
        IConverter converter = null;
        try {
            converter = ConverterFactory.createConverter(worksWithXugglerBufferedImage, IPixelFormat.Type.YUV420P);
        }
        catch (UnsupportedOperationException e) {
            System.out.println(e.getMessage());
            e.printStackTrace(System.out);
        }
        long timeStamp = (now - this.firstTimeStamp) * 1000L;
        IVideoPicture outFrame = converter.toPicture(worksWithXugglerBufferedImage, timeStamp);
        outFrame.setQuality(0);
        int retval = this.outStreamCoder.encodeVideo(packet, outFrame, 0);
        if (retval < 0) {
            throw new RuntimeException("could not encode video");
        }
        if (packet.isComplete() && (retval = this.outContainer.writePacket(packet)) < 0) {
            throw new RuntimeException("could not save packet to container");
        }
    }

    public void closeStreams() {
        int retval = this.outContainer.writeTrailer();
        if (retval < 0) {
            throw new RuntimeException("Could not write trailer to output file");
        }
    }

    public BufferedImage takeSingleSnapshot() {
        return this.robot.createScreenCapture(this.screenBounds);
    }

    public static BufferedImage convertToType(BufferedImage sourceImage, int targetType) {
        BufferedImage image;
        if (sourceImage.getType() == targetType) {
            image = sourceImage;
        } else {
            image = new BufferedImage(sourceImage.getWidth(), sourceImage.getHeight(), targetType);
            image.getGraphics().drawImage(sourceImage, 0, 0, null);
        }
        return image;
    }
}

