/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.office2007;

import com.jidesoft.icons.IconsFactory;
import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.plaf.basic.BasicJideButtonUI;
import com.jidesoft.plaf.basic.BasicPainter;
import com.jidesoft.plaf.basic.ThemePainter;
import com.jidesoft.plaf.office2003.Office2003Painter;
import com.jidesoft.swing.ComponentStateSupport;
import com.jidesoft.swing.JideSplitButton;
import com.jidesoft.swing.JideSwingUtilities;
import com.jidesoft.utils.ColorUtils;
import com.jidesoft.utils.SystemInfo;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.geom.Area;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class Office2007Painter
extends BasicPainter {
    public static final String IS_MENU_PART_BUTTON = "isMenuPartButton";
    private static Office2007Painter _instance;
    private ThemePainter _defaultPainter;
    private static final Color[] STATUS_BAR_BG;
    private static final Color[] SPECIAL_STATUS_BAR_BG;
    private static final Color[] DOCKABLE_FRAME_TITLE_BAR_BG;
    private static final Color[] ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG;
    private static final Color[] COLLAPSIBLE_PANE_TITLE_BAR_BG;
    private static final Color[] EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG;
    private static final Color[] COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG;
    private static final Color[] EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG;

    public static ThemePainter getInstance() {
        if (_instance == null) {
            _instance = new Office2007Painter();
        }
        return _instance;
    }

    protected Office2007Painter() {
    }

    protected ThemePainter createDefaultPainter() {
        return Office2003Painter.getInstance();
    }

    public ThemePainter getDefaultPainter() {
        if (this._defaultPainter == null) {
            this._defaultPainter = this.createDefaultPainter();
        }
        return this._defaultPainter;
    }

    public void installDefaults() {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.installDefaults();
        }
    }

    public void uninstallDefaults() {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.uninstallDefaults();
        }
    }

    public void paintContentBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        graphics2D.setColor(bl != false ? UIDefaultsLookup.getColor("Content.background") : new Color(0xBFDBFF));
        graphics2D.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2D.dispose();
    }

    private void paintButtonBorder(Component component, Graphics graphics, Rectangle rectangle, int n) {
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (n == 3 || n == 1) {
            graphics2D.setColor(new Color(9139796));
            graphics2D.drawLine(n2 + 1, n3, n2 + n4 - 2, n3);
            graphics2D.setPaint(new GradientPaint(n2, n3 + 1, new Color(9139796), n2, n3 + n5 - 3, new Color(12892584)));
            graphics2D.drawLine(n2, n3 + 1, n2, n3 + n5 - 3);
            graphics2D.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 3);
            graphics2D.setColor(new Color(15977082));
            graphics2D.drawLine(n2, n3 + n5 - 3, n2, n3 + n5 - 3);
            graphics2D.drawLine(n2 + n4 - 1, n3 + n5 - 3, n2 + n4 - 1, n3 + n5 - 3);
            if (component instanceof JideSplitButton && BasicJideButtonUI.shouldWrapText(component)) {
                graphics2D.setColor(new Color(13680517));
                graphics2D.drawLine(n2, n3 + n5 - 30, n2 + n4, n3 + n5 - 30);
            }
        } else if (n == 2) {
            if (n5 != 0) {
                Paint paint = JideSwingUtilities.getLinearGradientPaint(n2, n3, n2, n3 + n5, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(14207638), new Color(12165236), new Color(12102030)});
                graphics2D.setPaint(paint);
            }
            graphics2D.drawLine(n2, n3 + 1, n2, n5 - 2);
            graphics2D.setColor(new Color(14405273));
            graphics2D.drawLine(n2 + 1, n3, n2 + n4 - 2, n3);
            graphics2D.setPaint(new GradientPaint(n2, n3 + n5, new Color(12299927), n2 + (n4 >> 1), n3 + n5, new Color(13353898), true));
            graphics2D.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 2, n3 + n5 - 1);
            if (n5 - 1 != 0) {
                graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n2 + n4 - 1, n3, n2 + n4 - 1, n3 + n5 - 1, new float[]{0.0f, 0.5f, 1.0f}, new Color[]{new Color(14470810), new Color(12823418), new Color(13815481)}));
            }
            graphics2D.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 2);
            graphics2D.setColor(new Color(15393448));
            graphics2D.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
            graphics2D.drawLine(n2 + n4 - 2, n3 + 1, n2 + n4 - 2, n3 + 1);
            graphics2D.setColor(new Color(15786940));
            graphics2D.drawLine(n2 + 1, n3 + n5 - 2, n2 + 1, n3 + n5 - 2);
            graphics2D.drawLine(n2 + n4 - 2, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
        } else if (n == 0) {
            graphics2D.setColor(new Color(7836601));
            graphics2D.drawLine(n2 + 1, n3, n2 + n4 - 2, n3);
            graphics2D.drawLine(n2, n3 + 1, n2, n3 + n5 - 2);
            graphics2D.drawLine(n2 + n4 - 1, n3 + 1, n2 + n4 - 1, n3 + n5 - 2);
            graphics2D.drawLine(n2 + 1, n3 + n5 - 1, n2 + n4 - 2, n3 + n5 - 1);
            graphics2D.setColor(new Color(10269908));
            graphics2D.drawLine(n2 + 1, n3 + 1, n2 + 1, n3 + 1);
            graphics2D.drawLine(n2 + 1, n3 + n5 - 2, n2 + 1, n3 + n5 - 2);
            graphics2D.drawLine(n2 + n4 - 2, n3 + 1, n2 + n4 - 2, n3 + 1);
            graphics2D.drawLine(n2 + n4 - 2, n3 + n5 - 2, n2 + n4 - 2, n3 + n5 - 2);
        }
    }

    public void paintButtonBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        Boolean bl2 = UIManager.getBoolean("Theme.highContrast");
        if (bl2.booleanValue()) {
            super.paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
            return;
        }
        Color color = null;
        switch (n2) {
            case 0: {
                color = jComponent.getBackground();
                break;
            }
            case 2: {
                if (!(jComponent instanceof ComponentStateSupport)) break;
                color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(n2);
                break;
            }
            case 3: {
                if (!(jComponent instanceof ComponentStateSupport)) break;
                color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(n2);
                break;
            }
            case 1: {
                if (!(jComponent instanceof ComponentStateSupport)) break;
                color = ((ComponentStateSupport)((Object)jComponent)).getBackgroundOfState(n2);
            }
        }
        if (color != null && !(color instanceof UIResource)) {
            this.getDefaultPainter().paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (!bl) {
            --n3;
            --n4;
            n5 += 2;
            n6 += 2;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (n2 == 1) {
            Office2007Painter.paintShadowedButtonBackground(graphics2D, rectangle, new Color[]{new Color(16624913), new Color(16161816), new Color(16229415), new Color(15771740)}, new Color[]{new Color(16623720), new Color(16551741), new Color(16560957)});
        } else if (n2 == 2) {
            if (jComponent.getClientProperty(IS_MENU_PART_BUTTON) == Boolean.TRUE) {
                if (1 != n6 - 2) {
                    graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n3 + 1, n4 + 1, n3 + 1, n4 + n6 - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(0xFFFEE2), new Color(16768115), new Color(16766560), new Color(16771752)}));
                }
                graphics2D.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
            } else {
                graphics2D.setPaint(new GradientPaint(n3, n4, new Color(0xFFFFFF), n3, n4 + n6, new Color(16773982)));
                graphics2D.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
                graphics2D.setPaint(new GradientPaint(n3, n4, new Color(16775058), n3 + n5 >> 1, n4, new Color(0xFFFFFF), true));
                graphics2D.drawLine(n3, n4 + n6 - 2, n3 + n5, n4 + n6 - 2);
                if (2 != n6 - 4) {
                    graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n3 + 2, n4 + 2, n3 + 2, n4 + n6 - 4, new float[]{0.0f, 0.36f, 0.37f, 0.38f, 1.0f}, new Color[]{new Color(0xFFFDDF), new Color(16770964), new Color(16699744), new Color(16698712), new Color(16770964)}));
                }
                graphics2D.fillRect(n3 + 2, n4 + 2, n5 - 4, n6 - 4);
            }
        } else if (n2 == 3) {
            Office2007Painter.paintShadowedButtonBackground(graphics2D, rectangle, new Color[]{new Color(15978405), new Color(15774041), new Color(15839569), new Color(16500832)}, new Color[]{new Color(16633240), new Color(16298843), new Color(16504194)});
        } else if (n2 == 0) {
            if (1 != n6 - 2) {
                graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n3 + 1, n4 + 1, n3 + 1, n4 + n6 - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)}));
            }
            graphics2D.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
        }
        if (bl) {
            graphics2D.setComposite(AlphaComposite.getInstance(10));
            this.paintButtonBorder(jComponent, graphics2D, rectangle, n2);
        }
        graphics2D.dispose();
    }

    static void paintShadowedButtonBackground(Graphics2D graphics2D, Rectangle rectangle, Color[] colorArray, Color[] colorArray2) {
        assert (colorArray.length == 4 && colorArray2.length == 3);
        int n = rectangle.x;
        int n2 = rectangle.y;
        int n3 = rectangle.width;
        int n4 = rectangle.height;
        if (1 != n4 - 2) {
            graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n + 1, n2 + 1, n + n3 - 2, n2 + n4 - 2, new float[]{0.0f, 0.6f, 0.61f, 1.0f}, colorArray));
        }
        graphics2D.fillRect(n + 1, n2 + 1, n3 - 2, n4 - 2);
        Area area = new Area(new Rectangle(n + 2, n2 + 1, n3 - 4, n4 - 3));
        area.subtract(new Area(new Rectangle(n + 2, n2 + n4 - 3, 1, 1)));
        area.subtract(new Area(new Rectangle(n + n3 - 3, n2 + n4 - 3, 1, 1)));
        if (2 != n4 - 4) {
            graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n + 2, n2 + 2, n + 2, n2 + n4 - 4, new float[]{0.39f, 0.4f, 1.0f}, colorArray2));
        }
        graphics2D.fill(area);
    }

    public void paintStatusBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (jComponent.isOpaque()) {
            Color[] colorArray = n2 == 0 ? STATUS_BAR_BG : SPECIAL_STATUS_BAR_BG;
            Graphics2D graphics2D = (Graphics2D)graphics.create();
            int n3 = rectangle.y;
            graphics2D.setColor(colorArray[0]);
            graphics2D.drawLine(rectangle.x, n3, rectangle.x + rectangle.width, n3);
            graphics2D.setColor(colorArray[1]);
            graphics2D.drawLine(rectangle.x, ++n3, rectangle.x + rectangle.width, n3);
            Rectangle rectangle2 = new Rectangle(rectangle.x, ++n3, rectangle.width, (rectangle.height - 4) / 3);
            JideSwingUtilities.fillGradient(graphics2D, rectangle2, colorArray[2], colorArray[3], true);
            rectangle2.y += rectangle2.height;
            rectangle2.height = rectangle.height - rectangle2.y - 2;
            JideSwingUtilities.fillGradient(graphics2D, rectangle2, colorArray[4], colorArray[5], true);
            n3 = rectangle2.y + rectangle2.height;
            graphics2D.setColor(colorArray[6]);
            graphics2D.drawLine(rectangle.x, n3, rectangle.x + rectangle.width, n3);
            graphics2D.setColor(colorArray[7]);
            graphics2D.drawLine(rectangle.x, ++n3, rectangle.x + rectangle.width, n3);
            graphics2D.dispose();
        }
    }

    public void paintStatusBarSepartor(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        graphics.setColor(new Color(9284821));
        graphics.drawLine(rectangle.x, rectangle.y, rectangle.x, rectangle.y + rectangle.height);
        graphics.setColor(new Color(0xFFFFFF));
        graphics.drawLine(rectangle.x + 1, rectangle.y, rectangle.x + 1, rectangle.y + rectangle.height);
    }

    public void paintMenuShadow(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (jComponent.getClientProperty("vsnet.paintShadow") != Boolean.FALSE) {
            super.paintMenuShadow(jComponent, graphics, rectangle, n, n2);
            graphics.setColor(new Color(0xC5C5C5));
            graphics.drawLine(rectangle.x + rectangle.width, rectangle.y, rectangle.x + rectangle.width, rectangle.y + rectangle.height);
        } else {
            graphics.setColor(this.getMenuItemBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void paintMenuItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, boolean bl) {
        if (jComponent.getClientProperty(IS_MENU_PART_BUTTON) == Boolean.TRUE) {
            this.paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
        } else {
            JideSwingUtilities.drawImageBorder(graphics, IconsFactory.getImageIcon(Office2007Painter.class, "icons/menu_item_bg.png"), rectangle, new Insets(2, 2, 2, 2), true);
        }
    }

    public void paintPopupMenuSepartor(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        super.paintPopupMenuSepartor(jComponent, graphics, rectangle, n, n2);
        graphics.setColor(new Color(0xC5C5C5));
        graphics.drawLine(rectangle.x + 24, rectangle.y, rectangle.x + 24, rectangle.y + rectangle.height);
    }

    public void paintDropDownIcon(Graphics graphics, int n, int n2) {
        graphics.setColor(new Color(5668273));
        graphics.drawLine(n, n2, n + 5, n2);
        graphics.drawLine(n + 1, n2 + 1, n + 4, n2 + 1);
        graphics.drawLine(n + 2, n2 + 2, n + 3, n2 + 2);
    }

    public void paintCommandBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCommandBarBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCommandBarBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color[] colorArray = new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)};
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            colorArray[i] = ColorUtils.getDerivedColor(color, 0.47f);
        }
        if (1 != n6 - 2) {
            graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n3 + 1, n4 + 1, n3 + 1, n4 + n6 - 2, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, colorArray));
        }
        graphics2D.fillRect(n3 + 1, n4 + 1, n5 - 2, n6 - 2);
        AlphaComposite alphaComposite = AlphaComposite.getInstance(10);
        graphics2D.setComposite(SystemInfo.isJdk6Above() ? alphaComposite.derive(0.1f) : AlphaComposite.getInstance(alphaComposite.getRule(), 0.1f));
        this.paintButtonBorder(jComponent, graphics2D, rectangle, n2);
        graphics2D.dispose();
    }

    public void paintFloatingCommandBarBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintFloatingCommandBarBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color[] colorArray = new Color[]{new Color(15266300), new Color(15266300), new Color(13820404), new Color(15463421)};
        for (int i = 0; i < colorArray.length; ++i) {
            Color color = colorArray[i];
            colorArray[i] = ColorUtils.getDerivedColor(color, 0.48f);
        }
        if (n6 != 0) {
            graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n3, n4, n3, n4 + n6, new float[]{0.0f, 0.5f, 0.51f, 1.0f}, colorArray));
        }
        graphics2D.fillRect(n3, n4, n5, n6);
        graphics2D.dispose();
    }

    public void paintDockableFrameTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintDockableFrameTitlePane(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintDockableFrameTitlePane(jComponent, graphics, rectangle, n, n2);
            return;
        }
        int n3 = rectangle.x;
        int n4 = rectangle.y;
        int n5 = rectangle.width;
        int n6 = rectangle.height;
        if (jComponent.getBorder() != null) {
            Insets insets = jComponent.getBorder().getBorderInsets(jComponent);
            n3 += insets.left;
            n4 += insets.top;
            n5 -= insets.right + insets.left;
            n6 -= insets.top + insets.bottom;
        }
        boolean bl2 = n2 == 3;
        Color[] colorArray = bl2 ? ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG : DOCKABLE_FRAME_TITLE_BAR_BG;
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Color color = graphics2D.getColor();
        graphics2D.setColor(Color.WHITE);
        graphics2D.drawLine(n3, n4, n3 + n5, n4);
        graphics2D.drawLine(n3, n4, n3, n4 + n6);
        graphics2D.setColor(color);
        if (n6 != 0) {
            graphics2D.setPaint(JideSwingUtilities.getLinearGradientPaint(n3 + 1, n4 + 1, n3 + 1, n4 + n6 - 1, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colorArray));
        }
        graphics2D.fillRect(n3 + 1, n4 + 1, n5 - 1, n6 - 1);
        graphics2D.dispose();
    }

    public void paintCollapsiblePaneTitlePaneBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        this.paintCollapsiblePaneTitlePane(jComponent, graphics, rectangle, COLLAPSIBLE_PANE_TITLE_BAR_BG, n2);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        this.paintCollapsiblePaneTitlePane(jComponent, graphics, rectangle, EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG, n2);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundSeparatorEmphasized(jComponent, graphics, rectangle, n, n2);
            return;
        }
        this.paintCollapsiblePaneTitlePaneSeparator(jComponent, graphics, rectangle, EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG, n2);
    }

    public void paintCollapsiblePaneTitlePaneBackgroundSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePaneTitlePaneBackgroundSeparator(jComponent, graphics, rectangle, n, n2);
            return;
        }
        if (!SystemInfo.isJdk6Above()) {
            this.getDefaultPainter().paintCollapsiblePaneTitlePaneBackgroundSeparator(jComponent, graphics, rectangle, n, n2);
            return;
        }
        this.paintCollapsiblePaneTitlePaneSeparator(jComponent, graphics, rectangle, COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG, n2);
    }

    private void paintCollapsiblePaneTitlePane(JComponent jComponent, Graphics graphics, Rectangle rectangle, Color[] colorArray, int n) {
        Object object;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (jComponent.getBorder() != null) {
            object = jComponent.getBorder().getBorderInsets(jComponent);
            n2 += ((Insets)object).left;
            n3 += ((Insets)object).top;
            n4 -= ((Insets)object).right + ((Insets)object).left;
            n5 -= ((Insets)object).top + ((Insets)object).bottom;
        }
        if (n5 != 0) {
            object = (Graphics2D)graphics.create();
            if (n == 2) {
                Color[] colorArray2 = new Color[colorArray.length];
                for (int i = 0; i < colorArray.length; ++i) {
                    Color color = colorArray[i];
                    colorArray2[i] = ColorUtils.getDerivedColor(color, 0.6f);
                }
                ((Graphics2D)object).setPaint(JideSwingUtilities.getLinearGradientPaint(n2, n3, n2, n3 + n5, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colorArray2));
            } else {
                ((Graphics2D)object).setPaint(JideSwingUtilities.getLinearGradientPaint(n2, n3, n2, n3 + n5, new float[]{0.0f, 0.333f, 0.334f, 1.0f}, colorArray));
            }
            ((Graphics)object).fillRect(n2, n3, n4, n5);
            ((Graphics)object).dispose();
        }
    }

    private void paintCollapsiblePaneTitlePaneSeparator(JComponent jComponent, Graphics graphics, Rectangle rectangle, Color[] colorArray, int n) {
        Object object;
        int n2 = rectangle.x;
        int n3 = rectangle.y;
        int n4 = rectangle.width;
        int n5 = rectangle.height;
        if (jComponent.getBorder() != null) {
            object = jComponent.getBorder().getBorderInsets(jComponent);
            n2 += ((Insets)object).left;
            n3 += ((Insets)object).top;
            n4 -= ((Insets)object).right + ((Insets)object).left;
            n5 -= ((Insets)object).top + ((Insets)object).bottom;
        }
        if (n5 != 0) {
            object = (Graphics2D)graphics.create();
            if (n == 2) {
                Color[] colorArray2 = new Color[colorArray.length];
                for (int i = 0; i < colorArray.length; ++i) {
                    Color color = colorArray[i];
                    colorArray2[i] = ColorUtils.getDerivedColor(color, 0.6f);
                }
                ((Graphics2D)object).setPaint(JideSwingUtilities.getLinearGradientPaint(n2, n3, n2 + n4, n3, new float[]{0.0f, 0.5f, 1.0f}, colorArray2));
            } else {
                ((Graphics2D)object).setPaint(JideSwingUtilities.getLinearGradientPaint(n2, n3, n2 + n4, n3, new float[]{0.0f, 0.5f, 1.0f}, colorArray));
            }
            ((Graphics)object).fillRect(n2, n3, n4, n5);
            ((Graphics)object).dispose();
        }
    }

    public void paintCollapsiblePanesBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (!jComponent.isOpaque()) {
            return;
        }
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintCollapsiblePanesBackground(jComponent, graphics, rectangle, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!(jComponent.getBackground() instanceof UIResource)) {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), jComponent.getBackground(), ColorUtils.getDerivedColor(jComponent.getBackground(), 0.6f), n == 0);
        } else {
            JideSwingUtilities.fillGradient(graphics2D, new Rectangle(rectangle.x, rectangle.y, rectangle.width, rectangle.height), UIDefaultsLookup.getColor("CollapsiblePanes.backgroundLt"), UIDefaultsLookup.getColor("CollapsiblePanes.backgroundDk"), n == 0);
        }
    }

    public void paintSidePaneItemBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, Color[] colorArray, int n, int n2) {
        Boolean bl = UIManager.getBoolean("Theme.highContrast");
        if (bl.booleanValue()) {
            super.paintSidePaneItemBackground(jComponent, graphics, rectangle, colorArray, n, n2);
            return;
        }
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        switch (n) {
            case 3: 
            case 7: {
                graphics2D.rotate(-Math.toRadians(90.0), rectangle.x, rectangle.y);
                graphics2D.translate(-rectangle.height, rectangle.y);
                this.paintButtonBackground(jComponent, graphics2D, new Rectangle(0, 0, rectangle.height, rectangle.width), 0, n2, false);
                break;
            }
            case 1: 
            case 5: {
                this.paintButtonBackground(jComponent, graphics2D, rectangle, 0, n2, false);
            }
        }
        graphics2D.dispose();
    }

    public void paintHeaderBoxBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        boolean bl = !(jComponent instanceof AbstractButton) || ((AbstractButton)jComponent).isBorderPainted();
        this.paintButtonBackground(jComponent, graphics, rectangle, n, n2, bl);
        if (!bl) {
            Color color = graphics.getColor();
            graphics.setColor(UIDefaultsLookup.getColor("Table.gridColor"));
            graphics.drawLine(rectangle.x + rectangle.width - 1, rectangle.y, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width - 1, rectangle.y + rectangle.height - 1);
            graphics.setColor(color);
        }
    }

    public void paintGripper(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2) {
        if (rectangle.width > 30) {
            n = 1;
        } else if (rectangle.height > 30) {
            n = 0;
        }
        int n3 = n == 0 ? rectangle.height : rectangle.width;
        int n4 = Math.min(9, (n3 - 6) / 4);
        int n5 = rectangle.y;
        int n6 = rectangle.x;
        if (n == 0) {
            n5 += rectangle.height / 2 - n4 * 2;
            n6 += rectangle.width / 2 - 1;
        } else {
            n6 += rectangle.width / 2 - n4 * 2;
            n5 += rectangle.height / 2 - 1;
        }
        for (int i = 0; i < n4; ++i) {
            graphics.setColor(this.getGripperForegroundLt());
            graphics.fillRect(n6 + 1, n5 + 1, 2, 2);
            graphics.setColor(this.getGripperForeground());
            graphics.fillRect(n6, n5, 2, 2);
            graphics.setColor(ColorUtils.getDerivedColor(this.getGripperForeground(), 0.55f));
            graphics.fillRect(n6 + 1, n5 + 1, 1, 1);
            if (n == 0) {
                n5 += 4;
                continue;
            }
            n6 += 4;
        }
    }

    public Color getGripperForegroundLt() {
        return UIDefaultsLookup.getColor("Gripper.light");
    }

    public Color getSelectionSelectedDk() {
        return new ColorUIResource(16305011);
    }

    public Color getSelectionSelectedLt() {
        return new ColorUIResource(16710613);
    }

    public Color getBackgroundDk() {
        return UIDefaultsLookup.getColor("JideTabbedPane.background");
    }

    public Color getBackgroundLt() {
        return UIDefaultsLookup.getColor("JideTabbedPane.background");
    }

    public void fillBackground(JComponent jComponent, Graphics graphics, Rectangle rectangle, int n, int n2, Color color) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        if (n == 0) {
            int n3 = rectangle.height / 3;
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, rectangle.width, n3), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), true);
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y + n3, rectangle.width, rectangle.height - n3), color, ColorUtils.getDerivedColor(color, 0.64f), true);
        } else {
            int n4 = rectangle.width / 3;
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x, rectangle.y, n4, rectangle.height), ColorUtils.getDerivedColor(color, 0.74f), ColorUtils.getDerivedColor(color, 0.64f), false);
            JideSwingUtilities.fillGradient((Graphics2D)graphics, new Rectangle(rectangle.x + n4, rectangle.y, rectangle.width - n4, rectangle.height), color, ColorUtils.getDerivedColor(color, 0.64f), false);
        }
        graphics2D.dispose();
    }

    static {
        STATUS_BAR_BG = new Color[]{new Color(5668272), new Color(0xFFFFFF), new Color(14149369), new Color(13098232), new Color(11784437), new Color(14149111), new Color(13492471), new Color(12244215)};
        SPECIAL_STATUS_BAR_BG = new Color[]{new Color(5668272), new Color(12967160), new Color(12769783), new Color(11127543), new Color(9484010), new Color(7772357), new Color(7640514), new Color(9809358)};
        DOCKABLE_FRAME_TITLE_BAR_BG = new Color[]{new Color(15070461), new Color(14217212), new Color(12510973), new Color(10934772)};
        ACTIVE_DOCKABLE_FRAME_TITLE_BAR_BG = new Color[]{new Color(16769959), new Color(16764785), new Color(16761679), new Color(16762964)};
        COLLAPSIBLE_PANE_TITLE_BAR_BG = new Color[]{new Color(14149369), new Color(13098232), new Color(11784437), new Color(14149111)};
        EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_BG = new Color[]{new Color(15200510), new Color(12178423), new Color(10863853), new Color(9415117)};
        COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG = new Color[]{new Color(13098232), new Color(14149369), new Color(13098232)};
        EMPHASIZED_COLLAPSIBLE_PANE_TITLE_BAR_SEPARATOR_BG = new Color[]{new Color(12178423), new Color(15200510), new Color(12178423)};
    }
}

