/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.capture;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.util.HashSet;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.PspGeList;
import jpcsp.Memory;
import jpcsp.graphics.VideoEngine;
import jpcsp.graphics.capture.CaptureDisplayDetails;
import jpcsp.graphics.capture.CaptureFrameBufDetails;
import jpcsp.graphics.capture.CaptureHeader;
import jpcsp.graphics.capture.CaptureImage;
import jpcsp.graphics.capture.CaptureList;
import jpcsp.graphics.capture.CaptureRAM;
import org.apache.log4j.Level;

public class CaptureManager {
    private static OutputStream out;
    public static boolean captureInProgress;
    private static boolean listExecuted;
    private static CaptureFrameBufDetails replayFrameBufDetails;
    private static Level logLevel;
    private static HashSet<Integer> capturedImages;

    public static void startReplay(String filename) {
        if (captureInProgress) {
            VideoEngine.log.error((Object)"Ignoring startReplay, capture is in progress");
            return;
        }
        VideoEngine.log.info((Object)("Starting replay: " + filename));
        try {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(filename));
            block8: while (((InputStream)in).available() > 0) {
                CaptureHeader header = CaptureHeader.read(in);
                int packetType = header.getPacketType();
                switch (packetType) {
                    case 1: {
                        CaptureList list = CaptureList.read(in);
                        list.commit();
                        continue block8;
                    }
                    case 2: {
                        CaptureRAM ramFragment = CaptureRAM.read(in);
                        ramFragment.commit();
                        continue block8;
                    }
                    case 3: {
                        CaptureDisplayDetails displayDetails = CaptureDisplayDetails.read(in);
                        displayDetails.commit();
                        continue block8;
                    }
                    case 4: {
                        replayFrameBufDetails = CaptureFrameBufDetails.read(in);
                        continue block8;
                    }
                }
                throw new Exception("Unknown packet type " + packetType);
            }
            ((InputStream)in).close();
        }
        catch (Exception e) {
            VideoEngine.log.error((Object)("Failed to start replay: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void endReplay() {
        replayFrameBufDetails.commit();
        replayFrameBufDetails = null;
        VideoEngine.log.info((Object)"Replay completed");
        Emulator.PauseEmu();
    }

    public static void startCapture(String filename, PspGeList list) {
        if (captureInProgress) {
            VideoEngine.log.error((Object)"Ignoring startCapture, capture is already in progress");
            return;
        }
        logLevel = VideoEngine.log.getLevel();
        VideoEngine.getInstance().setLogLevel(Level.TRACE);
        capturedImages = new HashSet();
        try {
            VideoEngine.log.info((Object)("Starting capture... (list=" + list.id + ")"));
            out = new BufferedOutputStream(new FileOutputStream(filename));
            CaptureHeader header = new CaptureHeader(1);
            header.write(out);
            CaptureList commandList = new CaptureList(list);
            commandList.write(out);
            captureInProgress = true;
            listExecuted = false;
        }
        catch (Exception e) {
            VideoEngine.log.error((Object)("Failed to start capture: " + e.getMessage()));
            e.printStackTrace();
            Emulator.PauseEmu();
        }
    }

    public static void endCapture() {
        if (!captureInProgress) {
            VideoEngine.log.warn((Object)"Ignoring endCapture, capture hasn't been started");
            Emulator.PauseEmu();
            return;
        }
        try {
            out.flush();
            out.close();
            out = null;
        }
        catch (Exception e) {
            VideoEngine.log.error((Object)("Failed to end capture: " + e.getMessage()));
            e.printStackTrace();
            Emulator.PauseEmu();
        }
        captureInProgress = false;
        VideoEngine.log.info((Object)"Capture completed");
        VideoEngine.log.setLevel(logLevel);
        Emulator.PauseEmu();
    }

    public static void captureRAM(int address, int length) {
        if (!captureInProgress) {
            VideoEngine.log.warn((Object)"Ignoring captureRAM, capture hasn't been started");
            return;
        }
        if (!Memory.isAddressGood(address)) {
            return;
        }
        try {
            CaptureHeader header = new CaptureHeader(2);
            header.write(out);
            CaptureRAM captureRAM = new CaptureRAM(address, length);
            captureRAM.write(out);
        }
        catch (Exception e) {
            VideoEngine.log.error((Object)("Failed to capture RAM: " + e.getMessage()));
            e.printStackTrace();
        }
    }

    public static void captureImage(int imageaddr, int level, Buffer buffer, int width, int height, int bufferWidth, int imageType, boolean compressedImage, int compressedImageSize, boolean invert, boolean overwriteFile) {
        try {
            CaptureImage captureImage = new CaptureImage(imageaddr, level, buffer, width, height, bufferWidth, imageType, compressedImage, compressedImageSize, invert, overwriteFile, null);
            captureImage.write();
            if (capturedImages != null) {
                capturedImages.add(imageaddr);
            }
        }
        catch (Exception e) {
            VideoEngine.log.error((Object)("Failed to capture Image: " + e.getMessage()));
            e.printStackTrace();
            Emulator.PauseEmu();
        }
    }

    public static boolean isImageCaptured(int imageaddr) {
        if (capturedImages == null) {
            return false;
        }
        return capturedImages.contains(imageaddr);
    }

    public static void captureFrameBufDetails() {
        if (!captureInProgress) {
            VideoEngine.log.warn((Object)"Ignoring captureRAM, capture hasn't been started");
            return;
        }
        try {
            CaptureHeader header = new CaptureHeader(4);
            header.write(out);
            CaptureFrameBufDetails details = new CaptureFrameBufDetails();
            details.write(out);
        }
        catch (Exception e) {
            VideoEngine.log.error((Object)("Failed to capture frame buf details: " + e.getMessage()));
            e.printStackTrace();
            Emulator.PauseEmu();
        }
    }

    public static void markListExecuted() {
        listExecuted = true;
    }

    public static boolean hasListExecuted() {
        return listExecuted;
    }
}

