/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.ITPointerBase;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;
import jpcsp.HLE.kernel.types.pspBaseCallback;

public class SceKernelCallbackInfo
extends pspBaseCallback {
    private final String name;
    private final int threadId;
    private final int callbackArgument;
    private int notifyCount;
    private int notifyArg;

    public SceKernelCallbackInfo(String name, int threadId, int callback_addr, int callback_arg_addr) {
        super(callback_addr, 3);
        this.name = name;
        this.threadId = threadId;
        this.callbackArgument = callback_arg_addr;
        this.notifyCount = 0;
        this.notifyArg = 0;
    }

    public void write(ITPointerBase statusAddr) {
        SceKernelCallbackStatus status = new SceKernelCallbackStatus();
        status.write(statusAddr);
    }

    @Override
    public void call(SceKernelThreadInfo thread, IAction afterAction) {
        this.setArgument(0, this.notifyCount);
        this.setArgument(1, this.notifyArg);
        this.setArgument(2, this.callbackArgument);
        this.notifyCount = 0;
        this.notifyArg = 0;
        super.call(thread, afterAction);
    }

    public int getThreadId() {
        return this.threadId;
    }

    public int getNotifyCount() {
        return this.notifyCount;
    }

    public int getNotifyArg() {
        return this.notifyArg;
    }

    public void cancel() {
        this.notifyArg = 0;
        this.notifyCount = 0;
    }

    public int getCallbackArgument() {
        return this.callbackArgument;
    }

    public void setNotifyArg(int notifyArg) {
        ++this.notifyCount;
        this.notifyArg = notifyArg;
    }

    public String toString() {
        return String.format("uid:0x%X, name:'%s', thread:'%s', PC:0x%08X, $a0:0x%08X, $a1:0x%08X, $a2:0x%08X", this.getUid(), this.name, Modules.ThreadManForUserModule.getThreadName(this.threadId), this.getCallbackFunction(), this.notifyCount, this.notifyArg, this.callbackArgument);
    }

    private class SceKernelCallbackStatus
    extends pspAbstractMemoryMappedStructureVariableLength {
        private SceKernelCallbackStatus() {
        }

        @Override
        protected void write() {
            super.write();
            this.writeStringNZ(32, SceKernelCallbackInfo.this.name);
            this.write32(SceKernelCallbackInfo.this.threadId);
            this.write32(SceKernelCallbackInfo.this.getCallbackFunction());
            this.write32(SceKernelCallbackInfo.this.callbackArgument);
            this.write32(SceKernelCallbackInfo.this.notifyCount);
            this.write32(SceKernelCallbackInfo.this.notifyArg);
        }
    }
}

