/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructureVariableLength;

public class SceKernelThreadEventHandlerInfo
extends pspAbstractMemoryMappedStructureVariableLength {
    public final String name;
    public final int thid;
    public int mask;
    public int handler;
    public final int common;
    private boolean active;
    public final int uid;
    private static final String uidPurpose = "ThreadMan-ThreadEventHandler";
    public static final int THREAD_EVENT_ID_ALL = -1;
    public static final int THREAD_EVENT_ID_KERN = -8;
    public static final int THREAD_EVENT_ID_USER = -16;
    public static final int THREAD_EVENT_ID_CURRENT = 0;
    public static final int THREAD_EVENT_CREATE = 1;
    public static final int THREAD_EVENT_START = 2;
    public static final int THREAD_EVENT_EXIT = 4;
    public static final int THREAD_EVENT_DELETE = 8;
    public static final int THREAD_EVENT_ALL = 15;

    public SceKernelThreadEventHandlerInfo(String name, int thid, int mask, int handler, int common) {
        this.name = name;
        this.thid = thid;
        this.mask = mask;
        this.handler = handler;
        this.common = common;
        this.setActive(true);
        this.uid = SceUidManager.getNewUid(uidPurpose);
    }

    public void release() {
        SceUidManager.releaseUid(this.uid, uidPurpose);
        this.mask = 0;
        this.handler = 0;
        this.setActive(false);
    }

    public boolean hasEventMask(int event) {
        return (this.mask & event) == event;
    }

    public void triggerThreadEventHandler(SceKernelThreadInfo contextThread, int event) {
        Modules.ThreadManForUserModule.executeCallback(contextThread, this.handler, (IAction)new AfterEventHandler(), false, true, event, this.thid, this.common);
    }

    public boolean appliesFor(SceKernelThreadInfo currentThread, SceKernelThreadInfo thread, int event) {
        if ((this.mask & event) == 0) {
            return false;
        }
        if (!this.isActive()) {
            return false;
        }
        if (!currentThread.isUserMode() && thread.isUserMode()) {
            return false;
        }
        if (this.thid == -1 || this.thid == -8 || this.thid == thread.uid) {
            return true;
        }
        return this.thid == -16 && thread.isUserMode() && currentThread.isUserMode();
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    @Override
    protected void write() {
        super.write();
        this.writeStringNZ(32, this.name);
        this.write32(this.thid);
        this.write32(this.mask);
        this.write32(this.handler);
        this.write32(this.common);
    }

    private class AfterEventHandler
    implements IAction {
        private AfterEventHandler() {
        }

        @Override
        public void execute() {
            int result = Emulator.getProcessor().cpu._v0;
            if (result != 0) {
                SceKernelThreadEventHandlerInfo.this.setActive(false);
            }
            if (Modules.log.isInfoEnabled()) {
                Modules.log.info((Object)String.format("Thread Event Handler exit detected (thid=0x%X, result=0x%08X)", SceKernelThreadEventHandlerInfo.this.thid, result));
            }
        }
    }
}

