/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.util;

import jpcsp.media.codec.util.IBitReader;

public class BitBuffer
implements IBitReader {
    private final int[] bits;
    private int readIndex;
    private int writeIndex;
    private int readCount;
    private int writeCount;

    public BitBuffer(int length) {
        this.bits = new int[length];
    }

    @Override
    public int read1() {
        ++this.readCount;
        int bit = this.bits[this.readIndex];
        ++this.readIndex;
        if (this.readIndex >= this.bits.length) {
            this.readIndex = 0;
        }
        return bit;
    }

    @Override
    public int read(int n) {
        int value = 0;
        while (n > 0) {
            value = (value << 1) + this.read1();
            --n;
        }
        return value;
    }

    public int getBitsRead() {
        return this.readCount;
    }

    public int getBitsWritten() {
        return this.writeCount;
    }

    @Override
    public void skip(int n) {
        this.readCount += n;
        this.readIndex += n;
        while (this.readIndex < 0) {
            this.readIndex += this.bits.length;
        }
        while (this.readIndex >= this.bits.length) {
            this.readIndex -= this.bits.length;
        }
    }

    private void writeBit(int n) {
        this.bits[this.writeIndex] = n;
        ++this.writeIndex;
        ++this.writeCount;
        if (this.writeIndex >= this.bits.length) {
            this.writeIndex = 0;
        }
    }

    public void writeByte(int n) {
        for (int bit = 7; bit >= 0; --bit) {
            this.writeBit(n >> bit & 1);
        }
    }

    @Override
    public boolean readBool() {
        return this.read1() != 0;
    }

    @Override
    public int peek(int n) {
        int read = this.read(n);
        this.skip(-n);
        return read;
    }

    @Override
    public int getReadAddr() {
        return this.getBitsRead() >>> 3;
    }

    public String toString() {
        return String.format("BitBuffer readIndex=%d, writeIndex=%d, readCount=%d", this.readIndex, this.writeIndex, this.readCount);
    }
}

