/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network.proonline;

import java.net.InetAddress;
import java.net.UnknownHostException;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.network.proonline.ProOnlineNetworkAdapter;

public class MacIp {
    public byte[] mac;
    public pspNetMacAddress macAddress;
    public int ip;
    public InetAddress inetAddress;

    public MacIp(byte[] mac, int ip) {
        this.setMac(mac);
        this.setIp(ip);
    }

    public void setMac(byte[] mac) {
        this.mac = (byte[])mac.clone();
        this.macAddress = new pspNetMacAddress(this.mac);
    }

    public void setIp(int ip) {
        this.ip = ip;
        try {
            this.inetAddress = InetAddress.getByAddress(MacIp.getRawIp(ip));
        }
        catch (UnknownHostException e) {
            ProOnlineNetworkAdapter.log.error((Object)"Incorrect IP", (Throwable)e);
        }
    }

    public static byte[] getRawIp(int ip) {
        byte[] rawIp = new byte[]{(byte)ip, (byte)(ip >> 8), (byte)(ip >> 16), (byte)(ip >> 24)};
        return rawIp;
    }

    public String toString() {
        return String.format("MAC=%s, ip=%s", this.macAddress, ProOnlineNetworkAdapter.convertIpToString(this.ip));
    }
}

