/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.FileNotFoundException;
import java.io.IOException;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.kernel.types.SceKernelLoadExecVSHParam;
import jpcsp.NIDMapper;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class SystemCtrlForKernel
extends HLEModule {
    public static Logger log = Modules.getLogger("SystemCtrlForKernel");

    @HLEFunction(nid=479248075, version=150)
    public int sctrlHENSetStartModuleHandler(TPointer startModuleHandler) {
        int previousStartModuleHandler = Modules.ModuleMgrForUserModule.getStartModuleHandler();
        Modules.ModuleMgrForUserModule.setStartModuleHandler(startModuleHandler.getAddress());
        return previousStartModuleHandler;
    }

    @HLEUnimplemented
    @HLEFunction(nid=2028233749, version=150)
    public int sctrlHENFindDriver(String drvname) {
        return 0;
    }

    @HLEFunction(nid=-1131176511, version=150)
    public void sctrlSESetBootConfFileIndex(int index) {
    }

    @HLEFunction(nid=1513474376, version=150)
    public void sctrlSESetUmdFile(PspString file) {
        String fileName = file.getString();
        int deviceNameIndex = fileName.indexOf(58);
        if (deviceNameIndex > 0) {
            String deviceName = fileName.substring(0, deviceNameIndex);
            String directoryMapping = Settings.getInstance().getDirectoryMapping(deviceName);
            if (directoryMapping != null) {
                int fileNameIndex = deviceNameIndex + 1;
                if (fileName.charAt(fileNameIndex) == '/') {
                    ++fileNameIndex;
                }
                fileName = directoryMapping + fileName.substring(fileNameIndex);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sctrlSESetUmdFile local fileName='%s'", fileName));
                }
            }
        }
        try {
            UmdIsoReader iso = new UmdIsoReader(fileName);
            Modules.IoFileMgrForUserModule.setfilepath("disc0/");
            Modules.IoFileMgrForUserModule.setIsoReader(iso);
            Modules.sceUmdUserModule.setIsoReader(iso);
        }
        catch (FileNotFoundException e) {
            log.error((Object)"sctrlSESetUmdFile", (Throwable)e);
        }
        catch (IOException e) {
            log.error((Object)"sctrlSESetUmdFile", (Throwable)e);
        }
    }

    @HLEFunction(nid=756087592, version=150)
    public int sctrlKernelLoadExecVSHWithApitype(int apiType, PspString filename, TPointer param) {
        SceKernelLoadExecVSHParam loadExecVSHParam = new SceKernelLoadExecVSHParam();
        loadExecVSHParam.read(param);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sctrlKernelLoadExecVSHWithApitype param: %s", loadExecVSHParam));
            if (loadExecVSHParam.args > 0) {
                log.debug((Object)String.format("sctrlKernelLoadExecVSHWithApitype argp: %s", Utilities.getMemoryDump(loadExecVSHParam.argp, loadExecVSHParam.args)));
            }
            if (loadExecVSHParam.vshmainArgsSize > 0) {
                log.debug((Object)String.format("sctrlKernelLoadExecVSHWithApitype vshmainArgs: %s", Utilities.getMemoryDump(loadExecVSHParam.vshmainArgs, loadExecVSHParam.vshmainArgsSize)));
            }
        }
        String realFileName = filename.getString();
        if (loadExecVSHParam.args > 0 && loadExecVSHParam.argp != 0) {
            int dirIndex;
            String arg = Utilities.readStringNZ(loadExecVSHParam.argp, loadExecVSHParam.args);
            if (arg.startsWith("disc0:")) {
                Modules.IoFileMgrForUserModule.setfilepath("disc0/");
                if (realFileName.startsWith("ms0:")) {
                    int argIndex = arg.indexOf(32);
                    realFileName = argIndex < 0 ? arg : arg.substring(0, argIndex);
                }
            } else if (arg.startsWith("ms0:") && (dirIndex = arg.lastIndexOf(47)) >= 0) {
                Modules.IoFileMgrForUserModule.setfilepath(Settings.getInstance().getDirectoryMapping("ms0") + arg.substring(4, dirIndex));
            }
        }
        return Modules.LoadExecForUserModule.hleKernelLoadExec(new PspString(realFileName), loadExecVSHParam.args, loadExecVSHParam.argp);
    }

    @HLEUnimplemented
    @HLEFunction(nid=501067020, version=150)
    public int sctrlSESetConfig(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=72, usage=BufferInfo.Usage.in) TPointer configAddr) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=381925358, version=150)
    public int sctrlSEGetConfig(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=72, usage=BufferInfo.Usage.out) TPointer configAddr) {
        return 0;
    }

    @HLEFunction(nid=362477004, version=150)
    public int sctrlHENFindFunction(@CanBeNull PspString szMod, @CanBeNull PspString szLib, int nid) {
        return NIDMapper.getInstance().getAddressByNid(nid, szMod.getString());
    }
}

