/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.io.ByteArrayOutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import jpcsp.HLE.Modules;
import org.apache.log4j.Logger;

public class AES128 {
    private static Logger log = Modules.log;
    private static final byte[] const_Zero = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final byte[] const_Rb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -121};
    private byte[] contentKey;
    private ByteArrayOutputStream barros;
    private static Cipher cipher;
    private static final byte[] iv0;
    public static final boolean useBouncyCastle = false;

    public static void init() {
        Thread staticInit = new Thread(new Runnable(){

            @Override
            public void run() {
                AES128.init("AES/CBC/NoPadding");
            }
        });
        staticInit.start();
    }

    private static void init(String mode) {
        if (cipher == null) {
            try {
                cipher = Cipher.getInstance(mode);
            }
            catch (Exception e) {
                log.error((Object)"AES128 Cipher", (Throwable)e);
            }
        }
    }

    public AES128(String mode) {
        AES128.init(mode);
    }

    private Key getKeySpec(byte[] encKey) {
        return new SecretKeySpec(encKey, "AES");
    }

    private byte[] encryptCMAC(byte[] in, byte[] encKey) {
        return this.encryptCMAC(in, this.getKeySpec(encKey));
    }

    private byte[] encryptCMAC(byte[] in, Key keySpec) {
        return this.encrypt(in, keySpec, iv0);
    }

    public byte[] encrypt(byte[] in, byte[] encKey, byte[] iv) {
        return this.encrypt(in, this.getKeySpec(encKey), iv);
    }

    public byte[] encrypt(byte[] in, Key keySpec, byte[] iv) {
        IvParameterSpec ivec = new IvParameterSpec(iv);
        byte[] result = null;
        try {
            Cipher c = cipher;
            c.init(1, keySpec, ivec);
            result = c.doFinal(in);
        }
        catch (InvalidKeyException e) {
            log.error((Object)"encrypt", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            log.error((Object)"encrypt", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            log.error((Object)"encrypt", (Throwable)e);
        }
        catch (BadPaddingException e) {
            log.error((Object)"encrypt", (Throwable)e);
        }
        return result;
    }

    public byte[] decrypt(byte[] in, byte[] decKey, byte[] iv) {
        SecretKeySpec keySpec = new SecretKeySpec(decKey, "AES");
        IvParameterSpec ivec = new IvParameterSpec(iv);
        byte[] result = null;
        try {
            Cipher c = cipher;
            c.init(2, (Key)keySpec, ivec);
            result = c.doFinal(in);
        }
        catch (Exception e) {
            log.error((Object)"decrypt", (Throwable)e);
        }
        return result;
    }

    public void doInitCMAC(byte[] contentKey) {
        this.contentKey = contentKey;
        this.barros = new ByteArrayOutputStream();
    }

    public void doUpdateCMAC(byte[] input, int offset, int len) {
        this.barros.write(input, offset, len);
    }

    public void doUpdateCMAC(byte[] input) {
        this.barros.write(input, 0, input.length);
    }

    public byte[] doFinalCMAC() {
        byte[] Y;
        byte[] M_last;
        byte[] partInput;
        boolean lastBlockComplete;
        Object[] keys = this.generateSubKey(this.contentKey);
        byte[] K1 = (byte[])keys[0];
        byte[] K2 = (byte[])keys[1];
        byte[] input = this.barros.toByteArray();
        int numberOfRounds = (input.length + 15) / 16;
        if (numberOfRounds == 0) {
            numberOfRounds = 1;
            lastBlockComplete = false;
        } else {
            lastBlockComplete = input.length % 16 == 0;
        }
        int srcPos = 16 * (numberOfRounds - 1);
        if (lastBlockComplete) {
            partInput = new byte[16];
            System.arraycopy(input, srcPos, partInput, 0, 16);
            M_last = AES128.xor128(partInput, K1);
        } else {
            partInput = new byte[input.length % 16];
            System.arraycopy(input, srcPos, partInput, 0, input.length % 16);
            byte[] padded = this.doPaddingCMAC(partInput);
            M_last = AES128.xor128(padded, K2);
        }
        byte[] X = (byte[])const_Zero.clone();
        byte[] partInput2 = new byte[16];
        Key keySpec = this.getKeySpec(this.contentKey);
        for (int i = 0; i < numberOfRounds - 1; ++i) {
            srcPos = 16 * i;
            System.arraycopy(input, srcPos, partInput2, 0, 16);
            Y = AES128.xor128(partInput2, X);
            X = this.encryptCMAC(Y, keySpec);
        }
        Y = AES128.xor128(X, M_last);
        X = this.encryptCMAC(Y, this.contentKey);
        return X;
    }

    public boolean doVerifyCMAC(byte[] verificationCMAC) {
        byte[] cmac = this.doFinalCMAC();
        if (verificationCMAC == null || verificationCMAC.length != cmac.length) {
            return false;
        }
        for (int i = 0; i < cmac.length; ++i) {
            if (cmac[i] == verificationCMAC[i]) continue;
            return false;
        }
        return true;
    }

    private byte[] doPaddingCMAC(byte[] input) {
        byte[] padded = new byte[16];
        for (int j = 0; j < 16; ++j) {
            padded[j] = j < input.length ? input[j] : (j == input.length ? -128 : 0);
        }
        return padded;
    }

    private Object[] generateSubKey(byte[] key) {
        byte[] L = this.encryptCMAC(const_Zero, key);
        byte[] K1 = null;
        if ((L[0] & 0x80) == 0) {
            K1 = AES128.doLeftShiftOneBit(L);
        } else {
            byte[] tmp = AES128.doLeftShiftOneBit(L);
            K1 = AES128.xor128(tmp, const_Rb);
        }
        byte[] K2 = null;
        if ((K1[0] & 0x80) == 0) {
            K2 = AES128.doLeftShiftOneBit(K1);
        } else {
            byte[] tmp = AES128.doLeftShiftOneBit(K1);
            K2 = AES128.xor128(tmp, const_Rb);
        }
        Object[] result = new Object[]{K1, K2};
        return result;
    }

    private static byte[] xor128(byte[] input1, byte[] input2) {
        byte[] output = new byte[input1.length];
        for (int i = 0; i < input1.length; ++i) {
            output[i] = (byte)((input1[i] ^ input2[i]) & 0xFF);
        }
        return output;
    }

    private static byte[] doLeftShiftOneBit(byte[] input) {
        byte[] output = new byte[input.length];
        byte overflow = 0;
        for (int i = input.length - 1; i >= 0; --i) {
            output[i] = (byte)(input[i] << 1 & 0xFF);
            int n = i;
            output[n] = (byte)(output[n] | overflow);
            overflow = (input[i] & 0x80) != 0 ? (byte)1 : 0;
        }
        return output;
    }

    static {
        iv0 = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    }
}

