/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.filters;

import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractProxyVirtualFile;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.filters.IVirtualFileFilter;
import jpcsp.memory.IMemoryReaderWriter;
import jpcsp.memory.MemoryReaderWriter;

public class XorVirtualFileFilter
extends AbstractProxyVirtualFile
implements IVirtualFileFilter {
    private int xor;

    protected XorVirtualFileFilter(byte xor) {
        this.xor = xor & 0xFF;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int readLength = super.ioRead(outputPointer, outputLength);
        if (readLength > 0) {
            IMemoryReaderWriter memoryReaderWriter = MemoryReaderWriter.getMemoryReaderWriter(outputPointer.getAddress(), readLength, 1);
            for (int i = 0; i < readLength; ++i) {
                int value = memoryReaderWriter.readCurrent();
                memoryReaderWriter.writeNext(value ^= this.xor);
            }
            memoryReaderWriter.flush();
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = super.ioRead(outputBuffer, outputOffset, outputLength);
        if (readLength > 0) {
            this.filter(outputBuffer, outputOffset, readLength);
        }
        return readLength;
    }

    @Override
    public void filter(byte[] data, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            int n = offset + i;
            data[n] = (byte)(data[n] ^ this.xor);
        }
    }

    @Override
    public void setVirtualFile(IVirtualFile vFile) {
        this.setProxyVirtualFile(vFile);
    }

    @Override
    public String toString() {
        return String.format("XorVirtualFileFilter(xor=0x%02X, %s)", this.xor, this.vFile);
    }
}

