/*
 * Decompiled with CFR 0.152.
 */
package libkirk;

import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.ShortBufferException;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import libkirk.KirkEngine;
import libkirk.Utilities;

public class AES {
    public static final int AES_MAXROUNDS = 14;
    private static boolean inInit = false;
    private static volatile Cipher cipher;
    private static final byte[] const_Rb;

    public static void init() {
        if (cipher == null && !inInit) {
            inInit = true;
            Thread staticInit = new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        cipher = Cipher.getInstance("AES/CBC/NoPadding");
                        inInit = false;
                    }
                    catch (NoSuchAlgorithmException e) {
                        Utilities.log.error((Object)"AES Cipher init", (Throwable)e);
                    }
                    catch (NoSuchPaddingException e) {
                        Utilities.log.error((Object)"AES Cipher init", (Throwable)e);
                    }
                }
            });
            staticInit.start();
        }
    }

    public static int rijndael_set_key(rijndael_ctx ctx, byte[] key, int bits) {
        return AES.rijndael_set_key(ctx, key, 0, bits);
    }

    public static int rijndael_set_key(rijndael_ctx ctx, byte[] key, int keyoffset, int bits) {
        ctx.keySpec = new SecretKeySpec(key, keyoffset, bits / 8, "AES");
        return 0;
    }

    public static int AES_set_key(AES_ctx ctx, byte[] key, int bits) {
        return AES.rijndael_set_key(ctx, key, bits);
    }

    private static void xor_128(byte[] a, byte[] b, byte[] out) {
        AES.xor_128(a, 0, b, 0, out, 0);
    }

    private static void xor_128(byte[] a, int offset1, byte[] b, byte[] out) {
        AES.xor_128(a, offset1, b, 0, out, 0);
    }

    private static void xor_128(byte[] a, int offset1, byte[] b, int offset2, byte[] out, int outOffset) {
        for (int i = 0; i < 16; ++i) {
            out[i + outOffset] = (byte)(a[i + offset1] ^ b[i + offset2]);
        }
    }

    private static void doCipher(rijndael_ctx ctx, int mode, byte[] src, int srcOffset, byte[] dst, int dstOffset, int size) {
        while (cipher == null) {
        }
        byte[] iv = new byte[16];
        IvParameterSpec ivec = new IvParameterSpec(iv);
        try {
            cipher.init(mode, ctx.keySpec, ivec);
            cipher.doFinal(src, srcOffset, Utilities.alignUp(size, 15), dst, dstOffset);
        }
        catch (InvalidKeyException e) {
            Utilities.log.error((Object)"doCipher", (Throwable)e);
        }
        catch (InvalidAlgorithmParameterException e) {
            Utilities.log.error((Object)"doCipher", (Throwable)e);
        }
        catch (IllegalBlockSizeException e) {
            Utilities.log.error((Object)"doCipher", (Throwable)e);
        }
        catch (BadPaddingException e) {
            Utilities.log.error((Object)"doCipher", (Throwable)e);
        }
        catch (ShortBufferException e) {
            Utilities.log.error((Object)"doCipher", (Throwable)e);
        }
        catch (IllegalArgumentException e) {
            Utilities.log.error((Object)"doCipher", (Throwable)e);
        }
    }

    public static void rijndael_encrypt(rijndael_ctx ctx, byte[] src, byte[] dst) {
        AES.rijndael_encrypt(ctx, src, 0, dst, 0);
    }

    public static void rijndael_encrypt(rijndael_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset) {
        AES.rijndael_encrypt(ctx, src, srcOffset, dst, dstOffset, 16);
    }

    private static void rijndael_encrypt(rijndael_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset, int size) {
        AES.doCipher(ctx, 1, src, srcOffset, dst, dstOffset, size);
    }

    public static void AES_cbc_encrypt(AES_ctx ctx, byte[] src, byte[] dst, int size) {
        AES.AES_cbc_encrypt(ctx, src, 0, dst, 0, size);
    }

    public static void AES_cbc_encrypt(AES_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset, int size) {
        AES.rijndael_encrypt(ctx, src, srcOffset, dst, dstOffset, size);
    }

    public static void AES_cbc_decrypt(AES_ctx ctx, byte[] src, byte[] dst, int size) {
        AES.AES_cbc_decrypt(ctx, src, 0, dst, 0, size);
    }

    public static void AES_cbc_decrypt(AES_ctx ctx, byte[] src, int srcOffset, KirkEngine.header_keys dst, int size) {
        byte[] buffer = new byte[32];
        AES.AES_cbc_decrypt(ctx, src, srcOffset, buffer, 0, size);
        dst.read(buffer, 0);
    }

    public static void rijndael_decrypt(rijndael_ctx ctx, byte[] src, byte[] dst) {
        AES.rijndael_decrypt(ctx, src, 0, dst, 0);
    }

    private static void rijndael_decrypt(rijndael_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset) {
        AES.rijndael_decrypt(ctx, src, srcOffset, dst, dstOffset, 16);
    }

    private static void rijndael_decrypt(rijndael_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset, int size) {
        AES.doCipher(ctx, 2, src, srcOffset, dst, dstOffset, size);
    }

    public static void AES_cbc_decrypt(AES_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset, int size) {
        AES.rijndael_decrypt(ctx, src, srcOffset, dst, dstOffset, size);
    }

    public static void AES_encrypt(AES_ctx ctx, byte[] src, byte[] dst) {
        AES.AES_encrypt(ctx, src, 0, dst, 0);
    }

    public static void AES_encrypt(AES_ctx ctx, byte[] src, int srcOffset, byte[] dst, int dstOffset) {
        AES.AES_cbc_encrypt(ctx, src, srcOffset, dst, dstOffset, 16);
    }

    private static void leftshift_onebit(byte[] input, byte[] output) {
        AES.leftshift_onebit(input, 0, output, 0);
    }

    private static void leftshift_onebit(byte[] input, int inputOffset, byte[] output, int outputOffset) {
        byte overflow = 0;
        for (int i = 15; i >= 0; --i) {
            output[i + outputOffset] = (byte)(input[i + inputOffset] << 1);
            int n = i + outputOffset;
            output[n] = (byte)(output[n] | overflow);
            overflow = (input[i + inputOffset] & 0x80) != 0 ? (byte)1 : 0;
        }
    }

    private static void generate_subkey(AES_ctx ctx, byte[] K1, byte[] K2) {
        byte[] L = new byte[16];
        byte[] Z = new byte[16];
        byte[] tmp = new byte[16];
        AES.AES_encrypt(ctx, Z, L);
        if ((L[0] & 0x80) == 0) {
            AES.leftshift_onebit(L, K1);
        } else {
            AES.leftshift_onebit(L, tmp);
            AES.xor_128(tmp, const_Rb, K1);
        }
        if ((K1[0] & 0x80) == 0) {
            AES.leftshift_onebit(K1, K2);
        } else {
            AES.leftshift_onebit(K1, tmp);
            AES.xor_128(tmp, const_Rb, K2);
        }
    }

    private static void padding(byte[] lastb, int lastbOffset, byte[] pad, int length) {
        AES.padding(lastb, lastbOffset, pad, 0, length);
    }

    private static void padding(byte[] lastb, int lastbOffset, byte[] pad, int padOffset, int length) {
        for (int j = 0; j < 16; ++j) {
            pad[j + padOffset] = j < length ? lastb[j + lastbOffset] : (j == length ? -128 : 0);
        }
    }

    public static void AES_CMAC(AES_ctx ctx, byte[] input, int inputOffset, int length, byte[] mac) {
        boolean flag;
        byte[] X = new byte[16];
        byte[] Y = new byte[16];
        byte[] M_last = new byte[16];
        byte[] padded = new byte[16];
        byte[] K1 = new byte[16];
        byte[] K2 = new byte[16];
        AES.generate_subkey(ctx, K1, K2);
        int n = (length + 15) / 16;
        if (n == 0) {
            n = 1;
            flag = false;
        } else {
            boolean bl = flag = length % 16 == 0;
        }
        if (flag) {
            AES.xor_128(input, inputOffset + 16 * (n - 1), K1, M_last);
        } else {
            AES.padding(input, inputOffset + 16 * (n - 1), padded, length % 16);
            AES.xor_128(padded, K2, M_last);
        }
        for (int i = 0; i < n - 1; ++i) {
            AES.xor_128(input, inputOffset + 16 * i, X, Y);
            AES.AES_encrypt(ctx, Y, X);
        }
        AES.xor_128(X, M_last, Y);
        AES.AES_encrypt(ctx, Y, X);
        Utilities.memcpy(mac, X, 16);
    }

    static {
        const_Rb = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, -121};
    }

    public static class AES_ctx
    extends rijndael_ctx {
    }

    public static class rijndael_ctx {
        public int enc_only;
        public int Nr;
        public final int[] ek = new int[60];
        public final int[] dk = new int[60];
        protected Key keySpec;
    }
}

