/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.graphics.RE;

import jpcsp.graphics.RE.BaseRenderingEngineFunction;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.ShaderProgram;
import jpcsp.graphics.Uniforms;
import jpcsp.settings.Settings;

public class REFixedFunction
extends BaseRenderingEngineFunction {
    private ShaderProgram stencilShaderProgram;

    public REFixedFunction(IRenderingEngine proxy) {
        super(proxy);
    }

    @Override
    public void setTextureFunc(int func, boolean alphaUsed, boolean colorDoubled) {
        if (colorDoubled || !alphaUsed) {
            switch (func) {
                case 0: {
                    func = 12;
                    this.re.setTexEnv(0, 0);
                    this.re.setTexEnv(4, 7);
                    this.re.setTexEnv(10, 10);
                    this.re.setTexEnv(5, 9);
                    this.re.setTexEnv(11, 10);
                    if (alphaUsed) {
                        this.re.setTexEnv(1, 0);
                        this.re.setTexEnv(7, 7);
                        this.re.setTexEnv(13, 11);
                        this.re.setTexEnv(8, 9);
                        this.re.setTexEnv(14, 11);
                        break;
                    }
                    this.re.setTexEnv(1, 3);
                    this.re.setTexEnv(7, 9);
                    this.re.setTexEnv(13, 11);
                    break;
                }
                case 1: {
                    func = 12;
                    if (!alphaUsed) {
                        this.re.setTexEnv(0, 3);
                        this.re.setTexEnv(4, 7);
                        this.re.setTexEnv(10, 10);
                    } else {
                        this.re.setTexEnv(0, 5);
                        this.re.setTexEnv(4, 7);
                        this.re.setTexEnv(10, 10);
                        this.re.setTexEnv(5, 9);
                        this.re.setTexEnv(11, 10);
                        this.re.setTexEnv(6, 7);
                        this.re.setTexEnv(12, 11);
                    }
                    this.re.setTexEnv(1, 3);
                    this.re.setTexEnv(7, 9);
                    this.re.setTexEnv(13, 11);
                    break;
                }
                case 2: {
                    func = 12;
                    this.re.setTexEnv(0, 5);
                    this.re.setTexEnv(4, 8);
                    this.re.setTexEnv(10, 10);
                    this.re.setTexEnv(5, 9);
                    this.re.setTexEnv(11, 10);
                    this.re.setTexEnv(6, 7);
                    this.re.setTexEnv(12, 10);
                    if (alphaUsed) {
                        this.re.setTexEnv(1, 0);
                        this.re.setTexEnv(7, 7);
                        this.re.setTexEnv(13, 11);
                        this.re.setTexEnv(8, 9);
                        this.re.setTexEnv(14, 11);
                        break;
                    }
                    this.re.setTexEnv(1, 3);
                    this.re.setTexEnv(7, 9);
                    this.re.setTexEnv(13, 11);
                    break;
                }
                case 3: {
                    func = 12;
                    this.re.setTexEnv(0, 3);
                    this.re.setTexEnv(4, 7);
                    this.re.setTexEnv(10, 10);
                    if (alphaUsed) {
                        this.re.setTexEnv(1, 3);
                        this.re.setTexEnv(7, 7);
                        this.re.setTexEnv(13, 11);
                        break;
                    }
                    this.re.setTexEnv(1, 3);
                    this.re.setTexEnv(7, 9);
                    this.re.setTexEnv(13, 11);
                    break;
                }
                case 4: {
                    func = 12;
                    this.re.setTexEnv(0, 4);
                    this.re.setTexEnv(4, 7);
                    this.re.setTexEnv(10, 10);
                    this.re.setTexEnv(5, 9);
                    this.re.setTexEnv(11, 10);
                    if (alphaUsed) {
                        this.re.setTexEnv(1, 0);
                        this.re.setTexEnv(7, 7);
                        this.re.setTexEnv(13, 11);
                        this.re.setTexEnv(8, 9);
                        this.re.setTexEnv(14, 11);
                        break;
                    }
                    this.re.setTexEnv(1, 3);
                    this.re.setTexEnv(7, 9);
                    this.re.setTexEnv(13, 11);
                }
            }
        }
        super.setTextureFunc(func, alphaUsed, colorDoubled);
    }

    @Override
    public void disableFlag(int flag) {
        if (this.canUpdateFlag(flag)) {
            super.disableFlag(flag);
        }
    }

    @Override
    public void enableFlag(int flag) {
        if (this.canUpdateFlag(flag)) {
            super.enableFlag(flag);
        }
    }

    @Override
    public void enableVertexAttribArray(int id) {
    }

    @Override
    public void disableVertexAttribArray(int id) {
    }

    @Override
    public boolean canNativeClut(int textureAddress, int pixelFormat, boolean textureSwizzle) {
        return false;
    }

    @Override
    public boolean setCopyRedToAlpha(boolean copyRedToAlpha) {
        if (copyRedToAlpha) {
            if (this.stencilShaderProgram == null) {
                if (!this.re.isShaderAvailable()) {
                    log.info((Object)"Shaders are not available on your computer. They are required to save stencil information into the GE texture. Saving of the stencil information has been disabled.");
                    return false;
                }
                String fragmentShaderSource = "uniform sampler2D tex;void main() {    gl_FragColor.a = texture2DProj(tex, gl_TexCoord[0].xyz).r;}";
                int shaderId = this.re.createShader(1);
                boolean compiled = this.re.compilerShader(shaderId, fragmentShaderSource);
                if (!compiled) {
                    log.error((Object)String.format("Cannot compile shader required for storing stencil information into the GE texture: %s", this.re.getShaderInfoLog(shaderId)));
                    return false;
                }
                int stencilShaderProgramId = this.re.createProgram();
                this.re.attachShader(stencilShaderProgramId, shaderId);
                boolean linked = this.re.linkProgram(stencilShaderProgramId);
                if (!linked) {
                    log.error((Object)String.format("Cannot link shader required for storing stencil information into the GE texture: %s", this.re.getProgramInfoLog(stencilShaderProgramId)));
                    return false;
                }
                Uniforms.tex.allocateId(this.re, stencilShaderProgramId);
                this.stencilShaderProgram = new ShaderProgram();
                this.stencilShaderProgram.setProgramId(this.re, stencilShaderProgramId);
                if (!Settings.getInstance().readBool("emu.useshaders")) {
                    log.info((Object)"Shaders are disabled in the Jpcsp video settings. However a small shader program is required to implement the saving of the Stencil information into the GE texture. This small shader program will still be used even though the shaders are disabled in the settings. This was just for your information, you do not need to take special actions.");
                }
            }
            this.stencilShaderProgram.use(this.re);
            this.re.setUniform(Uniforms.tex.getId(this.stencilShaderProgram.getProgramId()), 0);
            this.re.checkAndLogErrors("setUniform");
        } else {
            this.re.useProgram(0);
        }
        return super.setCopyRedToAlpha(copyRedToAlpha);
    }

    @Override
    public void setFogDist(float end, float scale) {
        if (end != 0.0f && scale != 0.0f) {
            float glEnd = end;
            float glStart = end - 1.0f / scale;
            if (scale < 0.0f) {
                glEnd = -glEnd;
                glStart = -glStart;
            }
            super.setFogDist(glStart, glEnd);
        }
    }

    @Override
    public boolean canDiscardVertices() {
        return false;
    }
}

