/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.logging.Logger;

public class TimeUtils {
    private static final Logger logger = Logger.getLogger(TimeUtils.class.getName());

    public static Date createTime(String string) throws ParseException {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss");
        return simpleDateFormat.parse(string);
    }

    public static Integer mostSignificantDifference(Calendar calendar, Calendar calendar2) {
        if (!TimeUtils.isSameYear(calendar, calendar2)) {
            logger.info("YEAR");
            return 1;
        }
        if (!TimeUtils.isSameMonth(calendar, calendar2)) {
            logger.info("Month");
            return 2;
        }
        if (!TimeUtils.isSameWeek(calendar, calendar2)) {
            logger.info("WEEK_OF_YEAR");
            return 3;
        }
        if (!TimeUtils.isSameDay(calendar, calendar2)) {
            logger.info("DAY_OF_MONTH");
            return 5;
        }
        if (!TimeUtils.isSameHour(calendar, calendar2)) {
            logger.info("HOUR_OF_DAY");
            return 11;
        }
        if (!TimeUtils.isSameMinute(calendar, calendar2)) {
            logger.info("MINUTE");
            return 12;
        }
        if (!TimeUtils.isSameSecond(calendar, calendar2)) {
            logger.info("SECOND");
            return 13;
        }
        if (!TimeUtils.isSameMillis(calendar, calendar2)) {
            logger.info("MILLISECOND");
            return 14;
        }
        return null;
    }

    public static boolean isSameYear(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(1, calendar, calendar2);
    }

    public static boolean isSameMonth(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(2, calendar, calendar2);
    }

    public static boolean isSameWeek(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(3, calendar, calendar2);
    }

    public static boolean isSameDay(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(5, calendar, calendar2);
    }

    public static boolean isSameHour(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(11, calendar, calendar2);
    }

    public static boolean isSameMinute(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(12, calendar, calendar2);
    }

    public static boolean isSameSecond(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(13, calendar, calendar2);
    }

    public static boolean isSameMillis(Calendar calendar, Calendar calendar2) {
        return TimeUtils.isSameInField(14, calendar, calendar2);
    }

    public static boolean isSameInField(int n, Calendar calendar, Calendar calendar2) {
        int n2;
        int n3 = calendar.get(n);
        return n3 == (n2 = calendar2.get(n));
    }

    public static double yearsDiff(Calendar calendar, Calendar calendar2) {
        return TimeUtils.weeksDiff(calendar, calendar2) / 52.0;
    }

    public static double weeksDiff(Calendar calendar, Calendar calendar2) {
        return TimeUtils.daysDiff(calendar, calendar2) / 7.0;
    }

    public static double daysDiff(Calendar calendar, Calendar calendar2) {
        return TimeUtils.hoursDiff(calendar, calendar2) / 24.0;
    }

    public static double hoursDiff(Calendar calendar, Calendar calendar2) {
        return TimeUtils.minutesDiff(calendar, calendar2) / 60.0;
    }

    public static double minutesDiff(Calendar calendar, Calendar calendar2) {
        return TimeUtils.secondsDiff(calendar, calendar2) / 60.0;
    }

    public static double secondsDiff(Calendar calendar, Calendar calendar2) {
        return (double)TimeUtils.millisDiff(calendar, calendar2) / 1000.0;
    }

    public static long millisDiff(Calendar calendar, Calendar calendar2) {
        long l = calendar.getTimeInMillis();
        long l2 = calendar2.getTimeInMillis();
        return Math.abs(l - l2);
    }

    public static Calendar min(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTimeInMillis(calendar2.getTimeInMillis());
        if (TimeUtils.yearsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(3, 0);
            calendar3.set(2, 0);
            calendar3.set(5, 0);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else if (TimeUtils.weeksDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
        } else {
            if (TimeUtils.daysDiff(calendar, calendar2) > 1.0) {
                calendar3.set(11, 0);
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
                return calendar3;
            }
            if (TimeUtils.hoursDiff(calendar, calendar2) > 1.0) {
                calendar3.set(12, 0);
                calendar3.set(13, 0);
                calendar3.set(14, 0);
            } else if (TimeUtils.minutesDiff(calendar, calendar2) > 1.0) {
                calendar3.set(13, 0);
                calendar3.set(14, 0);
            } else if (TimeUtils.secondsDiff(calendar, calendar2) > 1.0) {
                calendar3.set(14, 0);
                calendar3.add(13, 1);
            }
        }
        return calendar3;
    }

    public static Calendar max(Calendar calendar, Calendar calendar2) {
        Calendar calendar3 = Calendar.getInstance();
        calendar3.setTimeInMillis(calendar2.getTimeInMillis());
        if (TimeUtils.yearsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(3, 0);
            calendar3.set(2, 0);
            calendar3.set(5, 0);
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(1, 1);
        } else if (TimeUtils.weeksDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(5, 1);
        } else if (TimeUtils.daysDiff(calendar, calendar2) > 1.0) {
            calendar3.set(11, 0);
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(5, 1);
        } else if (TimeUtils.hoursDiff(calendar, calendar2) > 1.0) {
            calendar3.set(12, 0);
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(11, 1);
        } else if (TimeUtils.minutesDiff(calendar, calendar2) > 1.0) {
            calendar3.set(13, 0);
            calendar3.set(14, 0);
            calendar3.add(12, 1);
        } else if (TimeUtils.secondsDiff(calendar, calendar2) > 1.0) {
            calendar3.set(14, 0);
            calendar3.add(13, 1);
        }
        return calendar3;
    }
}

