/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.remote;

import java.awt.AWTException;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.Authenticator;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.PasswordAuthentication;
import java.net.Proxy;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.imageio.ImageIO;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceNpTicket;
import jpcsp.HLE.modules.sceNpAuth;
import jpcsp.MainGUI;
import jpcsp.State;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.format.Elf32Header;
import jpcsp.hardware.Wlan;
import jpcsp.remote.HTTPConfiguration;
import jpcsp.remote.IProcessHTTPRequest;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class HTTPServer {
    private static Logger log = Logger.getLogger((String)"http");
    private static HTTPServer instance;
    private static final HTTPServerDescriptor[] serverDescriptors;
    public static boolean processProxyRequestLocally;
    public static final String method = "method";
    public static final String path = "path";
    public static final String host = "host";
    public static final String parameters = "parameters";
    public static final String version = "version";
    public static final String data = "data";
    public static final String contentLength = "content-length";
    private static final String eol = "\r\n";
    private static final String boundary = "--boundarybetweensingleimages";
    private static final String isoDirectory = "/iso/";
    private static final String iconDirectory = "/icon/";
    private static final String rootDirectory = "root";
    private static final String widgetDirectory = "Widget";
    private static final String widgetPath = "root/Widget";
    private static final String indexFile = "index.html";
    private static final String naclDirectory = "nacl";
    private static final String widgetlistFile = "/widgetlist.xml";
    private HTTPServerThread[] serverThreads;
    private Robot captureRobot;
    private UmdIsoReader previousUmdIsoReader;
    private String previousIsoFilename;
    private HashMap<Integer, Controller.keyCode> keyMapping = new HashMap();
    private int runMapping = -1;
    private int pauseMapping = -1;
    private int resetMapping = -1;
    private static final int MAX_COMPRESSED_COUNT = 127;
    private DisplayAction displayAction;
    private int displayActionUsageCount = 0;
    private BufferedImage currentDisplayImage;
    private boolean currentDisplayImageHasAlpha = false;
    private Proxy proxy;
    private int proxyPort;
    private int proxyAddress;
    private SceNpTicket ticket;
    private Map<String, IProcessHTTPRequest> processors = new HashMap<String, IProcessHTTPRequest>();

    public static HTTPServer getInstance() {
        if (instance == null) {
            Utilities.disableSslCertificateChecks();
            instance = new HTTPServer();
        }
        return instance;
    }

    private HTTPServer() {
        this.serverThreads = new HTTPServerThread[serverDescriptors.length];
        for (HTTPServerDescriptor descriptor : serverDescriptors) {
            HTTPServerThread serverThread;
            if (descriptor.getIndex() == 0) {
                String addressName = "localhost";
                this.proxyPort = descriptor.getPort();
                InetSocketAddress socketAddress = new InetSocketAddress(addressName, this.proxyPort);
                this.proxy = new Proxy(Proxy.Type.HTTP, socketAddress);
                byte[] addrBytes = socketAddress.getAddress().getAddress();
                this.proxyAddress = addrBytes[0] & 0xFF | (addrBytes[1] & 0xFF) << 8 | (addrBytes[2] & 0xFF) << 16 | (addrBytes[3] & 0xFF) << 24;
            }
            this.serverThreads[descriptor.getIndex()] = serverThread = new HTTPServerThread(descriptor);
            serverThread.setDaemon(true);
            serverThread.setName("HTTP Server");
            serverThread.start();
        }
        Authenticator.setDefault(new Authenticator(){

            @Override
            protected PasswordAuthentication getPasswordAuthentication() {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("getPasswordAuthentication called for scheme='%s', prompt='%s'", this.getRequestingScheme(), this.getRequestingPrompt()));
                }
                if ("digest".equals(this.getRequestingScheme())) {
                    return new PasswordAuthentication("c7y-basic01", "A9QTbosh0W0D^{7467l-n_>2Y%JG^v>o".toCharArray());
                }
                if ("c7y-basic".equals(this.getRequestingPrompt())) {
                    char[] pwd = new char[]{'5', '\u0003', '\u000f', '\u0019', '@', '\u0016', 'I', '\u0004', '\u001c', '5', '\u0003', '\u001e', '!', 'H', '-', 'N', '\u0007', '\u001c', 'Z', '6', '\u000e', '?', '\f', '\u0018', 'I', '\u0015', 'N', '!', '\u0014', '6', '\u001d', '\u0016'};
                    return new PasswordAuthentication("c7y-basic02", pwd);
                }
                if ("c7y-ranking".equals(this.getRequestingPrompt())) {
                    char[] pwd = new char[]{'!', '-', '\u0018', '\u001b', '\u001d', '\u000e', '*', '#', '\u0004', 'L', 'K', '\u0019', 'O', '%', '&', '?', 'K', 'M', 'L', 'D', 'X', '<', '1', 'L', '\u0015', 'L', '\\', 'A', '2', '8', '\u001e', '\b'};
                    return new PasswordAuthentication("c7y-ranking01", pwd);
                }
                return super.getPasswordAuthentication();
            }
        });
        try {
            this.captureRobot = new Robot();
            this.captureRobot.setAutoDelay(0);
        }
        catch (AWTException e) {
            log.error((Object)"Create captureRobot", (Throwable)e);
        }
    }

    public void register(String path, IProcessHTTPRequest processor) {
        this.processors.put(path, processor);
    }

    private static String decodePath(String path) {
        StringBuilder decoded = new StringBuilder();
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '+') {
                decoded.append(' ');
                continue;
            }
            if (c == '%') {
                int hex = Integer.parseInt(path.substring(i + 1, i + 3), 16);
                i += 2;
                decoded.append((char)hex);
                continue;
            }
            decoded.append(c);
        }
        return decoded.toString();
    }

    private void process(HTTPServerDescriptor descriptor, Socket socket) {
        InputStream is = null;
        try {
            is = socket.getInputStream();
        }
        catch (IOException e) {
            log.error((Object)"process InputStream", (Throwable)e);
        }
        OutputStream os = null;
        try {
            os = socket.getOutputStream();
        }
        catch (IOException e) {
            log.error((Object)"process OutputStream", (Throwable)e);
        }
        byte[] buffer = new byte[10000];
        int bufferLength = 0;
        while (is != null && os != null) {
            try {
                String request;
                HashMap<String, String> requestHeaders;
                int length = is.read(buffer, bufferLength, buffer.length - bufferLength);
                if (length < 0) break;
                if (length <= 0 || (requestHeaders = this.parseRequest(request = new String(buffer, 0, bufferLength += length))) == null) continue;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Received request: '%s', headers: %s", request, requestHeaders));
                }
                boolean keepAlive = this.process(descriptor, requestHeaders, os);
                os.flush();
                if (!keepAlive) break;
                bufferLength = 0;
            }
            catch (SocketTimeoutException length) {
            }
            catch (IOException e) {
                if (e.getCause() instanceof EOFException || !log.isDebugEnabled()) break;
                log.debug((Object)"Receive socket", (Throwable)e);
                break;
            }
        }
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private HashMap<String, String> parseRequest(String request) {
        String additionalData;
        int headerContentLength;
        HashMap<String, String> headers = new HashMap<String, String>();
        String[] lines = request.split(eol, -1);
        boolean header = true;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("parseRequest '%s'", request));
        }
        for (int i = 0; i < lines.length; ++i) {
            String[] words;
            String line = lines[i];
            if (i == 0) {
                words = line.split(" ");
                if (words.length >= 1) {
                    headers.put(method, words[0]);
                }
                if (words.length >= 2) {
                    String completePath = words[1];
                    int parametersIndex = completePath.indexOf("?");
                    if (parametersIndex >= 0) {
                        headers.put(path, HTTPServer.decodePath(completePath.substring(0, parametersIndex)));
                        headers.put(parameters, completePath.substring(parametersIndex + 1));
                    } else {
                        headers.put(path, HTTPServer.decodePath(completePath));
                    }
                }
                if (words.length < 3) continue;
                headers.put(version, words[2]);
                continue;
            }
            if (header) {
                if (line.length() == 0) {
                    header = false;
                    continue;
                }
                words = line.split(": *", 2);
                if (words.length < 2) continue;
                headers.put(words[0].toLowerCase(), words[1]);
                continue;
            }
            String previousData = headers.get(data);
            if (previousData != null) {
                headers.put(data, previousData + eol + line);
                continue;
            }
            headers.put(data, line);
        }
        if (header) {
            return null;
        }
        if (headers.get(contentLength) != null && (headerContentLength = Integer.parseInt(headers.get(contentLength))) > 0 && ((additionalData = headers.get(data)) == null || additionalData.length() < headerContentLength)) {
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("parseRequest content-length=%d, data length=%d", headerContentLength, additionalData.length()));
            }
            return null;
        }
        return headers;
    }

    private boolean doProxy(HTTPConfiguration.HttpServerConfiguration httpServerConfiguration, HTTPServerDescriptor descriptor, HashMap<String, String> request, OutputStream os, String pathValue) throws IOException {
        int forcedPort = 0;
        if (httpServerConfiguration.serverPort != descriptor.port) {
            forcedPort = httpServerConfiguration.serverPort;
        }
        boolean keepAlive = this.doProxy(descriptor, request, os, pathValue, forcedPort);
        if (!httpServerConfiguration.doKeepAlive) {
            keepAlive = false;
        }
        return keepAlive;
    }

    private boolean doProxy(HTTPServerDescriptor descriptor, HashMap<String, String> request, OutputStream os, String pathValue, int forcedPort) throws IOException {
        int length;
        boolean keepAlive = false;
        String remoteUrl = HTTPServer.getUrl(descriptor, request, pathValue, forcedPort);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("doProxy connecting to '%s'", remoteUrl));
        }
        HttpURLConnection connection = (HttpURLConnection)new URL(remoteUrl).openConnection();
        for (String key : request.keySet()) {
            if (data.equals(key) || method.equals(key) || version.equals(key) || path.equals(key) || parameters.equals(key)) continue;
            connection.setRequestProperty(key, request.get(key));
        }
        connection.setInstanceFollowRedirects(false);
        connection.setRequestMethod(request.get(method));
        String additionalData = request.get(data);
        if (additionalData != null) {
            if ("/nav/auth".equals(pathValue) && additionalData.contains("&consoleid=")) {
                additionalData = additionalData.replaceAll("\\&consoleid=[0-9a-fA-F]*", "");
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("doProxy additional data: '%s'", additionalData));
            }
            connection.setDoOutput(true);
            OutputStream dataStream = connection.getOutputStream();
            dataStream.write(additionalData.getBytes());
            dataStream.close();
        }
        connection.connect();
        int dataLength = connection.getContentLength();
        byte[] buffer = new byte[100000];
        boolean endOfInputReached = false;
        InputStream in = null;
        try {
            int l;
            in = connection.getInputStream();
            for (length = 0; length < buffer.length; length += l) {
                l = in.read(buffer, length, buffer.length - length);
                if (l >= 0) continue;
                endOfInputReached = true;
                break;
            }
        }
        catch (IOException e) {
            log.debug((Object)"doProxy", (Throwable)e);
        }
        String bufferString = new String(buffer, 0, length);
        boolean bufferPatched = false;
        if (bufferString.contains("https://legaldoc.dl.playstation.net")) {
            bufferString = bufferString.replace("https://legaldoc.dl.playstation.net", "http://legaldoc.dl.playstation.net");
            bufferPatched = true;
        }
        if (bufferPatched) {
            buffer = bufferString.getBytes();
            length = buffer.length;
            if (dataLength >= 0) {
                dataLength = length;
            }
        }
        this.sendHTTPResponseCode(os, connection.getResponseCode(), connection.getResponseMessage());
        if (dataLength >= 0) {
            this.sendResponseHeader(os, contentLength, dataLength);
        }
        for (Map.Entry<String, List<String>> entry : connection.getHeaderFields().entrySet()) {
            String key = entry.getKey();
            if (key == null || "transfer-encoding".equals(key.toLowerCase())) continue;
            for (String value : entry.getValue()) {
                if ("Set-Cookie".equalsIgnoreCase(key) && value.length() == 0) continue;
                if (forcedPort == 443 && "Set-Cookie".equalsIgnoreCase(key)) {
                    value = value.replace("; Secure", "");
                }
                if (forcedPort == 443 && "Location".equalsIgnoreCase(key) && value.startsWith("https:")) {
                    value = value.replaceFirst("https:", "http:");
                }
                this.sendResponseHeader(os, key, value);
                if ("connection".equalsIgnoreCase(key) && "keep-alive".equalsIgnoreCase(value)) {
                    keepAlive = true;
                }
                if (!"content-type".equalsIgnoreCase(key) || !"application/x-i-5-ticket".equalsIgnoreCase(value) || length <= 0) continue;
                this.ticket = new SceNpTicket();
                this.ticket.read(buffer, 0, length);
            }
        }
        this.sendEndOfHeaders(os);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("doProxy%s:\n%s", bufferPatched ? " (response patched)" : "", Utilities.getMemoryDump(buffer, 0, length)));
        }
        os.write(buffer, 0, length);
        if (in != null) {
            while (!endOfInputReached) {
                try {
                    int l;
                    for (length = 0; length < buffer.length; length += l) {
                        l = in.read(buffer, length, buffer.length - length);
                        if (l >= 0) continue;
                        endOfInputReached = true;
                        break;
                    }
                }
                catch (IOException e) {
                    log.debug((Object)"doProxy", (Throwable)e);
                }
                os.write(buffer, 0, length);
            }
            in.close();
        }
        return keepAlive;
    }

    private HTTPConfiguration.HttpServerConfiguration getHttpServerConfiguration(String serverName, String pathValue) {
        if (serverName != null) {
            for (HTTPConfiguration.HttpServerConfiguration httpServerConfiguration : HTTPConfiguration.doProxyServers) {
                if (!httpServerConfiguration.serverName.equals(serverName)) continue;
                boolean found = true;
                if (httpServerConfiguration.fakedPaths != null) {
                    for (String fakedPath : httpServerConfiguration.fakedPaths) {
                        if (!fakedPath.equals(pathValue)) continue;
                        found = false;
                        break;
                    }
                }
                if (!found) continue;
                return httpServerConfiguration;
            }
        }
        return null;
    }

    private boolean process(OutputStream os, String path, HashMap<String, String> request) throws IOException {
        for (String key : this.processors.keySet()) {
            IProcessHTTPRequest processor;
            if (!path.startsWith(key) || !(processor = this.processors.get(key)).processRequest(this, os, path, request)) continue;
            return true;
        }
        return false;
    }

    private boolean process(HTTPServerDescriptor descriptor, HashMap<String, String> request, OutputStream os) throws IOException {
        boolean keepAlive = false;
        try {
            String pathValue = request.get(path);
            String baseUrl = HTTPServer.getBaseUrl(descriptor, request, 0);
            if (pathValue.startsWith(baseUrl)) {
                pathValue = pathValue.substring(baseUrl.length() - 1);
            }
            String methodValue = request.get(method);
            HTTPConfiguration.HttpServerConfiguration httpServerConfiguration = this.getHttpServerConfiguration(request.get(host), pathValue);
            if (httpServerConfiguration != null) {
                keepAlive = this.doProxy(httpServerConfiguration, descriptor, request, os, pathValue);
            } else if ("commerce.np.ac.playstation.net".equals(request.get(host)) && "/cap.m".equals(pathValue)) {
                this.sendCapM(request.get(data), os);
            } else if ("commerce.np.ac.playstation.net".equals(request.get(host)) && "/kdp.m".equals(pathValue)) {
                this.sendKdpM(request.get(data), os);
            } else if ("video.dl.playstation.net".equals(request.get(host)) && pathValue.matches("/cdn/video/[A-Z][A-Z]/g")) {
                this.sendVideoStore(os);
            } else if ("GET".equals(methodValue)) {
                if (!this.process(os, pathValue, request)) {
                    if ("/".equals(pathValue)) {
                        this.sendResponseFile(os, "root/index.html");
                    } else if ("/screen.png".equals(pathValue)) {
                        this.sendScreenImage(os, "png");
                    } else if ("/screen.jpg".equals(pathValue)) {
                        this.sendScreenImage(os, "jpg");
                    } else if ("/screen.mjpg".equals(pathValue)) {
                        this.sendVideoMJPG(os);
                    } else if ("/screen.raw".equals(pathValue)) {
                        this.sendVideoRAW(os);
                    } else if ("/screen.craw".equals(pathValue)) {
                        this.sendVideoCompressedRAW(os);
                    } else if ("/audio.wav".equals(pathValue)) {
                        this.sendAudioWAV(os);
                    } else if ("/audio.raw".equals(pathValue)) {
                        this.sendAudioRAW(os);
                    } else if ("/controls".equals(pathValue)) {
                        this.processControls(os, request.get(parameters));
                    } else if (pathValue.startsWith(iconDirectory)) {
                        this.sendIcon(os, pathValue);
                    } else if (pathValue.startsWith(isoDirectory)) {
                        this.sendIso(request, os, pathValue, true);
                    } else if (widgetlistFile.equals(pathValue)) {
                        this.sendWidgetlist(descriptor, request, os, pathValue);
                    } else if (pathValue.startsWith("/Widget/")) {
                        this.sendWidget(os, request.get(parameters), rootDirectory + pathValue);
                    } else if (pathValue.startsWith("/nacl/")) {
                        this.sendNaClResponse(os, pathValue.substring(6));
                    } else if (pathValue.endsWith(".html")) {
                        this.sendResponseFile(os, rootDirectory + pathValue);
                    } else if (pathValue.endsWith(".txt")) {
                        this.sendResponseFile(os, rootDirectory + pathValue);
                    } else if (pathValue.endsWith(".xml")) {
                        this.sendResponseFile(os, rootDirectory + pathValue);
                    } else {
                        this.sendErrorNotFound(os);
                    }
                }
            } else if ("HEAD".equals(methodValue)) {
                if (pathValue.startsWith(isoDirectory)) {
                    this.sendIso(request, os, pathValue, false);
                } else {
                    this.sendErrorNotFound(os);
                }
            } else if ("POST".equals(methodValue)) {
                if (!this.process(os, pathValue, request)) {
                    this.sendErrorMethodNotAllowed(os);
                }
            } else {
                this.sendErrorMethodNotAllowed(os);
            }
        }
        catch (SocketException e) {
            keepAlive = false;
        }
        return keepAlive;
    }

    private static String guessMimeType(String fileName) {
        if (fileName != null) {
            if (fileName.endsWith(".js")) {
                return "application/javascript";
            }
            if (fileName.endsWith(".html")) {
                return "text/html";
            }
            if (fileName.endsWith(".css")) {
                return "text/css";
            }
            if (fileName.endsWith(".png")) {
                return "image/png";
            }
            if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
                return "image/jpeg";
            }
            if (fileName.endsWith(".xml")) {
                return "text/xml";
            }
            if (fileName.endsWith(".zip")) {
                return "application/zip";
            }
        }
        return "application/octet-stream";
    }

    private void sendRedirect(OutputStream os, String redirect) throws IOException {
        this.sendHTTPResponseCode(os, 302);
        this.sendResponseHeader(os, "Location", redirect);
        this.sendEndOfHeaders(os);
    }

    private void sendResponseFile(OutputStream os, String fileName) throws IOException {
        this.sendResponseFile(os, this.getClass().getResourceAsStream(fileName), HTTPServer.guessMimeType(fileName));
    }

    public void sendResponse(OutputStream os, String response) throws IOException {
        byte[] buffer = response.getBytes();
        this.sendResponse(os, buffer, buffer.length, null);
    }

    private void sendResponse(OutputStream os, byte[] buffer, int bufferLength, String contentType) throws IOException {
        this.sendOK(os);
        if (contentType != null) {
            this.sendResponseHeader(os, "Content-Type", contentType);
        }
        if (bufferLength > 0) {
            this.sendResponseHeader(os, "Content-Length", bufferLength);
        }
        this.sendEndOfHeaders(os);
        if (bufferLength > 0) {
            os.write(buffer, 0, bufferLength);
        }
    }

    private void sendResponseFile(OutputStream os, InputStream is, String contentType) throws IOException {
        byte[] buffer = new byte[1000];
        int contentLength = 0;
        if (is != null) {
            while (true) {
                int length;
                if (buffer.length - contentLength < 1000) {
                    buffer = Utilities.extendArray(buffer, 1000);
                }
                if ((length = is.read(buffer, contentLength, buffer.length - contentLength)) < 0) break;
                contentLength += length;
            }
            is.close();
        }
        this.sendResponse(os, buffer, contentLength, contentType);
    }

    private void sendResponseLine(OutputStream os, String line) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Response: %s", line));
        }
        os.write(line.getBytes());
        os.write(eol.getBytes());
    }

    private static String guessHTTPResponseCodeMsg(int code) {
        switch (code) {
            case 200: {
                return "OK";
            }
            case 206: {
                return "Partial Content";
            }
            case 302: {
                return "Found";
            }
            case 404: {
                return "Not Found";
            }
            case 405: {
                return "Method Not Allowed";
            }
        }
        return "";
    }

    private void sendHTTPResponseCode(OutputStream os, int code, String msg) throws IOException {
        this.sendResponseLine(os, String.format("HTTP/1.1 %d %s", code, msg));
    }

    private void sendHTTPResponseCode(OutputStream os, int code) throws IOException {
        this.sendHTTPResponseCode(os, code, HTTPServer.guessHTTPResponseCodeMsg(code));
    }

    private void sendOK(OutputStream os) throws IOException {
        this.sendHTTPResponseCode(os, 200);
    }

    private void sendResponseHeader(OutputStream os, String name, String value) throws IOException {
        this.sendResponseLine(os, String.format("%s: %s", name, value));
    }

    private void sendResponseHeader(OutputStream os, String name, int value) throws IOException {
        this.sendResponseHeader(os, name, String.valueOf(value));
    }

    private void sendResponseHeader(OutputStream os, String name, long value) throws IOException {
        this.sendResponseHeader(os, name, String.valueOf(value));
    }

    private void sendNoCache(OutputStream os) throws IOException {
        this.sendResponseHeader(os, "Cache-Control", "no-cache");
        this.sendResponseHeader(os, "Cache-Control", "private");
    }

    private void sendEndOfHeaders(OutputStream os) throws IOException {
        this.sendResponseLine(os, "");
    }

    private void sendError(OutputStream os, int code) throws IOException {
        this.sendHTTPResponseCode(os, code);
        this.sendEndOfHeaders(os);
    }

    private void sendErrorNotFound(OutputStream os) throws IOException {
        this.sendError(os, 404);
    }

    private void sendErrorMethodNotAllowed(OutputStream os) throws IOException {
        this.sendError(os, 405);
    }

    private void sendScreenImage(OutputStream os, String fileFormat) throws IOException {
        String fileName = String.format("%s%cscreen.%s", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), fileFormat);
        File file = new File(fileName);
        file.deleteOnExit();
        Rectangle rect = Emulator.getMainGUI().getCaptureRectangle();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Capturing screen from %s to %s", rect, fileName));
        }
        BufferedImage img = this.captureRobot.createScreenCapture(rect);
        try {
            file.delete();
            ImageIO.write((RenderedImage)img, fileFormat, file);
            img.flush();
        }
        catch (IOException e) {
            log.error((Object)"Error saving screenshot", (Throwable)e);
        }
        if (file.canRead()) {
            int length = (int)file.length();
            this.sendOK(os);
            this.sendNoCache(os);
            this.sendResponseHeader(os, "Content-Type", String.format("image/%s", fileFormat));
            this.sendResponseHeader(os, "Content-Length", length);
            this.sendEndOfHeaders(os);
            byte[] buffer = new byte[length];
            FileInputStream is = new FileInputStream(file);
            length = ((InputStream)is).read(buffer);
            ((InputStream)is).close();
            file.delete();
            os.write(buffer, 0, length);
        } else {
            this.sendErrorNotFound(os);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendVideoMJPG(OutputStream os) throws IOException {
        String fileFormat = "jpg";
        String fileName = String.format("%s%cscreen.%s", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), fileFormat);
        File file = new File(fileName);
        file.deleteOnExit();
        Rectangle rect = Emulator.getMainGUI().getCaptureRectangle();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Capturing screen from %s to %s", rect, fileName));
        }
        this.startDisplayAction();
        try {
            this.sendOK(os);
            this.sendNoCache(os);
            this.sendResponseHeader(os, "Content-Type", String.format("multipart/x-mixed-replace; boundary=%s", boundary));
            this.sendEndOfHeaders(os);
            while (true) {
                BufferedImage img = this.getScreenImage(rect);
                try {
                    file.delete();
                    ImageIO.write((RenderedImage)img, fileFormat, file);
                    img.flush();
                }
                catch (IOException e) {
                    log.error((Object)"Error saving screenshot", (Throwable)e);
                }
                if (!file.canRead()) break;
                int length = (int)file.length();
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Sending video image length=%d", length));
                }
                byte[] buffer = new byte[length];
                FileInputStream is = new FileInputStream(file);
                length = ((InputStream)is).read(buffer);
                ((InputStream)is).close();
                this.sendResponseLine(os, boundary);
                this.sendResponseHeader(os, "Content-Type", "image/jpeg");
                this.sendResponseHeader(os, "Content-Length", length);
                this.sendEndOfHeaders(os);
                os.write(buffer, 0, length);
                this.sendEndOfHeaders(os);
                os.flush();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Cannot read capture file %s", file));
            }
        }
        finally {
            this.stopDisplayAction();
            file.delete();
        }
    }

    private void sendAudioWAV(OutputStream os) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendAudioWAV", new Object[0]));
        }
        this.sendOK(os);
        this.sendResponseHeader(os, "Content-Type", "audio/wav");
        this.sendEndOfHeaders(os);
        int channels = 2;
        int sampleRate = 44100;
        byte[] silenceBuffer = new byte[1024 * channels * 2];
        byte[] header = new byte[100];
        int n = 0;
        header[n++] = 82;
        header[n++] = 73;
        header[n++] = 70;
        header[n++] = 70;
        header[n++] = 0;
        header[n++] = 0;
        header[n++] = 0;
        header[n++] = 127;
        header[n++] = 87;
        header[n++] = 65;
        header[n++] = 86;
        header[n++] = 69;
        header[n++] = 102;
        header[n++] = 109;
        header[n++] = 116;
        header[n++] = 32;
        header[n++] = 16;
        header[n++] = 0;
        header[n++] = 0;
        header[n++] = 0;
        header[n++] = 1;
        header[n++] = 0;
        header[n++] = (byte)channels;
        header[n++] = 0;
        header[n++] = (byte)(sampleRate & 0xFF);
        header[n++] = (byte)(sampleRate >> 8 & 0xFF);
        header[n++] = 0;
        header[n++] = 0;
        int bytesPerSecond = 2 * channels * sampleRate;
        header[n++] = (byte)(bytesPerSecond & 0xFF);
        header[n++] = (byte)(bytesPerSecond >> 8 & 0xFF);
        header[n++] = (byte)(bytesPerSecond >> 16 & 0xFF);
        header[n++] = (byte)(bytesPerSecond >> 24 & 0xFF);
        header[n++] = (byte)(2 * channels);
        header[n++] = 0;
        header[n++] = 16;
        header[n++] = 0;
        os.write(header, 0, n);
        byte[] dataHeader = new byte[8];
        dataHeader[0] = 100;
        dataHeader[1] = 97;
        dataHeader[2] = 116;
        dataHeader[3] = 97;
        long start = System.currentTimeMillis();
        while (true) {
            long now = System.currentTimeMillis();
            while (now < start) {
                Utilities.sleep(1, 0);
                now = System.currentTimeMillis();
            }
            byte[] buffer = Modules.sceAudioModule.audioData;
            if (buffer == null) {
                buffer = silenceBuffer;
            }
            int length = buffer.length;
            dataHeader[4] = (byte)(length & 0xFF);
            dataHeader[5] = (byte)(length >> 8 & 0xFF);
            dataHeader[6] = (byte)(length >> 16 & 0xFF);
            dataHeader[7] = (byte)(length >> 24 & 0xFF);
            os.write(dataHeader);
            os.write(buffer, 0, length);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sendAudioWAV sent %d bytes", length));
            }
            start += (long)(1000 * length / (2 * channels * sampleRate));
        }
    }

    private void sendAudioRAW(OutputStream os) throws IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendAudioRAW", new Object[0]));
        }
        this.sendOK(os);
        this.sendResponseHeader(os, "Content-Type", "audio/raw");
        this.sendEndOfHeaders(os);
        int channels = 2;
        int sampleRate = 44100;
        byte[] silenceBuffer = new byte[1024 * channels * 2];
        long start = System.currentTimeMillis();
        while (true) {
            long now = System.currentTimeMillis();
            while (now < start) {
                Utilities.sleep(1, 0);
                now = System.currentTimeMillis();
            }
            byte[] buffer = Modules.sceAudioModule.audioData;
            if (buffer == null) {
                buffer = silenceBuffer;
            }
            int length = buffer.length;
            os.write(buffer, 0, length);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("sendAudioRAW sent %d bytes", length));
            }
            start += (long)(1000 * length / (2 * channels * sampleRate));
        }
    }

    private BufferedImage getScreenImage(Rectangle rect) {
        if (this.currentDisplayImage != null) {
            return this.currentDisplayImage;
        }
        this.currentDisplayImageHasAlpha = true;
        return this.captureRobot.createScreenCapture(rect);
    }

    private void sendVideoRAW(OutputStream os) throws IOException {
        Rectangle rect = Emulator.getMainGUI().getCaptureRectangle();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Capturing RAW screen from %s", rect));
        }
        this.startDisplayAction();
        try {
            this.sendOK(os);
            this.sendNoCache(os);
            this.sendResponseHeader(os, "Content-Type", "video/raw");
            this.sendEndOfHeaders(os);
            byte[] pixels = new byte[rect.width * rect.height * 3];
            while (true) {
                BufferedImage img = this.getScreenImage(rect);
                int i = 0;
                for (int y = 0; y < img.getHeight(); ++y) {
                    int x = 0;
                    while (x < img.getWidth()) {
                        int color = img.getRGB(x, y);
                        pixels[i + 0] = (byte)(color >> 16 & 0xFF);
                        pixels[i + 1] = (byte)(color >> 8 & 0xFF);
                        pixels[i + 2] = (byte)(color >> 0 & 0xFF);
                        ++x;
                        i += 3;
                    }
                }
                os.write(pixels);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sendVideoRAW sent %dx%d image (%d bytes)", rect.width, rect.height, pixels.length));
                }
                os.flush();
            }
        }
        catch (Throwable throwable) {
            this.stopDisplayAction();
            throw throwable;
        }
    }

    private int storeCompressedPixel(int color, byte[] buffer, int compressedLength, boolean rle, int count) {
        if (!rle) {
            count |= 0x80;
        }
        buffer[compressedLength++] = (byte)count;
        buffer[compressedLength++] = (byte)(color >> 16 & 0xFF);
        buffer[compressedLength++] = (byte)(color >> 8 & 0xFF);
        buffer[compressedLength++] = (byte)(color >> 0 & 0xFF);
        return compressedLength;
    }

    private int compressImage(int width, int height, int[] image, int[] previousImage, byte[] buffer, int compressedLength) {
        int i = 0;
        for (int y = 0; y < height; ++y) {
            int x = 0;
            while (x < width) {
                int count;
                int color = image[i];
                int previousColor = previousImage[i];
                if (++x < width && color == image[++i]) {
                    if (color == previousColor) {
                        int count2;
                        boolean rleFailed = false;
                        boolean previousFailed = false;
                        for (count2 = 0; x < width && count2 < 127; ++x, ++count2) {
                            boolean previousMatch;
                            boolean rleMatch = !rleFailed && image[i] == color;
                            boolean bl = previousMatch = !previousFailed && image[i] == previousImage[i];
                            if (rleMatch) {
                                if (!previousMatch) {
                                    previousFailed = true;
                                }
                            } else {
                                if (!previousMatch) break;
                                rleFailed = true;
                            }
                            ++i;
                        }
                        if (!rleFailed) {
                            compressedLength = this.storeCompressedPixel(color, buffer, compressedLength, true, count2);
                            continue;
                        }
                        if (x < width) {
                            color = image[i++];
                            ++x;
                        } else if (count2 > 0) {
                            color = image[i - 1];
                            --count2;
                        }
                        compressedLength = this.storeCompressedPixel(color, buffer, compressedLength, false, count2);
                        continue;
                    }
                    ++i;
                    ++x;
                    for (count = 1; x < width && color == image[i] && count < 127; ++x, ++count) {
                        ++i;
                    }
                    compressedLength = this.storeCompressedPixel(color, buffer, compressedLength, true, count);
                    continue;
                }
                if (x < width && color == previousColor) {
                    count = 0;
                    while (x < width) {
                        color = image[i];
                        previousColor = previousImage[i];
                        ++i;
                        if (color != previousColor || count >= 127 || ++x >= width) break;
                        ++count;
                    }
                    compressedLength = this.storeCompressedPixel(color, buffer, compressedLength, false, count);
                    continue;
                }
                compressedLength = this.storeCompressedPixel(color, buffer, compressedLength, true, 0);
            }
        }
        return compressedLength;
    }

    private static void write32(byte[] buffer, int offset, int value) {
        buffer[offset + 0] = (byte)(value >> 0 & 0xFF);
        buffer[offset + 1] = (byte)(value >> 8 & 0xFF);
        buffer[offset + 2] = (byte)(value >> 16 & 0xFF);
        buffer[offset + 3] = (byte)(value >> 24 & 0xFF);
    }

    private void sendVideoCompressedRAW(OutputStream os) throws IOException {
        Rectangle rect = Emulator.getMainGUI().getCaptureRectangle();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Capturing compressed RAW screen from %s", rect));
        }
        this.startDisplayAction();
        try {
            this.sendOK(os);
            this.sendNoCache(os);
            this.sendResponseHeader(os, "Content-Type", "video/compressed-raw");
            this.sendEndOfHeaders(os);
            int[] image = new int[]{};
            int[] previousImage = null;
            byte[] buffer = null;
            while (true) {
                BufferedImage img;
                if ((img = this.getScreenImage(rect)) != null) {
                    int height;
                    int width = img.getWidth();
                    int imageSize = width * (height = img.getHeight());
                    if (image.length < imageSize) {
                        image = new int[imageSize];
                        previousImage = new int[imageSize];
                        buffer = new byte[imageSize * 4 + 12];
                    }
                    img.getRGB(0, 0, width, height, image, 0, width);
                    if (this.currentDisplayImageHasAlpha) {
                        int i = 0;
                        while (i < imageSize) {
                            int n = i++;
                            image[n] = image[n] & 0xFFFFFF;
                        }
                    }
                    int compressedLength = this.compressImage(width, height, image, previousImage, buffer, 12);
                    HTTPServer.write32(buffer, 0, compressedLength);
                    HTTPServer.write32(buffer, 4, width);
                    HTTPServer.write32(buffer, 8, height);
                    os.write(buffer, 0, compressedLength);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sendVideoCompressedRAW sent %dx%d image (%d bytes, compression rate %.1f%%)", width, height, compressedLength, Float.valueOf(100.0f * (float)compressedLength / (float)(image.length * 3))));
                    }
                    os.flush();
                    int[] swapImage = image;
                    image = previousImage;
                    previousImage = swapImage;
                    continue;
                }
                Utilities.sleep(10, 0);
            }
        }
        catch (Throwable throwable) {
            this.stopDisplayAction();
            throw throwable;
        }
    }

    private void sendIso(HashMap<String, String> request, OutputStream os, String pathValue, boolean sendContent) throws IOException {
        String isoFileName = pathValue.substring(isoDirectory.length());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendIso '%s'", isoFileName));
        }
        boolean contentSent = false;
        try {
            UmdIsoReader iso = this.getIso(isoFileName);
            if (iso != null) {
                if (sendContent) {
                    String range = request.get("range");
                    if (range != null) {
                        if (range.startsWith("bytes=")) {
                            String rangeValues = range.substring(6);
                            String[] ranges = rangeValues.split("-");
                            if (ranges != null && ranges.length == 2) {
                                long from = Long.parseLong(ranges[0]);
                                long to = Long.parseLong(ranges[1]);
                                if (log.isDebugEnabled()) {
                                    log.debug((Object)String.format("sendIso bytes from=0x%X, to=0x%X, length=0x%X", from, to, to - from + 1L));
                                }
                                this.sendHTTPResponseCode(os, 206);
                                this.sendResponseHeader(os, "Content-Range", String.format("bytes %d-%d", from, to));
                                this.sendEndOfHeaders(os);
                                this.sendIsoContent(os, iso, from, to);
                                contentSent = true;
                            } else {
                                log.warn((Object)String.format("sendIso: unsupported range format '%s'", range));
                            }
                        } else {
                            log.warn((Object)String.format("sendIso: unsupported range format '%s'", range));
                        }
                    }
                } else {
                    this.sendOK(os);
                    long isoLength = (long)iso.getNumSectors() * 2048L;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("sendIso returning content-length=0x%X", isoLength));
                    }
                    this.sendResponseHeader(os, "Content-Length", isoLength);
                    this.sendResponseHeader(os, "Accept-Ranges", "bytes");
                    this.sendEndOfHeaders(os);
                    contentSent = true;
                }
            }
        }
        catch (IOException e) {
            contentSent = false;
        }
        if (!contentSent) {
            this.sendErrorNotFound(os);
        }
    }

    private UmdIsoReader getIso(String isoFileName) throws FileNotFoundException, IOException {
        UmdIsoReader iso = null;
        if (isoFileName.equals(this.previousIsoFilename)) {
            iso = this.previousUmdIsoReader;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Reusing previous UmdIsoReader for '%s'", isoFileName));
            }
        } else {
            if ("umdbuffer.iso".equals(isoFileName)) {
                iso = new UmdIsoReader(null, true);
            } else {
                File[] umdPaths = MainGUI.getUmdPaths(false);
                for (int i = 0; i < umdPaths.length; ++i) {
                    File isoPath = new File(String.format("%s%s%s", umdPaths[i], File.separator, isoFileName));
                    if (!isoPath.exists()) continue;
                    iso = new UmdIsoReader(isoPath.getPath(), false);
                    break;
                }
            }
            if (this.previousUmdIsoReader != null) {
                this.previousUmdIsoReader.close();
            }
            this.previousIsoFilename = isoFileName;
            this.previousUmdIsoReader = iso;
        }
        return iso;
    }

    private void sendIsoContent(OutputStream os, UmdIsoReader iso, long from, long to) throws IOException {
        int startSector = (int)(from / 2048L);
        int endSector = (int)((to + 2048L) / 2048L);
        int numberSectors = endSector - startSector;
        byte[] buffer = new byte[numberSectors * 2048];
        iso.readSectors(startSector, numberSectors, buffer, 0);
        int startSectorOffset = (int)(from - (long)startSector * 2048L);
        int length = (int)(to - from + 1L);
        os.write(buffer, startSectorOffset, length);
    }

    private static Map<String, String> parseParameters(String parameters) {
        String[] nvpairs;
        HashMap<String, String> result = new HashMap<String, String>();
        for (String nvpair : nvpairs = parameters.split("&")) {
            String[] nv = nvpair.split("=", 2);
            if (nv == null || nv.length < 2) continue;
            String name = nv[0];
            String value = HTTPServer.decodePath(nv[1]);
            result.put(name, value);
        }
        return result;
    }

    private void processControls(OutputStream os, String parameters) throws IOException {
        if (parameters != null) {
            Map<String, String> event;
            String type;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("processControls %s", parameters));
            }
            if ("keyup".equals(type = (event = HTTPServer.parseParameters(parameters)).get("type"))) {
                int code = Integer.parseInt(event.get("keyCode"));
                if (code == this.runMapping) {
                    Emulator.getMainGUI().run();
                } else if (code == this.pauseMapping) {
                    Emulator.getMainGUI().pause();
                } else if (code == this.resetMapping) {
                    Emulator.getMainGUI().reset();
                } else if (this.keyMapping.containsKey(code)) {
                    State.controller.keyReleased(this.keyMapping.get(code));
                } else {
                    State.controller.keyReleased(code);
                }
            } else if ("keydown".equals(type)) {
                int code = Integer.parseInt(event.get("keyCode"));
                if (this.keyMapping.containsKey(code)) {
                    State.controller.keyPressed(this.keyMapping.get(code));
                } else {
                    State.controller.keyPressed(code);
                }
            } else if ("run".equals(type)) {
                Emulator.getMainGUI().run();
            } else if ("pause".equals(type)) {
                Emulator.getMainGUI().pause();
            } else if ("reset".equals(type)) {
                Emulator.getMainGUI().reset();
            } else if ("mapping".equals(type)) {
                this.processKeyMapping(event);
            } else {
                log.warn((Object)String.format("processControls unknown type '%s'", type));
            }
        }
        this.sendOK(os);
        this.sendEndOfHeaders(os);
    }

    private void processKeyMapping(Map<String, String> event) {
        for (String key : event.keySet()) {
            String value = event.get(key);
            if (value.length() == 0) continue;
            if ("run".equals(key)) {
                this.runMapping = Integer.parseInt(value);
                continue;
            }
            if ("pause".equals(key)) {
                this.pauseMapping = Integer.parseInt(value);
                continue;
            }
            if ("reset".equals(key)) {
                this.resetMapping = Integer.parseInt(value);
                continue;
            }
            if ("type".equals(key)) continue;
            try {
                Controller.keyCode code = Controller.keyCode.valueOf(key);
                this.keyMapping.put(Integer.parseInt(value), code);
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
    }

    private void sendIcon(OutputStream os, String pathValue) throws IOException {
        this.sendResponseFile(os, "/jpcsp/icons/" + pathValue.substring(iconDirectory.length()));
    }

    private String readInputStream(InputStream is) throws IOException {
        byte[] buffer = new byte[100000];
        int length = is.read(buffer);
        return new String(buffer, 0, length);
    }

    private String readResource(String name) throws IOException {
        InputStream is = this.getClass().getResourceAsStream(name);
        return this.readInputStream(is);
    }

    private String extractTemplateRepeat(String template) {
        int repeat = template.indexOf("$REPEAT");
        int end = template.indexOf("$END");
        if (repeat < 0 || end < 0 || end < repeat) {
            return "";
        }
        return template.substring(repeat + 7, end);
    }

    private String replaceTemplate(String template, String name, String value) {
        return template.replace(name, value);
    }

    private String replaceTemplateRepeat(String template, String value) {
        int repeat = template.indexOf("$REPEAT");
        int end = template.indexOf("$END");
        if (repeat < 0 || end < 0 || end < repeat) {
            return template;
        }
        return template.substring(0, repeat) + value + template.substring(end + 4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] getWidgetList() throws IOException {
        LinkedList<String> list = new LinkedList<String>();
        try (BufferedReader dir = null;){
            String entry;
            dir = new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(widgetPath)));
            while ((entry = dir.readLine()) != null) {
                list.add(entry);
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private InputStream getFileFromZip(String zipFileName, String fileName) throws IOException {
        InputStream zipInput;
        if (File.separatorChar != '/') {
            fileName = fileName.replace('/', File.separatorChar);
        }
        if ((zipInput = this.getClass().getResourceAsStream(zipFileName)) != null) {
            ZipEntry entry;
            ZipInputStream zipContent = new ZipInputStream(zipInput);
            while ((entry = zipContent.getNextEntry()) != null) {
                if (!fileName.equalsIgnoreCase(entry.getName())) continue;
                return zipContent;
            }
        }
        return null;
    }

    private void sendNaClResponse(OutputStream os, String pathValue) throws IOException {
        int sepIndex = pathValue.indexOf("/");
        if (sepIndex < 0) {
            if (pathValue.isEmpty() || indexFile.equals(pathValue)) {
                String template = this.readResource("root/nacl/index.html");
                String repeat = this.extractTemplateRepeat(template);
                StringBuilder lines = new StringBuilder();
                for (String widget : this.getWidgetList()) {
                    lines.append(this.replaceTemplate(repeat, "$NAME", widget.replace(".zip", "")));
                }
                String html = this.replaceTemplateRepeat(template, lines.toString());
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sendNaClResponse returning:\n%s", html));
                }
                this.sendResponseFile(os, new ByteArrayInputStream(html.getBytes()), HTTPServer.guessMimeType(indexFile));
            } else {
                this.sendRedirect(os, pathValue + "/" + indexFile);
            }
            return;
        }
        String zipFileName = pathValue.substring(0, sepIndex);
        String resourceFileName = pathValue.substring(sepIndex + 1);
        if (resourceFileName.startsWith("$MANAGER_WIDGET/")) {
            this.sendResponseFile(os, "root/" + resourceFileName.substring(1));
        } else {
            InputStream zipContent = this.getFileFromZip(zipFileName = String.format("%s/%s.zip", widgetPath, zipFileName), resourceFileName);
            if (zipContent != null) {
                this.sendResponseFile(os, zipContent, HTTPServer.guessMimeType(resourceFileName));
            } else {
                this.sendError(os, 404);
            }
        }
    }

    private void startDisplayAction() {
        ++this.displayActionUsageCount;
        if (this.displayAction == null) {
            this.displayAction = new DisplayAction();
            Modules.sceDisplayModule.addDisplayAction(this.displayAction);
        }
    }

    private void stopDisplayAction() {
        --this.displayActionUsageCount;
        if (this.displayAction != null && this.displayActionUsageCount <= 0) {
            Modules.sceDisplayModule.removeDisplayAction(this.displayAction);
            this.displayAction = null;
        }
    }

    private static String getBaseUrl(HTTPServerDescriptor descriptor, HashMap<String, String> request, int forcedPort) {
        String hostName = request.get(host);
        int port = forcedPort > 0 ? forcedPort : descriptor.getPort();
        String protocol = request.get("x-forwarded-proto");
        if (protocol == null) {
            protocol = forcedPort > 0 ? (forcedPort == 443 ? "https" : "http") : (descriptor.isSsl() ? "https" : "http");
        }
        StringBuilder baseUrl = new StringBuilder();
        baseUrl.append(protocol);
        baseUrl.append("://");
        baseUrl.append(hostName);
        if (port != Utilities.getDefaultPortForProtocol(protocol)) {
            baseUrl.append(":");
            baseUrl.append(port);
        }
        baseUrl.append("/");
        return baseUrl.toString();
    }

    private static String getUrl(HTTPServerDescriptor descriptor, HashMap<String, String> request, String pathValue, int forcedPort) {
        if (pathValue.startsWith("https://") || pathValue.startsWith("http://")) {
            int endOfPath = pathValue.indexOf("/", 8);
            pathValue = endOfPath >= 0 ? pathValue.substring(endOfPath) : "";
        }
        String baseUrl = HTTPServer.getBaseUrl(descriptor, request, forcedPort);
        String query = "";
        if (request.containsKey(parameters)) {
            query = "?" + request.get(parameters);
        }
        if (pathValue == null) {
            return baseUrl + query;
        }
        if (pathValue.startsWith("/")) {
            pathValue = pathValue.substring(1);
        }
        return baseUrl + pathValue + query;
    }

    private static String getArchitecture(HashMap<String, String> request) {
        String architecture = null;
        String userAgent = request.get("user-agent");
        if (userAgent != null && userAgent.indexOf("SmartTV") > 0) {
            architecture = Integer.toString(40);
        }
        return architecture;
    }

    private void sendWidgetlist(HTTPServerDescriptor descriptor, HashMap<String, String> request, OutputStream os, String pathValue) throws IOException {
        String template = this.readResource("root/widgetlist.xml.template");
        String repeat = this.extractTemplateRepeat(template);
        String architecture = HTTPServer.getArchitecture(request);
        String architectureParam = "";
        if (architecture != null) {
            architectureParam = "?architecture=" + architecture;
        }
        StringBuilder list = new StringBuilder();
        Pattern pattern = Pattern.compile("<widgetname(\\s+itemtype=\"string\")?>(.*)</widgetname>", 10);
        for (String widget : this.getWidgetList()) {
            String xml;
            Matcher matcher;
            String zipFileName = String.format("%s/%s", widgetPath, widget);
            InputStream configXml = this.getFileFromZip(zipFileName, "config.xml");
            if (configXml == null || !(matcher = pattern.matcher(xml = this.readInputStream(configXml))).find()) continue;
            String widgetName = matcher.group(2);
            String downloadUrl = String.format("%s%s/%s%s", HTTPServer.getBaseUrl(descriptor, request, 0), widgetDirectory, widget, architectureParam);
            String entry = this.replaceTemplate(repeat, "$WIDGETNAME", widgetName);
            entry = this.replaceTemplate(entry, "$DOWNLOADURL", downloadUrl);
            list.append(entry);
        }
        String xml = this.replaceTemplateRepeat(template, list.toString());
        this.sendResponseFile(os, new ByteArrayInputStream(xml.getBytes()), HTTPServer.guessMimeType(pathValue));
    }

    private boolean isMatchingELFArchitecture(byte[] header, int length, int machineArchitecture) throws IOException {
        ByteBuffer byteBuffer = ByteBuffer.wrap(header, 0, length);
        Elf32Header elfHeader = new Elf32Header(byteBuffer);
        return elfHeader.isValid() && elfHeader.getE_machine() == machineArchitecture;
    }

    private void sendWidget(OutputStream os, String parameters, String pathValue) throws IOException {
        String architecture = null;
        if (parameters != null) {
            Map<String, String> map = HTTPServer.parseParameters(parameters);
            architecture = map.get("architecture");
        }
        if (architecture == null) {
            this.sendResponseFile(os, pathValue);
        } else {
            ZipEntry entry;
            int machineArchitecture = Integer.parseInt(architecture);
            ZipInputStream zin = new ZipInputStream(this.getClass().getResourceAsStream(pathValue));
            ByteArrayOutputStream out = new ByteArrayOutputStream(1000000);
            ZipOutputStream zout = new ZipOutputStream(out);
            byte[] buffer = new byte[100000];
            byte[] header = new byte[64];
            while ((entry = zin.getNextEntry()) != null) {
                int length = 0;
                boolean doCopy = true;
                if (entry.getName().endsWith(".nexe") && !this.isMatchingELFArchitecture(header, length = zin.read(header), machineArchitecture)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Skipping the Widget entry '%s' because it is not matching the architecture 0x%X", entry.getName(), machineArchitecture));
                    }
                    doCopy = false;
                }
                if (!doCopy) continue;
                zout.putNextEntry(entry);
                zout.write(header, 0, length);
                while ((length = zin.read(buffer)) > 0) {
                    zout.write(buffer, 0, length);
                }
            }
            zin.close();
            zout.close();
            this.sendResponseFile(os, new ByteArrayInputStream(out.toByteArray()), HTTPServer.guessMimeType(pathValue));
        }
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public int getProxyAddress() {
        return this.proxyAddress;
    }

    public void sendNpNavAuth(String data, OutputStream os) throws IOException {
        Map<String, String> parameters = HTTPServer.parseParameters(data);
        SceNpTicket ticket = new SceNpTicket();
        ticket.version = 289;
        ticket.size = 240;
        ticket.unknown = 12288;
        ticket.sizeParams = 164;
        sceNpAuth.addTicketParam(ticket, "XXXXXXXXXXXXXXXXXXXX", 20);
        sceNpAuth.addTicketParam(ticket, 0);
        long now = System.currentTimeMillis();
        sceNpAuth.addTicketDateParam(ticket, now);
        sceNpAuth.addTicketDateParam(ticket, now + 600000L);
        sceNpAuth.addTicketLongParam(ticket, 0L);
        sceNpAuth.addTicketParam(ticket, 4, "DummyOnlineID", 32);
        sceNpAuth.addTicketParam(ticket, "gb", 4);
        sceNpAuth.addTicketParam(ticket, 4, "XX", 4);
        sceNpAuth.addTicketParam(ticket, parameters.get("serviceid"), 24);
        int status = 0;
        if (Modules.sceNpModule.parentalControl == 1) {
            status |= 0x200;
        }
        sceNpAuth.addTicketParam(ticket, status |= (Modules.sceNpModule.getUserAge() & 0x7F) << 24);
        sceNpAuth.addTicketParam(ticket);
        sceNpAuth.addTicketParam(ticket);
        ticket.unknownBytes = new byte[72];
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sendNpNavAuth returning dummy ticket: %s", ticket));
        }
        byte[] response = ticket.toByteArray();
        this.sendOK(os);
        this.sendResponseHeader(os, "X-I-5-Status", "OK");
        this.sendResponseHeader(os, "X-I-5-Version", "2.1");
        this.sendResponseHeader(os, "Content-Length", response.length);
        this.sendResponseHeader(os, "Content-Type", "application/x-i-5-ticket");
        this.sendEndOfHeaders(os);
        os.write(response);
    }

    public void sendNpGetSelfProfile(String data, OutputStream os) throws IOException {
        String xml = "<profile result=\"00\">";
        xml = xml + "<jid>DummyOnlineID@a8.gb.np.playstation.net</jid>";
        xml = xml + "<onlinename upd=\"0\">DummyOnlineID</onlinename>";
        xml = xml + "<country>gb</country>";
        xml = xml + "<language1>1</language1>";
        xml = xml + "<language2 />";
        xml = xml + "<language3 />";
        xml = xml + "<aboutme />";
        xml = xml + "<avatarurl id=\"0\">http://static-resource.np.community.playstation.net/avatar_s/default/DefaultAvatar_s.png</avatarurl>";
        xml = xml + "<ptlp>0</ptlp>";
        xml = xml + "</profile>";
        byte[] response = xml.getBytes();
        this.sendOK(os);
        this.sendResponseHeader(os, "Content-Length", response.length);
        this.sendResponseHeader(os, "Content-Type", "text/xml;charset=UTF-8");
        this.sendEndOfHeaders(os);
        os.write(response);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Response: %s", xml));
        }
    }

    public void sendCapM(String data, OutputStream os) throws IOException {
        int responseLength = 4240;
        byte[] response = new byte[responseLength];
        if (this.ticket != null) {
            SceNpTicket.TicketParam ticketParam = this.ticket.parameters.get(4);
            for (int i = 0; i < 8; ++i) {
                response[i + 80] = ticketParam.getBytesValue()[7 - i];
            }
        }
        this.sendOK(os);
        this.sendResponseHeader(os, "X-I-5-DRM-Version", "1.0");
        this.sendResponseHeader(os, "X-I-5-DRM-Status", "OK; max_console=1; current_console=0");
        this.sendResponseHeader(os, "Content-Length", responseLength);
        this.sendResponseHeader(os, "Content-Type", "application/x-i-5-drm");
        this.sendEndOfHeaders(os);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Response:%s", Utilities.getMemoryDump(response, 0, responseLength)));
        }
        os.write(response, 0, responseLength);
    }

    public void sendKdpM(String data, OutputStream os) throws IOException {
        Map<String, String> parameters = HTTPServer.parseParameters(data);
        String productId = parameters.get("productid");
        int responseLength = 4240;
        byte[] response = new byte[responseLength];
        if (productId != null) {
            ByteBuffer buffer = ByteBuffer.wrap(response);
            buffer.position(16);
            Utilities.writeStringZ(buffer, productId);
        }
        if (this.ticket != null) {
            SceNpTicket.TicketParam ticketParam = this.ticket.parameters.get(4);
            for (int i = 0; i < 8; ++i) {
                response[i + 80] = ticketParam.getBytesValue()[7 - i];
            }
        }
        this.sendOK(os);
        this.sendResponseHeader(os, "X-I-5-DRM-Version", "1.0");
        this.sendResponseHeader(os, "X-I-5-DRM-Status", "OK");
        this.sendResponseHeader(os, "Content-Length", responseLength);
        this.sendResponseHeader(os, "Content-Type", "application/x-i-5-drm");
        this.sendEndOfHeaders(os);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Response:%s", Utilities.getMemoryDump(response, 0, responseLength)));
        }
        os.write(response, 0, responseLength);
    }

    public void sendVideoStore(OutputStream os) throws IOException {
        byte[] response = new byte[]{51};
        int responseLength = response.length;
        this.sendOK(os);
        this.sendResponseHeader(os, "Content-Length", responseLength);
        this.sendEndOfHeaders(os);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Response:%s", Utilities.getMemoryDump(response, 0, responseLength)));
        }
        os.write(response, 0, responseLength);
    }

    static {
        serverDescriptors = new HTTPServerDescriptor[]{new HTTPServerDescriptor(0, 80, false), new HTTPServerDescriptor(1, 443, true)};
        processProxyRequestLocally = false;
    }

    private class DisplayAction
    implements IAction {
        private DisplayAction() {
        }

        @Override
        public void execute() {
            HTTPServer.this.currentDisplayImage = Modules.sceDisplayModule.getCurrentDisplayAsBufferedImage(false);
            HTTPServer.this.currentDisplayImageHasAlpha = false;
        }
    }

    private class HTTPSocketHandlerThread
    extends Thread {
        private HTTPServerDescriptor descriptor;
        private Socket socket;

        public HTTPSocketHandlerThread(HTTPServerDescriptor descriptor, Socket socket) {
            this.descriptor = descriptor;
            this.socket = socket;
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            HTTPServer.this.process(this.descriptor, this.socket);
        }
    }

    private class HTTPServerThread
    extends Thread {
        private boolean exit;
        private ServerSocket serverSocket;
        private HTTPServerDescriptor descriptor;

        public HTTPServerThread(HTTPServerDescriptor descriptor) {
            this.descriptor = descriptor;
        }

        @Override
        public void run() {
            RuntimeContext.setLog4jMDC();
            try {
                if (this.descriptor.isSsl()) {
                    SSLServerSocketFactory factory = this.getSSLServerSocketFactory();
                    if (factory != null) {
                        this.serverSocket = factory.createServerSocket(this.descriptor.getPort());
                    }
                } else {
                    this.serverSocket = new ServerSocket(this.descriptor.getPort(), 50, Wlan.getLocalInetAddress());
                }
                if (this.serverSocket != null) {
                    this.serverSocket.setSoTimeout(1);
                }
            }
            catch (IOException e) {
                log.error((Object)String.format("Server socket at port %d not available: %s", this.descriptor.getPort(), e));
            }
            catch (KeyStoreException e) {
                log.error((Object)String.format("SSL Server socket at port %d not available: %s", this.descriptor.getPort(), e));
            }
            catch (NoSuchAlgorithmException e) {
                log.error((Object)String.format("SSL Server socket at port %d not available: %s", this.descriptor.getPort(), e));
            }
            catch (CertificateException e) {
                log.error((Object)String.format("SSL Server socket at port %d not available: %s", this.descriptor.getPort(), e));
            }
            catch (UnrecoverableKeyException e) {
                log.error((Object)String.format("SSL Server socket at port %d not available: %s", this.descriptor.getPort(), e));
            }
            catch (KeyManagementException e) {
                log.error((Object)String.format("SSL Server socket at port %d not available: %s", this.descriptor.getPort(), e));
            }
            if (this.serverSocket == null) {
                this.exit();
            }
            while (!this.exit) {
                try {
                    Socket socket = this.serverSocket.accept();
                    socket.setSoTimeout(1);
                    HTTPSocketHandlerThread handlerThread = new HTTPSocketHandlerThread(this.descriptor, socket);
                    handlerThread.setName(String.format("HTTP Handler %d/%d", this.descriptor.getPort(), socket.getPort()));
                    handlerThread.setDaemon(true);
                    handlerThread.start();
                }
                catch (SocketTimeoutException socket) {
                }
                catch (IOException e) {
                    log.debug((Object)"Accept server socket", (Throwable)e);
                }
                Utilities.sleep(10);
            }
            if (this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ((HTTPServer)HTTPServer.this).serverThreads[this.descriptor.getIndex()] = null;
        }

        private SSLServerSocketFactory getSSLServerSocketFactory() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException, UnrecoverableKeyException, KeyManagementException {
            String jksFileName = "jpcsp.jks";
            if (!new File(jksFileName).canRead()) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("getSSLServerSocketFactory cannot read the file '%s'", jksFileName));
                }
                return null;
            }
            char[] password = "changeit".toCharArray();
            FileInputStream keyStoreInputStream = new FileInputStream(jksFileName);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            keyStore.load(keyStoreInputStream, password);
            String defaultAlgorithm = KeyManagerFactory.getDefaultAlgorithm();
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(defaultAlgorithm);
            keyManagerFactory.init(keyStore, password);
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(keyManagerFactory.getKeyManagers(), null, null);
            return sslContext.getServerSocketFactory();
        }

        public void exit() {
            this.exit = true;
        }
    }

    private static class HTTPServerDescriptor {
        private int index;
        private int port;
        private boolean ssl;

        public HTTPServerDescriptor(int index, int port, boolean ssl) {
            this.index = index;
            this.port = port;
            this.ssl = ssl;
        }

        public int getIndex() {
            return this.index;
        }

        public int getPort() {
            return this.port;
        }

        public boolean isSsl() {
            return this.ssl;
        }
    }
}

