/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.HashMap;
import java.util.List;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.CheckArgument;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.types.pspNetMacAddress;
import jpcsp.HLE.modules.sceNetAdhocctl;
import jpcsp.Processor;
import jpcsp.network.INetworkAdapter;
import jpcsp.network.adhoc.MatchingObject;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceNetAdhocMatching
extends HLEModule {
    public static Logger log = Modules.getLogger("sceNetAdhocMatching");
    protected HashMap<Integer, MatchingObject> matchingObjects;
    public static final int loopThreadRegisterArgument = 16;
    private boolean isInitialized;
    public int NET_ADHOC_MATCHING_EVENT_LOOP_ADDRESS;
    public int NET_ADHOC_MATCHING_INPUT_LOOP_ADDRESS;
    public static final int PSP_ADHOC_MATCHING_EVENT_HELLO = 1;
    public static final int PSP_ADHOC_MATCHING_EVENT_JOIN = 2;
    public static final int PSP_ADHOC_MATCHING_EVENT_LEFT = 3;
    public static final int PSP_ADHOC_MATCHING_EVENT_REJECT = 4;
    public static final int PSP_ADHOC_MATCHING_EVENT_CANCEL = 5;
    public static final int PSP_ADHOC_MATCHING_EVENT_ACCEPT = 6;
    public static final int PSP_ADHOC_MATCHING_EVENT_COMPLETE = 7;
    public static final int PSP_ADHOC_MATCHING_EVENT_TIMEOUT = 8;
    public static final int PSP_ADHOC_MATCHING_EVENT_ERROR = 9;
    public static final int PSP_ADHOC_MATCHING_EVENT_DISCONNECT = 10;
    public static final int PSP_ADHOC_MATCHING_EVENT_DATA = 11;
    public static final int PSP_ADHOC_MATCHING_EVENT_DATA_CONFIRM = 12;
    public static final int PSP_ADHOC_MATCHING_EVENT_DATA_TIMEOUT = 13;
    public static final int PSP_ADHOC_MATCHING_EVENT_INTERNAL_FIRST = 100;
    public static final int PSP_ADHOC_MATCHING_EVENT_INTERNAL_PING = 100;
    public static final int PSP_ADHOC_MATCHING_EVENT_INTERNAL_BIRTH = 101;
    public static final int PSP_ADHOC_MATCHING_MODE_HOST = 1;
    public static final int PSP_ADHOC_MATCHING_MODE_CLIENT = 2;
    public static final int PSP_ADHOC_MATCHING_MODE_PTP = 3;

    @Override
    public void start() {
        this.matchingObjects = new HashMap();
        this.isInitialized = false;
        this.NET_ADHOC_MATCHING_EVENT_LOOP_ADDRESS = HLEUtilities.getInstance().installLoopHandler(this, "hleNetAdhocMatchingEventThread");
        this.NET_ADHOC_MATCHING_INPUT_LOOP_ADDRESS = HLEUtilities.getInstance().installLoopHandler(this, "hleNetAdhocMatchingInputThread");
        super.start();
    }

    protected INetworkAdapter getNetworkAdapter() {
        return Modules.sceNetModule.getNetworkAdapter();
    }

    public int checkMatchingId(int matchingId) {
        this.checkInitialized();
        if (!this.matchingObjects.containsKey(matchingId)) {
            throw new SceKernelErrorException(-2143221753);
        }
        return matchingId;
    }

    @HLEFunction(nid=-1, version=150)
    public void hleNetAdhocMatchingEventThread(Processor processor) {
        MatchingObject matchingObject;
        int matchingId = processor.cpu.getRegister(16);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleNetAdhocMatchingEventThread matchingId=%d", matchingId));
        }
        if ((matchingObject = this.matchingObjects.get(matchingId)) != null && matchingObject.eventLoop()) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(10000, false);
        } else {
            processor.cpu._v0 = 0;
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
        }
    }

    @HLEFunction(nid=-1, version=150)
    public void hleNetAdhocMatchingInputThread(Processor processor) {
        MatchingObject matchingObject;
        int matchingId = processor.cpu.getRegister(16);
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("hleNetAdhocMatchingInputThread matchingId=%d", matchingId));
        }
        if ((matchingObject = this.matchingObjects.get(matchingId)) != null && matchingObject.inputLoop()) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(10000, false);
        } else {
            processor.cpu._v0 = 0;
            Modules.ThreadManForUserModule.hleKernelExitDeleteThread();
        }
    }

    private static String getModeName(int mode) {
        switch (mode) {
            case 1: {
                return "HOST";
            }
            case 2: {
                return "CLIENT";
            }
            case 3: {
                return "PTP";
            }
        }
        return String.format("Unknown mode %d", mode);
    }

    protected void checkInitialized() {
        if (!this.isInitialized) {
            throw new SceKernelErrorException(-2143221741);
        }
    }

    @HLEFunction(nid=707403271, version=150)
    public int sceNetAdhocMatchingInit(int memsize) {
        if (this.isInitialized) {
            return -2143221742;
        }
        this.isInitialized = true;
        return 0;
    }

    @HLEFunction(nid=2034625754, version=150)
    public int sceNetAdhocMatchingTerm() {
        this.isInitialized = false;
        return 0;
    }

    @HLEFunction(nid=-899753361, version=150)
    public int sceNetAdhocMatchingCreate(int mode, int maxPeers, int port, int bufSize, int helloDelay, int pingDelay, int initCount, int msgDelay, @CanBeNull TPointer callback) {
        this.checkInitialized();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocMatchingCreate mode=%s", sceNetAdhocMatching.getModeName(mode)));
        }
        MatchingObject matchingObject = this.getNetworkAdapter().createMatchingObject();
        matchingObject.setMode(mode);
        matchingObject.setMaxPeers(maxPeers);
        matchingObject.setPort(port);
        matchingObject.setBufSize(bufSize);
        matchingObject.setHelloDelay(helloDelay);
        matchingObject.setPingDelay(pingDelay);
        matchingObject.setInitCount(initCount);
        matchingObject.setMsgDelay(msgDelay);
        matchingObject.setCallback(callback.getAddress());
        matchingObject.create();
        this.matchingObjects.put(matchingObject.getId(), matchingObject);
        return matchingObject.getId();
    }

    @HLEFunction(nid=-1813039037, version=150)
    public int sceNetAdhocMatchingStart(@CheckArgument(value="checkMatchingId") int matchingId, int evthPri, int evthStack, int inthPri, int inthStack, int optLen, @CanBeNull TPointer optData) {
        if (log.isTraceEnabled() && optData.isNotNull()) {
            log.trace((Object)String.format("Matching opt data: %s", Utilities.getMemoryDump(optData, optLen)));
        }
        return this.matchingObjects.get(matchingId).start(evthPri, 2, evthStack, inthPri, 2, inthStack, optLen, optData.getAddress());
    }

    @HLEFunction(nid=-398111643, version=150)
    public int sceNetAdhocMatchingStart2(@CheckArgument(value="checkMatchingId") int matchingId, int evthPri, int evthPartitionId, int evthStack, int inthPri, int inthPartitionId, int inthStack, int optLen, @CanBeNull TPointer optData) {
        if (log.isTraceEnabled() && optData.isNotNull()) {
            log.trace((Object)String.format("Matching opt data: %s", Utilities.getMemoryDump(optData, optLen)));
        }
        return this.matchingObjects.get(matchingId).start(evthPri, evthPartitionId, evthStack, inthPri, inthPartitionId, inthStack, optLen, optData.getAddress());
    }

    @HLEFunction(nid=850482867, version=150)
    public int sceNetAdhocMatchingStop(@CheckArgument(value="checkMatchingId") int matchingId) {
        return this.matchingObjects.get(matchingId).stop();
    }

    @HLEFunction(nid=-244404401, version=150)
    public int sceNetAdhocMatchingDelete(@CheckArgument(value="checkMatchingId") int matchingId) {
        this.matchingObjects.remove(matchingId).delete();
        return 0;
    }

    @HLEFunction(nid=-141266217, version=150)
    public int sceNetAdhocMatchingSendData(@CheckArgument(value="checkMatchingId") int matchingId, pspNetMacAddress macAddress, int dataLen, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.in) TPointer data) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Send data: %s", Utilities.getMemoryDump(data.getAddress(), dataLen)));
        }
        return this.matchingObjects.get(matchingId).send(macAddress, dataLen, data.getAddress());
    }

    @HLEUnimplemented
    @HLEFunction(nid=-333892739, version=150)
    public int sceNetAdhocMatchingAbortSendData(@CheckArgument(value="checkMatchingId") int matchingId, pspNetMacAddress macAddress) {
        return 0;
    }

    @HLEFunction(nid=1581075321, version=150)
    public int sceNetAdhocMatchingSelectTarget(@CheckArgument(value="checkMatchingId") int matchingId, pspNetMacAddress macAddress, int optLen, @CanBeNull TPointer optData) {
        return this.matchingObjects.get(matchingId).selectTarget(macAddress, optLen, optData.getAddress());
    }

    @HLEFunction(nid=-365141752, version=150)
    public int sceNetAdhocMatchingCancelTarget(@CheckArgument(value="checkMatchingId") int matchingId, pspNetMacAddress macAddress) {
        return this.matchingObjects.get(matchingId).cancelTarget(macAddress);
    }

    @HLEFunction(nid=-1890009377, version=150)
    public int sceNetAdhocMatchingCancelTargetWithOpt(@CheckArgument(value="checkMatchingId") int matchingId, pspNetMacAddress macAddress, int optLen, @CanBeNull TPointer optData) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Opt data: %s", Utilities.getMemoryDump(optData.getAddress(), optLen)));
        }
        return this.matchingObjects.get(matchingId).cancelTarget(macAddress, optLen, optData.getAddress());
    }

    @HLEFunction(nid=-1244042198, version=150)
    public int sceNetAdhocMatchingGetHelloOpt(@CheckArgument(value="checkMatchingId") int matchingId, TPointer32 optLenAddr, @CanBeNull TPointer optData) {
        MatchingObject matchingObject = this.matchingObjects.get(matchingId);
        int helloOptLen = matchingObject.getHelloOptLen();
        int bufSize = optLenAddr.getValue();
        optLenAddr.setValue(helloOptLen);
        if (helloOptLen > 0 && optData.getAddress() != 0 && bufSize > 0) {
            int length = Math.min(bufSize, helloOptLen);
            Utilities.writeBytes(optData.getAddress(), length, matchingObject.getHelloOptData(), 0);
        }
        return 0;
    }

    @HLEFunction(nid=-1248960073, version=150)
    public int sceNetAdhocMatchingSetHelloOpt(@CheckArgument(value="checkMatchingId") int matchingId, int optLen, @CanBeNull TPointer optData) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Hello opt data: %s", Utilities.getMemoryDump(optData.getAddress(), optLen)));
        }
        this.matchingObjects.get(matchingId).setHelloOpt(optLen, optData.getAddress());
        return 0;
    }

    @HLEFunction(nid=-980693602, version=150)
    public int sceNetAdhocMatchingGetMembers(@CheckArgument(value="checkMatchingId") int matchingId, @BufferInfo(usage=BufferInfo.Usage.inout) TPointer32 sizeAddr, @CanBeNull @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=36, usage=BufferInfo.Usage.out) TPointer buf) {
        int matchingMemberSize = 12;
        MatchingObject matchingObject = this.matchingObjects.get(matchingId);
        List<pspNetMacAddress> members = matchingObject.getMembers();
        int size = sizeAddr.getValue();
        sizeAddr.setValue(12 * members.size());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceNetAdhocMatchingGetMembers returning size=%d", sizeAddr.getValue()));
        }
        if (buf.isNotNull()) {
            int offset = 0;
            for (pspNetMacAddress member : members) {
                if (offset + 12 > size || member == null) break;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceNetAdhocMatchingGetMembers returning %s at 0x%08X", member, buf.getAddress() + offset));
                }
                member.write(buf, offset += 4);
                buf.setValue16(offset += member.sizeof(), (short)0);
                offset += 2;
            }
            sceNetAdhocctl.fillNextPointersInLinkedList(buf, offset, 12);
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1671627907, version=150)
    public int sceNetAdhocMatchingGetPoolStat() {
        this.checkInitialized();
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1090057269, version=150)
    public int sceNetAdhocMatchingGetPoolMaxAlloc() {
        this.checkInitialized();
        return 0;
    }
}

