/*
 * Decompiled with CFR 0.152.
 */
package com.jidesoft.plaf.basic;

import com.jidesoft.plaf.UIDefaultsLookup;
import com.jidesoft.swing.RangeSlider;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JSlider;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicSliderUI;

public class BasicRangeSliderUI
extends BasicSliderUI {
    protected Icon _lowerIcon;
    protected Icon _upperIcon;
    protected Icon _middleIcon;
    protected Icon _lowerIconV;
    protected Icon _upperIconV;
    protected Icon _middleIconV;
    protected static final int MOUSE_HANDLE_NONE = 0;
    protected static final int MOUSE_HANDLE_MIN = 1;
    protected static final int MOUSE_HANDLE_MAX = 2;
    protected static final int MOUSE_HANDLE_MIDDLE = 4;

    public BasicRangeSliderUI(JSlider jSlider) {
        super(jSlider);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRangeSliderUI((JSlider)jComponent);
    }

    protected void installDefaults(JSlider jSlider) {
        super.installDefaults(jSlider);
        this.resetAllIcons();
    }

    protected void resetAllIcons() {
        this._lowerIcon = UIDefaultsLookup.getIcon("RangeSlider.lowerIcon");
        this._upperIcon = UIDefaultsLookup.getIcon("RangeSlider.upperIcon");
        this._middleIcon = UIDefaultsLookup.getIcon("RangeSlider.middleIcon");
        this._lowerIconV = UIDefaultsLookup.getIcon("RangeSlider.lowerVIcon");
        this._upperIconV = UIDefaultsLookup.getIcon("RangeSlider.upperVIcon");
        this._middleIconV = UIDefaultsLookup.getIcon("RangeSlider.middleVIcon");
    }

    public void uninstallUI(JComponent jComponent) {
        super.uninstallUI(jComponent);
        this._lowerIcon = null;
        this._upperIcon = null;
        this._middleIcon = null;
        this._lowerIconV = null;
        this._upperIconV = null;
        this._middleIconV = null;
    }

    protected void calculateTrackRect() {
        super.calculateTrackRect();
        if (this.slider.getOrientation() == 1) {
            this.trackRect.x += 4;
        } else {
            this.trackRect.y += 4;
        }
    }

    protected BasicSliderUI.TrackListener createTrackListener(JSlider jSlider) {
        return new RangeTrackListener();
    }

    private void offset(int n) {
        this.slider.getModel().setValue(((RangeSlider)this.slider).getLowValue() + n);
    }

    protected int getMouseHandle(int n, int n2) {
        Rectangle rectangle = this.trackRect;
        if (this.slider.getOrientation() == 1) {
            int n3 = this.yPositionForValue(((RangeSlider)this.slider).getLowValue());
            int n4 = this.yPositionForValue(((RangeSlider)this.slider).getHighValue());
            Rectangle rectangle2 = new Rectangle(rectangle.x + rectangle.width / 2, n3 - this._lowerIconV.getIconHeight() / 2, this._lowerIcon.getIconWidth(), this._lowerIconV.getIconHeight());
            if (rectangle2.contains(n, n2)) {
                return 1;
            }
            Rectangle rectangle3 = new Rectangle(rectangle.x, n4 - this._upperIconV.getIconHeight() / 2, this._upperIconV.getIconWidth(), this._upperIconV.getIconHeight());
            if (rectangle3.contains(n, n2)) {
                return 2;
            }
            Rectangle rectangle4 = new Rectangle(rectangle.x - this._middleIcon.getIconWidth(), n4 - this._middleIconV.getIconHeight() / 2, this._middleIconV.getIconWidth(), this._middleIconV.getIconHeight());
            if (rectangle4.contains(n, n2)) {
                return 4;
            }
            return 0;
        }
        int n5 = this.xPositionForValue(((RangeSlider)this.slider).getLowValue());
        int n6 = this.xPositionForValue(((RangeSlider)this.slider).getHighValue());
        Rectangle rectangle5 = new Rectangle(n5 - this._lowerIcon.getIconWidth() / 2, rectangle.y + rectangle.height / 2, this._lowerIcon.getIconWidth(), this._lowerIcon.getIconHeight());
        if (rectangle5.contains(n, n2)) {
            return 1;
        }
        Rectangle rectangle6 = new Rectangle(n6 - this._upperIcon.getIconWidth() / 2, rectangle.y, this._upperIcon.getIconWidth(), this._upperIcon.getIconHeight());
        if (rectangle6.contains(n, n2)) {
            return 2;
        }
        Rectangle rectangle7 = new Rectangle(n6 - this._middleIcon.getIconWidth() / 2, rectangle.y - this._middleIcon.getIconHeight(), this._middleIcon.getIconWidth(), this._middleIcon.getIconHeight());
        if (rectangle7.contains(n, n2)) {
            return 4;
        }
        return 0;
    }

    public void paintThumb(Graphics graphics) {
        Rectangle rectangle = this.trackRect;
        RangeSlider rangeSlider = (RangeSlider)this.slider;
        if (this.slider.getOrientation() == 1) {
            int n = this.yPositionForValue(rangeSlider.getLowValue());
            int n2 = this.yPositionForValue(rangeSlider.getHighValue());
            this._lowerIconV.paintIcon(this.slider, graphics, rectangle.x + rectangle.width / 2, n - this._lowerIconV.getIconHeight() / 2);
            this._upperIconV.paintIcon(this.slider, graphics, rectangle.x, n2 - this._upperIconV.getIconHeight() / 2);
            this._middleIconV.paintIcon(this.slider, graphics, rectangle.x - this._middleIconV.getIconWidth(), n2 - this._middleIconV.getIconHeight() / 2);
        } else {
            int n = this.xPositionForValue(rangeSlider.getLowValue());
            int n3 = this.xPositionForValue(rangeSlider.getHighValue());
            this._lowerIcon.paintIcon(this.slider, graphics, n - this._lowerIcon.getIconWidth() / 2, rectangle.y + rectangle.height / 2);
            this._upperIcon.paintIcon(this.slider, graphics, n3 - this._upperIcon.getIconWidth() / 2, rectangle.y);
            this._middleIcon.paintIcon(this.slider, graphics, n3 - this._middleIcon.getIconWidth() / 2, rectangle.y - this._middleIcon.getIconHeight());
        }
    }

    protected void setMouseRollover(int n) {
        this.resetAllIcons();
        switch (n) {
            case 1: {
                Icon icon = UIDefaultsLookup.getIcon("RangeSlider.lowerRIcon");
                if (icon != null) {
                    this._lowerIcon = icon;
                }
                if ((icon = UIDefaultsLookup.getIcon("RangeSlider.lowerVRIcon")) == null) break;
                this._lowerIconV = icon;
                break;
            }
            case 2: {
                Icon icon = UIDefaultsLookup.getIcon("RangeSlider.upperRIcon");
                if (icon != null) {
                    this._upperIcon = icon;
                }
                if ((icon = UIDefaultsLookup.getIcon("RangeSlider.upperVRIcon")) == null) break;
                this._upperIconV = icon;
                break;
            }
            case 4: {
                Icon icon = UIDefaultsLookup.getIcon("RangeSlider.middleRIcon");
                if (icon != null) {
                    this._middleIcon = icon;
                }
                if ((icon = UIDefaultsLookup.getIcon("RangeSlider.middleVRIcon")) == null) break;
                this._middleIconV = icon;
                break;
            }
        }
        this.slider.repaint();
    }

    protected class RangeTrackListener
    extends BasicSliderUI.TrackListener {
        int handle;
        int handleOffset;
        int mouseStartLocation;

        public RangeTrackListener() {
            super(BasicRangeSliderUI.this);
        }

        public void mousePressed(MouseEvent mouseEvent) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            this.handle = BasicRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY());
            this.handleOffset = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() - BasicRangeSliderUI.this.yPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue()) : mouseEvent.getX() - BasicRangeSliderUI.this.xPositionForValue(((RangeSlider)BasicRangeSliderUI.this.slider).getLowValue());
            this.mouseStartLocation = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(true);
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            int n;
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            int n2 = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? mouseEvent.getY() : mouseEvent.getX();
            int n3 = n = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(n2) : BasicRangeSliderUI.this.valueForXPosition(n2);
            if (n < BasicRangeSliderUI.this.slider.getModel().getMinimum()) {
                n = BasicRangeSliderUI.this.slider.getModel().getMinimum();
            }
            if (n > BasicRangeSliderUI.this.slider.getModel().getMaximum()) {
                n = BasicRangeSliderUI.this.slider.getModel().getMaximum();
            }
            if (this.handle == 3) {
                if (n2 - this.mouseStartLocation > 2) {
                    this.handle = 2;
                } else if (n2 - this.mouseStartLocation < -2) {
                    this.handle = 1;
                } else {
                    return;
                }
            }
            RangeSlider rangeSlider = (RangeSlider)BasicRangeSliderUI.this.slider;
            switch (this.handle) {
                case 1: {
                    rangeSlider.setLowValue(Math.min(n, rangeSlider.getHighValue()));
                    break;
                }
                case 2: {
                    rangeSlider.setHighValue(Math.max(rangeSlider.getLowValue(), n));
                    break;
                }
                case 4: {
                    int n4;
                    int n5 = n4 = BasicRangeSliderUI.this.slider.getOrientation() == 1 ? BasicRangeSliderUI.this.valueForYPosition(n2 - this.handleOffset) - rangeSlider.getLowValue() : BasicRangeSliderUI.this.valueForXPosition(n2 - this.handleOffset) - rangeSlider.getLowValue();
                    if (n4 < 0 && rangeSlider.getLowValue() + n4 < rangeSlider.getMinimum()) {
                        n4 = rangeSlider.getMinimum() - rangeSlider.getLowValue();
                    }
                    if (n4 > 0 && rangeSlider.getHighValue() + n4 > rangeSlider.getMaximum()) {
                        n4 = rangeSlider.getMaximum() - rangeSlider.getHighValue();
                    }
                    if (n4 == 0) break;
                    BasicRangeSliderUI.this.offset(n4);
                }
            }
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            BasicRangeSliderUI.this.slider.getModel().setValueIsAdjusting(false);
        }

        private void setCursor(int n) {
            Cursor cursor = Cursor.getPredefinedCursor(n);
            if (BasicRangeSliderUI.this.slider.getCursor() != cursor) {
                BasicRangeSliderUI.this.slider.setCursor(cursor);
            }
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            if (!BasicRangeSliderUI.this.slider.isEnabled()) {
                return;
            }
            switch (BasicRangeSliderUI.this.getMouseHandle(mouseEvent.getX(), mouseEvent.getY())) {
                case 1: {
                    BasicRangeSliderUI.this.setMouseRollover(1);
                    this.setCursor(BasicRangeSliderUI.this.slider.getOrientation() == 1 ? 8 : 10);
                    break;
                }
                case 2: {
                    BasicRangeSliderUI.this.setMouseRollover(2);
                    this.setCursor(BasicRangeSliderUI.this.slider.getOrientation() == 1 ? 9 : 11);
                    break;
                }
                case 4: {
                    BasicRangeSliderUI.this.setMouseRollover(4);
                    this.setCursor(13);
                    break;
                }
                case 0: {
                    BasicRangeSliderUI.this.setMouseRollover(0);
                    this.setCursor(0);
                }
            }
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2) {
                BasicRangeSliderUI.this.slider.getModel().setValue(BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.getModel().setExtent(BasicRangeSliderUI.this.slider.getModel().getMaximum() - BasicRangeSliderUI.this.slider.getModel().getMinimum());
                BasicRangeSliderUI.this.slider.repaint();
            }
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.setCursor(0);
        }
    }
}

