/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.managers;

import java.util.HashMap;
import java.util.Iterator;
import jpcsp.HLE.Modules;
import jpcsp.HLE.SceKernelErrorException;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.managers.SceUidManager;
import jpcsp.HLE.kernel.types.IWaitStateChecker;
import jpcsp.HLE.kernel.types.SceKernelEventFlagInfo;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.ThreadWaitInfo;
import jpcsp.HLE.modules.ThreadManForUser;
import org.apache.log4j.Logger;

public class EventFlagManager {
    protected static Logger log = Modules.getLogger("ThreadManForUser");
    private static HashMap<Integer, SceKernelEventFlagInfo> eventMap;
    private EventFlagWaitStateChecker eventFlagWaitStateChecker;
    public static final int PSP_EVENT_WAITSINGLE = 0;
    public static final int PSP_EVENT_WAITMULTIPLE = 512;
    public static final int PSP_EVENT_WAITANDOR_MASK = 1;
    public static final int PSP_EVENT_WAITAND = 0;
    public static final int PSP_EVENT_WAITOR = 1;
    public static final int PSP_EVENT_WAITCLEARALL = 16;
    public static final int PSP_EVENT_WAITCLEAR = 32;
    public static final EventFlagManager singleton;

    public void reset() {
        eventMap = new HashMap();
        this.eventFlagWaitStateChecker = new EventFlagWaitStateChecker();
    }

    private boolean removeWaitingThread(SceKernelThreadInfo thread) {
        SceKernelEventFlagInfo event = eventMap.get(thread.wait.EventFlag_id);
        if (event == null) {
            return false;
        }
        event.threadWaitingList.removeWaitingThread(thread);
        thread.wait.EventFlag_outBits_addr.setValue(event.currentPattern);
        return true;
    }

    public void onThreadWaitTimeout(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352152;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it! (timeout expired)");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadWaitReleased(SceKernelThreadInfo thread) {
        if (this.removeWaitingThread(thread)) {
            thread.cpuContext._v0 = -2147352150;
        } else {
            log.warn((Object)"EventFlag deleted while we were waiting for it!");
            thread.cpuContext._v0 = -2147352139;
        }
    }

    public void onThreadDeleted(SceKernelThreadInfo thread) {
        if (thread.isWaitingForType(4)) {
            this.removeWaitingThread(thread);
        }
    }

    private void onEventFlagDeletedCancelled(int evid, int result) {
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        Iterator<SceKernelThreadInfo> it = threadMan.iterator();
        while (it.hasNext()) {
            SceKernelThreadInfo thread = it.next();
            if (!thread.isWaitingFor(4, evid)) continue;
            thread.cpuContext._v0 = result;
            threadMan.hleChangeThreadState(thread, 2);
            reschedule = true;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private void onEventFlagDeleted(int evid) {
        this.onEventFlagDeletedCancelled(evid, -2147352139);
    }

    private void onEventFlagCancelled(int evid) {
        this.onEventFlagDeletedCancelled(evid, -2147352151);
    }

    private void onEventFlagModified(SceKernelEventFlagInfo event) {
        SceKernelThreadInfo thread;
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        boolean reschedule = false;
        SceKernelThreadInfo checkedThread = null;
        while (event.currentPattern != 0 && (thread = event.threadWaitingList.getNextWaitingThread(checkedThread)) != null) {
            if (this.checkEventFlag(event, thread.wait.EventFlag_bits, thread.wait.EventFlag_wait, thread.wait.EventFlag_outBits_addr)) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("onEventFlagModified waking thread %s", thread));
                }
                event.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                threadMan.hleChangeThreadState(thread, 2);
                reschedule = true;
                continue;
            }
            checkedThread = thread;
        }
        if (reschedule) {
            threadMan.hleRescheduleCurrentThread();
        }
    }

    private boolean checkEventFlag(SceKernelEventFlagInfo event, int bits, int wait, TPointer32 outBitsAddr) {
        boolean matched = false;
        if ((wait & 1) == 0 && (event.currentPattern & bits) == bits) {
            matched = true;
        } else if ((wait & 1) == 1 && (event.currentPattern & bits) != 0) {
            matched = true;
        }
        if (matched) {
            outBitsAddr.setValue(event.currentPattern);
            if (log.isDebugEnabled() && outBitsAddr.isNotNull()) {
                log.debug((Object)String.format("checkEventFlag returning outBits=0x%X at %s", outBitsAddr.getValue(), outBitsAddr));
            }
            if ((wait & 0x10) == 16) {
                event.currentPattern = 0;
            }
            if ((wait & 0x20) == 32) {
                event.currentPattern &= ~bits;
            }
        }
        return matched;
    }

    public int checkEventFlagID(int uid) {
        SceUidManager.checkUidPurpose(uid, "ThreadMan-eventflag", true);
        if (!eventMap.containsKey(uid)) {
            if (uid != 0) {
                log.warn((Object)String.format("checkEventFlagID unknown uid=0x%X", uid));
            }
            throw new SceKernelErrorException(-2147352166);
        }
        return uid;
    }

    public int sceKernelCreateEventFlag(String name, int attr, int initPattern, TPointer option) {
        SceKernelEventFlagInfo event = new SceKernelEventFlagInfo(name, attr, initPattern, initPattern);
        eventMap.put(event.uid, event);
        return event.uid;
    }

    public int sceKernelDeleteEventFlag(int uid) {
        SceKernelEventFlagInfo event = eventMap.remove(uid);
        if (event.getNumWaitThreads() > 0) {
            log.warn((Object)String.format("sceKernelDeleteEventFlag numWaitThreads %d", event.getNumWaitThreads()));
        }
        this.onEventFlagDeleted(uid);
        return 0;
    }

    public int sceKernelSetEventFlag(int uid, int bitsToSet) {
        SceKernelEventFlagInfo event = eventMap.get(uid);
        event.currentPattern |= bitsToSet;
        this.onEventFlagModified(event);
        return 0;
    }

    public int sceKernelClearEventFlag(int uid, int bitsToKeep) {
        SceKernelEventFlagInfo event = eventMap.get(uid);
        event.currentPattern &= bitsToKeep;
        return 0;
    }

    public int hleKernelWaitEventFlag(int uid, int bits, int wait, TPointer32 outBitsAddr, TPointer32 timeoutAddr, boolean doCallbacks) {
        if ((wait & 0xFFFFFFCE) != 0 || (wait & 0x30) == 48) {
            return -2147352171;
        }
        if (bits == 0) {
            return -2147352143;
        }
        if (!Modules.ThreadManForUserModule.isDispatchThreadEnabled()) {
            return -2147352153;
        }
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (event.getNumWaitThreads() >= 1 && (event.attr & 0x200) != 512) {
            log.warn((Object)"hleKernelWaitEventFlag already another thread waiting on it");
            return -2147352144;
        }
        if (!this.checkEventFlag(event, bits, wait, outBitsAddr)) {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelWaitEventFlag - %s fast check failed", event));
            }
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            event.threadWaitingList.addWaitingThread(currentThread);
            currentThread.wait.EventFlag_id = uid;
            currentThread.wait.EventFlag_bits = bits;
            currentThread.wait.EventFlag_wait = wait;
            currentThread.wait.EventFlag_outBits_addr = outBitsAddr;
            threadMan.hleKernelThreadEnterWaitState(4, uid, this.eventFlagWaitStateChecker, timeoutAddr.getAddress(), doCallbacks);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelWaitEventFlag - %s fast check succeeded", event));
        }
        return 0;
    }

    public int sceKernelWaitEventFlag(int uid, int bits, int wait, TPointer32 outBitsAddr, TPointer32 timeoutAddr) {
        return this.hleKernelWaitEventFlag(uid, bits, wait, outBitsAddr, timeoutAddr, false);
    }

    public int sceKernelWaitEventFlagCB(int uid, int bits, int wait, TPointer32 outBitsAddr, TPointer32 timeoutAddr) {
        return this.hleKernelWaitEventFlag(uid, bits, wait, outBitsAddr, timeoutAddr, true);
    }

    public int sceKernelPollEventFlag(int uid, int bits, int wait, TPointer32 outBitsAddr) {
        if (bits == 0) {
            return -2147352143;
        }
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (!this.checkEventFlag(event, bits, wait, outBitsAddr)) {
            outBitsAddr.setValue(event.currentPattern);
            return -2147352145;
        }
        return 0;
    }

    public int sceKernelCancelEventFlag(int uid, int newPattern, TPointer32 numWaitThreadAddr) {
        SceKernelEventFlagInfo event = eventMap.get(uid);
        numWaitThreadAddr.setValue(event.getNumWaitThreads());
        event.threadWaitingList.removeAllWaitingThreads();
        event.currentPattern = newPattern;
        this.onEventFlagCancelled(uid);
        return 0;
    }

    public int sceKernelReferEventFlagStatus(int uid, TPointer addr) {
        SceKernelEventFlagInfo event = eventMap.get(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelReferEventFlagStatus event=%s", event));
        }
        event.write(addr);
        return 0;
    }

    private EventFlagManager() {
    }

    static {
        singleton = new EventFlagManager();
    }

    private class EventFlagWaitStateChecker
    implements IWaitStateChecker {
        private EventFlagWaitStateChecker() {
        }

        @Override
        public boolean continueWaitState(SceKernelThreadInfo thread, ThreadWaitInfo wait) {
            SceKernelEventFlagInfo event = (SceKernelEventFlagInfo)eventMap.get(wait.EventFlag_id);
            if (event == null) {
                thread.cpuContext._v0 = -2147352166;
                return false;
            }
            if (EventFlagManager.this.checkEventFlag(event, wait.EventFlag_bits, wait.EventFlag_wait, wait.EventFlag_outBits_addr)) {
                event.threadWaitingList.removeWaitingThread(thread);
                thread.cpuContext._v0 = 0;
                return false;
            }
            return true;
        }
    }
}

