/*
 * Decompiled with CFR 0.152.
 */
package libkirk;

import java.util.Arrays;
import libkirk.Utilities;

public class BN {
    private static final int[] inv256 = new int[]{1, 171, 205, 183, 57, 163, 197, 239, 241, 27, 61, 167, 41, 19, 53, 223, 225, 139, 173, 151, 25, 131, 165, 207, 209, 251, 29, 135, 9, 243, 21, 191, 193, 107, 141, 119, 249, 99, 133, 175, 177, 219, 253, 103, 233, 211, 245, 159, 161, 75, 109, 87, 217, 67, 101, 143, 145, 187, 221, 71, 201, 179, 213, 127, 129, 43, 77, 55, 185, 35, 69, 111, 113, 155, 189, 39, 169, 147, 181, 95, 97, 11, 45, 23, 153, 3, 37, 79, 81, 123, 157, 7, 137, 115, 149, 63, 65, 235, 13, 247, 121, 227, 5, 47, 49, 91, 125, 231, 105, 83, 117, 31, 33, 203, 237, 215, 89, 195, 229, 15, 17, 59, 93, 199, 73, 51, 85, 255};

    public static void bn_print(String name, byte[] a, int offset, int n) {
        if (Utilities.log.isDebugEnabled()) {
            Utilities.log.debug((Object)String.format("%s = %s", name, jpcsp.util.Utilities.getMemoryDump(a, offset, n)));
        }
    }

    public static void bn_zero(byte[] d, int n) {
        BN.bn_zero(d, 0, n);
    }

    public static void bn_zero(byte[] d, int offset, int n) {
        Arrays.fill(d, offset, offset + n, (byte)0);
    }

    public static void bn_copy(byte[] d, byte[] a, int n) {
        BN.bn_copy(d, 0, a, 0, n);
    }

    public static void bn_copy(byte[] d, int offsetDst, byte[] a, int offsetSrc, int n) {
        System.arraycopy(a, offsetSrc, d, offsetDst, n);
    }

    public static int bn_compare(byte[] a, byte[] b, int n) {
        return BN.bn_compare(a, 0, b, 0, n);
    }

    public static int bn_compare(byte[] a, int offset1, byte[] b, int offset2, int n) {
        for (int i = 0; i < n; ++i) {
            int b8;
            int a8 = Utilities.u8(a, offset1 + i);
            if (a8 < (b8 = Utilities.u8(b, offset2 + i))) {
                return -1;
            }
            if (a8 <= b8) continue;
            return 1;
        }
        return 0;
    }

    public static int bn_add_1(byte[] d, byte[] a, byte[] b, int n) {
        return BN.bn_add_1(d, 0, a, 0, b, 0, n);
    }

    public static int bn_add_1(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2, int n) {
        int c = 0;
        for (int i = n - 1; i >= 0; --i) {
            int dig = Utilities.u8(a, offset1 + i) + Utilities.u8(b, offset2 + i) + c;
            c = Utilities.u8(dig >>> 8);
            d[offsetDst + i] = (byte)dig;
        }
        return c;
    }

    public static int bn_sub_1(byte[] d, byte[] a, byte[] b, int n) {
        return BN.bn_sub_1(d, 0, a, 0, b, 0, n);
    }

    public static int bn_sub_1(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2, int n) {
        int c = 1;
        for (int i = n - 1; i >= 0; --i) {
            int dig = Utilities.u8(a, offset1 + i) + 255 - Utilities.u8(b, offset2 + i) + c;
            c = Utilities.u8(dig >>> 8);
            d[offsetDst + i] = (byte)dig;
        }
        return 1 - c;
    }

    public static void bn_reduce(byte[] d, byte[] N, int n) {
        BN.bn_reduce(d, 0, N, 0, n);
    }

    public static void bn_reduce(byte[] d, int offsetDst, byte[] N, int offsetN, int n) {
        if (BN.bn_compare(d, offsetDst, N, offsetN, n) >= 0) {
            BN.bn_sub_1(d, offsetDst, d, offsetDst, N, offsetN, n);
        }
    }

    public static void bn_add(byte[] d, byte[] a, byte[] b, byte[] N, int n) {
        BN.bn_add(d, 0, a, 0, b, 0, N, 0, n);
    }

    public static void bn_add(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2, byte[] N, int offsetN, int n) {
        if (BN.bn_add_1(d, offsetDst, a, offset1, b, offset2, n) != 0) {
            BN.bn_sub_1(d, offsetDst, d, offsetDst, N, offsetN, n);
        }
        BN.bn_reduce(d, offsetDst, N, offsetN, n);
    }

    public static void bn_sub(byte[] d, byte[] a, byte[] b, byte[] N, int n) {
        BN.bn_sub(d, 0, a, 0, b, 0, N, 0, n);
    }

    public static void bn_sub(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2, byte[] N, int offsetN, int n) {
        if (BN.bn_sub_1(d, offsetDst, a, offset1, b, offset2, n) != 0) {
            BN.bn_add_1(d, offsetDst, d, offsetDst, N, offsetN, n);
        }
    }

    public static void bn_mon_muladd_dig(byte[] d, byte[] a, int b, byte[] N, int n) {
        BN.bn_mon_muladd_dig(d, 0, a, 0, b, N, 0, n);
    }

    public static void bn_mon_muladd_dig(byte[] d, int offsetDst, byte[] a, int offset1, int b, byte[] N, int offsetN, int n) {
        b = Utilities.u8(b);
        int z = Utilities.u8(-(Utilities.u8(d, offsetDst + n - 1) + Utilities.u8(a, offset1 + n - 1) * b) * inv256[Utilities.u8(N, offsetN + n - 1) / 2]);
        int dig = Utilities.u8(d, offsetDst + n - 1) + Utilities.u8(a, offset1 + n - 1) * b + Utilities.u8(N, offsetN + n - 1) * z;
        dig >>>= 8;
        for (int i = n - 2; i >= 0; --i) {
            d[offsetDst + i + 1] = (byte)(dig += Utilities.u8(d, offsetDst + i) + Utilities.u8(a, offset1 + i) * b + Utilities.u8(N, offsetN + i) * z);
            dig >>>= 8;
        }
        d[offsetDst + 0] = (byte)dig;
        if ((dig >>>= 8) != 0) {
            BN.bn_sub_1(d, offsetDst, d, offsetDst, N, offsetN, n);
        }
        BN.bn_reduce(d, offsetDst, N, offsetN, n);
    }

    public static void bn_mon_mul(byte[] d, byte[] a, byte[] b, byte[] N, int n) {
        BN.bn_mon_mul(d, 0, a, 0, b, 0, N, 0, n);
    }

    public static void bn_mon_mul(byte[] d, int offsetDst, byte[] a, int offset1, byte[] b, int offset2, byte[] N, int offsetN, int n) {
        byte[] t = new byte[n];
        for (int i = n - 1; i >= 0; --i) {
            BN.bn_mon_muladd_dig(t, 0, a, offset1, b[offset2 + i], N, offsetN, n);
        }
        BN.bn_copy(d, offsetDst, t, 0, n);
    }

    public static void bn_to_mon(byte[] d, byte[] N, int n) {
        BN.bn_to_mon(d, 0, N, 0, n);
    }

    public static void bn_to_mon(byte[] d, int offsetDst, byte[] N, int offsetN, int n) {
        for (int i = 0; i < 8 * n; ++i) {
            BN.bn_add(d, offsetDst, d, offsetDst, d, offsetDst, N, offsetN, n);
        }
    }

    public static void bn_from_mon(byte[] d, byte[] N, int n) {
        BN.bn_from_mon(d, 0, N, 0, n);
    }

    public static void bn_from_mon(byte[] d, int offsetDst, byte[] N, int offsetN, int n) {
        byte[] t = new byte[n];
        t[n - 1] = 1;
        BN.bn_mon_mul(d, offsetDst, d, offsetDst, t, 0, N, offsetN, n);
    }

    public static void bn_mon_exp(byte[] d, byte[] a, byte[] N, int n, byte[] e, int en) {
        BN.bn_mon_exp(d, 0, a, 0, N, 0, n, e, 0, en);
    }

    public static void bn_mon_exp(byte[] d, int offsetDst, byte[] a, int offset1, byte[] N, int offsetN, int n, byte[] e, int offsetE, int en) {
        byte[] t = new byte[n];
        BN.bn_zero(d, offsetDst, n);
        d[offsetDst + n - 1] = 1;
        BN.bn_to_mon(d, offsetDst, N, offsetN, n);
        for (int i = 0; i < en; ++i) {
            for (int mask = 128; mask != 0; mask >>= 1) {
                BN.bn_mon_mul(t, 0, d, offsetDst, d, offsetDst, N, offsetN, n);
                if ((Utilities.u8(e, offsetE + i) & mask) != 0) {
                    BN.bn_mon_mul(d, offsetDst, t, 0, a, offset1, N, offsetN, n);
                    continue;
                }
                BN.bn_copy(d, offsetDst, t, 0, n);
            }
        }
    }

    public static void bn_mon_inv(byte[] d, byte[] a, byte[] N, int n) {
        BN.bn_mon_inv(d, 0, a, 0, N, 0, n);
    }

    public static void bn_mon_inv(byte[] d, int offsetDst, byte[] a, int offset1, byte[] N, int offsetN, int n) {
        byte[] t = new byte[n];
        byte[] s = new byte[n];
        s[n - 1] = 2;
        BN.bn_sub_1(t, 0, N, offsetN, s, 0, n);
        BN.bn_mon_exp(d, offsetDst, a, offset1, N, offsetN, n, t, 0, n);
    }
}

