/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.network;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.log4j.Logger;

public class AutoDetectLocalIPAddress {
    public static Logger log = Logger.getLogger((String)"network");
    private static AutoDetectLocalIPAddress instance = null;
    private static final int serverSocketPort = 30005;
    private InetAddress localIPAddress;
    private ServerSocket localIPSocket;
    private AutoDetectAcceptOnServerSocket autoDetectAcceptOnServerSocket;

    public static AutoDetectLocalIPAddress getInstance() {
        if (instance == null) {
            instance = new AutoDetectLocalIPAddress();
        }
        return instance;
    }

    private AutoDetectLocalIPAddress() {
    }

    public InetAddress getLocalIPAddress() {
        if (this.localIPAddress == null) {
            this.detectLocalIPAddress();
        }
        return this.localIPAddress;
    }

    private void detectLocalIPAddress() {
        for (int i = 1; i < 128; ++i) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("Trying to Auto Detect Local IP Address 127.0.0.%d", i));
                }
                this.localIPAddress = InetAddress.getByAddress(new byte[]{127, 0, 0, (byte)i});
                this.localIPSocket = new ServerSocket(30005, 10, this.localIPAddress);
                this.autoDetectAcceptOnServerSocket = new AutoDetectAcceptOnServerSocket();
                this.autoDetectAcceptOnServerSocket.setName("Auto Detect Accept On Server Socket");
                this.autoDetectAcceptOnServerSocket.setDaemon(true);
                this.autoDetectAcceptOnServerSocket.start();
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("Successfully Auto Detected Local IP Address %s", this.localIPAddress));
                break;
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.localIPAddress = null;
            if (this.localIPSocket != null) {
                try {
                    this.localIPSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.localIPSocket = null;
        }
    }

    private void acceptOnServerSocket() {
        try {
            Socket socket = this.localIPSocket.accept();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("acceptOnServerSocket socket=%s", socket));
            }
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class AutoDetectAcceptOnServerSocket
    extends Thread {
        private AutoDetectAcceptOnServerSocket() {
        }

        @Override
        public void run() {
            while (AutoDetectLocalIPAddress.this.localIPSocket != null) {
                AutoDetectLocalIPAddress.this.acceptOnServerSocket();
            }
        }
    }
}

