/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.util;

import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import jpcsp.Memory;
import jpcsp.util.Utilities;

public class FIFOByteBuffer {
    private byte[] buffer;
    private int bufferReadOffset;
    private int bufferWriteOffset;
    private int bufferLength;

    public FIFOByteBuffer() {
        this.buffer = new byte[0];
        this.clear();
    }

    public FIFOByteBuffer(byte[] buffer) {
        this.buffer = buffer;
        this.bufferReadOffset = 0;
        this.bufferWriteOffset = 0;
        this.bufferLength = buffer.length;
    }

    private int incrementOffset(int offset, int n) {
        if ((offset += n) >= this.buffer.length) {
            offset -= this.buffer.length;
        } else if (offset < 0) {
            offset += this.buffer.length;
        }
        return offset;
    }

    public void clear() {
        this.bufferReadOffset = 0;
        this.bufferWriteOffset = 0;
        this.bufferLength = 0;
    }

    private void checkBufferForWrite(int length) {
        if (this.bufferLength + length > this.buffer.length) {
            byte[] extendedBuffer = new byte[this.bufferLength + length];
            if (this.bufferReadOffset + this.bufferLength <= this.buffer.length) {
                System.arraycopy(this.buffer, this.bufferReadOffset, extendedBuffer, 0, this.bufferLength);
            } else {
                int lengthEndBuffer = this.buffer.length - this.bufferReadOffset;
                System.arraycopy(this.buffer, this.bufferReadOffset, extendedBuffer, 0, lengthEndBuffer);
                System.arraycopy(this.buffer, 0, extendedBuffer, lengthEndBuffer, this.bufferLength - lengthEndBuffer);
            }
            this.buffer = extendedBuffer;
            this.bufferReadOffset = 0;
            this.bufferWriteOffset = this.bufferLength;
        }
    }

    private void copyToBuffer(int offset, int length, Buffer src) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(this.buffer, offset, length);
        Utilities.putBuffer(byteBuffer, src, ByteOrder.LITTLE_ENDIAN, length);
    }

    public void write(Buffer src, int length) {
        if (this.buffer == null) {
            return;
        }
        this.checkBufferForWrite(length);
        if (this.bufferWriteOffset + length <= this.buffer.length) {
            this.copyToBuffer(this.bufferWriteOffset, length, src);
        } else {
            int lengthEndBuffer = this.buffer.length - this.bufferWriteOffset;
            if ((lengthEndBuffer & 3) == 0 || !(src instanceof IntBuffer)) {
                this.copyToBuffer(this.bufferWriteOffset, lengthEndBuffer, src);
                this.copyToBuffer(0, length - lengthEndBuffer, src);
            } else {
                int lengthEndBuffer4 = lengthEndBuffer & 0xFFFFFFFC;
                this.copyToBuffer(this.bufferWriteOffset, lengthEndBuffer4, src);
                int overlapValue = ((IntBuffer)src).get();
                byte[] bytes4 = new byte[4];
                ByteBuffer src1 = ByteBuffer.wrap(bytes4).order(ByteOrder.LITTLE_ENDIAN);
                src1.asIntBuffer().put(overlapValue);
                int bytesCopyLength1 = lengthEndBuffer & 3;
                this.copyToBuffer(this.bufferWriteOffset + lengthEndBuffer4, bytesCopyLength1, src1);
                int bytesCopyLength2 = bytes4.length - bytesCopyLength1;
                this.copyToBuffer(0, bytesCopyLength2, src1);
                this.copyToBuffer(bytesCopyLength2, length - lengthEndBuffer - bytesCopyLength2, src);
            }
        }
        this.bufferWriteOffset = this.incrementOffset(this.bufferWriteOffset, length);
        this.bufferLength += length;
    }

    public void write(int address, int length) {
        if (length > 0 && Memory.isAddressGood(address)) {
            Buffer memoryBuffer = Memory.getInstance().getBuffer(address, length);
            this.write(memoryBuffer, length);
        }
    }

    public void write(ByteBuffer src) {
        this.write(src, src.remaining());
    }

    public void write(byte[] src) {
        this.write(ByteBuffer.wrap(src), src.length);
    }

    public void write(byte[] src, int offset, int length) {
        this.write(ByteBuffer.wrap(src, offset, length), length);
    }

    public int readByteBuffer(ByteBuffer dst) {
        if (this.buffer == null) {
            return 0;
        }
        int length = dst.remaining();
        if (length > this.bufferLength) {
            length = this.bufferLength;
        }
        if (this.bufferReadOffset + length > this.buffer.length) {
            int lengthEndBuffer = this.buffer.length - this.bufferReadOffset;
            dst.put(this.buffer, this.bufferReadOffset, lengthEndBuffer);
            dst.put(this.buffer, 0, length - lengthEndBuffer);
        } else {
            dst.put(this.buffer, this.bufferReadOffset, length);
        }
        this.bufferReadOffset = this.incrementOffset(this.bufferReadOffset, length);
        this.bufferLength -= length;
        return length;
    }

    public boolean forward(int length) {
        if (this.buffer == null || length < 0) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        if (length > this.bufferLength) {
            return false;
        }
        this.bufferLength -= length;
        this.bufferReadOffset = this.incrementOffset(this.bufferReadOffset, length);
        return true;
    }

    public boolean rewind(int length) {
        if (this.buffer == null || length < 0) {
            return false;
        }
        if (length == 0) {
            return true;
        }
        int maxRewindLength = this.buffer.length - this.bufferLength;
        if (length > maxRewindLength) {
            return false;
        }
        this.bufferLength += length;
        this.bufferReadOffset = this.incrementOffset(this.bufferReadOffset, -length);
        return true;
    }

    public int length() {
        return this.bufferLength;
    }

    public void delete() {
        this.buffer = null;
    }

    public void setBufferLength(int length) {
        if (this.buffer != null && length > this.buffer.length) {
            this.checkBufferForWrite(length - this.buffer.length);
        }
    }

    public String toString() {
        return String.format("FIFOByteBuffer(size=%d, bufferLength=%d, readOffset=%d, writeOffset=%d)", this.buffer.length, this.bufferLength, this.bufferReadOffset, this.bufferWriteOffset);
    }
}

