/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.interpreter;

import java.util.Stack;
import jpcsp.Emulator;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.VSMXCode;
import jpcsp.format.rco.vsmx.VSMXGroup;
import jpcsp.format.rco.vsmx.VSMXMem;
import jpcsp.format.rco.vsmx.interpreter.VSMXArray;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXBoolean;
import jpcsp.format.rco.vsmx.interpreter.VSMXCallState;
import jpcsp.format.rco.vsmx.interpreter.VSMXFunction;
import jpcsp.format.rco.vsmx.interpreter.VSMXLocalVarReference;
import jpcsp.format.rco.vsmx.interpreter.VSMXMethod;
import jpcsp.format.rco.vsmx.interpreter.VSMXNull;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXReference;
import jpcsp.format.rco.vsmx.interpreter.VSMXString;
import org.apache.log4j.Logger;

public class VSMXInterpreter {
    private static final Logger log = VSMX.log;
    private VSMXMem mem;
    private int pc;
    private boolean exit;
    private Stack<VSMXBaseObject> stack;
    private Stack<VSMXCallState> callStates;
    private VSMXCallState callState;
    private VSMXObject globalVariables;
    private String prefix;
    private String name;

    public void setVSMX(VSMX vsmx) {
        this.mem = vsmx.getMem();
        this.name = vsmx.getName();
    }

    public VSMXObject getGlobalVariables() {
        return this.globalVariables;
    }

    private VSMXBaseObject[] popValues(int n) {
        VSMXBaseObject[] values = new VSMXBaseObject[n];
        for (int i = n - 1; i >= 0; --i) {
            values[i] = this.stack.pop().getValue();
        }
        return values;
    }

    private void pushCallState(VSMXBaseObject thisObject, int numberOfLocalVariables, boolean returnThis, boolean exitAfterCall) {
        if (this.callState != null) {
            this.callStates.push(this.callState);
        }
        this.callState = new VSMXCallState(thisObject, numberOfLocalVariables, this.pc, returnThis, exitAfterCall);
        this.stack = this.callState.getStack();
        this.prefix = this.prefix + "  ";
    }

    private void popCallState() {
        if (this.callStates.isEmpty()) {
            this.callState = null;
            this.stack = null;
            this.prefix = "";
        } else {
            this.callState = this.callStates.pop();
            this.stack = this.callState.getStack();
            this.prefix = this.prefix.substring(0, this.prefix.length() - 2);
        }
    }

    private void interpret(VSMXGroup code) {
        switch (code.getOpcode()) {
            case 0: {
                break;
            }
            case 1: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop();
                if (o2 instanceof VSMXReference) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("%s = %s", o2, o1));
                    }
                    ((VSMXReference)o2).assign(o1);
                    this.stack.push(o1);
                    break;
                }
                log.warn((Object)String.format("Line#%d non-ref assignment %s", this.pc - 1, code));
                break;
            }
            case 2: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                if (o1 instanceof VSMXString || o2 instanceof VSMXString) {
                    String s1 = o1.getStringValue();
                    String s2 = o2.getStringValue();
                    String s = s2 + s1;
                    this.stack.push(new VSMXString(this, s));
                    break;
                }
                float f1 = o1.getFloatValue();
                float f2 = o2.getFloatValue();
                float f = f2 + f1;
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 3: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                float f = f2 - f1;
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 4: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                float f = f2 * f1;
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 5: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                float f = f2 / f1;
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 6: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                float f = f2 % f1;
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 7: {
                float f1;
                float f = f1 = this.stack.pop().getFloatValue();
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 8: {
                float f1 = this.stack.pop().getFloatValue();
                float f = -f1;
                this.stack.push(new VSMXNumber(this, f));
                break;
            }
            case 9: {
                boolean b = this.stack.pop().getBooleanValue();
                b = !b;
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 10: {
                VSMXBaseObject o = this.stack.pop();
                float f = o.getFloatValue();
                this.stack.push(new VSMXNumber(this, f += 1.0f));
                if (o instanceof VSMXReference) {
                    ((VSMXReference)o).assign(new VSMXNumber(this, f));
                    break;
                }
                log.warn((Object)String.format("Line#%d non-ref increment %s", this.pc - 1, code));
                break;
            }
            case 11: {
                VSMXBaseObject o = this.stack.pop();
                float f = o.getFloatValue();
                this.stack.push(new VSMXNumber(this, f -= 1.0f));
                if (o instanceof VSMXReference) {
                    ((VSMXReference)o).assign(new VSMXNumber(this, f));
                    break;
                }
                log.warn((Object)String.format("Line#%d non-ref increment %s", this.pc - 1, code));
                break;
            }
            case 12: {
                VSMXBaseObject o = this.stack.pop();
                float f = o.getFloatValue();
                this.stack.push(new VSMXNumber(this, f));
                if (o instanceof VSMXReference) {
                    ((VSMXReference)o).assign(new VSMXNumber(this, f + 1.0f));
                    break;
                }
                log.warn((Object)String.format("Line#%d non-ref increment %s", this.pc - 1, code));
                break;
            }
            case 13: {
                VSMXBaseObject o = this.stack.pop();
                float f = o.getFloatValue();
                this.stack.push(new VSMXNumber(this, f));
                if (o instanceof VSMXReference) {
                    ((VSMXReference)o).assign(new VSMXNumber(this, f - 1.0f));
                    break;
                }
                log.warn((Object)String.format("Line#%d non-ref decrement %s", this.pc - 1, code));
                break;
            }
            case 14: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                boolean b = o1.equals(o2);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("%s == %s: %b", o1, o2, b));
                }
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 15: {
                boolean b;
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                boolean bl = b = !o1.equals(o2);
                if (log.isTraceEnabled()) {
                    log.trace((Object)String.format("%s != %s: %b", o1, o2, b));
                }
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 16: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                boolean b = o1.identity(o2);
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 17: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                boolean b = !o1.identity(o2);
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 18: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                boolean b = f2 < f1;
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 19: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                boolean b = f2 <= f1;
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 20: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                boolean b = f2 >= f1;
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 21: {
                float f1 = this.stack.pop().getFloatValue();
                float f2 = this.stack.pop().getFloatValue();
                boolean b = f2 > f1;
                this.stack.push(VSMXBoolean.getValue(b));
                break;
            }
            case 22: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 23: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 24: {
                VSMXBaseObject o = this.stack.pop().getValue();
                String typeOf = o.typeOf();
                this.stack.push(new VSMXString(this, typeOf));
                break;
            }
            case 25: {
                int i1 = this.stack.pop().getIntValue();
                int i2 = this.stack.pop().getIntValue();
                int i = i1 & i2;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 26: {
                int i1 = this.stack.pop().getIntValue();
                int i2 = this.stack.pop().getIntValue();
                int i = i1 ^ i2;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 27: {
                int i1 = this.stack.pop().getIntValue();
                int i2 = this.stack.pop().getIntValue();
                int i = i1 | i2;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 28: {
                int i1 = this.stack.pop().getIntValue();
                int i = ~i1;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 29: {
                int i1 = this.stack.pop().getIntValue();
                int i2 = this.stack.pop().getIntValue();
                int i = i2 << i1;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 30: {
                int i1 = this.stack.pop().getIntValue();
                int i2 = this.stack.pop().getIntValue();
                int i = i2 >> i1;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 31: {
                int i1 = this.stack.pop().getIntValue();
                int i2 = this.stack.pop().getIntValue();
                int i = i2 >>> i1;
                this.stack.push(new VSMXNumber(this, i));
                break;
            }
            case 32: {
                VSMXBaseObject o1 = this.stack.peek();
                this.stack.push(o1);
                break;
            }
            case 33: {
                VSMXBaseObject o1 = this.stack.pop();
                VSMXBaseObject o2 = this.stack.pop();
                this.stack.push(o1);
                this.stack.push(o2);
                break;
            }
            case 34: {
                this.stack.clear();
                break;
            }
            case 35: {
                this.stack.push(VSMXNull.singleton);
                break;
            }
            case 36: {
                VSMXArray o = new VSMXArray(this);
                this.stack.push(o);
                break;
            }
            case 37: {
                this.stack.push(VSMXBoolean.getValue(code.value));
                break;
            }
            case 38: {
                this.stack.push(new VSMXNumber(this, code.value));
                break;
            }
            case 39: {
                this.stack.push(new VSMXNumber(this, code.getFloatValue()));
                break;
            }
            case 40: {
                this.stack.push(new VSMXString(this, this.mem.texts[code.value]));
                break;
            }
            case 41: {
                break;
            }
            case 42: {
                this.stack.push(new VSMXFunction(this, code.id >> 8 & 0xFF, code.id >> 24 & 0xFF, code.value));
                break;
            }
            case 43: {
                this.stack.push(new VSMXArray(this));
                break;
            }
            case 44: {
                this.stack.push(this.callState.getThisObject());
                break;
            }
            case 45: {
                this.stack.push(new VSMXLocalVarReference(this, this.callState, code.value));
                break;
            }
            case 46: {
                this.stack.push(new VSMXReference(this, this.globalVariables, this.mem.names[code.value]));
                if (!log.isTraceEnabled()) break;
                log.trace((Object)String.format("%s '%s'", VSMXCode.VsmxDecOps[code.getOpcode()], this.mem.names[code.value]));
                break;
            }
            case 47: {
                VSMXBaseObject o = this.stack.pop().getValue();
                if (o instanceof VSMXObject) {
                    this.stack.push(new VSMXReference(this, (VSMXObject)o, this.mem.properties[code.value]));
                    if (!log.isTraceEnabled()) break;
                    log.trace((Object)String.format("%s '%s': %s", VSMXCode.VsmxDecOps[code.getOpcode()], this.mem.properties[code.value], this.stack.peek()));
                    break;
                }
                this.stack.push(o.getPropertyValue(this.mem.properties[code.value]));
                break;
            }
            case 48: {
                VSMXBaseObject o = this.stack.pop().getValue();
                this.stack.push(new VSMXMethod(this, o, this.mem.properties[code.value]));
                if (!log.isTraceEnabled()) break;
                log.trace((Object)String.format("%s '%s'", VSMXCode.VsmxDecOps[code.getOpcode()], this.mem.properties[code.value]));
                break;
            }
            case 49: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop();
                o2.setPropertyValue(this.mem.properties[code.value], o1);
                if (!log.isTraceEnabled()) break;
                log.trace((Object)String.format("%s %s.%s = %s", VSMXCode.VsmxDecOps[code.getOpcode()], o2, this.mem.properties[code.value], o1));
                break;
            }
            case 50: {
                VSMXBaseObject o1 = this.stack.pop();
                o1.deletePropertyValue(this.mem.properties[code.value]);
                break;
            }
            case 51: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 52: {
                VSMXBaseObject o;
                VSMXBaseObject o1 = this.stack.pop();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                if (o2 instanceof VSMXArray) {
                    o = new VSMXReference(this, (VSMXObject)o2, o1.getIntValue());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("%s VSMXArray %s[%d] = %s", VSMXCode.VsmxDecOps[code.getOpcode()], o2, o1.getIntValue(), o));
                    }
                } else if (o2 instanceof VSMXObject) {
                    o = new VSMXReference(this, (VSMXObject)o2, o1.getStringValue());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("%s VSMXObject %s[%s] = %s", VSMXCode.VsmxDecOps[code.getOpcode()], o2, o1.getStringValue(), o));
                    }
                } else {
                    o = o2.getPropertyValue(o1.getStringValue());
                    if (log.isTraceEnabled()) {
                        log.trace((Object)String.format("%s %s[%s] = %s", VSMXCode.VsmxDecOps[code.getOpcode()], o2, o1.getStringValue(), o));
                    }
                }
                this.stack.push(o);
                break;
            }
            case 53: {
                VSMXBaseObject o1 = this.stack.pop();
                VSMXBaseObject o2 = this.stack.peek().getValue();
                VSMXBaseObject o = o2 instanceof VSMXArray ? o2.getPropertyValue(o1.getIntValue()) : o2.getPropertyValue(o1.getStringValue());
                this.stack.push(o);
                break;
            }
            case 54: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop();
                VSMXBaseObject o3 = this.stack.pop().getValue();
                if (o3 instanceof VSMXArray) {
                    o3.setPropertyValue(o2.getIntValue(), o1);
                    break;
                }
                log.warn((Object)String.format("Line#%d non-array index assignment %s", this.pc - 1, code));
                break;
            }
            case 55: {
                VSMXBaseObject o1 = this.stack.pop();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                if (o2 instanceof VSMXArray) {
                    o2.deletePropertyValue(o1.getIntValue());
                    break;
                }
                log.warn((Object)String.format("Line#%d non-array delete %s", this.pc - 1, code));
                break;
            }
            case 56: {
                VSMXBaseObject o1 = this.stack.pop().getValue();
                VSMXBaseObject o2 = this.stack.pop().getValue();
                if (o2 instanceof VSMXArray) {
                    int length = ((VSMXArray)o2).getLength();
                    o2.setPropertyValue(length, o1);
                    this.stack.push(o2);
                    break;
                }
                log.warn((Object)String.format("Line#%d non-array push %s", this.pc - 1, code));
                break;
            }
            case 57: {
                this.pc = code.value;
                break;
            }
            case 58: {
                VSMXBaseObject o1 = this.stack.pop();
                boolean b = o1.getBooleanValue();
                if (!b) break;
                this.pc = code.value;
                break;
            }
            case 59: {
                boolean b;
                VSMXBaseObject o1 = this.stack.pop();
                boolean bl = b = !o1.getBooleanValue();
                if (!b) break;
                this.pc = code.value;
                break;
            }
            case 60: {
                VSMXBaseObject[] arguments = this.popValues(code.value);
                VSMXBaseObject o = this.stack.pop().getValueWithArguments(code.value);
                if (o instanceof VSMXFunction) {
                    VSMXFunction function = (VSMXFunction)o;
                    this.callFunction(function, VSMXNull.singleton, arguments, code.value, false);
                    break;
                }
                this.stack.push(VSMXNull.singleton);
                log.warn((Object)String.format("Line#%d non-function call %s", this.pc - 1, code));
                break;
            }
            case 61: {
                VSMXBaseObject[] arguments = this.popValues(code.value);
                VSMXBaseObject o = this.stack.pop().getValueWithArguments(code.value);
                if (o instanceof VSMXMethod) {
                    VSMXMethod method = (VSMXMethod)o;
                    VSMXFunction function = method.getFunction(code.value, arguments);
                    if (function == null) {
                        this.stack.push(VSMXNull.singleton);
                        log.warn((Object)String.format("Line#%d non existing method %s()", this.pc - 1, method.getName()));
                        break;
                    }
                    this.callFunction(function, method.getThisObject(), method.getArguments(), method.getNumberOfArguments(), false);
                    break;
                }
                if (o instanceof VSMXFunction) {
                    VSMXFunction function = (VSMXFunction)o;
                    o = this.stack.pop().getValue();
                    this.callFunction(function, o, arguments, code.value, false);
                    break;
                }
                this.stack.push(VSMXNull.singleton);
                log.warn((Object)String.format("Line#%d non-method call %s", this.pc - 1, code));
                break;
            }
            case 62: {
                VSMXBaseObject[] arguments = this.popValues(code.value);
                VSMXBaseObject r = this.stack.pop();
                VSMXBaseObject o = r.getValue();
                if (o instanceof VSMXArray) {
                    if (code.value == 0) {
                        this.stack.push(new VSMXArray(this));
                        break;
                    }
                    if (code.value == 1) {
                        this.stack.push(new VSMXArray(this, arguments[0].getIntValue()));
                        break;
                    }
                    VSMXArray array = new VSMXArray(this, code.value);
                    for (int j = 0; j < code.value; ++j) {
                        array.setPropertyValue(j, arguments[j]);
                    }
                    this.stack.push(array);
                    break;
                }
                if (o instanceof VSMXFunction) {
                    VSMXFunction function = (VSMXFunction)o;
                    String className = null;
                    if (r instanceof VSMXReference) {
                        className = ((VSMXReference)r).getRefProperty();
                    }
                    VSMXObject thisObject = new VSMXObject(this, className);
                    this.callFunction(function, thisObject, arguments, code.value, true);
                    break;
                }
                if (o instanceof VSMXObject) {
                    if (code.value == 0) {
                        this.stack.push(new VSMXObject(this, null));
                        break;
                    }
                    log.warn((Object)String.format("Line#%d wrong number of arguments for new Object %s", this.pc - 1, code));
                    break;
                }
                this.stack.push(new VSMXArray(this));
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 63: {
                VSMXBaseObject o = this.stack.pop().getValue();
                if (this.callState.getReturnThis()) {
                    o = this.callState.getThisObject();
                }
                this.pc = this.callState.getReturnPc();
                if (this.callState.getExitAfterCall()) {
                    this.exit = true;
                }
                this.popCallState();
                if (this.callState == null) {
                    this.exit = true;
                    break;
                }
                this.stack.push(o);
                break;
            }
            case 64: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 65: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 66: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 67: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 68: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            case 69: {
                this.exit = true;
                break;
            }
            case 70: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("debug file '%s'", this.mem.texts[code.value]));
                break;
            }
            case 71: {
                if (!log.isDebugEnabled()) break;
                log.debug((Object)String.format("debug line %d", code.value));
                break;
            }
            case 73: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
                break;
            }
            default: {
                log.warn((Object)String.format("Line#%d unimplemented %s", this.pc - 1, code));
            }
        }
    }

    private void interpret() {
        this.exit = false;
        while (!this.exit) {
            VSMXGroup code = this.mem.codes[this.pc];
            if (log.isTraceEnabled()) {
                log.trace((Object)String.format("%sInterpret Line#%d: %s", this.prefix, this.pc, code));
            }
            ++this.pc;
            this.interpret(code);
        }
        this.exit = false;
    }

    public synchronized void run(VSMXObject globalVariables) {
        this.prefix = "";
        this.pc = 0;
        this.exit = false;
        this.callStates = new Stack();
        this.pushCallState(VSMXNull.singleton, 0, false, true);
        this.globalVariables = globalVariables;
        VSMXBoolean.init(this);
        this.interpret();
        this.callStates.clear();
        this.callState = null;
        this.prefix = "";
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("Global variables after run(): %s", globalVariables));
        }
    }

    private void callFunction(VSMXFunction function, VSMXBaseObject thisObject, VSMXBaseObject[] arguments, int numberArguments, boolean returnThis) {
        this.pushCallState(thisObject, function.getLocalVars() + function.getArgs(), returnThis, false);
        for (int i = 1; i <= function.getArgs() && i <= numberArguments; ++i) {
            this.callState.setLocalVar(i, arguments[i - 1]);
        }
        function.call(this.callState);
        int startLine = function.getStartLine();
        if (startLine >= 0 && startLine < this.mem.codes.length) {
            this.pc = startLine;
        } else {
            this.popCallState();
            VSMXBaseObject returnValue = function.getReturnValue();
            if (returnThis) {
                this.stack.push(thisObject);
            } else if (returnValue != null) {
                this.stack.push(returnValue);
            }
        }
    }

    public synchronized void interpretFunction(VSMXFunction function, VSMXBaseObject object, VSMXBaseObject[] arguments) {
        this.pushCallState(object, function.getLocalVars(), false, true);
        for (int i = 1; i <= function.getArgs(); ++i) {
            if (arguments == null || i > arguments.length) {
                this.callState.setLocalVar(i, VSMXNull.singleton);
                continue;
            }
            this.callState.setLocalVar(i, arguments[i - 1]);
        }
        this.pc = function.getStartLine();
        this.interpret();
    }

    public synchronized void delayInterpretFunction(VSMXFunction function, VSMXBaseObject object, VSMXBaseObject[] arguments) {
        InterpretFunctionAction action = new InterpretFunctionAction(function, object, arguments);
        Emulator.getScheduler().addAction(action);
    }

    public synchronized void interpretScript(VSMXBaseObject object, String script) {
        String scriptPrefix;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("interpretScript %s on %s", script, object));
        }
        if (script == null) {
            return;
        }
        if (object == null) {
            object = VSMXNull.singleton;
        }
        if (script.startsWith(scriptPrefix = String.format("script:/%s/", this.name))) {
            String functionName = script.substring(scriptPrefix.length());
            VSMXBaseObject functionObject = this.globalVariables.getPropertyValue(functionName);
            if (functionObject instanceof VSMXFunction) {
                VSMXFunction function = (VSMXFunction)functionObject;
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("interpretScript function=%s", function));
                }
                this.interpretFunction(function, object, null);
            }
        } else {
            log.warn((Object)String.format("interpretScript unknown script syntax '%s'", script));
        }
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        s.append(String.format("pc=%d", this.pc));
        s.append(String.format(", %s", this.callState));
        return s.toString();
    }

    private class InterpretFunctionAction
    implements IAction {
        private VSMXFunction function;
        private VSMXBaseObject object;
        private VSMXBaseObject[] arguments;

        public InterpretFunctionAction(VSMXFunction function, VSMXBaseObject object, VSMXBaseObject[] arguments) {
            this.function = function;
            this.object = object;
            this.arguments = arguments;
        }

        @Override
        public void execute() {
            VSMXInterpreter.this.interpretFunction(this.function, this.object, this.arguments);
        }
    }
}

