/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.util.Arrays;
import java.util.Random;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.memory.ByteArrayMemory;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceMemab
extends HLEModule {
    public static Logger log = Modules.getLogger("sceMemab");
    private Random random = new Random();
    private long scrambleCounter;
    private byte[] randomKey;

    private byte[] readCertificate() {
        byte[] bufferBytes = new byte[512];
        ByteArrayMemory bufferMemory = new ByteArrayMemory(bufferBytes);
        TPointer buffer = new TPointer(bufferMemory, 0);
        int result = Modules.sceIdStorageModule.hleIdStorageReadLeaf(256, buffer);
        if (result != 0) {
            return null;
        }
        byte[] certificate = new byte[184];
        System.arraycopy(bufferBytes, 240, certificate, 0, certificate.length);
        return certificate;
    }

    private int decrypt(byte[] output, byte[] input, int keyseed) {
        byte[] buffer = new byte[input.length + 20];
        Utilities.writeUnaligned32(buffer, 0, 5);
        Utilities.writeUnaligned32(buffer, 4, 0);
        Utilities.writeUnaligned32(buffer, 8, 0);
        Utilities.writeUnaligned32(buffer, 12, keyseed);
        Utilities.writeUnaligned32(buffer, 16, input.length);
        System.arraycopy(input, 0, buffer, 20, input.length);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(output, output.length, buffer, buffer.length, 7);
        return result;
    }

    private int encrypt(byte[] output, byte[] input, int keyseed) {
        byte[] buffer = new byte[input.length + 20];
        Utilities.writeUnaligned32(buffer, 0, 4);
        Utilities.writeUnaligned32(buffer, 4, 0);
        Utilities.writeUnaligned32(buffer, 8, 0);
        Utilities.writeUnaligned32(buffer, 12, keyseed);
        Utilities.writeUnaligned32(buffer, 16, input.length);
        System.arraycopy(input, 0, buffer, 20, input.length);
        byte[] outputBuffer = new byte[output.length + 20];
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(outputBuffer, outputBuffer.length, buffer, buffer.length, 7);
        System.arraycopy(outputBuffer, 20, output, 0, output.length);
        return result;
    }

    private int random(byte[] output, int outputLength) {
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(output, outputLength, null, 0, 14);
        return result;
    }

    private int encryptWithRandomData(byte[] output, byte[] input, int keyseed) {
        int i;
        byte[] randomData = new byte[32];
        int result = this.random(randomData, randomData.length);
        if (result != 0) {
            return result;
        }
        byte[] buffer = new byte[input.length + 16];
        for (i = 0; i < 8; ++i) {
            buffer[i] = randomData[i * 4];
        }
        for (i = 8; i < 16; ++i) {
            buffer[i] = 0;
        }
        System.arraycopy(input, 0, buffer, 16, input.length);
        result = this.encrypt(output, buffer, keyseed);
        return result;
    }

    private int hash(byte[] output, byte[] input, int offset, int length) {
        byte[] buffer = new byte[length + 4];
        Utilities.writeUnaligned32(buffer, 0, length);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(output, 20, buffer, buffer.length, 11);
        return result;
    }

    private int verify(byte[] publicKey, int publicKeyOffset, byte[] messageHash, int messageHashOffset, byte[] signature, int signatureOffset) {
        byte[] buffer = new byte[100];
        System.arraycopy(publicKey, publicKeyOffset, buffer, 0, 40);
        System.arraycopy(messageHash, messageHashOffset, buffer, 40, 20);
        System.arraycopy(signature, signatureOffset, buffer, 60, 40);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(null, 0, buffer, buffer.length, 17);
        return result;
    }

    private int genKeys(byte[] privateKey, byte[] publicKey) {
        byte[] buffer = new byte[60];
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(buffer, buffer.length, null, 0, 12);
        System.arraycopy(buffer, 0, privateKey, 0, 20);
        System.arraycopy(buffer, 20, publicKey, 0, 40);
        return result;
    }

    private int multiply(byte[] output, byte[] multiplier, byte[] publicKey, int publicKeyOffset) {
        byte[] buffer = new byte[60];
        System.arraycopy(multiplier, 0, buffer, 0, 20);
        System.arraycopy(publicKey, publicKeyOffset, buffer, 20, 40);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(output, 40, buffer, buffer.length, 13);
        return result;
    }

    private int sign(byte[] output, byte[] encPrivate, int encPrivateOffset, byte[] messageHash, int messageHashOffset) {
        byte[] buffer = new byte[52];
        System.arraycopy(encPrivate, encPrivateOffset, buffer, 0, 32);
        System.arraycopy(messageHash, messageHashOffset, buffer, 32, 20);
        int result = Modules.semaphoreModule.hleUtilsBufferCopyWithRange(output, 40, buffer, buffer.length, 16);
        return result;
    }

    private int scrambleKey(byte[] output, long[] counter, byte[] key) {
        int keyseed = 68;
        byte[] input = new byte[output.length];
        for (int i = 0; i < output.length; i += 16) {
            Utilities.writeUnaligned64(input, i, counter[0]);
            if ((counter[0] & 1L) != 0L) {
                System.arraycopy(key, 0, input, i + 8, 8);
            } else {
                System.arraycopy(key, 8, input, i + 8, 8);
            }
            counter[0] = counter[0] + 1L;
        }
        int result = this.decrypt(output, input, 68);
        return result;
    }

    private int decryptAndHash(byte[] dataBuffer, int dataLength, long[] counter, byte[] key, byte[] output, boolean flag) {
        Utilities.writeUnaligned64(output, 0, counter[0]);
        Arrays.fill(output, 8, 16, (byte)0);
        if (flag) {
            if (dataLength == 0) {
                return -1;
            }
            byte[] buffer = new byte[dataLength];
            int result = this.scrambleKey(buffer, counter, key);
            if (result != 0) {
                return result;
            }
            for (int i = 0; i < dataLength; ++i) {
                int n = i;
                dataBuffer[n] = (byte)(dataBuffer[n] ^ buffer[i]);
            }
        }
        byte[] hashInput = new byte[36 + dataLength];
        byte[] hashOutput = new byte[20];
        System.arraycopy(key, 0, hashInput, 0, 20);
        System.arraycopy(output, 0, hashInput, 20, 16);
        System.arraycopy(dataBuffer, 0, hashInput, 36, dataLength);
        int result = this.hash(hashOutput, hashInput, 0, hashInput.length);
        if (result != 0) {
            return result;
        }
        System.arraycopy(hashOutput, 0, output, 16, 16);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1842819994, version=150)
    public int sceMemab_6DD7339A() {
        if (this.randomKey == null) {
            this.scrambleCounter = 0L;
            byte[] buffer = new byte[20];
            int result = this.random(buffer, buffer.length);
            if (result != 0) {
                return result;
            }
            this.randomKey = new byte[20];
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-713533785, version=150)
    public int sceMemab_D57856A7() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-146607485, version=150)
    public int sceMemab_F742F283(TPointer dataAddr, int dataLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer outputAddr, boolean unknownFlag) {
        if ((dataLength & 0xF) != 0 || dataLength < 0 || dataLength > 2320) {
            return -1;
        }
        byte[] dataBuffer = dataAddr.getArray8(dataLength);
        long[] counter = new long[]{this.scrambleCounter};
        byte[] output = new byte[32];
        int result = this.decryptAndHash(dataBuffer, dataLength, counter, this.randomKey, output, unknownFlag);
        outputAddr.setArray(output);
        this.scrambleCounter = counter[0];
        return result;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1263856301, version=150)
    public int sceMemab_4B54EAAD(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.out) TPointer unknownOutput1, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=160, usage=BufferInfo.Usage.out) TPointer unknownOutput2) {
        int offset1 = 0;
        unknownOutput1.clear(offset1, 60);
        unknownOutput1.clear(offset1 += 60, 16);
        unknownOutput1.clear(192 - (offset1 += 16));
        RuntimeContext.debugMemory(unknownOutput1.getAddress(), 192);
        unknownOutput2.clear(160);
        RuntimeContext.debugMemory(unknownOutput2.getAddress(), 160);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1678718627, version=150)
    public int sceMemab_9BF0C95D(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.out) TPointer keysOutput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=160, usage=BufferInfo.Usage.in) TPointer encryptedInputMessage, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=272, usage=BufferInfo.Usage.out) TPointer encryptedResponseMessage) {
        int keyseed = 2;
        byte[] encryptedMessage = encryptedInputMessage.getArray8(160);
        byte[] decryptedMessage = new byte[encryptedMessage.length];
        int result = this.decrypt(decryptedMessage, encryptedMessage, 2);
        if (result != 0) {
            return result;
        }
        byte[] hash1 = new byte[20];
        result = this.hash(hash1, decryptedMessage, 56, 56);
        byte[] certificate = this.readCertificate();
        if (certificate == null) {
            return -1;
        }
        result = this.verify(certificate, 96, hash1, 0, decryptedMessage, 112);
        if (result != 0) {
            return result;
        }
        byte[] generatedPrivateKey = new byte[20];
        byte[] generatedPublicKey = new byte[40];
        result = this.genKeys(generatedPrivateKey, generatedPublicKey);
        if (result != 0) {
            return result;
        }
        byte[] multipliedPoint = new byte[40];
        result = this.multiply(multipliedPoint, generatedPrivateKey, decryptedMessage, 16);
        if (result != 0) {
            return result;
        }
        byte[] inputHash2 = new byte[96];
        System.arraycopy(generatedPublicKey, 0, inputHash2, 0, 40);
        System.arraycopy(decryptedMessage, 16, inputHash2, 40, 40);
        System.arraycopy(decryptedMessage, 56, inputHash2, 80, 16);
        byte[] hash2 = new byte[20];
        result = this.hash(hash2, inputHash2, 0, inputHash2.length);
        if (result != 0) {
            return result;
        }
        byte[] signature = new byte[40];
        result = this.sign(signature, certificate, 136, hash2, 0);
        if (result != 0) {
            return result;
        }
        byte[] inputHash3 = new byte[20 + inputHash2.length];
        System.arraycopy(multipliedPoint, 0, inputHash3, 0, 20);
        System.arraycopy(inputHash2, 0, inputHash3, 20, inputHash2.length);
        byte[] hash3 = new byte[20];
        result = this.hash(hash3, inputHash3, 0, inputHash3.length);
        if (result != 0) {
            return result;
        }
        int offset = 0;
        keysOutput.setArray(offset, decryptedMessage, 72, 40);
        keysOutput.setArray(offset += 40, generatedPublicKey, 0, 40);
        keysOutput.setArray(offset += 40, decryptedMessage, 16, 40);
        keysOutput.setArray(offset += 40, certificate, 0, 16);
        keysOutput.setArray(offset += 16, multipliedPoint, 0, 20);
        keysOutput.clear(offset += 20, 192 - offset);
        byte[] encryptInput = new byte[256];
        offset = 0;
        System.arraycopy(inputHash2, 0, encryptInput, offset, inputHash2.length);
        System.arraycopy(certificate, 136, encryptInput, offset += inputHash2.length, 32);
        System.arraycopy(hash2, 0, encryptInput, offset += 32, 8);
        System.arraycopy(hash2, 0, encryptInput, offset += 8, 20);
        System.arraycopy(certificate, 0, encryptInput, offset += 20, 96);
        Arrays.fill(encryptInput, offset += 96, encryptInput.length, (byte)0);
        byte[] encryptOutput = new byte[272];
        result = this.encryptWithRandomData(encryptOutput, encryptInput, 2);
        if (result != 0) {
            return result;
        }
        encryptedResponseMessage.setArray(encryptOutput);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1013440799, version=150)
    public int sceMemab_C3981EE1(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.inout) TPointer unknownInputOuput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=272, usage=BufferInfo.Usage.in) TPointer unknownInput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.out) TPointer unknownOutput) {
        unknownInputOuput.clear(192);
        RuntimeContext.debugMemory(unknownInputOuput.getAddress(), 192);
        RuntimeContext.debugMemory(unknownInput.getAddress(), 272);
        unknownOutput.clear(256);
        RuntimeContext.debugMemory(unknownOutput.getAddress(), 256);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1967246267, version=150)
    public int sceMemab_8ABE3445(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.out) TPointer unknownOutput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.in) TPointer unknownInput) {
        unknownOutput.clear(192);
        RuntimeContext.debugMemory(unknownOutput.getAddress(), 192);
        RuntimeContext.debugMemory(unknownInput.getAddress(), 96);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=602170779, version=150)
    public int sceMemab_23E4659B(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=192, usage=BufferInfo.Usage.inout) TPointer unknownInputOutput1, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=256, usage=BufferInfo.Usage.inout) TPointer unknownInputOutput2, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=96, usage=BufferInfo.Usage.out) TPointer unknownOutput) {
        unknownInputOutput1.clear(192);
        RuntimeContext.debugMemory(unknownInputOutput1.getAddress(), 192);
        unknownInputOutput2.clear(256);
        RuntimeContext.debugMemory(unknownInputOutput2.getAddress(), 256);
        unknownOutput.clear(96);
        RuntimeContext.debugMemory(unknownOutput.getAddress(), 96);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-883082986, version=150)
    public int sceMemab_CB5D3916(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=60, usage=BufferInfo.Usage.inout) TPointer unknownInputOutput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer unknownInput, int inputLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer unknownOutput, int unknown1, int unknown2) {
        unknownInputOutput.clear(60);
        RuntimeContext.debugMemory(unknownInputOutput.getAddress(), 60);
        RuntimeContext.debugMemory(unknownInput.getAddress(), inputLength);
        unknownOutput.clear(32);
        RuntimeContext.debugMemory(unknownOutput.getAddress(), 32);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-730181455, version=150)
    public int sceMemab_D47A50B1(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=76, usage=BufferInfo.Usage.inout) TPointer unknownInputOutput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer unknownInput, int inputLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=32, usage=BufferInfo.Usage.out) TPointer unknownOutput, int unknown1, int unknown2) {
        unknownInputOutput.clear(76);
        RuntimeContext.debugMemory(unknownInputOutput.getAddress(), 76);
        RuntimeContext.debugMemory(unknownInput.getAddress(), inputLength);
        unknownOutput.clear(32);
        RuntimeContext.debugMemory(unknownOutput.getAddress(), 32);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=1008057484, version=150)
    public int sceMemab_3C15BC8C(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=68, usage=BufferInfo.Usage.inout) TPointer unknownInputOutput, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer unknownInput, int inputLength, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer unknownInput2, int unknown2) {
        unknownInputOutput.clear(68);
        RuntimeContext.debugMemory(unknownInputOutput.getAddress(), 68);
        RuntimeContext.debugMemory(unknownInput.getAddress(), inputLength);
        RuntimeContext.debugMemory(unknownInput2.getAddress(), 16);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=374949508, version=150)
    public int sceMemab_16594684(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.out) TPointer buffer) {
        for (int i = 0; i < 4; ++i) {
            buffer.setValue32(i << 2, this.random.nextInt());
        }
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1645688627, version=150)
    public int sceMemab_9DE8C8CD(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer xorKey, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.inout) TPointer buffer, int bufferLength) {
        RuntimeContext.debugMemory(buffer.getAddress(), bufferLength);
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1678663516, version=150)
    public int sceMemab_9BF1A0A4(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.fixedLength, length=16, usage=BufferInfo.Usage.in) TPointer xorKey, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.inout) TPointer buffer, int bufferLength) {
        RuntimeContext.debugMemory(buffer.getAddress(), bufferLength);
        return 0;
    }
}

