/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import java.io.IOException;
import jpcsp.HLE.modules.sceWlan;
import jpcsp.memory.mmio.wlan.MMIOARMHandlerBase;
import jpcsp.memory.mmio.wlan.MMIOHandlerWlanFirmware;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerWlanFirmware2
extends MMIOARMHandlerBase {
    public static Logger log = sceWlan.log;
    private static final int STATE_VERSION = 0;
    private final MMIOHandlerWlanFirmware handlerWlanFirmware;

    public MMIOHandlerWlanFirmware2(int baseAddress, MMIOHandlerWlanFirmware handlerWlanFirmware) {
        super(baseAddress);
        this.handlerWlanFirmware = handlerWlanFirmware;
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        super.write(stream);
    }

    @Override
    public int read8(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 2076: {
                value = 0;
                break;
            }
            case 2084: {
                value = this.handlerWlanFirmware.readEEPROMCmd8();
                break;
            }
            default: {
                value = super.read8(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read8(0x%08X) returning 0x%02X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public int read16(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 2048: {
                value = 0;
                break;
            }
            case 2052: {
                value = 0;
                break;
            }
            default: {
                value = super.read16(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read16(0x%08X) returning 0x%04X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 512: {
                value = 0;
                break;
            }
            case 520: {
                value = 0;
                break;
            }
            case 524: {
                value = 0;
                break;
            }
            case 548: {
                value = 0;
                break;
            }
            case 552: {
                value = 0;
                break;
            }
            case 568: {
                value = 0;
                break;
            }
            case 2056: {
                value = 0;
                break;
            }
            case 32768: {
                value = this.handlerWlanFirmware.getInterrupt();
                break;
            }
            case 32776: {
                value = 0;
                break;
            }
            case 36864: {
                value = 0;
                break;
            }
            case 36900: {
                value = 0;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write8(int address, byte value) {
        int value8 = value & 0xFF;
        switch (address - this.baseAddress) {
            case 0: {
                if (value8 == 1) break;
                super.write8(address, value);
                break;
            }
            case 4: {
                if (value8 == 0) break;
                super.write8(address, value);
                break;
            }
            case 2052: {
                this.handlerWlanFirmware.eepromMode = value8;
                if (value8 == 130 || value8 == 88 || value8 == 84) break;
                super.write8(address, value);
                break;
            }
            case 2084: {
                this.handlerWlanFirmware.writeEEPROMCmdLow8(value8);
                break;
            }
            case 2088: {
                this.handlerWlanFirmware.writeEEPROMCmdHigh8(value8);
                break;
            }
            default: {
                super.write8(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write8(0x%08X, 0x%02X) on %s", this.getPc(), address, value8, this));
        }
    }

    @Override
    public void write16(int address, short value) {
        int value16 = value & 0xFFFF;
        switch (address - this.baseAddress) {
            case 2048: {
                if (value16 == 0 || value16 == 1 || value16 == 4 || value16 == 8 || value16 == 16 || value16 == 24 || value16 == 32) break;
                super.write16(address, value);
                break;
            }
            case 2052: {
                if (value16 == 0) break;
                super.write16(address, value);
                break;
            }
            case 2056: {
                if (value16 == 1346) break;
                super.write16(address, value);
                break;
            }
            default: {
                super.write16(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write16(0x%08X, 0x%04X) on %s", this.getPc(), address, value16, this));
        }
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 512: {
                if (value == 4 || value == 12) break;
                super.write32(address, value);
                break;
            }
            case 520: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 524: {
                if (value == 0 || value == 2 || value == 16) break;
                super.write32(address, value);
                break;
            }
            case 548: {
                if (value == 2) break;
                super.write32(address, value);
                break;
            }
            case 552: {
                if (value == 64) break;
                super.write32(address, value);
                break;
            }
            case 568: {
                if (value == 0) break;
                super.write32(address, value);
                break;
            }
            case 32776: {
                if (value == 16 || value == 256 || value == 1024 || value == 32768 || value == 65536 || value == 99824) break;
                super.write32(address, value);
                break;
            }
            case 32780: {
                if (value == 256 || value == 1024 || value == 32768 || value == 65536) break;
                super.write32(address, value);
                break;
            }
            case 36864: {
                if (value == 10) break;
                super.write32(address, value);
                break;
            }
            case 36880: {
                if (value == 15) break;
                super.write32(address, value);
                break;
            }
            case 36900: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            case 36904: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }
}

