/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio.wlan;

import jpcsp.Emulator;
import jpcsp.Memory;
import jpcsp.arm.ARMProcessor;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.settings.Settings;

public class MMIOARMHandlerBase
extends MMIOHandlerBase {
    private ARMProcessor processor;

    protected MMIOARMHandlerBase(int baseAddress) {
        super(baseAddress);
    }

    public void setProcessor(ARMProcessor processor) {
        this.processor = processor;
    }

    @Override
    public Memory getMemory() {
        return this.processor.mem;
    }

    @Override
    public int getPc() {
        return this.processor.getCurrentInstructionPc();
    }

    private void invalidMemoryAddress(int address, String value, String prefix, int status) {
        this.log.error((Object)String.format("0x%08X - %s - Invalid memory address: 0x%08X%s", this.getPc(), prefix, address, value));
        if (!Settings.getInstance().readBool("emu.ignoreInvalidMemoryAccess")) {
            Emulator.PauseEmuWithStatus(status);
        }
    }

    @Override
    public int read8(int address) {
        this.invalidMemoryAddress(address, "", "read8", 4);
        return 0;
    }

    @Override
    public int read16(int address) {
        this.invalidMemoryAddress(address, "", "read16", 4);
        return 0;
    }

    @Override
    public int read32(int address) {
        this.invalidMemoryAddress(address, "", "read32", 4);
        return 0;
    }

    @Override
    public void write8(int address, byte value) {
        this.invalidMemoryAddress(address, String.format(" (0x%02X)", value & 0xFF), "write8", 8);
    }

    @Override
    public void write16(int address, short value) {
        this.invalidMemoryAddress(address, String.format(" (0x%04X)", value & 0xFFFF), "write16", 8);
    }

    @Override
    public void write32(int address, int value) {
        this.invalidMemoryAddress(address, String.format(" (0x%08X)", value), "write32", 8);
    }
}

