/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.util.Utilities;

public class Elf32ProgramHeader {
    public static final int PF_X = 1;
    public static final int PF_W = 2;
    public static final int PF_R = 4;
    private int p_type;
    private int p_offset;
    private int p_vaddr;
    private int p_paddr;
    private int p_filesz;
    private int p_memsz;
    private int p_flags;
    private int p_align;

    public static int sizeof() {
        return 32;
    }

    public Elf32ProgramHeader(ByteBuffer f) throws IOException {
        this.read(f);
    }

    private void read(ByteBuffer f) throws IOException {
        this.p_type = Utilities.readUWord(f);
        this.p_offset = Utilities.readUWord(f);
        this.p_vaddr = Utilities.readUWord(f);
        this.p_paddr = Utilities.readUWord(f);
        this.p_filesz = Utilities.readUWord(f);
        this.p_memsz = Utilities.readUWord(f);
        this.p_flags = Utilities.readUWord(f);
        this.p_align = Utilities.readUWord(f);
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("p_type \t\t " + Utilities.formatString("long", Long.toHexString((long)this.getP_type() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_offset \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_offset() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_vaddr \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_vaddr() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_paddr \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_paddr() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_filesz \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_filesz() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_memsz \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_memsz() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_flags \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_flags() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        str.append("p_align \t " + Utilities.formatString("long", Long.toHexString((long)this.getP_align() & 0xFFFFFFFFL).toUpperCase()) + "\n");
        return str.toString();
    }

    public int getP_type() {
        return this.p_type;
    }

    public int getP_offset() {
        return this.p_offset;
    }

    public int getP_vaddr() {
        return this.p_vaddr;
    }

    public int getP_paddr() {
        return this.p_paddr;
    }

    public int getP_filesz() {
        return this.p_filesz;
    }

    public int getP_memsz() {
        return this.p_memsz;
    }

    public int getP_flags() {
        return this.p_flags;
    }

    public int getP_align() {
        return this.p_align;
    }
}

