/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.HLE.modules.scePower;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.IState;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerPower
extends MMIOHandlerBase {
    public static Logger log = scePower.log;
    private static final int STATE_VERSION = 0;
    private final PowerObject unknown1 = new PowerObject();
    private final PowerObject unknown2 = new PowerObject();
    private final PowerObject unknown3 = new PowerObject();

    public MMIOHandlerPower(int baseAddress) {
        super(baseAddress);
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.unknown1.read(stream);
        this.unknown2.read(stream);
        this.unknown3.read(stream);
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.unknown1.write(stream);
        this.unknown2.write(stream);
        this.unknown3.write(stream);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.unknown1.reset();
        this.unknown2.reset();
        this.unknown3.reset();
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                value = this.unknown1.read32(address - this.baseAddress);
                break;
            }
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                value = this.unknown2.read32(address - this.baseAddress - 32);
                break;
            }
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: 
            case 84: 
            case 88: 
            case 92: {
                value = this.unknown3.read32(address - this.baseAddress - 64);
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 12: 
            case 16: 
            case 20: 
            case 24: 
            case 28: {
                this.unknown1.write32(address - this.baseAddress, value);
                break;
            }
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 48: 
            case 52: 
            case 56: 
            case 60: {
                this.unknown2.write32(address - this.baseAddress - 32, value);
                break;
            }
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: 
            case 84: 
            case 88: 
            case 92: {
                this.unknown3.write32(address - this.baseAddress - 64, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    private static class PowerObject
    implements IState {
        private static final int STATE_VERSION = 0;
        public int unknown00;
        public int unknown04;
        public int unknown08;
        public int unknown0C;
        public int unknown10;
        public int unknown14;
        public int unknown18;
        public int unknown1C;

        private PowerObject() {
        }

        private int getUnknown0C() {
            this.unknown0C = this.unknown04;
            return this.unknown0C;
        }

        public int read32(int offset) {
            int value = 0;
            switch (offset) {
                case 0: {
                    value = this.unknown00;
                    break;
                }
                case 4: {
                    value = this.unknown04;
                    break;
                }
                case 8: {
                    value = this.unknown08;
                    break;
                }
                case 12: {
                    value = this.getUnknown0C();
                    break;
                }
                case 16: {
                    value = this.unknown10;
                    break;
                }
                case 20: {
                    value = this.unknown14;
                    break;
                }
                case 24: {
                    value = this.unknown18;
                    break;
                }
                case 28: {
                    value = this.unknown1C;
                }
            }
            return value;
        }

        public void write32(int offset, int value) {
            switch (offset) {
                case 0: {
                    this.unknown00 = value;
                    break;
                }
                case 4: {
                    this.unknown04 = value;
                    break;
                }
                case 8: {
                    this.unknown08 = value;
                    break;
                }
                case 12: {
                    this.unknown0C = value;
                    break;
                }
                case 16: {
                    this.unknown10 = value;
                    break;
                }
                case 20: {
                    this.unknown14 = value;
                    break;
                }
                case 24: {
                    this.unknown18 = value;
                    break;
                }
                case 28: {
                    this.unknown1C = value;
                }
            }
        }

        @Override
        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.unknown00 = stream.readInt();
            this.unknown04 = stream.readInt();
            this.unknown08 = stream.readInt();
            this.unknown0C = stream.readInt();
            this.unknown10 = stream.readInt();
            this.unknown14 = stream.readInt();
            this.unknown18 = stream.readInt();
            this.unknown1C = stream.readInt();
        }

        @Override
        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeInt(this.unknown00);
            stream.writeInt(this.unknown04);
            stream.writeInt(this.unknown08);
            stream.writeInt(this.unknown0C);
            stream.writeInt(this.unknown10);
            stream.writeInt(this.unknown14);
            stream.writeInt(this.unknown18);
            stream.writeInt(this.unknown1C);
        }

        public void reset() {
            this.unknown00 = 0;
            this.unknown04 = 0;
            this.unknown08 = 0;
            this.unknown0C = 0;
            this.unknown10 = 0;
            this.unknown14 = 0;
            this.unknown18 = 0;
            this.unknown1C = 0;
        }
    }
}

