/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.memory.mmio;

import java.io.IOException;
import jpcsp.HLE.modules.sceLcdc;
import jpcsp.memory.mmio.MMIOHandlerBase;
import jpcsp.state.StateInputStream;
import jpcsp.state.StateOutputStream;
import org.apache.log4j.Logger;

public class MMIOHandlerLcdc
extends MMIOHandlerBase {
    public static Logger log = sceLcdc.log;
    private static final int STATE_VERSION = 0;
    private final LcdcController controller1 = new LcdcController();
    private final LcdcController controller2 = new LcdcController();
    private int enabled;
    private int scaledXResolution;
    private int yResolution;
    private int unknown18C;
    private int unknown190;
    private int unknown194;
    private int unknown198;
    private int displayFlags;
    private int displayClock;

    public MMIOHandlerLcdc(int baseAddress) {
        super(baseAddress);
        this.reset();
    }

    @Override
    public void read(StateInputStream stream) throws IOException {
        stream.readVersion(0);
        this.controller1.read(stream);
        this.controller2.read(stream);
        this.enabled = stream.readInt();
        this.scaledXResolution = stream.readInt();
        this.yResolution = stream.readInt();
        this.unknown18C = stream.readInt();
        this.unknown190 = stream.readInt();
        this.unknown194 = stream.readInt();
        this.unknown198 = stream.readInt();
        this.displayFlags = stream.readInt();
        this.displayClock = stream.readInt();
        super.read(stream);
    }

    @Override
    public void write(StateOutputStream stream) throws IOException {
        stream.writeVersion(0);
        this.controller1.write(stream);
        this.controller2.write(stream);
        stream.writeInt(this.enabled);
        stream.writeInt(this.scaledXResolution);
        stream.writeInt(this.yResolution);
        stream.writeInt(this.unknown18C);
        stream.writeInt(this.unknown190);
        stream.writeInt(this.unknown194);
        stream.writeInt(this.unknown198);
        stream.writeInt(this.displayFlags);
        stream.writeInt(this.displayClock);
        super.write(stream);
    }

    @Override
    public void reset() {
        super.reset();
        this.controller1.reset();
        this.controller2.reset();
        this.enabled = 0;
        this.scaledXResolution = 0;
        this.yResolution = 0;
        this.unknown18C = 0;
        this.unknown190 = 0;
        this.unknown194 = 0;
        this.unknown198 = 0;
        this.displayFlags = 0;
        this.displayClock = 0;
    }

    @Override
    public int read32(int address) {
        int value;
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 80: {
                value = this.controller1.read32(address - this.baseAddress);
                break;
            }
            case 256: 
            case 260: 
            case 264: 
            case 272: 
            case 276: 
            case 280: 
            case 284: 
            case 288: 
            case 292: 
            case 296: 
            case 300: 
            case 320: 
            case 324: 
            case 328: 
            case 332: 
            case 336: {
                value = this.controller2.read32(address - this.baseAddress - 256);
                break;
            }
            case 384: {
                value = this.enabled;
                break;
            }
            case 388: {
                value = this.scaledXResolution;
                break;
            }
            case 392: {
                value = this.yResolution;
                break;
            }
            case 396: {
                value = this.unknown18C;
                break;
            }
            case 400: {
                value = this.unknown190;
                break;
            }
            case 404: {
                value = this.unknown194;
                break;
            }
            case 408: {
                value = this.unknown198;
                break;
            }
            case 416: {
                value = this.displayFlags;
                break;
            }
            case 432: {
                value = this.displayClock;
                break;
            }
            default: {
                value = super.read32(address);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - read32(0x%08X) returning 0x%08X", this.getPc(), address, value));
        }
        return value;
    }

    @Override
    public void write32(int address, int value) {
        switch (address - this.baseAddress) {
            case 0: 
            case 4: 
            case 8: 
            case 16: 
            case 20: 
            case 24: 
            case 28: 
            case 32: 
            case 36: 
            case 40: 
            case 44: 
            case 64: 
            case 68: 
            case 72: 
            case 76: 
            case 112: {
                this.controller1.write32(address - this.baseAddress, value);
                break;
            }
            case 256: 
            case 260: 
            case 264: 
            case 272: 
            case 276: 
            case 280: 
            case 284: 
            case 288: 
            case 292: 
            case 296: 
            case 300: 
            case 320: 
            case 324: 
            case 328: 
            case 332: 
            case 368: {
                this.controller2.write32(address - this.baseAddress - 256, value);
                break;
            }
            case 384: {
                this.enabled = value;
                break;
            }
            case 388: {
                this.scaledXResolution = value;
                break;
            }
            case 392: {
                this.yResolution = value;
                break;
            }
            case 396: {
                this.unknown18C = value;
                break;
            }
            case 400: {
                this.unknown190 = value;
                break;
            }
            case 404: {
                this.unknown194 = value;
                break;
            }
            case 408: {
                this.unknown198 = value;
                break;
            }
            case 416: {
                this.displayFlags = value;
                break;
            }
            case 432: {
                this.displayClock = value;
                break;
            }
            case 512: {
                if (value == 1) break;
                super.write32(address, value);
                break;
            }
            default: {
                super.write32(address, value);
            }
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("0x%08X - write32(0x%08X, 0x%08X) on %s", this.getPc(), address, value, this));
        }
    }

    @Override
    public String toString() {
        return String.format("MMIOHandlerLcdc", new Object[0]);
    }

    private static class LcdcController {
        private static final int STATE_VERSION = 0;
        public int enable;
        public int synchronizationDifference;
        public int unknown008;
        public int xBackPorch;
        public int xPulseWidth;
        public int xFrontPorch;
        public int xResolution;
        public int yBackPorch;
        public int yPulseWidth;
        public int yFrontPorch;
        public int yResolution;
        public int yShift;
        public int xShift;
        public int scaledXResolution;
        public int scaledYResolution;
        public int resume;

        private LcdcController() {
        }

        public void reset() {
            this.enable = 0;
            this.synchronizationDifference = 0;
            this.unknown008 = 0;
            this.xPulseWidth = 41;
            this.xBackPorch = 2;
            this.xFrontPorch = 2;
            this.xResolution = 480;
            this.yPulseWidth = 10;
            this.yBackPorch = 2;
            this.yFrontPorch = 2;
            this.yResolution = 272;
            this.yShift = 0;
            this.xShift = 0;
            this.scaledXResolution = 480;
            this.scaledYResolution = 272;
            this.resume = 0;
        }

        public int read32(int offset) {
            int value = 0;
            switch (offset) {
                case 0: {
                    value = this.enable;
                    break;
                }
                case 4: {
                    value = this.synchronizationDifference;
                    break;
                }
                case 8: {
                    value = this.unknown008;
                    break;
                }
                case 16: {
                    value = this.xPulseWidth;
                    break;
                }
                case 20: {
                    value = this.xBackPorch;
                    break;
                }
                case 24: {
                    value = this.xFrontPorch;
                    break;
                }
                case 28: {
                    value = this.xResolution;
                    break;
                }
                case 32: {
                    value = this.yBackPorch;
                    break;
                }
                case 36: {
                    value = this.yFrontPorch;
                    break;
                }
                case 40: {
                    value = this.yPulseWidth;
                    break;
                }
                case 44: {
                    value = this.yResolution;
                    break;
                }
                case 64: {
                    value = this.yShift;
                    break;
                }
                case 68: {
                    value = this.xShift;
                    break;
                }
                case 72: {
                    value = this.scaledXResolution;
                    break;
                }
                case 76: {
                    value = this.scaledYResolution;
                    break;
                }
                case 80: {
                    value = 1;
                }
            }
            return value;
        }

        public void write32(int offset, int value) {
            switch (offset) {
                case 0: {
                    this.enable = value;
                    break;
                }
                case 4: {
                    this.synchronizationDifference = value;
                    break;
                }
                case 8: {
                    this.unknown008 = value;
                    break;
                }
                case 16: {
                    this.xPulseWidth = value;
                    break;
                }
                case 20: {
                    this.xBackPorch = value;
                    break;
                }
                case 24: {
                    this.xFrontPorch = value;
                    break;
                }
                case 28: {
                    this.xResolution = value;
                    break;
                }
                case 32: {
                    this.yBackPorch = value;
                    break;
                }
                case 36: {
                    this.yFrontPorch = value;
                    break;
                }
                case 40: {
                    this.yPulseWidth = value;
                    break;
                }
                case 44: {
                    this.yResolution = value;
                    break;
                }
                case 64: {
                    this.yShift = value;
                    break;
                }
                case 68: {
                    this.xShift = value;
                    break;
                }
                case 72: {
                    this.scaledXResolution = value;
                    break;
                }
                case 76: {
                    this.scaledYResolution = value;
                    break;
                }
                case 112: {
                    this.resume = value;
                }
            }
        }

        public void read(StateInputStream stream) throws IOException {
            stream.readVersion(0);
            this.enable = stream.readInt();
            this.synchronizationDifference = stream.readInt();
            this.unknown008 = stream.readInt();
            this.xPulseWidth = stream.readInt();
            this.xBackPorch = stream.readInt();
            this.xFrontPorch = stream.readInt();
            this.xResolution = stream.readInt();
            this.yBackPorch = stream.readInt();
            this.yFrontPorch = stream.readInt();
            this.yPulseWidth = stream.readInt();
            this.yResolution = stream.readInt();
            this.yShift = stream.readInt();
            this.xShift = stream.readInt();
            this.scaledXResolution = stream.readInt();
            this.scaledYResolution = stream.readInt();
            this.resume = stream.readInt();
        }

        public void write(StateOutputStream stream) throws IOException {
            stream.writeVersion(0);
            stream.writeInt(this.enable);
            stream.writeInt(this.synchronizationDifference);
            stream.writeInt(this.unknown008);
            stream.writeInt(this.xPulseWidth);
            stream.writeInt(this.xBackPorch);
            stream.writeInt(this.xFrontPorch);
            stream.writeInt(this.xResolution);
            stream.writeInt(this.yBackPorch);
            stream.writeInt(this.yFrontPorch);
            stream.writeInt(this.yPulseWidth);
            stream.writeInt(this.yResolution);
            stream.writeInt(this.yShift);
            stream.writeInt(this.xShift);
            stream.writeInt(this.scaledXResolution);
            stream.writeInt(this.scaledYResolution);
            stream.writeInt(this.resume);
        }
    }
}

