/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.Allegrex.compiler;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.concurrent.Semaphore;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;

public class RuntimeThread
extends Thread {
    private Semaphore semaphore = new Semaphore(1);
    private SceKernelThreadInfo threadInfo;
    private boolean isInSyscall;
    private int stackSize;
    private static final int maxStackSize = 1000;

    public RuntimeThread(SceKernelThreadInfo threadInfo) {
        this.threadInfo = threadInfo;
        threadInfo.javaThreadId = this.getId();
        this.isInSyscall = false;
        if (RuntimeContext.log.isDebugEnabled()) {
            this.setName(String.format("%s_0x%X", threadInfo.name, threadInfo.uid));
        } else {
            this.setName(threadInfo.name);
        }
        this.suspendRuntimeExecution();
    }

    @Override
    public void run() {
        RuntimeContext.runThread(this);
        this.setInSyscall(true);
        ThreadMXBean threadMXBean = ManagementFactory.getThreadMXBean();
        if (threadMXBean.isThreadCpuTimeEnabled()) {
            this.threadInfo.javaThreadCpuTimeNanos = threadMXBean.getCurrentThreadCpuTime();
        }
    }

    public void suspendRuntimeExecution() {
        boolean acquired = false;
        while (!acquired) {
            try {
                this.semaphore.acquire();
                acquired = true;
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void continueRuntimeExecution() {
        this.semaphore.release();
    }

    public SceKernelThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    public boolean isInSyscall() {
        return this.isInSyscall;
    }

    public void setInSyscall(boolean isInSyscall) {
        this.isInSyscall = isInSyscall;
    }

    public void increaseStackSize() {
        ++this.stackSize;
    }

    public void decreaseStackSize() {
        --this.stackSize;
    }

    public boolean isStackMaxSize() {
        return this.stackSize > 1000;
    }

    public int getStackSize() {
        return this.stackSize;
    }

    public void onThreadStart() {
        if (this.threadInfo != null) {
            this.threadInfo.onThreadStart();
        }
    }
}

