/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.media.codec.aac;

import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jpcsp.Memory;
import jpcsp.media.codec.ICodec;
import jpcsp.media.codec.aac.AACADTSHeaderInfo;
import jpcsp.media.codec.aac.AacPs;
import jpcsp.media.codec.aac.AacPsData;
import jpcsp.media.codec.aac.AacSbr;
import jpcsp.media.codec.aac.AacTab;
import jpcsp.media.codec.aac.ChannelCoupling;
import jpcsp.media.codec.aac.ChannelElement;
import jpcsp.media.codec.aac.Context;
import jpcsp.media.codec.aac.DynamicRangeControl;
import jpcsp.media.codec.aac.IndividualChannelStream;
import jpcsp.media.codec.aac.LongTermPrediction;
import jpcsp.media.codec.aac.Lpc;
import jpcsp.media.codec.aac.MPEG4AudioConfig;
import jpcsp.media.codec.aac.PredictorState;
import jpcsp.media.codec.aac.Pulse;
import jpcsp.media.codec.aac.SingleChannelElement;
import jpcsp.media.codec.aac.TemporalNoiseShaping;
import jpcsp.media.codec.util.BitReader;
import jpcsp.media.codec.util.CodecUtils;
import jpcsp.media.codec.util.FFT;
import jpcsp.media.codec.util.FloatDSP;
import jpcsp.media.codec.util.SineWin;
import jpcsp.media.codec.util.VLC;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class AacDecoder
implements ICodec {
    public static Logger log = Logger.getLogger((String)"aac");
    public static final int AAC_ERROR = -4;
    public static final int MAX_CHANNELS = 64;
    public static final int MAX_ELEM_ID = 16;
    public static final int TNS_MAX_ORDER = 20;
    public static final int MAX_LTP_LONG_SFB = 40;
    public static final int MAX_PREDICTORS = 672;
    public static final int TYPE_SCE = 0;
    public static final int TYPE_CPE = 1;
    public static final int TYPE_CCE = 2;
    public static final int TYPE_LFE = 3;
    public static final int TYPE_DSE = 4;
    public static final int TYPE_PCE = 5;
    public static final int TYPE_FIL = 6;
    public static final int TYPE_END = 7;
    public static final int CH_FRONT_LEFT = 1;
    public static final int CH_FRONT_RIGHT = 2;
    public static final int CH_FRONT_CENTER = 4;
    public static final int CH_LOW_FREQUENCY = 8;
    public static final int CH_BACK_LEFT = 16;
    public static final int CH_BACK_RIGHT = 32;
    public static final int CH_FRONT_LEFT_OF_CENTER = 64;
    public static final int CH_FRONT_RIGHT_OF_CENTER = 128;
    public static final int CH_BACK_CENTER = 256;
    public static final int CH_SIDE_LEFT = 512;
    public static final int CH_SIDE_RIGHT = 1024;
    public static final int CH_LAYOUT_MONO = 4;
    public static final int CH_LAYOUT_STEREO = 3;
    public static final int CH_LAYOUT_SURROUND = 7;
    public static final int CH_LAYOUT_4POINT0 = 263;
    public static final int CH_LAYOUT_5POINT0_BACK = 55;
    public static final int CH_LAYOUT_5POINT1_BACK = 63;
    public static final int CH_LAYOUT_7POINT1_WIDE_BACK = 255;
    public static final int EXT_FILL = 0;
    public static final int EXT_FILL_DATA = 1;
    public static final int EXT_DATA_ELEMENT = 2;
    public static final int EXT_DYNAMIC_RANGE = 11;
    public static final int EXT_SBR_DATA = 13;
    public static final int EXT_SBR_DATA_CRC = 14;
    public static final int AAC_CHANNEL_OFF = 0;
    public static final int AAC_CHANNEL_FRONT = 1;
    public static final int AAC_CHANNEL_SIDE = 2;
    public static final int AAC_CHANNEL_BACK = 3;
    public static final int AAC_CHANNEL_LFE = 4;
    public static final int AAC_CHANNEL_CC = 5;
    public static final int AOT_AAC_MAIN = 1;
    public static final int AOT_AAC_LC = 2;
    public static final int AOT_AAC_LTP = 4;
    public static final int AOT_ER_AAC_LC = 17;
    public static final int AOT_ER_AAC_LTP = 19;
    public static final int AOT_ER_AAC_LD = 23;
    public static final int AOT_ER_AAC_ELD = 39;
    public static final int ONLY_LONG_SEQUENCE = 0;
    public static final int LONG_START_SEQUENCE = 1;
    public static final int EIGHT_SHORT_SEQUENCE = 2;
    public static final int LONG_STOP_SEQUENCE = 3;
    public static final int ZERO_BT = 0;
    public static final int FIRST_PAIR_BT = 5;
    public static final int ESC_BT = 11;
    public static final int NOISE_BT = 13;
    public static final int INTENSITY_BT2 = 14;
    public static final int INTENSITY_BT = 15;
    public static final int BEFORE_TNS = 0;
    public static final int BETWEEN_TNS_AND_IMDCT = 1;
    public static final int AFTER_IMDCT = 3;
    private static VLC vlc_scalefactors;
    private static VLC[] vlc_spectral;
    private Context ac;
    private BitReader br;
    public static final float[] ltp_coef;
    public static final float[] tns_tmp2_map_1_3;
    public static final float[] tns_tmp2_map_0_3;
    public static final float[] tns_tmp2_map_1_4;
    public static final float[] tns_tmp2_map_0_4;
    public static final float[][] tns_tmp2_map;
    public static final int[] tags_per_config;
    public static final int[][][] aac_channel_layout_map;
    public static final int[] aac_channel_layout;
    private static final double M_SQRT2 = 1.4142135623730951;
    private static final float[] cce_scale;

    private static int sampleRateIdx(int rate) {
        if (92017 <= rate) {
            return 0;
        }
        if (75132 <= rate) {
            return 1;
        }
        if (55426 <= rate) {
            return 2;
        }
        if (46009 <= rate) {
            return 3;
        }
        if (37566 <= rate) {
            return 4;
        }
        if (27713 <= rate) {
            return 5;
        }
        if (23004 <= rate) {
            return 6;
        }
        if (18783 <= rate) {
            return 7;
        }
        if (13856 <= rate) {
            return 8;
        }
        if (11502 <= rate) {
            return 9;
        }
        if (9391 <= rate) {
            return 10;
        }
        return 11;
    }

    @Override
    public int init(int bytesPerFrame, int channels, int outputChannels, int codingMode) {
        int[] layoutMapTags;
        int[][] layoutMap;
        int ret;
        int i;
        this.ac = new Context();
        this.ac.outputChannels = outputChannels;
        this.ac.oc[1].m4ac.sampleRate = 44100;
        this.ac.oc[1].m4ac.samplingIndex = AacDecoder.sampleRateIdx(this.ac.oc[1].m4ac.sampleRate);
        this.ac.channels = channels;
        this.ac.oc[1].m4ac.sbr = -1;
        this.ac.oc[1].m4ac.ps = -1;
        this.ac.oc[1].m4ac.chanConfig = 0;
        for (i = 0; i < AacTab.ff_mpeg4audio_channels.length; ++i) {
            if (AacTab.ff_mpeg4audio_channels[i] != this.ac.channels) continue;
            this.ac.oc[1].m4ac.chanConfig = i;
            break;
        }
        if (this.ac.oc[1].m4ac.chanConfig != 0 && (ret = this.setDefaultChannelConfig(layoutMap = new int[64][3], layoutMapTags = new int[1], this.ac.oc[1].m4ac.chanConfig)) == 0) {
            this.outputConfigure(layoutMap, layoutMapTags[0], 3, false);
        }
        for (i = 0; i < vlc_spectral.length; ++i) {
            AacDecoder.vlc_spectral[i] = new VLC();
            vlc_spectral[i].initVLCSparse(8, AacTab.ff_aac_spectral_sizes[i], AacTab.ff_aac_spectral_bits[i], AacTab.ff_aac_spectral_codes[i], null);
        }
        AacSbr.sbrInit();
        this.ac.randomState = 523124044;
        AacTab.tableinit();
        AacPs.init();
        AacPsData.tableinit();
        vlc_scalefactors = new VLC();
        vlc_scalefactors.initVLCSparse(7, AacTab.ff_aac_scalefactor_code.length, AacTab.ff_aac_scalefactor_bits, AacTab.ff_aac_scalefactor_code, null);
        this.ac.mdct = new FFT();
        this.ac.mdct.mdctInit(11, true, 2.9802322387695312E-8);
        this.ac.mdctLd = new FFT();
        this.ac.mdctLd.mdctInit(10, true, 5.960464477539063E-8);
        this.ac.mdctSmall = new FFT();
        this.ac.mdctSmall.mdctInit(8, true, 2.384185791015625E-7);
        this.ac.mdctLtp = new FFT();
        this.ac.mdctLtp.mdctInit(11, false, -65536.0);
        SineWin.initFfSineWindows();
        return 0;
    }

    private static int lcgRandom(int previousVal) {
        return previousVal * 1664525 + 1013904223;
    }

    private int setDefaultChannelConfig(int[][] layoutMap, int[] tags, int channelConfig) {
        if (channelConfig < 1 || channelConfig > 7) {
            log.error((Object)String.format("invalid default channel configuration (%d)", channelConfig));
            return -4;
        }
        tags[0] = tags_per_config[channelConfig];
        for (int i = 0; i < tags[0]; ++i) {
            Utilities.copy(layoutMap[i], aac_channel_layout_map[channelConfig - 1][i]);
        }
        return 0;
    }

    private int parseAdtsFrameHeader() {
        AACADTSHeaderInfo hdrInfo = new AACADTSHeaderInfo();
        int[][] layoutMap = new int[64][3];
        int[] layoutMapTabs = new int[1];
        int size = hdrInfo.parse(this.br);
        if (size > 0) {
            if (hdrInfo.numAacFrames != 1) {
                log.warn((Object)String.format("More than one AAC RDB per ADTS frame", new Object[0]));
            }
            this.pushOutputConfiguration();
            if (hdrInfo.chanConfig != 0) {
                this.ac.oc[1].m4ac.chanConfig = hdrInfo.chanConfig;
                int ret = this.setDefaultChannelConfig(layoutMap, layoutMapTabs, hdrInfo.chanConfig);
                if (ret < 0) {
                    return ret;
                }
                ret = this.outputConfigure(layoutMap, layoutMapTabs[0], Math.max(this.ac.oc[1].status, 2), false);
                if (ret < 0) {
                    return ret;
                }
            } else {
                this.ac.oc[1].m4ac.chanConfig = 0;
                if (this.ac.dmonoMode != 0 && this.ac.oc[0].status == 0) {
                    int layoutMapTags = 2;
                    layoutMap[0][0] = 0;
                    layoutMap[1][0] = 0;
                    layoutMap[0][2] = 1;
                    layoutMap[1][0] = 1;
                    layoutMap[0][1] = 0;
                    layoutMap[1][1] = 1;
                    if (this.outputConfigure(layoutMap, layoutMapTags, 2, false) != 0) {
                        return -4;
                    }
                }
            }
            this.ac.oc[1].m4ac.sampleRate = hdrInfo.sampleRate;
            this.ac.oc[1].m4ac.samplingIndex = hdrInfo.samplingIndex;
            this.ac.oc[1].m4ac.objectType = hdrInfo.objectType;
            if (this.ac.oc[0].status != 4 || this.ac.oc[0].m4ac.chanConfig != hdrInfo.chanConfig || this.ac.oc[0].m4ac.sampleRate != hdrInfo.sampleRate) {
                this.ac.oc[1].m4ac.sbr = -1;
                this.ac.oc[1].m4ac.ps = -1;
            }
            if (!hdrInfo.crcAbsent) {
                this.br.skip(16);
            }
        }
        return size;
    }

    private int frameConfigureElements() {
        for (int type = 0; type < 4; ++type) {
            for (int id = 0; id < 16; ++id) {
                ChannelElement che = this.ac.che[type][id];
                if (che == null) continue;
                che.ch[0].ret = che.ch[0].retBuf;
                che.ch[1].ret = che.ch[1].retBuf;
            }
        }
        if (this.ac.channels == 0) {
            return 1;
        }
        this.ac.nbSamples = 2048;
        for (int ch = 0; ch < this.ac.channels; ++ch) {
            if (this.ac.outputElement[ch] == null) continue;
            this.ac.outputElement[ch].ret = this.ac.samples[ch];
        }
        return 0;
    }

    private ChannelElement getChe(int type, int elemId) {
        int[] layoutMapTags;
        int[][] layoutMap;
        if (this.ac.oc[1].m4ac.chanConfig == 0) {
            return this.ac.tagCheMap[type][elemId];
        }
        if (this.ac.tagsMapped == 0 && type == 1 && this.ac.oc[1].m4ac.chanConfig == 1) {
            layoutMap = new int[64][3];
            layoutMapTags = new int[1];
            this.pushOutputConfiguration();
            if (this.setDefaultChannelConfig(layoutMap, layoutMapTags, 2) < 0) {
                return null;
            }
            if (this.outputConfigure(layoutMap, layoutMapTags[0], 2, true) < 0) {
                return null;
            }
            this.ac.oc[1].m4ac.chanConfig = 2;
            this.ac.oc[1].m4ac.ps = 0;
        }
        if (this.ac.tagsMapped == 0 && type == 0 && this.ac.oc[1].m4ac.chanConfig == 2) {
            layoutMap = new int[64][3];
            layoutMapTags = new int[1];
            this.pushOutputConfiguration();
            if (this.setDefaultChannelConfig(layoutMap, layoutMapTags, 1) < 0) {
                return null;
            }
            if (this.outputConfigure(layoutMap, layoutMapTags[0], 2, true) < 0) {
                return null;
            }
            this.ac.oc[1].m4ac.chanConfig = 1;
            if (this.ac.oc[1].m4ac.sbr != 0) {
                this.ac.oc[1].m4ac.ps = -1;
            }
        }
        switch (this.ac.oc[1].m4ac.chanConfig) {
            case 7: {
                if (this.ac.tagsMapped == 3 && type == 1) {
                    ++this.ac.tagsMapped;
                    ChannelElement channelElement = this.ac.che[1][2];
                    this.ac.tagCheMap[1][elemId] = channelElement;
                    return channelElement;
                }
            }
            case 6: {
                if (this.ac.tagsMapped == tags_per_config[this.ac.oc[1].m4ac.chanConfig] - 1 && (type == 3 || type == 0)) {
                    ++this.ac.tagsMapped;
                    ChannelElement channelElement = this.ac.che[3][0];
                    this.ac.tagCheMap[type][elemId] = channelElement;
                    return channelElement;
                }
            }
            case 5: {
                if (this.ac.tagsMapped == 2 && type == 1) {
                    ++this.ac.tagsMapped;
                    ChannelElement channelElement = this.ac.che[1][1];
                    this.ac.tagCheMap[1][elemId] = channelElement;
                    return channelElement;
                }
            }
            case 4: {
                if (this.ac.tagsMapped == 2 && this.ac.oc[1].m4ac.chanConfig == 4 && type == 0) {
                    ++this.ac.tagsMapped;
                    ChannelElement channelElement = this.ac.che[0][1];
                    this.ac.tagCheMap[0][elemId] = channelElement;
                    return channelElement;
                }
            }
            case 2: 
            case 3: {
                if (this.ac.tagsMapped == (this.ac.oc[1].m4ac.chanConfig != 2 ? 1 : 0) && type == 1) {
                    ++this.ac.tagsMapped;
                    ChannelElement channelElement = this.ac.che[1][0];
                    this.ac.tagCheMap[1][elemId] = channelElement;
                    return channelElement;
                }
                if (this.ac.oc[1].m4ac.chanConfig == 2) {
                    return null;
                }
            }
            case 1: {
                if (this.ac.tagsMapped != 0 || type != 0) break;
                ++this.ac.tagsMapped;
                ChannelElement channelElement = this.ac.che[0][0];
                this.ac.tagCheMap[0][elemId] = channelElement;
                return channelElement;
            }
        }
        return null;
    }

    private int decodePrediction(IndividualChannelStream ics) {
        if (this.br.readBool()) {
            ics.predictorResetGroup = this.br.read(5);
            if (ics.predictorResetGroup == 0 || ics.predictorResetGroup > 30) {
                log.error((Object)String.format("Invalid Predictor Reset Group", new Object[0]));
                return -4;
            }
        }
        for (int sfb = 0; sfb < Math.min(ics.maxSfb, AacTab.ff_aac_pred_sfb_max[this.ac.oc[1].m4ac.samplingIndex]); ++sfb) {
            ics.predictionUsed[sfb] = this.br.readBool();
        }
        return 0;
    }

    private void decodeLtp(LongTermPrediction ltp, int maxSfb) {
        ltp.lag = this.br.read(11);
        ltp.coef = ltp_coef[this.br.read(3)];
        for (int sfb = 0; sfb < Math.min(maxSfb, 40); ++sfb) {
            ltp.used[sfb] = this.br.readBool();
        }
    }

    private int decodeIcsInfo(IndividualChannelStream ics) {
        int aot = this.ac.oc[1].m4ac.objectType;
        if (aot != 39) {
            if (this.br.readBool()) {
                log.error((Object)String.format("Reserved bit set", new Object[0]));
                return -4;
            }
            ics.windowSequence[1] = ics.windowSequence[0];
            ics.windowSequence[0] = this.br.read(2);
            if (aot == 23 && ics.windowSequence[0] != 0) {
                log.error((Object)String.format("AAC LD is only defined for ONLY_LONG_SEQUENCE but window sequence %d found", ics.windowSequence[0]));
                ics.windowSequence[0] = 0;
                return -4;
            }
            ics.useKbWindow[1] = ics.useKbWindow[0];
            ics.useKbWindow[0] = this.br.readBool();
        }
        ics.numWindowGroups = 1;
        ics.groupLen[0] = 1;
        if (ics.windowSequence[0] == 2) {
            ics.maxSfb = this.br.read(4);
            for (int i = 0; i < 7; ++i) {
                if (this.br.readBool()) {
                    int n = ics.numWindowGroups - 1;
                    ics.groupLen[n] = ics.groupLen[n] + 1;
                    continue;
                }
                ++ics.numWindowGroups;
                ics.groupLen[ics.numWindowGroups - 1] = 1;
            }
            ics.numWindows = 8;
            ics.swbOffset = AacTab.ff_swb_offset_128[this.ac.oc[1].m4ac.samplingIndex];
            ics.numSwb = AacTab.ff_aac_num_swb_128[this.ac.oc[1].m4ac.samplingIndex];
            ics.tnsMaxBands = AacTab.ff_tns_max_bands_128[this.ac.oc[1].m4ac.samplingIndex];
            ics.predictorPresent = false;
        } else {
            ics.maxSfb = this.br.read(6);
            ics.numWindows = 1;
            if (aot == 23 || aot == 39) {
                ics.swbOffset = AacTab.ff_swb_offset_512[this.ac.oc[1].m4ac.samplingIndex];
                ics.numSwb = AacTab.ff_aac_num_swb_512[this.ac.oc[1].m4ac.samplingIndex];
                ics.tnsMaxBands = AacTab.ff_tns_max_bands_512[this.ac.oc[1].m4ac.samplingIndex];
                if (ics.numSwb == 0 || ics.swbOffset == null) {
                    return -4;
                }
            } else {
                ics.swbOffset = AacTab.ff_swb_offset_1024[this.ac.oc[1].m4ac.samplingIndex];
                ics.numSwb = AacTab.ff_aac_num_swb_1024[this.ac.oc[1].m4ac.samplingIndex];
                ics.tnsMaxBands = AacTab.ff_tns_max_bands_1024[this.ac.oc[1].m4ac.samplingIndex];
            }
            if (aot != 39) {
                ics.predictorPresent = this.br.readBool();
                ics.predictorResetGroup = 0;
            }
            if (ics.predictorPresent) {
                if (aot == 1) {
                    if (this.decodePrediction(ics) != 0) {
                        ics.maxSfb = 0;
                        return -4;
                    }
                } else {
                    if (aot == 2 || aot == 17) {
                        log.error((Object)String.format("Prediction is not allowed in AAC-LC", new Object[0]));
                        ics.maxSfb = 0;
                        return -4;
                    }
                    if (aot == 23) {
                        log.error((Object)String.format("LTP in ER AAC LD not yet implemented", new Object[0]));
                        return -4;
                    }
                    ics.ltp.present = this.br.readBool();
                    if (ics.ltp.present) {
                        this.decodeLtp(ics.ltp, ics.maxSfb);
                    }
                }
            }
        }
        if (ics.maxSfb > ics.numSwb) {
            log.error((Object)String.format("Number of scalefactor bands in group (%d) exceeds limit (%d)", ics.maxSfb, ics.numSwb));
            ics.maxSfb = 0;
            return -4;
        }
        return 0;
    }

    private int decodeBandTypes(int[] bandType, int[] bandTypeRunEnd, IndividualChannelStream ics) {
        int idx = 0;
        int bits = ics.windowSequence[0] == 2 ? 3 : 5;
        for (int g = 0; g < ics.numWindowGroups; ++g) {
            int k = 0;
            while (k < ics.maxSfb) {
                int sectLenIncr;
                int sectEnd = k;
                int sectBandType = this.br.read(4);
                if (sectBandType == 12) {
                    log.error((Object)String.format("invalid band type", new Object[0]));
                    return -4;
                }
                do {
                    sectLenIncr = this.br.read(bits);
                    sectEnd += sectLenIncr;
                    if (this.br.getBitsLeft() < 0) {
                        log.error((Object)String.format("decodeBandTypes overread error", new Object[0]));
                        return -4;
                    }
                    if (sectEnd <= ics.maxSfb) continue;
                    log.error((Object)String.format("Number of bands (%d) exceeds limit (%d)", sectEnd, ics.maxSfb));
                    return -4;
                } while (sectLenIncr == (1 << bits) - 1);
                while (k < sectEnd) {
                    bandType[idx] = sectBandType;
                    bandTypeRunEnd[idx++] = sectEnd;
                    ++k;
                }
            }
        }
        return 0;
    }

    private int decodeScalefactors(float[] sf, int globalGain, IndividualChannelStream ics, int[] bandType, int[] bandTypeRunEnd) {
        int idx = 0;
        int[] offset = new int[]{globalGain, globalGain - 90, 0};
        boolean noiseFlag = true;
        for (int g = 0; g < ics.numWindowGroups; ++g) {
            int i = 0;
            while (i < ics.maxSfb) {
                int clippedOffset;
                int runEnd = bandTypeRunEnd[idx];
                if (bandType[idx] == 0) {
                    while (i < runEnd) {
                        sf[idx] = 0.0f;
                        ++i;
                        ++idx;
                    }
                    continue;
                }
                if (bandType[idx] == 15 || bandType[idx] == 14) {
                    while (i < runEnd) {
                        offset[2] = offset[2] + (vlc_scalefactors.getVLC2(this.br, 3) - 60);
                        clippedOffset = Utilities.clip(offset[2], -155, 100);
                        if (offset[2] != clippedOffset) {
                            log.warn((Object)String.format("Clipped intensity stereo position (%d -> %d)", offset[2], clippedOffset));
                        }
                        sf[idx] = AacTab.ff_aac_pow2sf_tab[-clippedOffset + 200];
                        ++i;
                        ++idx;
                    }
                    continue;
                }
                if (bandType[idx] == 13) {
                    while (i < runEnd) {
                        if (noiseFlag) {
                            offset[1] = offset[1] + (this.br.read(9) - 256);
                            noiseFlag = false;
                        } else {
                            offset[1] = offset[1] + (vlc_scalefactors.getVLC2(this.br, 3) - 60);
                        }
                        clippedOffset = Utilities.clip(offset[1], -100, 155);
                        if (offset[1] != clippedOffset) {
                            log.warn((Object)String.format("Clipped intensity stereo position (%d -> %d)", offset[1], clippedOffset));
                        }
                        sf[idx] = -AacTab.ff_aac_pow2sf_tab[clippedOffset + 200];
                        ++i;
                        ++idx;
                    }
                    continue;
                }
                while (i < runEnd) {
                    offset[0] = offset[0] + (vlc_scalefactors.getVLC2(this.br, 3) - 60);
                    if (offset[0] > 255) {
                        log.error((Object)String.format("Scalefactor (%d) out of range", offset[0]));
                        return -4;
                    }
                    sf[idx] = -AacTab.ff_aac_pow2sf_tab[offset[0] - 100 + 200];
                    ++i;
                    ++idx;
                }
            }
        }
        return 0;
    }

    private int decodePulses(Pulse pulse, int[] swbOffset, int numSwb) {
        pulse.numPulse = this.br.read(2) + 1;
        int pulseSwb = this.br.read(6);
        if (pulseSwb >= numSwb) {
            return -1;
        }
        pulse.pos[0] = swbOffset[pulseSwb];
        pulse.pos[0] = pulse.pos[0] + this.br.read(5);
        if (pulse.pos[0] >= swbOffset[numSwb]) {
            return -1;
        }
        pulse.amp[0] = this.br.read(4);
        for (int i = 1; i < pulse.numPulse; ++i) {
            pulse.pos[i] = this.br.read(5) + pulse.pos[i - 1];
            if (pulse.pos[i] >= swbOffset[numSwb]) {
                return -1;
            }
            pulse.amp[i] = this.br.read(4);
        }
        return 0;
    }

    private int decodeTns(TemporalNoiseShaping tns, IndividualChannelStream ics) {
        int is8;
        int n = is8 = ics.windowSequence[0] == 2 ? 1 : 0;
        int tnsMaxOrder = is8 != 0 ? 7 : (this.ac.oc[1].m4ac.objectType == 1 ? 20 : 12);
        for (int w = 0; w < ics.numWindows; ++w) {
            tns.nFilt[w] = this.br.read(2 - is8);
            if (tns.nFilt[w] == 0) continue;
            int coefRes = this.br.read1();
            for (int filt = 0; filt < tns.nFilt[w]; ++filt) {
                tns.length[w][filt] = this.br.read(6 - 2 * is8);
                tns.order[w][filt] = this.br.read(5 - 2 * is8);
                if (tns.order[w][filt] > tnsMaxOrder) {
                    log.error((Object)String.format("TNS filter order %d is greater than maximum %d", tns.order[w][filt], tnsMaxOrder));
                    tns.order[w][filt] = 0;
                    return -4;
                }
                if (tns.order[w][filt] <= 0) continue;
                tns.direction[w][filt] = this.br.readBool();
                int coefCompress = this.br.read1();
                int coefLen = coefRes + 3 - coefCompress;
                int tmp2Idx = 2 * coefCompress + coefRes;
                for (int i = 0; i < tns.order[w][filt]; ++i) {
                    tns.coef[w][filt][i] = tns_tmp2_map[tmp2Idx][this.br.read(coefLen)];
                }
            }
        }
        return 0;
    }

    private static int VMUL2(float[] dst, int dstOffset, float[] v, int vOffset, int idx, float scale) {
        dst[dstOffset++] = v[vOffset + (idx & 0xF)] * scale;
        dst[dstOffset++] = v[vOffset + (idx >> 4 & 0xF)] * scale;
        return dstOffset;
    }

    private static int VMUL4(float[] dst, int dstOffset, float[] v, int vOffset, int idx, float scale) {
        dst[dstOffset++] = v[vOffset + (idx & 3)] * scale;
        dst[dstOffset++] = v[vOffset + (idx >> 2 & 3)] * scale;
        dst[dstOffset++] = v[vOffset + (idx >> 4 & 3)] * scale;
        dst[dstOffset++] = v[vOffset + (idx >> 6 & 3)] * scale;
        return dstOffset;
    }

    private static int VMUL2S(float[] dst, int dstOffset, float[] v, int vOffset, int idx, int sign, float scale) {
        int s0 = Float.floatToRawIntBits(scale);
        int s1 = Float.floatToRawIntBits(scale);
        dst[dstOffset++] = v[vOffset + (idx & 0xF)] * Float.intBitsToFloat(s0 ^= sign >> 1 << 31);
        dst[dstOffset++] = v[vOffset + (idx >> 4 & 0xF)] * Float.intBitsToFloat(s1 ^= sign << 31);
        return dstOffset;
    }

    private static int VMUL4S(float[] dst, int dstOffset, float[] v, int vOffset, int idx, int sign, float scale) {
        int nz = idx >>> 12;
        int s = Float.floatToRawIntBits(scale);
        int t = s ^ sign & Integer.MIN_VALUE;
        dst[dstOffset++] = v[vOffset + (idx & 3)] * Float.intBitsToFloat(t);
        sign <<= nz & 1;
        t = s ^ sign & Integer.MIN_VALUE;
        dst[dstOffset++] = v[vOffset + (idx >> 2 & 3)] * Float.intBitsToFloat(t);
        t = s ^ (sign <<= (nz >>= 1) & 1) & Integer.MIN_VALUE;
        dst[dstOffset++] = v[vOffset + (idx >> 4 & 3)] * Float.intBitsToFloat(t);
        t = s ^ (sign <<= (nz >>= 1) & 1) & Integer.MIN_VALUE;
        dst[dstOffset++] = v[vOffset + (idx >> 6 & 3)] * Float.intBitsToFloat(t);
        return dstOffset;
    }

    private int decodeSpectrumAndDequant(float[] coef, float[] sf, boolean pulsePresent, Pulse pulse, IndividualChannelStream ics, int[] bandType) {
        int idx = 0;
        int c = 1024 / ics.numWindows;
        int[] offsets = ics.swbOffset;
        for (int g = 0; g < ics.numWindows; ++g) {
            Arrays.fill(coef, g * 128 + offsets[ics.maxSfb], g * 128 + c, 0.0f);
        }
        int coefOffset = 0;
        for (int g = 0; g < ics.numWindowGroups; ++g) {
            int gLen = ics.groupLen[g];
            int i = 0;
            while (i < ics.maxSfb) {
                int cbtM1 = bandType[idx] == 0 ? Integer.MAX_VALUE : bandType[idx] - 1;
                int cfo = coefOffset + offsets[i];
                int offLen = offsets[i + 1] - offsets[i];
                if (cbtM1 >= 13) {
                    int group = 0;
                    while (group < gLen) {
                        Arrays.fill(coef, cfo, cfo + offLen, 0.0f);
                        ++group;
                        cfo += 128;
                    }
                } else if (cbtM1 == 12) {
                    int group = 0;
                    while (group < gLen) {
                        for (int k = 0; k < offLen; ++k) {
                            this.ac.randomState = AacDecoder.lcgRandom(this.ac.randomState);
                            coef[cfo + k] = this.ac.randomState;
                        }
                        float bandEnergy = FloatDSP.scalarproduct(coef, cfo, coef, cfo, offLen);
                        float scale = sf[idx] / (float)Math.sqrt(bandEnergy);
                        FloatDSP.vectorFmulScalar(coef, cfo, coef, cfo, scale, offLen);
                        ++group;
                        cfo += 128;
                    }
                } else {
                    float[] vq = AacTab.ff_aac_codebook_vector_vals[cbtM1];
                    int[] cbVertexIdx = AacTab.ff_aac_codebook_vector_idx[cbtM1];
                    VLC vlc = vlc_spectral[cbtM1];
                    switch (cbtM1 >> 1) {
                        case 0: {
                            int cbIdx;
                            int code;
                            int len;
                            int cf;
                            int group = 0;
                            while (group < gLen) {
                                cf = cfo;
                                for (len = offLen; len != 0; len -= 4) {
                                    code = vlc.getVLC2(this.br, 2);
                                    cbIdx = cbVertexIdx[code];
                                    cf = AacDecoder.VMUL4(coef, cf, vq, 0, cbIdx, sf[idx]);
                                }
                                ++group;
                                cfo += 128;
                            }
                            break;
                        }
                        case 1: {
                            int nnz;
                            int cbIdx;
                            int code;
                            int len;
                            int cf;
                            int group = 0;
                            while (group < gLen) {
                                cf = cfo;
                                for (len = offLen; len != 0; len -= 4) {
                                    code = vlc.getVLC2(this.br, 2);
                                    cbIdx = cbVertexIdx[code];
                                    nnz = cbIdx >> 8 & 0xF;
                                    int bits = nnz != 0 ? this.br.peek(32) : 0;
                                    this.br.skip(nnz);
                                    cf = AacDecoder.VMUL4S(coef, cf, vq, 0, cbIdx, bits, sf[idx]);
                                }
                                ++group;
                                cfo += 128;
                            }
                            break;
                        }
                        case 2: {
                            int cbIdx;
                            int code;
                            int len;
                            int cf;
                            int group = 0;
                            while (group < gLen) {
                                cf = cfo;
                                for (len = offLen; len != 0; len -= 2) {
                                    code = vlc.getVLC2(this.br, 2);
                                    cbIdx = cbVertexIdx[code];
                                    cf = AacDecoder.VMUL2(coef, cf, vq, 0, cbIdx, sf[idx]);
                                }
                                ++group;
                                cfo += 128;
                            }
                            break;
                        }
                        case 3: 
                        case 4: {
                            int nnz;
                            int cbIdx;
                            int code;
                            int len;
                            int cf;
                            int group = 0;
                            while (group < gLen) {
                                cf = cfo;
                                for (len = offLen; len != 0; len -= 2) {
                                    code = vlc.getVLC2(this.br, 2);
                                    cbIdx = cbVertexIdx[code];
                                    nnz = cbIdx >> 8 & 0xF;
                                    int sign = nnz != 0 ? this.br.peek(nnz) << (cbIdx >> 12) : 0;
                                    this.br.skip(nnz);
                                    cf = AacDecoder.VMUL2S(coef, cf, vq, 0, cbIdx, sign, sf[idx]);
                                }
                                ++group;
                                cfo += 128;
                            }
                            break;
                        }
                        default: {
                            int nnz;
                            int cbIdx;
                            int code;
                            int len;
                            int group = 0;
                            while (group < gLen) {
                                int icf = cfo;
                                for (len = offLen; len != 0; len -= 2) {
                                    code = vlc.getVLC2(this.br, 2);
                                    if (code == 0) {
                                        coef[icf++] = 0.0f;
                                        coef[icf++] = 0.0f;
                                        continue;
                                    }
                                    cbIdx = cbVertexIdx[code];
                                    nnz = cbIdx >> 12;
                                    int nzt = cbIdx >> 8;
                                    int bits = this.br.read(nnz) << 32 - nnz;
                                    for (int j = 0; j < 2; ++j) {
                                        if ((nzt & 1 << j) != 0) {
                                            int b = this.br.peek(32);
                                            if ((b = 31 - CodecUtils.avLog2(~b)) > 8) {
                                                log.error((Object)String.format("error in spectral data, ESC overflow", new Object[0]));
                                                return -4;
                                            }
                                            this.br.skip(b + 1);
                                            int n = (1 << (b += 4)) + this.br.read(b);
                                            coef[icf++] = Float.intBitsToFloat(AacTab.cbrt_tab[n] | bits & Integer.MIN_VALUE);
                                            bits <<= 1;
                                        } else {
                                            float v = vq[cbIdx & 0xF];
                                            if (v == 0.0f) {
                                                coef[icf++] = 0.0f;
                                            } else {
                                                if ((bits & Integer.MIN_VALUE) != 0) {
                                                    v = -v;
                                                }
                                                coef[icf++] = v;
                                                bits <<= 1;
                                            }
                                        }
                                        cbIdx >>= 4;
                                    }
                                }
                                FloatDSP.vectorFmulScalar(coef, cfo, coef, cfo, sf[idx], offLen);
                                ++group;
                                cfo += 128;
                            }
                            break block0;
                        }
                    }
                }
                ++i;
                ++idx;
            }
            coefOffset += gLen << 7;
        }
        if (pulsePresent) {
            idx = 0;
            for (int i = 0; i < pulse.numPulse; ++i) {
                float co = coef[pulse.pos[i]];
                while (offsets[idx + 1] <= pulse.pos[i]) {
                    ++idx;
                }
                if (bandType[idx] == 13 || sf[idx] == 0.0f) continue;
                float ico = -pulse.amp[i];
                if (co != 0.0f) {
                    ico = (co /= sf[idx]) / (float)Math.sqrt(Math.sqrt(Math.abs(co))) + (co > 0.0f ? -ico : ico);
                }
                coef[pulse.pos[i]] = (float)Math.cbrt(Math.abs(ico)) * ico * sf[idx];
            }
        }
        return 0;
    }

    private void resetPredictState(PredictorState ps) {
        ps.r0 = 0.0f;
        ps.r1 = 0.0f;
        ps.cor0 = 0.0f;
        ps.cor1 = 0.0f;
        ps.var0 = 1.0f;
        ps.var1 = 1.0f;
    }

    private void resetAllPredictors(PredictorState[] ps) {
        for (int i = 0; i < 672; ++i) {
            this.resetPredictState(ps[i]);
        }
    }

    private void resetPredictorGroup(PredictorState[] ps, int groupNum) {
        for (int i = groupNum - 1; i < 672; i += 30) {
            this.resetPredictState(ps[i]);
        }
    }

    private static float flt16Round(float pf) {
        int i = Float.floatToRawIntBits(pf);
        i = i + 32768 & 0xFFFF0000;
        return Float.intBitsToFloat(i);
    }

    private static float flt16Even(float pf) {
        int i = Float.floatToRawIntBits(pf);
        i = i + Short.MAX_VALUE + ((i & 0x10000) >> 16) & 0xFFFF0000;
        return Float.intBitsToFloat(i);
    }

    private static float flt16Trunc(float pf) {
        int i = Float.floatToRawIntBits(pf);
        return Float.intBitsToFloat(i &= 0xFFFF0000);
    }

    private void predict(PredictorState ps, float[] coef, int coefOffset, boolean outputEnable) {
        float a = 0.953125f;
        float alpha = 0.90625f;
        float r0 = ps.r0;
        float r1 = ps.r1;
        float cor0 = ps.cor0;
        float cor1 = ps.cor1;
        float var0 = ps.var0;
        float var1 = ps.var1;
        float k1 = var0 > 1.0f ? cor0 * AacDecoder.flt16Even(0.953125f / var0) : 0.0f;
        float k2 = var1 > 1.0f ? cor1 * AacDecoder.flt16Even(0.953125f / var1) : 0.0f;
        float pv = AacDecoder.flt16Round(k1 * r0 + k2 * r1);
        if (outputEnable) {
            int n = coefOffset;
            coef[n] = coef[n] + pv;
        }
        float e0 = coef[coefOffset];
        float e1 = e0 - k1 * r0;
        ps.cor1 = AacDecoder.flt16Trunc(0.90625f * cor1 + r1 * e1);
        ps.var1 = AacDecoder.flt16Trunc(0.90625f * var1 + 0.5f * (r1 * r1 + e1 * e1));
        ps.cor0 = AacDecoder.flt16Trunc(0.90625f * cor0 + r0 * e0);
        ps.var0 = AacDecoder.flt16Trunc(0.90625f * var0 + 0.5f * (r0 * r0 + e0 * e0));
        ps.r1 = AacDecoder.flt16Trunc(0.953125f * (r0 - k1 * e0));
        ps.r0 = AacDecoder.flt16Trunc(0.953125f * e0);
    }

    private void applyPrediction(SingleChannelElement sce) {
        if (!sce.ics.predictorInitialized) {
            this.resetAllPredictors(sce.predictorState);
            sce.ics.predictorInitialized = true;
        }
        if (sce.ics.windowSequence[0] != 2) {
            for (int sfb = 0; sfb < AacTab.ff_aac_pred_sfb_max[this.ac.oc[1].m4ac.samplingIndex]; ++sfb) {
                for (int k = sce.ics.swbOffset[sfb]; k < sce.ics.swbOffset[sfb + 1]; ++k) {
                    this.predict(sce.predictorState[k], sce.coeffs, k, sce.ics.predictorPresent && sce.ics.predictionUsed[sfb]);
                }
            }
            if (sce.ics.predictorResetGroup != 0) {
                this.resetPredictorGroup(sce.predictorState, sce.ics.predictorResetGroup);
            }
        } else {
            this.resetAllPredictors(sce.predictorState);
        }
    }

    private int decodeIcs(SingleChannelElement sce, boolean commonWindow, boolean scaleFlag) {
        Pulse pulse = new Pulse();
        TemporalNoiseShaping tns = sce.tns;
        IndividualChannelStream ics = sce.ics;
        float[] out = sce.coeffs;
        boolean eldSyntax = this.ac.oc[1].m4ac.objectType == 39;
        boolean erSyntax = this.ac.oc[1].m4ac.objectType == 17 || this.ac.oc[1].m4ac.objectType == 19 || this.ac.oc[1].m4ac.objectType == 23 || this.ac.oc[1].m4ac.objectType == 39;
        int globalGain = this.br.read(8);
        if (!commonWindow && !scaleFlag && this.decodeIcsInfo(ics) < 0) {
            return -4;
        }
        int ret = this.decodeBandTypes(sce.bandType, sce.bandTypeRunEnd, ics);
        if (ret < 0) {
            return ret;
        }
        ret = this.decodeScalefactors(sce.sf, globalGain, ics, sce.bandType, sce.bandTypeRunEnd);
        if (ret < 0) {
            return ret;
        }
        boolean pulsePresent = false;
        if (!scaleFlag) {
            if (!eldSyntax && (pulsePresent = this.br.readBool())) {
                if (ics.windowSequence[0] == 2) {
                    log.error((Object)String.format("Pulse tool not allowed in eight short sequence", new Object[0]));
                    return -4;
                }
                if (this.decodePulses(pulse, ics.swbOffset, ics.numSwb) != 0) {
                    log.error((Object)String.format("Pulse data corrupt or invalid", new Object[0]));
                    return -4;
                }
            }
            tns.present = this.br.readBool();
            if (tns.present && !erSyntax && this.decodeTns(tns, ics) < 0) {
                return -4;
            }
            if (!eldSyntax && this.br.readBool()) {
                return -4;
            }
            if (tns.present && erSyntax && this.decodeTns(tns, ics) < 0) {
                return -4;
            }
        }
        if (this.decodeSpectrumAndDequant(out, sce.sf, pulsePresent, pulse, ics, sce.bandType) < 0) {
            return -4;
        }
        if (this.ac.oc[1].m4ac.objectType == 1 && !commonWindow) {
            this.applyPrediction(sce);
        }
        return 0;
    }

    private void decodeChannelMap(int[][] layoutMap, int layoutMapOffset, int type, int n) {
        while (n-- != 0) {
            int synEle;
            switch (type) {
                case 1: 
                case 2: 
                case 3: {
                    synEle = this.br.read1();
                    break;
                }
                case 5: {
                    this.br.skip(1);
                    synEle = 2;
                    break;
                }
                case 4: {
                    synEle = 3;
                    break;
                }
                default: {
                    log.error((Object)String.format("decodeChannelMap invalid type %d", type));
                    return;
                }
            }
            layoutMap[layoutMapOffset][0] = synEle;
            layoutMap[layoutMapOffset][1] = this.br.read(4);
            layoutMap[layoutMapOffset][2] = type;
            ++layoutMapOffset;
        }
    }

    private int decodePce(MPEG4AudioConfig m4ac, int[][] layoutMap) {
        this.br.skip(2);
        int samplingIndex = this.br.read(4);
        if (m4ac.samplingIndex != samplingIndex) {
            log.warn((Object)String.format("Sample rate index in program config element does not match the sample rate index configured by the container", new Object[0]));
        }
        int numFront = this.br.read(4);
        int numSide = this.br.read(4);
        int numBack = this.br.read(4);
        int numLfe = this.br.read(2);
        int numAssocData = this.br.read(3);
        int numCc = this.br.read(4);
        if (this.br.readBool()) {
            this.br.skip(4);
        }
        if (this.br.readBool()) {
            this.br.skip(4);
        }
        if (this.br.readBool()) {
            this.br.skip(3);
        }
        if (this.br.getBitsLeft() < 4 * (numFront + numSide + numBack + numLfe + numAssocData + numCc)) {
            log.error((Object)String.format("decode_pce: overread error", new Object[0]));
            return -4;
        }
        this.decodeChannelMap(layoutMap, 0, 1, numFront);
        int tags = numFront;
        this.decodeChannelMap(layoutMap, tags, 2, numSide);
        this.decodeChannelMap(layoutMap, tags += numSide, 3, numBack);
        this.decodeChannelMap(layoutMap, tags += numBack, 4, numLfe);
        this.br.skip(4 * numAssocData);
        this.decodeChannelMap(layoutMap, tags += numLfe, 5, numCc);
        tags += numCc;
        this.br.byteAlign();
        int commentLen = this.br.read(8) * 8;
        if (this.br.getBitsLeft() < commentLen) {
            log.error((Object)String.format("decode_pce: overread error", new Object[0]));
            return -4;
        }
        this.br.skip(commentLen);
        return tags;
    }

    private void pushOutputConfiguration() {
        if (this.ac.oc[1].status == 4) {
            this.ac.oc[0].copy(this.ac.oc[1]);
        }
        this.ac.oc[1].status = 0;
    }

    private void popOutputConfiguration() {
        if (this.ac.oc[1].status != 4 && this.ac.oc[0].status != 0) {
            this.ac.oc[1].copy(this.ac.oc[0]);
            this.ac.channels = this.ac.oc[1].channels;
            this.outputConfigure(this.ac.oc[1].layoutMap, this.ac.oc[1].layoutMapTags, this.ac.oc[1].status, false);
        }
    }

    private int assignPair(ElemToChannel[] e2cVec, int[][] layoutMap, int offset, int left, int right, int pos) {
        if (layoutMap[offset][0] == 1) {
            e2cVec[offset] = new ElemToChannel(left | right, 1, layoutMap[offset][1], pos);
            return 1;
        }
        e2cVec[offset] = new ElemToChannel(left, 0, layoutMap[offset][1], pos);
        e2cVec[offset + 1] = new ElemToChannel(right, 0, layoutMap[offset + 1][1], pos);
        return 2;
    }

    private int countPairedChannels(int[][] layoutMap, int tags, int pos, int[] current) {
        int i;
        int numPosChannels = 0;
        boolean firstCpe = false;
        boolean sceParity = false;
        for (i = current[0]; i < tags && layoutMap[i][2] == pos; ++i) {
            if (layoutMap[i][0] == 1) {
                if (sceParity) {
                    if (pos == 1 && !firstCpe) {
                        sceParity = false;
                    } else {
                        return -1;
                    }
                }
                numPosChannels += 2;
                firstCpe = true;
                continue;
            }
            ++numPosChannels;
            sceParity = !sceParity;
        }
        if (sceParity && (pos == 1 && firstCpe || pos == 2)) {
            return -1;
        }
        current[0] = i;
        return numPosChannels;
    }

    private int sniffChannelOrder(int[][] layoutMap, int tags) {
        int nextN;
        ElemToChannel[] e2cVec = new ElemToChannel[64];
        if (e2cVec.length < tags) {
            return 0;
        }
        int[] ii = new int[]{0};
        int numFrontChannels = this.countPairedChannels(layoutMap, tags, 1, ii);
        if (numFrontChannels < 0) {
            return 0;
        }
        int numSideChannels = this.countPairedChannels(layoutMap, tags, 2, ii);
        if (numSideChannels < 0) {
            return 0;
        }
        int numBackChannels = this.countPairedChannels(layoutMap, tags, 3, ii);
        if (numBackChannels < 0) {
            return 0;
        }
        int i = 0;
        if ((numFrontChannels & 1) != 0) {
            e2cVec[i] = new ElemToChannel(4, 0, layoutMap[i][1], 1);
            ++i;
            --numFrontChannels;
        }
        if (numFrontChannels >= 4) {
            i += this.assignPair(e2cVec, layoutMap, i, 64, 128, 1);
            numFrontChannels -= 2;
        }
        if (numFrontChannels >= 2) {
            i += this.assignPair(e2cVec, layoutMap, i, 1, 2, 1);
            numFrontChannels -= 2;
        }
        while (numFrontChannels >= 2) {
            i += this.assignPair(e2cVec, layoutMap, i, Integer.MAX_VALUE, Integer.MAX_VALUE, 1);
            numFrontChannels -= 2;
        }
        if (numSideChannels >= 2) {
            i += this.assignPair(e2cVec, layoutMap, i, 512, 1024, 1);
            numSideChannels -= 2;
        }
        while (numSideChannels >= 2) {
            i += this.assignPair(e2cVec, layoutMap, i, Integer.MAX_VALUE, Integer.MAX_VALUE, 2);
            numSideChannels -= 2;
        }
        while (numBackChannels >= 4) {
            i += this.assignPair(e2cVec, layoutMap, i, Integer.MAX_VALUE, Integer.MAX_VALUE, 3);
            numBackChannels -= 2;
        }
        if (numBackChannels >= 2) {
            i += this.assignPair(e2cVec, layoutMap, i, 16, 32, 3);
            numBackChannels -= 2;
        }
        if (numBackChannels > 0) {
            e2cVec[i] = new ElemToChannel(256, 0, layoutMap[i][1], 3);
            ++i;
            --numBackChannels;
        }
        if (i < tags && layoutMap[i][2] == 4) {
            e2cVec[i] = new ElemToChannel(8, 3, layoutMap[i][1], 4);
            ++i;
        }
        while (i < tags && layoutMap[i][2] == 4) {
            e2cVec[i] = new ElemToChannel(Integer.MAX_VALUE, 3, layoutMap[i][1], 4);
            ++i;
        }
        int totalNonCcElements = i;
        int n = i;
        ElemToChannel tmp = new ElemToChannel();
        do {
            nextN = 0;
            for (i = 1; i < n; ++i) {
                if (e2cVec[i - 1].avPosition <= e2cVec[i].avPosition) continue;
                tmp.copy(e2cVec[i - 1]);
                e2cVec[i - 2].copy(e2cVec[i]);
                e2cVec[i].copy(tmp);
                nextN = i;
            }
        } while ((n = nextN) > 0);
        int layout = 0;
        for (i = 0; i < totalNonCcElements; ++i) {
            layoutMap[i][0] = e2cVec[i].synEle;
            layoutMap[i][1] = e2cVec[i].elemId;
            layoutMap[i][2] = e2cVec[i].aacPosition;
            if (e2cVec[i].avPosition == Integer.MAX_VALUE) continue;
            layout |= e2cVec[i].avPosition;
        }
        return layout;
    }

    private int cheConfigure(int chePos, int type, int id, int[] channels) {
        if (channels[0] >= 64) {
            return -4;
        }
        if (chePos != 0) {
            if (this.ac.che[type][id] == null) {
                this.ac.che[type][id] = new ChannelElement();
                AacSbr.ctxInit(this.ac.che[type][id].sbr);
            }
            if (type != 2) {
                if (channels[0] >= 64 - (type == 1 || type == 0 && this.ac.oc[1].m4ac.ps == 1 ? 1 : 0)) {
                    log.error((Object)String.format("Too many channels", new Object[0]));
                    return -4;
                }
                int n = channels[0];
                channels[0] = n + 1;
                this.ac.outputElement[n] = this.ac.che[type][id].ch[0];
                if (type == 1 || type == 0 && this.ac.oc[1].m4ac.ps == 1) {
                    int n2 = channels[0];
                    channels[0] = n2 + 1;
                    this.ac.outputElement[n2] = this.ac.che[type][id].ch[1];
                }
            }
        } else if (this.ac.che[type][id] != null) {
            AacSbr.ctxClose(this.ac.che[type][id].sbr);
            this.ac.che[type][id] = null;
        }
        return 0;
    }

    private int outputConfigure(int[][] layoutMap, int tags, int ocType, boolean getNewFrame) {
        int ret;
        int i;
        if (this.ac.oc[1].layoutMap != layoutMap) {
            for (int i2 = 0; i2 < tags; ++i2) {
                System.arraycopy(layoutMap[i2], 0, this.ac.oc[1].layoutMap[i2], 0, 3);
            }
            this.ac.oc[1].layoutMapTags = tags;
        }
        int layout = this.sniffChannelOrder(layoutMap, tags);
        int[] channels = new int[1];
        for (i = 0; i < tags; ++i) {
            int position = layoutMap[i][2];
            int type = layoutMap[i][0];
            int id = layoutMap[i][1];
            int ret2 = this.cheConfigure(position, type, id, channels);
            if (ret2 >= 0) continue;
            return ret2;
        }
        if (this.ac.oc[1].m4ac.ps == 1 && channels[0] == 2) {
            layout = layout == 4 ? 3 : 0;
        }
        for (i = 0; i < 4; ++i) {
            for (int j = 0; j < 16; ++j) {
                this.ac.tagCheMap[i][j] = this.ac.che[i][j];
            }
        }
        this.ac.oc[1].channelLayout = layout;
        this.ac.channels = channels[0];
        this.ac.oc[1].channels = channels[0];
        this.ac.oc[1].status = ocType;
        if (getNewFrame && (ret = this.frameConfigureElements()) < 0) {
            return ret;
        }
        return 0;
    }

    private int decodeCpe(ChannelElement cpe) {
        int ret;
        boolean commonWindow;
        int msPresent = 0;
        boolean eldSyntax = this.ac.oc[1].m4ac.objectType == 39;
        boolean bl = commonWindow = eldSyntax || this.br.readBool();
        if (commonWindow) {
            if (this.decodeIcsInfo(cpe.ch[0].ics) != 0) {
                return -4;
            }
            boolean i = cpe.ch[1].ics.useKbWindow[0];
            cpe.ch[1].ics.copy(cpe.ch[0].ics);
            cpe.ch[1].ics.useKbWindow[1] = i;
            if (cpe.ch[1].ics.predictorPresent && this.ac.oc[1].m4ac.objectType != 1) {
                cpe.ch[1].ics.ltp.present = this.br.readBool();
                if (cpe.ch[1].ics.ltp.present) {
                    this.decodeLtp(cpe.ch[1].ics.ltp, cpe.ch[1].ics.maxSfb);
                }
            }
            if ((msPresent = this.br.read(2)) == 3) {
                log.error((Object)String.format("ms_present = 3 is reserved", new Object[0]));
                return -4;
            }
            if (msPresent != 0) {
                this.decodeMidSideStereo(cpe, msPresent);
            }
        }
        if ((ret = this.decodeIcs(cpe.ch[0], commonWindow, false)) != 0) {
            return ret;
        }
        ret = this.decodeIcs(cpe.ch[1], commonWindow, false);
        if (ret != 0) {
            return ret;
        }
        if (commonWindow) {
            if (msPresent != 0) {
                this.applyMidSideStereo(cpe);
            }
            if (this.ac.oc[1].m4ac.objectType == 1) {
                this.applyPrediction(cpe.ch[0]);
                this.applyPrediction(cpe.ch[1]);
            }
        }
        this.applyIntensityStereo(cpe, msPresent);
        return 0;
    }

    private void decodeMidSideStereo(ChannelElement cpe, int msPresent) {
        if (msPresent == 1) {
            for (int idx = 0; idx < cpe.ch[0].ics.numWindowGroups * cpe.ch[0].ics.maxSfb; ++idx) {
                cpe.msMask[idx] = this.br.read1();
            }
        } else if (msPresent == 2) {
            Arrays.fill(cpe.msMask, 0, cpe.ch[0].ics.numWindowGroups * cpe.ch[0].ics.maxSfb, 1);
        }
    }

    private void applyMidSideStereo(ChannelElement cpe) {
        IndividualChannelStream ics = cpe.ch[0].ics;
        int ch0 = 0;
        int ch1 = 0;
        int idx = 0;
        int[] offsets = ics.swbOffset;
        for (int g = 0; g < ics.numWindowGroups; ++g) {
            int i = 0;
            while (i < ics.maxSfb) {
                if (cpe.msMask[idx] != 0 && cpe.ch[0].bandType[idx] < 13 && cpe.ch[1].bandType[idx] < 13) {
                    for (int group = 0; group < ics.groupLen[g]; ++group) {
                        FloatDSP.butterflies(cpe.ch[0].coeffs, ch0 + group * 128 + offsets[i], cpe.ch[1].coeffs, ch1 + group * 128 + offsets[i], offsets[i + 1] - offsets[i]);
                    }
                }
                ++i;
                ++idx;
            }
            ch0 += ics.groupLen[g] * 128;
            ch1 += ics.groupLen[g] * 128;
        }
    }

    private void applyIntensityStereo(ChannelElement cpe, int msPresent) {
        IndividualChannelStream ics = cpe.ch[1].ics;
        SingleChannelElement sce1 = cpe.ch[1];
        int coef0 = 0;
        int coef1 = 0;
        int[] offsets = ics.swbOffset;
        int idx = 0;
        for (int g = 0; g < ics.numWindowGroups; ++g) {
            int i = 0;
            while (i < ics.maxSfb) {
                int btRunEnd;
                if (sce1.bandType[idx] == 15 || sce1.bandType[idx] == 14) {
                    btRunEnd = sce1.bandTypeRunEnd[idx];
                    while (i < btRunEnd) {
                        int c = -1 + 2 * (sce1.bandType[idx] - 14);
                        if (msPresent != 0) {
                            c *= 1 - 2 * cpe.msMask[idx];
                        }
                        float scale = (float)c * sce1.sf[idx];
                        for (int group = 0; group < ics.groupLen[g]; ++group) {
                            FloatDSP.vectorFmulScalar(cpe.ch[1].coeffs, coef1 + group * 128 + offsets[i], cpe.ch[0].coeffs, coef0 + group * 128 + offsets[i], scale, offsets[i + 1] - offsets[i]);
                        }
                        ++i;
                        ++idx;
                    }
                    continue;
                }
                btRunEnd = sce1.bandTypeRunEnd[idx];
                idx += btRunEnd - i;
                i = btRunEnd;
            }
            coef0 += ics.groupLen[g] * 128;
            coef1 += ics.groupLen[g] * 128;
        }
    }

    private int decodeCce(ChannelElement che) {
        int numGain = 0;
        SingleChannelElement sce = che.ch[0];
        ChannelCoupling coup = che.coup;
        coup.couplingPoint = 2 * this.br.read1();
        coup.numCoupled = this.br.read(3);
        for (int c = 0; c <= coup.numCoupled; ++c) {
            ++numGain;
            coup.type[c] = this.br.readBool() ? 1 : 0;
            coup.idSelect[c] = this.br.read(4);
            if (coup.type[c] == 1) {
                coup.chSelect[c] = this.br.read(2);
                if (coup.chSelect[c] != 3) continue;
                ++numGain;
                continue;
            }
            coup.chSelect[c] = 2;
        }
        coup.couplingPoint = coup.couplingPoint + (this.br.readBool() || coup.couplingPoint >> 1 != 0 ? 1 : 0);
        boolean sign = this.br.readBool();
        float scale = cce_scale[this.br.read(2)];
        int ret = this.decodeIcs(sce, false, false);
        if (ret != 0) {
            return ret;
        }
        for (int c = 0; c < numGain; ++c) {
            int idx = 0;
            boolean cge = true;
            int gain = 0;
            float gainCache = 1.0f;
            if (c != 0) {
                cge = coup.couplingPoint == 3 ? true : this.br.readBool();
                gain = cge ? vlc_scalefactors.getVLC2(this.br, 3) - 60 : 0;
                gainCache = (float)Math.pow(scale, -gain);
            }
            if (coup.couplingPoint == 3) {
                coup.gain[c][0] = gainCache;
                continue;
            }
            for (int g = 0; g < sce.ics.numWindowGroups; ++g) {
                int sfb = 0;
                while (sfb < sce.ics.maxSfb) {
                    if (sce.bandType[idx] != 0) {
                        int t;
                        if (!cge && (t = vlc_scalefactors.getVLC2(this.br, 3) - 60) != 0) {
                            int s = 1;
                            gain += t;
                            t = gain;
                            if (sign) {
                                s -= 2 * (t & 1);
                                t >>= 1;
                            }
                            gainCache = (float)Math.pow(scale, -t) * (float)s;
                        }
                        coup.gain[c][idx] = gainCache;
                    }
                    ++sfb;
                    ++idx;
                }
            }
        }
        return 0;
    }

    private int skipDataStreamElement() {
        boolean byteAlign = this.br.readBool();
        int count = this.br.read(8);
        if (count == 255) {
            count += this.br.read(8);
        }
        if (byteAlign) {
            this.br.byteAlign();
        }
        if (this.br.getBitsLeft() < 8 * count) {
            log.error((Object)String.format("skipDataStreamElement overread error", new Object[0]));
            return -4;
        }
        this.br.skip(8 * count);
        return 0;
    }

    private int decodeDrcChannelExclusions(DynamicRangeControl cheDrc) {
        int numExclChan = 0;
        do {
            for (int i = 0; i < 7; ++i) {
                cheDrc.excludeMask[numExclChan++] = this.br.read1();
            }
        } while (numExclChan < 57 && this.br.readBool());
        return numExclChan / 7;
    }

    private int decodeDynamicRange(DynamicRangeControl cheDrc) {
        int i;
        int n = 1;
        int drcNumBands = 1;
        if (this.br.readBool()) {
            cheDrc.pceInstanceTag = this.br.read(4);
            this.br.skip(4);
            ++n;
        }
        if (this.br.readBool()) {
            n += this.decodeDrcChannelExclusions(cheDrc);
        }
        if (this.br.readBool()) {
            cheDrc.bandIncr = this.br.read(4);
            cheDrc.interpolationScheme = this.br.read(4);
            ++n;
            drcNumBands += cheDrc.bandIncr;
            for (i = 0; i < drcNumBands; ++i) {
                cheDrc.bandTop[i] = this.br.read(8);
                ++n;
            }
        }
        if (this.br.readBool()) {
            cheDrc.progRefLevel = this.br.read(7);
            this.br.skip(1);
            ++n;
        }
        for (i = 0; i < drcNumBands; ++i) {
            cheDrc.dynRngSgn[i] = this.br.read1();
            cheDrc.dynRngCtl[i] = this.br.read(7);
            ++n;
        }
        return n;
    }

    private int decodeFill(int len) {
        if (len >= 69) {
            Pattern p;
            Matcher m;
            this.br.read(13);
            byte[] buf = new byte[Math.min(256, (len -= 13) / 8)];
            int i = 0;
            while (i < buf.length) {
                buf[i] = (byte)this.br.read(8);
                ++i;
                len -= 8;
            }
            String s = new String(buf);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("FILL: '%s'", s));
            }
            if ((m = (p = Pattern.compile("libfaac (\\d+)\\.(\\d+)")).matcher(s)).matches()) {
                this.ac.skipSamples = 1024;
            }
        }
        this.br.skip(len);
        return 0;
    }

    private int decodeExtensionPayload(int cnt, ChannelElement che, int elemType) {
        boolean crcFlag = false;
        int res = cnt;
        switch (this.br.read(4)) {
            case 14: {
                crcFlag = true;
            }
            case 13: {
                if (che == null) {
                    log.error((Object)String.format("SBR was found before the first channel element", new Object[0]));
                    return res;
                }
                if (this.ac.oc[1].m4ac.sbr == 0) {
                    log.error((Object)String.format("SBR signaled to be not-present but was found in the bitstream", new Object[0]));
                    this.br.skip(8 * cnt - 4);
                    return res;
                }
                if (this.ac.oc[1].m4ac.sbr == -1 && this.ac.oc[1].status == 4) {
                    log.error((Object)String.format("Implicit SBR was found with a first occurrence after the first frame", new Object[0]));
                    this.br.skip(8 * cnt - 4);
                    return res;
                }
                if (this.ac.oc[1].m4ac.ps == -1 && this.ac.oc[1].status < 4 && this.ac.channels == 1) {
                    this.ac.oc[1].m4ac.sbr = 1;
                    this.ac.oc[1].m4ac.ps = 1;
                    this.outputConfigure(this.ac.oc[1].layoutMap, this.ac.oc[1].layoutMapTags, this.ac.oc[1].status, true);
                } else {
                    this.ac.oc[1].m4ac.sbr = 1;
                }
                res = AacSbr.decodeSbrExtension(this.ac, che.sbr, crcFlag, cnt, elemType);
                break;
            }
            case 11: {
                res = this.decodeDynamicRange(this.ac.cheDrc);
                break;
            }
            case 0: {
                this.decodeFill(8 * cnt - 4);
                break;
            }
            default: {
                this.br.skip(8 * cnt - 4);
            }
        }
        return res;
    }

    private void imdctAndWindowing(SingleChannelElement sce) {
        IndividualChannelStream ics = sce.ics;
        float[] in = sce.coeffs;
        float[] out = sce.ret;
        float[] saved = sce.saved;
        float[] swindow = ics.useKbWindow[0] ? AacTab.ff_aac_kbd_short_128 : SineWin.ff_sine_128;
        float[] lwindowPrev = ics.useKbWindow[1] ? AacTab.ff_aac_kbd_long_1024 : SineWin.ff_sine_1024;
        float[] swindowPrev = ics.useKbWindow[1] ? AacTab.ff_aac_kbd_short_128 : SineWin.ff_sine_128;
        float[] buf = this.ac.bufMdct;
        float[] temp = this.ac.temp;
        if (ics.windowSequence[0] == 2) {
            for (int i = 0; i < 1024; i += 128) {
                this.ac.mdctSmall.imdctHalf(buf, i, in, i);
            }
        } else {
            this.ac.mdct.imdctHalf(buf, 0, in, 0);
        }
        if (!(ics.windowSequence[1] != 0 && ics.windowSequence[1] != 3 || ics.windowSequence[0] != 0 && ics.windowSequence[0] != 1)) {
            FloatDSP.vectorFmulWindow(out, 0, saved, 0, buf, 0, lwindowPrev, 0, 512);
        } else {
            System.arraycopy(saved, 0, out, 0, 448);
            if (ics.windowSequence[0] == 2) {
                FloatDSP.vectorFmulWindow(out, 448, saved, 448, buf, 0, swindowPrev, 0, 64);
                FloatDSP.vectorFmulWindow(out, 576, buf, 64, buf, 128, swindow, 0, 64);
                FloatDSP.vectorFmulWindow(out, 704, buf, 192, buf, 256, swindow, 0, 64);
                FloatDSP.vectorFmulWindow(out, 832, buf, 320, buf, 384, swindow, 0, 64);
                FloatDSP.vectorFmulWindow(temp, 0, buf, 448, buf, 512, swindow, 0, 64);
                System.arraycopy(temp, 0, out, 960, 64);
            } else {
                FloatDSP.vectorFmulWindow(out, 448, saved, 448, buf, 0, swindowPrev, 0, 64);
                System.arraycopy(buf, 64, out, 576, 448);
            }
        }
        if (ics.windowSequence[0] == 2) {
            System.arraycopy(temp, 64, saved, 0, 64);
            FloatDSP.vectorFmulWindow(saved, 64, buf, 576, buf, 640, swindow, 0, 64);
            FloatDSP.vectorFmulWindow(saved, 192, buf, 704, buf, 768, swindow, 0, 64);
            FloatDSP.vectorFmulWindow(saved, 320, buf, 832, buf, 896, swindow, 0, 64);
            System.arraycopy(buf, 960, saved, 448, 64);
        } else if (ics.windowSequence[0] == 1) {
            System.arraycopy(buf, 512, saved, 0, 448);
            System.arraycopy(buf, 960, saved, 448, 64);
        } else {
            System.arraycopy(buf, 512, saved, 0, 512);
        }
    }

    private void imdctAndWindowingLd(SingleChannelElement sce) {
        IndividualChannelStream ics = sce.ics;
        float[] in = sce.coeffs;
        float[] out = sce.ret;
        float[] saved = sce.saved;
        float[] buf = this.ac.bufMdct;
        this.ac.mdct.imdctHalf(buf, 0, in, 0);
        if (ics.useKbWindow[1]) {
            System.arraycopy(saved, 0, out, 0, 192);
            FloatDSP.vectorFmulWindow(out, 192, saved, 192, buf, 0, SineWin.ff_sine_128, 0, 64);
            System.arraycopy(buf, 64, out, 320, 192);
        } else {
            FloatDSP.vectorFmulWindow(out, 0, saved, 0, buf, 0, SineWin.ff_sine_512, 0, 256);
        }
        System.arraycopy(buf, 256, saved, 0, 256);
    }

    private void imdctAndWindowingEld(SingleChannelElement sce) {
        int i;
        float[] in = sce.coeffs;
        float[] out = sce.ret;
        float[] saved = sce.saved;
        float[] window = AacTab.ff_aac_eld_window;
        float[] buf = this.ac.bufMdct;
        int n = 512;
        int n2 = 256;
        int n4 = 128;
        for (i = 0; i < 256; i += 2) {
            float temp = in[i];
            in[i] = -in[511 - i];
            in[511 - i] = temp;
            temp = -in[i + 1];
            in[i + 1] = in[510 - i];
            in[510 - i] = temp;
        }
        this.ac.mdct.imdctHalf(buf, 0, in, 0);
        for (i = 0; i < 512; i += 2) {
            buf[i] = -buf[i];
        }
        for (i = 128; i < 256; ++i) {
            out[i - 128] = buf[255 - i] * window[i - 128] + saved[i + 256] * window[i + 512 - 128] + -saved[767 - i] * window[i + 1024 - 128] + -saved[1280 + i] * window[i + 1536 - 128];
        }
        for (i = 0; i < 256; ++i) {
            out[128 + i] = buf[i] * window[i + 256 - 128] + -saved[511 - i] * window[i + 256 + 512 - 128] + -saved[512 + i] * window[i + 256 + 1024 - 128] + saved[1535 - i] * window[i + 256 + 1536 - 128];
        }
        for (i = 0; i < 128; ++i) {
            out[384 + i] = buf[i + 256] * window[i + 512 - 128] + -saved[255 - i] * window[i + 1024 - 128] + -saved[768 + i] * window[i + 1536 - 128];
        }
        System.arraycopy(saved, 0, saved, 512, 1024);
        System.arraycopy(buf, 0, saved, 0, 512);
    }

    private void imdctAndWindow(SingleChannelElement sce) {
        switch (this.ac.oc[1].m4ac.objectType) {
            case 23: {
                this.imdctAndWindowingLd(sce);
                break;
            }
            case 39: {
                this.imdctAndWindowingEld(sce);
                break;
            }
            default: {
                this.imdctAndWindowing(sce);
            }
        }
    }

    private void windowingAndMdctLtp(float[] out, float[] in, IndividualChannelStream ics) {
        float[] swindowPrev;
        float[] lwindow = ics.useKbWindow[0] ? AacTab.ff_aac_kbd_long_1024 : SineWin.ff_sine_1024;
        float[] swindow = ics.useKbWindow[0] ? AacTab.ff_aac_kbd_short_128 : SineWin.ff_sine_128;
        float[] lwindowPrev = ics.useKbWindow[1] ? AacTab.ff_aac_kbd_long_1024 : SineWin.ff_sine_1024;
        float[] fArray = swindowPrev = ics.useKbWindow[1] ? AacTab.ff_aac_kbd_short_128 : SineWin.ff_sine_128;
        if (ics.windowSequence[0] != 3) {
            FloatDSP.vectorFmul(in, 0, in, 0, lwindowPrev, 0, 1024);
        } else {
            Arrays.fill(in, 0, 448, 0.0f);
            FloatDSP.vectorFmul(in, 448, in, 448, swindowPrev, 0, 128);
        }
        if (ics.windowSequence[0] != 1) {
            FloatDSP.vectorFmulReverse(in, 1024, in, 1024, lwindow, 0, 1024);
        } else {
            FloatDSP.vectorFmulReverse(in, 1472, in, 1472, swindow, 0, 128);
            Arrays.fill(in, 1600, 2048, 0.0f);
        }
        this.ac.mdctLtp.mdctCalc(out, 0, in, 0);
    }

    private void applyLtp(SingleChannelElement sce) {
        LongTermPrediction ltp = sce.ics.ltp;
        int[] offsets = sce.ics.swbOffset;
        if (sce.ics.windowSequence[0] != 2) {
            float[] predTime = sce.ret;
            float[] predFreq = this.ac.bufMdct;
            int numSamples = 2048;
            if (ltp.lag < 1024) {
                numSamples = ltp.lag + 1024;
            }
            for (int i = 0; i < numSamples; ++i) {
                predTime[i] = sce.ltpState[i + 2048 - ltp.lag] * ltp.coef;
            }
            Arrays.fill(predTime, numSamples, 2048, 0.0f);
            this.windowingAndMdctLtp(predFreq, predTime, sce.ics);
            if (sce.tns.present) {
                this.applyTns(predFreq, sce.tns, sce.ics, false);
            }
            for (int sfb = 0; sfb < Math.min(sce.ics.maxSfb, 40); ++sfb) {
                if (!ltp.used[sfb]) continue;
                for (int i = offsets[sfb]; i < offsets[sfb + 1]; ++i) {
                    int n = i;
                    sce.coeffs[n] = sce.coeffs[n] + predFreq[i];
                }
            }
        }
    }

    private void updateLtp(SingleChannelElement sce) {
        float[] swindow;
        IndividualChannelStream ics = sce.ics;
        float[] saved = sce.saved;
        float[] savedLtp = sce.coeffs;
        float[] lwindow = ics.useKbWindow[0] ? AacTab.ff_aac_kbd_long_1024 : SineWin.ff_sine_1024;
        float[] fArray = swindow = ics.useKbWindow[0] ? AacTab.ff_aac_kbd_short_128 : SineWin.ff_sine_128;
        if (ics.windowSequence[0] == 2) {
            System.arraycopy(saved, 0, savedLtp, 0, 512);
            Arrays.fill(savedLtp, 576, 1024, 0.0f);
            FloatDSP.vectorFmulReverse(savedLtp, 448, this.ac.bufMdct, 960, swindow, 64, 64);
            for (int i = 0; i < 64; ++i) {
                savedLtp[i + 512] = this.ac.bufMdct[1023 - i] * swindow[63 - i];
            }
        } else if (ics.windowSequence[0] == 1) {
            System.arraycopy(this.ac.bufMdct, 512, savedLtp, 0, 448);
            Arrays.fill(savedLtp, 576, 1024, 0.0f);
            FloatDSP.vectorFmulReverse(savedLtp, 448, this.ac.bufMdct, 960, swindow, 64, 64);
            for (int i = 0; i < 64; ++i) {
                savedLtp[i + 512] = this.ac.bufMdct[1023 - i] * swindow[63 - i];
            }
        } else {
            FloatDSP.vectorFmulReverse(savedLtp, 0, this.ac.bufMdct, 512, lwindow, 512, 512);
            for (int i = 0; i < 512; ++i) {
                savedLtp[i + 512] = this.ac.bufMdct[1023 - i] * lwindow[511 - i];
            }
        }
        System.arraycopy(sce.ltpState, 1024, sce.ltpState, 0, 1024);
        System.arraycopy(sce.ret, 0, sce.ltpState, 1024, 1024);
        System.arraycopy(savedLtp, 0, sce.ltpState, 2048, 1024);
    }

    private void applyTns(float[] coef, TemporalNoiseShaping tns, IndividualChannelStream ics, boolean decode) {
        int mmm = Math.min(ics.tnsMaxBands, ics.maxSfb);
        float[] lpc = new float[20];
        float[] tmp = new float[21];
        for (int w = 0; w < ics.numWindows; ++w) {
            int bottom = ics.numSwb;
            for (int filt = 0; filt < tns.nFilt[w]; ++filt) {
                int i;
                int m;
                int inc;
                int top = bottom;
                bottom = Math.max(0, top - tns.length[w][filt]);
                int order = tns.order[w][filt];
                if (order == 0) continue;
                Lpc.computeLpcCoefs(tns.coef[w][filt], order, lpc, 0, false, false);
                int start = ics.swbOffset[Math.min(bottom, mmm)];
                int end = ics.swbOffset[Math.min(top, mmm)];
                int size = end - start;
                if (size <= 0) continue;
                if (tns.direction[w][filt]) {
                    inc = -1;
                    start = end - 1;
                } else {
                    inc = 1;
                }
                start += w * 128;
                if (decode) {
                    m = 0;
                    while (m < size) {
                        for (i = 1; i <= Math.min(m, order); ++i) {
                            int n = start;
                            coef[n] = coef[n] - coef[start - i * inc] * lpc[i - 1];
                        }
                        ++m;
                        start += inc;
                    }
                    continue;
                }
                m = 0;
                while (m < size) {
                    tmp[0] = coef[start];
                    for (i = 1; i <= Math.min(m, order); ++i) {
                        int n = start;
                        coef[n] = coef[n] + tmp[i] * lpc[i - 1];
                    }
                    for (i = order; i > 0; --i) {
                        tmp[i] = tmp[i - 1];
                    }
                    ++m;
                    start += inc;
                }
            }
        }
    }

    private void applyDependentCoupling(SingleChannelElement target, ChannelElement cce, int index) {
        IndividualChannelStream ics = cce.ch[0].ics;
        int[] offsets = ics.swbOffset;
        float[] dest = target.coeffs;
        float[] src = cce.ch[0].coeffs;
        int idx = 0;
        if (this.ac.oc[1].m4ac.objectType == 4) {
            log.error((Object)String.format("Dependent coupling is not supported together with LTP", new Object[0]));
            return;
        }
        int destOffset = 0;
        int srcOffset = 0;
        for (int g = 0; g < ics.numWindowGroups; ++g) {
            int i = 0;
            while (i < ics.maxSfb) {
                if (cce.ch[0].bandType[idx] != 0) {
                    float gain = cce.coup.gain[index][idx];
                    for (int group = 0; group < ics.groupLen[g]; ++group) {
                        for (int k = offsets[i]; k < offsets[i + 1]; ++k) {
                            int n = destOffset + group * 128 + k;
                            dest[n] = dest[n] + gain * src[srcOffset + group * 128 + k];
                        }
                    }
                }
                ++i;
                ++idx;
            }
            destOffset += ics.groupLen[g] * 128;
            srcOffset += ics.groupLen[g] * 128;
        }
    }

    private void applyIndependentCoupling(SingleChannelElement target, ChannelElement cce, int index) {
        float gain = cce.coup.gain[index][0];
        float[] src = cce.ch[0].ret;
        float[] dest = target.ret;
        int len = 1024 << (this.ac.oc[1].m4ac.sbr == 1 ? 1 : 0);
        for (int i = 0; i < len; ++i) {
            int n = i;
            dest[n] = dest[n] + gain * src[i];
        }
    }

    private void applyCouplingMethod(SingleChannelElement target, ChannelElement cce, int index, boolean applyDependentCoupling) {
        if (applyDependentCoupling) {
            this.applyDependentCoupling(target, cce, index);
        } else {
            this.applyIndependentCoupling(target, cce, index);
        }
    }

    private void applyChannelCoupling(ChannelElement cc, int type, int elemId, int couplingPoint, boolean applyDependentCoupling) {
        for (int i = 0; i < 16; ++i) {
            ChannelElement cce = this.ac.che[2][i];
            if (cce == null || cce.coup.couplingPoint != couplingPoint) continue;
            int index = 0;
            ChannelCoupling coup = cce.coup;
            for (int c = 0; c <= coup.numCoupled; ++c) {
                if (coup.type[c] == type && coup.idSelect[c] == elemId) {
                    if (coup.chSelect[c] != 1) {
                        this.applyCouplingMethod(cc.ch[0], cce, index, applyDependentCoupling);
                        if (coup.chSelect[c] != 0) {
                            ++index;
                        }
                    }
                    if (coup.chSelect[c] == 2) continue;
                    this.applyCouplingMethod(cc.ch[1], cce, index++, applyDependentCoupling);
                    continue;
                }
                index += 1 + (coup.chSelect[c] == 3 ? 1 : 0);
            }
        }
    }

    private void spectralToSample() {
        for (int type = 3; type >= 0; --type) {
            for (int i = 0; i < 16; ++i) {
                ChannelElement che = this.ac.che[type][i];
                if (che == null) continue;
                if (type <= 1) {
                    this.applyChannelCoupling(che, type, i, 0, true);
                }
                if (this.ac.oc[1].m4ac.objectType == 4 && che.ch[0].ics.predictorPresent) {
                    if (che.ch[0].ics.ltp.present) {
                        this.applyLtp(che.ch[0]);
                    }
                    if (che.ch[1].ics.ltp.present && type == 1) {
                        this.applyLtp(che.ch[1]);
                    }
                }
                if (che.ch[0].tns.present) {
                    this.applyTns(che.ch[0].coeffs, che.ch[0].tns, che.ch[0].ics, true);
                }
                if (che.ch[1].tns.present) {
                    this.applyTns(che.ch[1].coeffs, che.ch[1].tns, che.ch[1].ics, true);
                }
                if (type <= 1) {
                    this.applyChannelCoupling(che, type, i, 1, true);
                }
                if (type != 2 || che.coup.couplingPoint == 3) {
                    this.imdctAndWindow(che.ch[0]);
                    if (this.ac.oc[1].m4ac.objectType == 4) {
                        this.updateLtp(che.ch[0]);
                    }
                    if (type == 1) {
                        this.imdctAndWindow(che.ch[1]);
                        if (this.ac.oc[1].m4ac.objectType == 4) {
                            this.updateLtp(che.ch[1]);
                        }
                    }
                    if (this.ac.oc[1].m4ac.sbr > 0) {
                        AacSbr.sbrApply(this.ac, che.sbr, type, che.ch[0].ret, che.ch[1].ret);
                    }
                }
                if (type > 2) continue;
                this.applyChannelCoupling(che, type, i, 3, false);
            }
        }
    }

    private int decodeFrameInt() {
        boolean isDmono;
        int elemType;
        int err;
        int elemTypePrev = 7;
        ChannelElement che = null;
        ChannelElement chePrev = null;
        boolean audioFound = false;
        int sceCount = 0;
        boolean pceFound = false;
        if (this.br.peek(12) == 4095) {
            err = this.parseAdtsFrameHeader();
            if (err < 0) {
                this.popOutputConfiguration();
                return err;
            }
            if (this.ac.oc[1].m4ac.samplingIndex > 12) {
                log.error((Object)String.format("Invalid sampling rate index %d", this.ac.oc[1].m4ac.samplingIndex));
                this.popOutputConfiguration();
                return -4;
            }
        }
        if ((err = this.frameConfigureElements()) < 0) {
            this.popOutputConfiguration();
            return err;
        }
        this.ac.tagsMapped = 0;
        int samples = 0;
        while ((elemType = this.br.read(3)) != 7) {
            int elemId = this.br.read(4);
            if (elemType < 4) {
                che = this.getChe(elemType, elemId);
                if (che == null) {
                    log.error((Object)String.format("channel element %d.%d is not allocated", elemType, elemId));
                    this.popOutputConfiguration();
                    return -4;
                }
                samples = 1024;
            }
            switch (elemType) {
                case 0: {
                    err = this.decodeIcs(che.ch[0], false, false);
                    audioFound = true;
                    ++sceCount;
                    break;
                }
                case 1: {
                    err = this.decodeCpe(che);
                    audioFound = true;
                    break;
                }
                case 2: {
                    err = this.decodeCce(che);
                    break;
                }
                case 3: {
                    err = this.decodeIcs(che.ch[0], false, false);
                    audioFound = true;
                    break;
                }
                case 4: {
                    err = this.skipDataStreamElement();
                    break;
                }
                case 5: {
                    int[][] layoutMap = new int[64][3];
                    this.pushOutputConfiguration();
                    int tags = this.decodePce(this.ac.oc[1].m4ac, layoutMap);
                    if (tags < 0) {
                        err = tags;
                        break;
                    }
                    if (pceFound) {
                        log.error((Object)String.format("Not evaluating a further program_config_element as this construct is dubious at best", new Object[0]));
                        break;
                    }
                    err = this.outputConfigure(layoutMap, tags, 1, true);
                    if (err == 0) {
                        this.ac.oc[1].m4ac.chanConfig = 0;
                    }
                    pceFound = true;
                    break;
                }
                case 6: {
                    if (elemId == 15) {
                        elemId += this.br.read(8) - 1;
                    }
                    if (this.br.getBitsLeft() < 8 * elemId) {
                        log.error((Object)String.format("TYPE_FIL: overread error", new Object[0]));
                        this.popOutputConfiguration();
                        return -4;
                    }
                    while (elemId > 0) {
                        elemId -= this.decodeExtensionPayload(elemId, chePrev, elemTypePrev);
                    }
                    err = 0;
                    break;
                }
                default: {
                    log.error((Object)String.format("Unknown element type %d", elemType));
                    this.popOutputConfiguration();
                    return -4;
                }
            }
            chePrev = che;
            elemTypePrev = elemType;
            if (err != 0) {
                this.popOutputConfiguration();
                return err;
            }
            if (this.br.getBitsLeft() >= 3) continue;
            log.error((Object)String.format("overread error", new Object[0]));
            this.popOutputConfiguration();
            return -4;
        }
        this.spectralToSample();
        int multiplier = this.ac.oc[1].m4ac.sbr == 1 ? (this.ac.oc[1].m4ac.extSampleRate > this.ac.oc[1].m4ac.sampleRate ? 1 : 0) : 0;
        samples <<= multiplier;
        if (this.ac.oc[1].status != 0 && audioFound) {
            this.ac.frameSize = samples;
            this.ac.oc[1].status = 4;
        }
        if (samples != 0) {
            this.ac.nbSamples = samples;
        }
        boolean bl = isDmono = this.ac.dmonoMode != 0 && sceCount == 2 && this.ac.oc[1].channelLayout == 3;
        if (isDmono) {
            if (this.ac.dmonoMode == 1) {
                System.arraycopy(this.ac.samples[0], 0, this.ac.samples[1], 0, samples);
            } else if (this.ac.dmonoMode == 2) {
                System.arraycopy(this.ac.samples[1], 0, this.ac.samples[0], 0, samples);
            }
        }
        return 0;
    }

    private int decodeErFrame() {
        int err;
        int samples = 1024;
        int chanConfig = this.ac.oc[1].m4ac.chanConfig;
        int aot = this.ac.oc[1].m4ac.objectType;
        if (aot == 23 || aot == 39) {
            samples >>= 1;
        }
        if ((err = this.frameConfigureElements()) < 0) {
            return err;
        }
        this.ac.tagsMapped = 0;
        if (chanConfig < 0 || chanConfig >= 8) {
            log.error((Object)String.format("Unknown ER channel configuration %d", chanConfig));
            return -4;
        }
        for (int i = 0; i < tags_per_config[chanConfig]; ++i) {
            int elemType = aac_channel_layout_map[chanConfig - 1][i][0];
            int elemId = aac_channel_layout_map[chanConfig - 1][i][1];
            ChannelElement che = this.getChe(elemType, elemId);
            if (che == null) {
                log.error((Object)String.format("channel element %d.%d is not allocated", elemType, elemId));
                return -4;
            }
            if (aot != 39) {
                this.br.skip(4);
            }
            switch (elemType) {
                case 0: {
                    err = this.decodeIcs(che.ch[0], false, false);
                    break;
                }
                case 1: {
                    err = this.decodeCpe(che);
                    break;
                }
                case 3: {
                    err = this.decodeIcs(che.ch[0], false, false);
                }
            }
            if (err >= 0) continue;
            return err;
        }
        this.spectralToSample();
        this.ac.nbSamples = samples;
        this.br.skip(this.br.getBitsLeft());
        return 0;
    }

    @Override
    public int decode(Memory inputMemory, int inputAddr, int inputLength, Memory outputMemory, int outputAddr) {
        int err;
        this.ac.br = this.br = new BitReader(inputMemory, inputAddr, inputLength);
        this.ac.dmonoMode = 0;
        switch (this.ac.oc[1].m4ac.objectType) {
            case 17: 
            case 19: 
            case 23: 
            case 39: {
                err = this.decodeErFrame();
                break;
            }
            default: {
                err = this.decodeFrameInt();
            }
        }
        if (err < 0) {
            return err;
        }
        CodecUtils.writeOutput(this.ac.samples, outputMemory, outputAddr, this.ac.nbSamples, this.ac.channels, this.ac.outputChannels);
        return this.br.getBytesRead();
    }

    @Override
    public int getNumberOfSamples() {
        return this.ac.nbSamples;
    }

    static {
        vlc_spectral = new VLC[11];
        ltp_coef = new float[]{0.570829f, 0.696616f, 0.813004f, 0.911304f, 0.9849f, 1.067894f, 1.194601f, 1.369533f};
        tns_tmp2_map_1_3 = new float[]{0.0f, -0.43388373f, 0.6427876f, 0.34202015f};
        tns_tmp2_map_0_3 = new float[]{0.0f, -0.43388373f, -0.7818315f, -0.9749279f, 0.9848077f, 0.8660254f, 0.6427876f, 0.34202015f};
        tns_tmp2_map_1_4 = new float[]{0.0f, -0.2079117f, -0.40673664f, -0.58778524f, 0.6736956f, 0.52643216f, 0.36124167f, 0.18374951f};
        tns_tmp2_map_0_4 = new float[]{0.0f, -0.2079117f, -0.40673664f, -0.58778524f, -0.7431448f, -0.8660254f, -0.95105654f, -0.9945219f, 0.99573416f, 0.9618256f, 0.8951633f, 0.7980172f, 0.6736956f, 0.52643216f, 0.36124167f, 0.18374951f};
        tns_tmp2_map = new float[][]{tns_tmp2_map_0_3, tns_tmp2_map_0_4, tns_tmp2_map_1_3, tns_tmp2_map_1_4};
        tags_per_config = new int[]{0, 1, 1, 2, 3, 3, 4, 5, 0, 0, 0, 0, 0, 0, 0, 0};
        aac_channel_layout_map = new int[][][]{new int[][]{{0, 0, 1}}, new int[][]{{1, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 1}}, new int[][]{{0, 0, 1}, {1, 0, 1}, {0, 1, 3}}, new int[][]{{0, 0, 1}, {1, 0, 1}, {1, 1, 3}}, new int[][]{{0, 0, 1}, {1, 0, 1}, {1, 1, 3}, {3, 0, 4}}, new int[][]{{0, 0, 1}, {1, 0, 1}, {1, 1, 1}, {1, 2, 3}, {3, 0, 4}}};
        aac_channel_layout = new int[]{4, 3, 7, 263, 55, 63, 255, 0};
        cce_scale = new float[]{1.0905077f, 1.1892071f, 1.4142135f, 2.0f};
    }

    private static class ElemToChannel {
        int avPosition;
        int synEle;
        int elemId;
        int aacPosition;

        public ElemToChannel() {
        }

        public ElemToChannel(int avPosition, int synEle, int elemId, int aacPosition) {
            this.avPosition = avPosition;
            this.synEle = synEle;
            this.elemId = elemId;
            this.aacPosition = aacPosition;
        }

        public void copy(ElemToChannel that) {
            this.avPosition = that.avPosition;
            this.synEle = that.synEle;
            this.elemId = that.elemId;
            this.aacPosition = that.aacPosition;
        }
    }
}

