/*
 * Decompiled with CFR 0.152.
 */
package com.twilight.h264.decoder;

import com.twilight.h264.decoder.AVPanScan;

public class AVFrame {
    public int imageWidthWOEdge;
    public int imageHeightWOEdge;
    public int imageWidth;
    public int imageHeight;
    public int[][] data_base = new int[4][];
    public int[] data_offset = new int[4];
    public int[] linesize = new int[4];
    public int[][] base = new int[4][];
    public int key_frame;
    public int pict_type;
    public long pts;
    public int coded_picture_number;
    public int display_picture_number;
    public int quality;
    public int age;
    public int reference;
    public int[] qscale_table;
    public int qstride;
    public int[] mbskip_table;
    public int[] motion_val_offset = new int[2];
    public int mb_type_offset;
    public int motion_subsample_log2;
    public Object opaque;
    public long[] error = new long[4];
    public int type;
    public int repeat_pict;
    public int qscale_type;
    public int interlaced_frame;
    public int top_field_first;
    public AVPanScan pan_scan;
    public int palette_has_changed;
    public int buffer_hints;
    public short[] dct_coeff;
    public int[][] ref_index = new int[2][];
    public long reordered_opaque;
    public Object hwaccel_picture_private;
    public long pkt_pts;
    public long pkt_dts;
    public int[] interpolated = new int[3];
    public int[][][] motion_val_base = new int[2][][];
    public long[] mb_type_base;
    public int[] field_poc = new int[2];
    public int poc;
    public int frame_num;
    public int mmco_reset;
    public int pic_id;
    public int long_ref;
    public int[][][] ref_poc = new int[2][2][16];
    public int[][] ref_count = new int[2][2];
    public int mbaff;
    public int mb_var_sum;
    public int mc_mb_var_sum;
    public int[] mb_var;
    public int[] mc_mb_var;
    public int[] mb_mean;
    public int[] mb_cmp_score;
    public int b_frame_score;

    public AVFrame copyTo(AVFrame ret) {
        int i;
        if (this == ret) {
            return ret;
        }
        ret.age = this.age;
        ret.b_frame_score = this.b_frame_score;
        for (i = 0; i < this.base.length; ++i) {
            ret.base[i] = this.base[i];
        }
        ret.buffer_hints = this.buffer_hints;
        ret.coded_picture_number = this.coded_picture_number;
        for (i = 0; i < this.data_base.length; ++i) {
            ret.data_base[i] = this.data_base[i];
            ret.data_offset[i] = this.data_offset[i];
        }
        ret.dct_coeff = this.dct_coeff;
        ret.display_picture_number = this.display_picture_number;
        System.arraycopy(this.error, 0, ret.error, 0, this.error.length);
        System.arraycopy(this.field_poc, 0, ret.field_poc, 0, this.field_poc.length);
        ret.frame_num = this.frame_num;
        ret.imageWidth = this.imageWidth;
        ret.imageHeight = this.imageHeight;
        ret.imageWidthWOEdge = this.imageWidthWOEdge;
        ret.imageHeightWOEdge = this.imageHeightWOEdge;
        ret.interlaced_frame = this.interlaced_frame;
        System.arraycopy(this.interpolated, 0, ret.interpolated, 0, this.interpolated.length);
        ret.key_frame = this.key_frame;
        System.arraycopy(this.linesize, 0, ret.linesize, 0, this.linesize.length);
        ret.long_ref = this.long_ref;
        ret.mb_cmp_score = this.mb_cmp_score;
        ret.mb_mean = this.mb_mean;
        ret.mb_type_base = this.mb_type_base;
        ret.mb_type_offset = this.mb_type_offset;
        ret.mb_var = this.mb_var;
        ret.mb_var_sum = this.mb_var_sum;
        ret.mbaff = this.mbaff;
        ret.mbskip_table = this.mbskip_table;
        ret.mc_mb_var = this.mc_mb_var;
        ret.mc_mb_var_sum = this.mc_mb_var_sum;
        ret.mmco_reset = this.mmco_reset;
        ret.motion_subsample_log2 = this.motion_subsample_log2;
        System.arraycopy(this.motion_val_base, 0, ret.motion_val_base, 0, this.motion_val_base.length);
        System.arraycopy(this.motion_val_offset, 0, ret.motion_val_offset, 0, this.motion_val_offset.length);
        ret.opaque = this.opaque;
        ret.palette_has_changed = this.palette_has_changed;
        ret.pan_scan = this.pan_scan;
        ret.pic_id = this.pic_id;
        ret.pict_type = this.pict_type;
        ret.pkt_dts = this.pkt_dts;
        ret.pkt_pts = this.pkt_pts;
        ret.poc = this.poc;
        ret.pts = this.pts;
        ret.qscale_table = this.qscale_table;
        ret.qscale_type = this.qscale_type;
        ret.qstride = this.qstride;
        ret.quality = this.quality;
        for (i = 0; i < this.ref_count.length; ++i) {
            System.arraycopy(this.ref_count[i], 0, ret.ref_count[i], 0, this.ref_count[i].length);
        }
        System.arraycopy(this.ref_index, 0, ret.ref_index, 0, this.ref_index.length);
        for (i = 0; i < this.ref_poc.length; ++i) {
            for (int j = 0; j < this.ref_poc[i].length; ++j) {
                System.arraycopy(this.ref_poc[i][j], 0, ret.ref_poc[i][j], 0, this.ref_poc[i][j].length);
            }
        }
        ret.reference = this.reference;
        ret.reordered_opaque = this.reordered_opaque;
        ret.repeat_pict = this.repeat_pict;
        ret.top_field_first = this.top_field_first;
        ret.type = this.type;
        return ret;
    }

    public void resetToZero() {
    }

    public static void pic_as_field(AVFrame pic, int parity) {
        int i = 0;
        while (i < 4) {
            if (parity == 2) {
                int n = i;
                pic.data_offset[n] = pic.data_offset[n] + pic.linesize[i];
            }
            pic.reference = parity;
            int n = i++;
            pic.linesize[n] = pic.linesize[n] * 2;
        }
        pic.poc = pic.field_poc[parity == 2 ? 1 : 0];
    }

    public static int split_field_copy(AVFrame dest, AVFrame src, int parity, int id_add) {
        int match;
        int n = match = (src.reference & parity) != 0 ? 1 : 0;
        if (match != 0) {
            src.copyTo(dest);
            if (parity != 3) {
                AVFrame.pic_as_field(dest, parity);
                dest.pic_id *= 2;
                dest.pic_id += id_add;
            }
        }
        return match;
    }

    public static int build_def_list(AVFrame[] def_base, int def_offset, AVFrame[] in_base, int in_offset, int len, int is_long, int sel) {
        int[] i = new int[]{0, 0};
        int index = 0;
        while (i[0] < len || i[1] < len) {
            while (i[0] < len && (in_base[in_offset + i[0]] == null || (in_base[in_offset + i[0]].reference & sel) == 0)) {
                i[0] = i[0] + 1;
            }
            while (i[1] < len && (in_base[in_offset + i[1]] == null || (in_base[in_offset + i[1]].reference & (sel ^ 3)) == 0)) {
                i[1] = i[1] + 1;
            }
            if (i[0] < len) {
                in_base[in_offset + i[0]].pic_id = is_long != 0 ? i[0] : in_base[in_offset + i[0]].frame_num;
                int n = index++;
                int n2 = i[0];
                i[0] = n2 + 1;
                AVFrame.split_field_copy(def_base[def_offset + n], in_base[in_offset + n2], sel, 1);
            }
            if (i[1] >= len) continue;
            in_base[in_offset + i[1]].pic_id = is_long != 0 ? i[1] : in_base[in_offset + i[1]].frame_num;
            int n = index++;
            int n3 = i[1];
            i[1] = n3 + 1;
            AVFrame.split_field_copy(def_base[def_offset + n], in_base[in_offset + n3], sel ^ 3, 0);
        }
        return index;
    }

    public static int add_sorted(AVFrame[] sorted_base, int sorted_offset, AVFrame[] src_base, int src_offset, int len, int limit, int dir) {
        int out_i = 0;
        while (true) {
            int best_poc = dir != 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE;
            for (int i = 0; i < len; ++i) {
                int poc = src_base[src_offset + i].poc;
                if (!(poc > limit ^ dir != 0) || !(poc < best_poc ^ dir != 0)) continue;
                best_poc = poc;
                sorted_base[sorted_offset + out_i] = src_base[src_offset + i];
            }
            if (best_poc == (dir != 0 ? Integer.MIN_VALUE : Integer.MAX_VALUE)) break;
            limit = sorted_base[sorted_offset + out_i++].poc - dir;
        }
        return out_i;
    }

    public static AVFrame avcodec_alloc_frame() {
        AVFrame ret = new AVFrame();
        ret.pts = Long.MIN_VALUE;
        ret.key_frame = 1;
        return ret;
    }
}

