/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.EnumMap;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.border.LineBorder;
import jpcsp.Controller;
import jpcsp.Emulator;
import jpcsp.GUI.CancelButton;
import jpcsp.State;
import jpcsp.WindowPropSaver;
import jpcsp.settings.Settings;
import net.java.games.input.Component;
import net.java.games.input.ControllerEnvironment;
import net.java.games.input.Event;
import net.java.games.input.EventQueue;

public class ControlsGUI
extends JFrame
implements KeyListener {
    private static final long serialVersionUID = -732715495873159718L;
    public static final String identifierForConfig = "controlsGUI";
    private boolean getKey = false;
    private JTextField sender;
    private Controller.keyCode targetKey;
    private Map<Integer, Controller.keyCode> currentKeys;
    private Map<Controller.keyCode, Integer> revertKeys;
    private Map<Controller.keyCode, String> currentController;
    private ControllerPollThread controllerPollThread;
    private static final int maxControllerFieldValueLength = 9;
    private JLabel bgLabel1;
    private CancelButton cancelButton;
    private JComboBox controllerBox;
    private JLabel controllerLabel;
    private JPanel fgPanel;
    private JTextField fieldAnalogDown;
    private JTextField fieldAnalogLeft;
    private JTextField fieldAnalogRight;
    private JTextField fieldAnalogUp;
    private JTextField fieldCircle;
    private JTextField fieldCross;
    private JTextField fieldDown;
    private JTextField fieldHold;
    private JTextField fieldHome;
    private JTextField fieldLTrigger;
    private JTextField fieldLeft;
    private JTextField fieldMusic;
    private JTextField fieldRTrigger;
    private JTextField fieldRight;
    private JTextField fieldScreen;
    private JTextField fieldSelect;
    private JTextField fieldSquare;
    private JTextField fieldStart;
    private JTextField fieldTriangle;
    private JTextField fieldUp;
    private JTextField fieldVolMin;
    private JTextField fieldVolPlus;
    private JButton jButtonOK;
    private JPanel keyPanel;

    public ControlsGUI() {
        this.initComponents();
        this.loadKeys();
        net.java.games.input.Controller controller = Controller.getInstance().getInputController();
        if (controller != null) {
            for (int i = 0; i < this.controllerBox.getItemCount(); ++i) {
                if (controller != this.controllerBox.getItemAt(i)) continue;
                this.controllerBox.setSelectedIndex(i);
                break;
            }
        }
        this.setFields();
        this.fieldCircle.addKeyListener(this);
        this.fieldCross.addKeyListener(this);
        this.fieldDown.addKeyListener(this);
        this.fieldLTrigger.addKeyListener(this);
        this.fieldLeft.addKeyListener(this);
        this.fieldRTrigger.addKeyListener(this);
        this.fieldRight.addKeyListener(this);
        this.fieldSelect.addKeyListener(this);
        this.fieldSquare.addKeyListener(this);
        this.fieldStart.addKeyListener(this);
        this.fieldTriangle.addKeyListener(this);
        this.fieldUp.addKeyListener(this);
        this.fieldHome.addKeyListener(this);
        this.fieldScreen.addKeyListener(this);
        this.fieldMusic.addKeyListener(this);
        this.fieldVolPlus.addKeyListener(this);
        this.fieldVolMin.addKeyListener(this);
        this.fieldHold.addKeyListener(this);
        this.fieldAnalogUp.addKeyListener(this);
        this.fieldAnalogDown.addKeyListener(this);
        this.fieldAnalogLeft.addKeyListener(this);
        this.fieldAnalogRight.addKeyListener(this);
        this.controllerBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                ControlsGUI.this.onControllerChange();
            }
        });
        this.controllerPollThread = new ControllerPollThread();
        this.controllerPollThread.setName("Controller Poll Thread");
        this.controllerPollThread.setDaemon(true);
        this.controllerPollThread.start();
        WindowPropSaver.loadWindowProperties(this);
    }

    @Override
    public void dispose() {
        if (this.controllerPollThread != null) {
            this.controllerPollThread.exit = true;
        }
        Emulator.getMainGUI().endWindowDialog();
        super.dispose();
    }

    private void onControllerChange() {
        this.setFields();
    }

    private net.java.games.input.Controller getSelectedController() {
        if (this.controllerBox != null) {
            int controllerIndex = this.controllerBox.getSelectedIndex();
            ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
            net.java.games.input.Controller[] controllers = ce.getControllers();
            if (controllers != null && controllerIndex >= 0 && controllerIndex < controllers.length) {
                return controllers[controllerIndex];
            }
        }
        return null;
    }

    private void loadKeys() {
        this.currentKeys = Settings.getInstance().loadKeys();
        this.revertKeys = new EnumMap<Controller.keyCode, Integer>(Controller.keyCode.class);
        for (Map.Entry<Integer, Controller.keyCode> entry : this.currentKeys.entrySet()) {
            this.revertKeys.put(entry.getValue(), entry.getKey());
        }
        this.currentController = Settings.getInstance().loadController();
    }

    private void setFieldValue(Controller.keyCode key, String value) {
        switch (key) {
            case DOWN: {
                this.fieldDown.setText(value);
                break;
            }
            case UP: {
                this.fieldUp.setText(value);
                break;
            }
            case LEFT: {
                this.fieldLeft.setText(value);
                break;
            }
            case RIGHT: {
                this.fieldRight.setText(value);
                break;
            }
            case LANDOWN: {
                this.fieldAnalogDown.setText(value);
                break;
            }
            case LANUP: {
                this.fieldAnalogUp.setText(value);
                break;
            }
            case LANLEFT: {
                this.fieldAnalogLeft.setText(value);
                break;
            }
            case LANRIGHT: {
                this.fieldAnalogRight.setText(value);
                break;
            }
            case TRIANGLE: {
                this.fieldTriangle.setText(value);
                break;
            }
            case SQUARE: {
                this.fieldSquare.setText(value);
                break;
            }
            case CIRCLE: {
                this.fieldCircle.setText(value);
                break;
            }
            case CROSS: {
                this.fieldCross.setText(value);
                break;
            }
            case L1: {
                this.fieldLTrigger.setText(value);
                break;
            }
            case R1: {
                this.fieldRTrigger.setText(value);
                break;
            }
            case START: {
                this.fieldStart.setText(value);
                break;
            }
            case SELECT: {
                this.fieldSelect.setText(value);
                break;
            }
            case HOME: {
                this.fieldHome.setText(value);
                break;
            }
            case HOLD: {
                this.fieldHold.setText(value);
                break;
            }
            case VOLMIN: {
                this.fieldVolMin.setText(value);
                break;
            }
            case VOLPLUS: {
                this.fieldVolPlus.setText(value);
                break;
            }
            case SCREEN: {
                this.fieldScreen.setText(value);
                break;
            }
            case MUSIC: {
                this.fieldMusic.setText(value);
                break;
            }
        }
    }

    private void setFields() {
        if (Controller.isKeyboardController(this.getSelectedController())) {
            for (Map.Entry<Integer, Controller.keyCode> entry : this.currentKeys.entrySet()) {
                this.setFieldValue(entry.getValue(), KeyEvent.getKeyText(entry.getKey()));
            }
        } else {
            for (Map.Entry<Controller.keyCode, String> entry : this.currentController.entrySet()) {
                String identifierName = entry.getValue();
                this.setFieldValue(entry.getKey(), this.getControllerFieldText(identifierName));
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent arg0) {
    }

    @Override
    public void keyReleased(KeyEvent arg0) {
    }

    @Override
    public void keyPressed(KeyEvent arg0) {
        if (!this.getKey) {
            return;
        }
        this.getKey = false;
        int pressedKey = arg0.getKeyCode();
        Controller.keyCode k = this.currentKeys.get(pressedKey);
        if (k != null) {
            Emulator.log.warn((Object)("Key already used for " + (Object)((Object)k)));
            this.sender.setText(KeyEvent.getKeyText(this.revertKeys.get((Object)this.targetKey)));
            return;
        }
        int oldMapping = this.revertKeys.get((Object)this.targetKey);
        this.revertKeys.remove((Object)this.targetKey);
        this.currentKeys.remove(oldMapping);
        this.currentKeys.put(pressedKey, this.targetKey);
        this.revertKeys.put(this.targetKey, pressedKey);
        this.sender.setText(KeyEvent.getKeyText(pressedKey));
        this.getKey = false;
    }

    private void setKey(JTextField sender, Controller.keyCode targetKey) {
        if (this.getKey) {
            this.sender.setText(KeyEvent.getKeyText(this.revertKeys.get((Object)this.targetKey)));
        }
        sender.setText("PressKey");
        this.getKey = true;
        this.sender = sender;
        this.targetKey = targetKey;
    }

    private void setControllerMapping(Controller.keyCode targetKey, String identifierName, JTextField field) {
        this.currentController.put(targetKey, identifierName);
        field.setText(this.getControllerFieldText(identifierName));
        this.getKey = false;
    }

    private Component getControllerComponent(String identifierName) {
        net.java.games.input.Controller controller = this.getSelectedController();
        if (controller == null) {
            return null;
        }
        Component[] components = controller.getComponents();
        if (components == null) {
            return null;
        }
        for (int i = 0; i < components.length; ++i) {
            if (!identifierName.equals(components[i].getIdentifier().getName())) continue;
            return components[i];
        }
        return null;
    }

    private String getControllerFieldText(String identifierName) {
        Component component = this.getControllerComponent(identifierName);
        if (component == null) {
            return identifierName;
        }
        String name = component.getName();
        if (name == null) {
            name = identifierName;
        } else if (name.length() > 9 && identifierName.length() < name.length()) {
            name = identifierName;
        }
        return name;
    }

    private void onControllerEvent(Event event) {
        if (!this.getKey) {
            return;
        }
        Component component = event.getComponent();
        float value = event.getValue();
        Component.Identifier identifier = component.getIdentifier();
        String identifierName = identifier.getName();
        if (identifier instanceof Component.Identifier.Button && value == 1.0f) {
            this.setControllerMapping(this.targetKey, identifierName, this.sender);
        } else if (identifier == Component.Identifier.Axis.POV) {
            switch (this.targetKey) {
                case DOWN: 
                case UP: 
                case LEFT: 
                case RIGHT: {
                    this.setControllerMapping(Controller.keyCode.DOWN, identifierName, this.fieldDown);
                    this.setControllerMapping(Controller.keyCode.UP, identifierName, this.fieldUp);
                    this.setControllerMapping(Controller.keyCode.LEFT, identifierName, this.fieldLeft);
                    this.setControllerMapping(Controller.keyCode.RIGHT, identifierName, this.fieldRight);
                    break;
                }
                default: {
                    Controller.log.warn((Object)String.format("Unknown Controller POV Event on %s(%s): %f for %s", component.getName(), identifier.getName(), Float.valueOf(value), this.targetKey.toString()));
                    break;
                }
            }
        } else if (identifier instanceof Component.Identifier.Axis && !Controller.isInDeadZone(component, value)) {
            switch (this.targetKey) {
                case DOWN: 
                case UP: {
                    this.setControllerMapping(Controller.keyCode.DOWN, identifierName, this.fieldDown);
                    this.setControllerMapping(Controller.keyCode.UP, identifierName, this.fieldUp);
                    break;
                }
                case LEFT: 
                case RIGHT: {
                    this.setControllerMapping(Controller.keyCode.LEFT, identifierName, this.fieldLeft);
                    this.setControllerMapping(Controller.keyCode.RIGHT, identifierName, this.fieldRight);
                    break;
                }
                case LANDOWN: 
                case LANUP: {
                    this.setControllerMapping(Controller.keyCode.LANDOWN, identifierName, this.fieldAnalogDown);
                    this.setControllerMapping(Controller.keyCode.LANUP, identifierName, this.fieldAnalogUp);
                    break;
                }
                case LANLEFT: 
                case LANRIGHT: {
                    this.setControllerMapping(Controller.keyCode.LANLEFT, identifierName, this.fieldAnalogLeft);
                    this.setControllerMapping(Controller.keyCode.LANRIGHT, identifierName, this.fieldAnalogRight);
                    break;
                }
                default: {
                    this.setControllerMapping(this.targetKey, identifierName, this.sender);
                    break;
                }
            }
        } else if (identifier instanceof Component.Identifier.Axis && Controller.isInDeadZone(component, value)) {
            Controller.log.debug((Object)String.format("Unknown Controller Event in DeadZone on %s(%s): %f for %s", component.getName(), identifier.getName(), Float.valueOf(value), this.targetKey.toString()));
        } else {
            Controller.log.warn((Object)String.format("Unknown Controller Event on %s(%s): %f for %s", component.getName(), identifier.getName(), Float.valueOf(value), this.targetKey.toString()));
        }
    }

    public ComboBoxModel makeControllerComboBoxModel() {
        net.java.games.input.Controller[] controllers;
        DefaultComboBoxModel<net.java.games.input.Controller> comboBox = new DefaultComboBoxModel<net.java.games.input.Controller>();
        ControllerEnvironment ce = ControllerEnvironment.getDefaultEnvironment();
        for (net.java.games.input.Controller c : controllers = ce.getControllers()) {
            comboBox.addElement(c);
        }
        return comboBox;
    }

    private void initComponents() {
        this.controllerLabel = new JLabel();
        this.controllerBox = new JComboBox();
        this.keyPanel = new JPanel();
        this.fgPanel = new JPanel();
        this.fieldStart = new JTextField();
        this.fieldSelect = new JTextField();
        this.fieldCross = new JTextField();
        this.fieldCircle = new JTextField();
        this.fieldTriangle = new JTextField();
        this.fieldSquare = new JTextField();
        this.fieldRight = new JTextField();
        this.fieldUp = new JTextField();
        this.fieldLeft = new JTextField();
        this.fieldDown = new JTextField();
        this.fieldHold = new JTextField();
        this.fieldHome = new JTextField();
        this.fieldVolMin = new JTextField();
        this.fieldVolPlus = new JTextField();
        this.fieldLTrigger = new JTextField();
        this.fieldRTrigger = new JTextField();
        this.fieldScreen = new JTextField();
        this.fieldMusic = new JTextField();
        this.fieldAnalogUp = new JTextField();
        this.fieldAnalogDown = new JTextField();
        this.fieldAnalogLeft = new JTextField();
        this.fieldAnalogRight = new JTextField();
        this.bgLabel1 = new JLabel();
        this.jButtonOK = new JButton();
        this.cancelButton = new CancelButton();
        ResourceBundle bundle = ResourceBundle.getBundle("jpcsp/languages/jpcsp");
        this.setTitle(bundle.getString("ControlsGUI.title"));
        this.setResizable(false);
        this.controllerLabel.setText(bundle.getString("ControlsGUI.controllerLabel.text"));
        this.controllerBox.setModel(this.makeControllerComboBoxModel());
        this.keyPanel.setBackground(new Color(255, 255, 255));
        this.keyPanel.setMinimumSize(new Dimension(1, 1));
        this.keyPanel.setLayout(new GridBagLayout());
        this.fgPanel.setBorder(BorderFactory.createEtchedBorder(0));
        this.fgPanel.setOpaque(false);
        this.fgPanel.setPreferredSize(new Dimension(614, 312));
        this.fieldStart.setEditable(false);
        this.fieldStart.setFont(new Font("Courier New", 1, 12));
        this.fieldStart.setHorizontalAlignment(0);
        this.fieldStart.setText("Enter");
        this.fieldStart.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldStart.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldStart.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldStartMouseClicked(evt);
            }
        });
        this.fieldSelect.setEditable(false);
        this.fieldSelect.setFont(new Font("Courier New", 1, 12));
        this.fieldSelect.setHorizontalAlignment(0);
        this.fieldSelect.setText("Space");
        this.fieldSelect.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldSelect.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldSelect.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldSelectMouseClicked(evt);
            }
        });
        this.fieldCross.setEditable(false);
        this.fieldCross.setFont(new Font("Courier New", 1, 12));
        this.fieldCross.setHorizontalAlignment(0);
        this.fieldCross.setText("S");
        this.fieldCross.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldCross.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldCross.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldCrossMouseClicked(evt);
            }
        });
        this.fieldCircle.setEditable(false);
        this.fieldCircle.setFont(new Font("Courier New", 1, 12));
        this.fieldCircle.setHorizontalAlignment(0);
        this.fieldCircle.setText("D");
        this.fieldCircle.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldCircle.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldCircle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldCircleMouseClicked(evt);
            }
        });
        this.fieldTriangle.setEditable(false);
        this.fieldTriangle.setFont(new Font("Courier New", 1, 12));
        this.fieldTriangle.setHorizontalAlignment(0);
        this.fieldTriangle.setText("W");
        this.fieldTriangle.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldTriangle.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldTriangle.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldTriangleMouseClicked(evt);
            }
        });
        this.fieldSquare.setEditable(false);
        this.fieldSquare.setFont(new Font("Courier New", 1, 12));
        this.fieldSquare.setHorizontalAlignment(0);
        this.fieldSquare.setText("A");
        this.fieldSquare.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldSquare.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldSquare.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldSquareMouseClicked(evt);
            }
        });
        this.fieldRight.setEditable(false);
        this.fieldRight.setFont(new Font("Courier New", 1, 12));
        this.fieldRight.setHorizontalAlignment(0);
        this.fieldRight.setText("Right");
        this.fieldRight.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldRight.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldRightMouseClicked(evt);
            }
        });
        this.fieldUp.setEditable(false);
        this.fieldUp.setFont(new Font("Courier New", 1, 12));
        this.fieldUp.setHorizontalAlignment(0);
        this.fieldUp.setText("Up");
        this.fieldUp.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldUp.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldUpMouseClicked(evt);
            }
        });
        this.fieldLeft.setEditable(false);
        this.fieldLeft.setFont(new Font("Courier New", 1, 12));
        this.fieldLeft.setHorizontalAlignment(0);
        this.fieldLeft.setText("Left");
        this.fieldLeft.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldLeft.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldLeftMouseClicked(evt);
            }
        });
        this.fieldDown.setEditable(false);
        this.fieldDown.setFont(new Font("Courier New", 1, 12));
        this.fieldDown.setHorizontalAlignment(0);
        this.fieldDown.setText("Down");
        this.fieldDown.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldDown.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldDownMouseClicked(evt);
            }
        });
        this.fieldHold.setEditable(false);
        this.fieldHold.setFont(new Font("Courier New", 1, 12));
        this.fieldHold.setHorizontalAlignment(0);
        this.fieldHold.setText("O");
        this.fieldHold.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldHold.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldHold.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldHoldMouseClicked(evt);
            }
        });
        this.fieldHome.setEditable(false);
        this.fieldHome.setFont(new Font("Courier New", 1, 12));
        this.fieldHome.setHorizontalAlignment(0);
        this.fieldHome.setText("H");
        this.fieldHome.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldHome.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldHome.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldHomeMouseClicked(evt);
            }
        });
        this.fieldVolMin.setEditable(false);
        this.fieldVolMin.setFont(new Font("Courier New", 1, 12));
        this.fieldVolMin.setHorizontalAlignment(0);
        this.fieldVolMin.setText("-");
        this.fieldVolMin.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldVolMin.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldVolMin.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldVolMinMouseClicked(evt);
            }
        });
        this.fieldVolPlus.setEditable(false);
        this.fieldVolPlus.setFont(new Font("Courier New", 1, 12));
        this.fieldVolPlus.setHorizontalAlignment(0);
        this.fieldVolPlus.setText("+");
        this.fieldVolPlus.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldVolPlus.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldVolPlus.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldVolPlusMouseClicked(evt);
            }
        });
        this.fieldLTrigger.setEditable(false);
        this.fieldLTrigger.setFont(new Font("Courier New", 1, 12));
        this.fieldLTrigger.setHorizontalAlignment(0);
        this.fieldLTrigger.setText("Q");
        this.fieldLTrigger.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldLTrigger.setBorder(new LineBorder(new Color(0, 0, 0), 1, true));
        this.fieldLTrigger.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldLTriggerMouseClicked(evt);
            }
        });
        this.fieldRTrigger.setEditable(false);
        this.fieldRTrigger.setFont(new Font("Courier New", 1, 12));
        this.fieldRTrigger.setHorizontalAlignment(0);
        this.fieldRTrigger.setText("E");
        this.fieldRTrigger.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldRTrigger.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldRTrigger.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldRTriggerMouseClicked(evt);
            }
        });
        this.fieldScreen.setEditable(false);
        this.fieldScreen.setFont(new Font("Courier New", 1, 12));
        this.fieldScreen.setHorizontalAlignment(0);
        this.fieldScreen.setText("N");
        this.fieldScreen.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldScreen.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldScreenMouseClicked(evt);
            }
        });
        this.fieldMusic.setEditable(false);
        this.fieldMusic.setFont(new Font("Courier New", 1, 12));
        this.fieldMusic.setHorizontalAlignment(0);
        this.fieldMusic.setText("M");
        this.fieldMusic.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldMusic.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldMusic.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldMusicMouseClicked(evt);
            }
        });
        this.fieldAnalogUp.setEditable(false);
        this.fieldAnalogUp.setFont(new Font("Courier New", 1, 12));
        this.fieldAnalogUp.setHorizontalAlignment(0);
        this.fieldAnalogUp.setText("I");
        this.fieldAnalogUp.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldAnalogUp.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldAnalogUp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogUpMouseClicked(evt);
            }
        });
        this.fieldAnalogDown.setEditable(false);
        this.fieldAnalogDown.setFont(new Font("Courier New", 1, 12));
        this.fieldAnalogDown.setHorizontalAlignment(0);
        this.fieldAnalogDown.setText("K");
        this.fieldAnalogDown.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldAnalogDown.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldAnalogDown.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogDownMouseClicked(evt);
            }
        });
        this.fieldAnalogLeft.setEditable(false);
        this.fieldAnalogLeft.setFont(new Font("Courier New", 1, 12));
        this.fieldAnalogLeft.setHorizontalAlignment(0);
        this.fieldAnalogLeft.setText("J");
        this.fieldAnalogLeft.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldAnalogLeft.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldAnalogLeft.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogLeftMouseClicked(evt);
            }
        });
        this.fieldAnalogRight.setEditable(false);
        this.fieldAnalogRight.setFont(new Font("Courier New", 1, 12));
        this.fieldAnalogRight.setHorizontalAlignment(0);
        this.fieldAnalogRight.setText("L");
        this.fieldAnalogRight.setToolTipText(bundle.getString("ControlsGUI.fieldPutKey.text"));
        this.fieldAnalogRight.setBorder(new LineBorder(new Color(102, 102, 102), 1, true));
        this.fieldAnalogRight.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                ControlsGUI.this.fieldAnalogRightMouseClicked(evt);
            }
        });
        GroupLayout fgPanelLayout = new GroupLayout(this.fgPanel);
        this.fgPanel.setLayout(fgPanelLayout);
        fgPanelLayout.setHorizontalGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addComponent(this.fieldAnalogLeft, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldAnalogRight, -2, 60, -2)).addGroup(fgPanelLayout.createSequentialGroup().addGap(35, 35, 35).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.TRAILING).addGroup(fgPanelLayout.createSequentialGroup().addComponent(this.fieldAnalogDown, -2, 60, -2).addGap(89, 89, 89).addComponent(this.fieldVolMin, -2, 60, -2).addGap(46, 46, 46)).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldAnalogUp, -2, 60, -2).addGroup(fgPanelLayout.createSequentialGroup().addGap(103, 103, 103).addComponent(this.fieldHome, -2, 60, -2).addGap(32, 32, 32).addComponent(this.fieldVolPlus, -2, 60, -2)))))).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(35, 35, 35).addComponent(this.fieldScreen, -2, 60, -2).addGap(0, 0, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 76, Short.MAX_VALUE).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addComponent(this.fieldMusic, -2, 60, -2).addGap(194, 194, 194)).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addComponent(this.fieldSelect, -2, 60, -2).addGap(72, 72, 72)))))).addGroup(fgPanelLayout.createSequentialGroup().addContainerGap().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addComponent(this.fieldDown, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldCross, -2, 60, -2)).addGroup(fgPanelLayout.createSequentialGroup().addComponent(this.fieldLTrigger, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldRTrigger, -2, 60, -2)).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addComponent(this.fieldLeft, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldCircle, -2, 60, -2)).addGroup(fgPanelLayout.createSequentialGroup().addComponent(this.fieldRight, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldSquare, -2, 60, -2)).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addComponent(this.fieldUp, -2, 60, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldTriangle, -2, 60, -2)).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.fieldHold, -2, 60, -2))).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, fgPanelLayout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.fieldStart, -2, 60, -2).addGap(39, 39, 39)));
        fgPanelLayout.setVerticalGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(7, 7, 7).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldLTrigger, -2, -1, -2).addComponent(this.fieldRTrigger, -2, -1, -2)).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(18, 18, 18).addComponent(this.fieldRight, -2, -1, -2).addGap(14, 14, 14).addComponent(this.fieldUp, -2, -1, -2)).addGroup(fgPanelLayout.createSequentialGroup().addGap(24, 24, 24).addComponent(this.fieldSquare, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.fieldTriangle, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldLeft, -2, -1, -2).addComponent(this.fieldCircle, GroupLayout.Alignment.TRAILING, -2, -1, -2)).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createSequentialGroup().addGap(12, 12, 12).addComponent(this.fieldDown, -2, -1, -2).addGap(82, 82, 82).addComponent(this.fieldAnalogUp, -2, -1, -2)).addGroup(fgPanelLayout.createSequentialGroup().addGap(50, 50, 50).addComponent(this.fieldHold, -2, -1, -2).addGap(18, 18, 18).addComponent(this.fieldStart, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldSelect, -2, -1, -2))).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.fieldAnalogRight, -2, -1, -2).addComponent(this.fieldHome, -2, -1, -2).addComponent(this.fieldVolPlus, -2, -1, -2)).addComponent(this.fieldAnalogLeft, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(fgPanelLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.fieldAnalogDown, -2, -1, -2).addComponent(this.fieldVolMin, -2, -1, -2)).addContainerGap(33, Short.MAX_VALUE)).addGroup(fgPanelLayout.createSequentialGroup().addGap(13, 13, 13).addComponent(this.fieldCross, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.fieldMusic, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.fieldScreen, -2, -1, -2).addGap(36, 36, 36)))));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.ipadx = 10;
        gridBagConstraints.ipady = 12;
        gridBagConstraints.anchor = 18;
        this.keyPanel.add((java.awt.Component)this.fgPanel, gridBagConstraints);
        this.bgLabel1.setHorizontalAlignment(0);
        this.bgLabel1.setIcon(new ImageIcon(this.getClass().getResource("/jpcsp/images/controls.jpg")));
        this.bgLabel1.setVerticalAlignment(1);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.keyPanel.add((java.awt.Component)this.bgLabel1, gridBagConstraints);
        this.jButtonOK.setText(bundle.getString("OkButton.text"));
        this.jButtonOK.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ControlsGUI.this.jButtonOKActionPerformed(evt);
            }
        });
        this.cancelButton.setText(bundle.getString("CancelButton.text"));
        this.cancelButton.setParent(this);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap(158, Short.MAX_VALUE).addComponent(this.controllerLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.controllerBox, -2, 209, -2).addContainerGap(193, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).addComponent(this.jButtonOK, -2, 88, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.cancelButton, -2, -1, -2).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.keyPanel, -2, -1, -2).addContainerGap())));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.controllerBox, -2, -1, -2).addComponent(this.controllerLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 343, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.cancelButton, -2, -1, -2).addComponent(this.jButtonOK)).addContainerGap()).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGap(46, 46, 46).addComponent(this.keyPanel, -2, -1, -2).addGap(46, 46, 46))));
        this.pack();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Settings.getInstance().writeKeys(this.currentKeys);
        Settings.getInstance().writeController(this.currentController);
        String controllerName = this.controllerBox.getSelectedItem().toString();
        Settings.getInstance().writeString("controller.controllerName", controllerName);
        int controllerNameIndex = 0;
        int selectedIndex = this.controllerBox.getSelectedIndex();
        for (int i = 0; i < this.controllerBox.getItemCount(); ++i) {
            if (!controllerName.equals(this.controllerBox.getItemAt(i).toString())) continue;
            if (i >= selectedIndex) break;
            ++controllerNameIndex;
        }
        Settings.getInstance().writeString("controller.controllerNameIndex", String.valueOf(controllerNameIndex));
        State.controller.setInputControllerIndex(this.controllerBox.getSelectedIndex());
        State.controller.loadKeyConfig(this.currentKeys);
        State.controller.loadControllerConfig(this.currentController);
        this.dispose();
    }

    private void fieldAnalogRightMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogRight, Controller.keyCode.LANRIGHT);
    }

    private void fieldAnalogLeftMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogLeft, Controller.keyCode.LANLEFT);
    }

    private void fieldAnalogDownMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogDown, Controller.keyCode.LANDOWN);
    }

    private void fieldAnalogUpMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldAnalogUp, Controller.keyCode.LANUP);
    }

    private void fieldMusicMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldMusic, Controller.keyCode.MUSIC);
    }

    private void fieldScreenMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldScreen, Controller.keyCode.SCREEN);
    }

    private void fieldRTriggerMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldRTrigger, Controller.keyCode.R1);
    }

    private void fieldLTriggerMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldLTrigger, Controller.keyCode.L1);
    }

    private void fieldVolPlusMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldVolPlus, Controller.keyCode.VOLPLUS);
    }

    private void fieldVolMinMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldVolMin, Controller.keyCode.VOLMIN);
    }

    private void fieldHomeMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldHome, Controller.keyCode.HOME);
    }

    private void fieldHoldMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldHold, Controller.keyCode.HOLD);
    }

    private void fieldDownMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldDown, Controller.keyCode.DOWN);
    }

    private void fieldLeftMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldLeft, Controller.keyCode.LEFT);
    }

    private void fieldUpMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldUp, Controller.keyCode.UP);
    }

    private void fieldRightMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldRight, Controller.keyCode.RIGHT);
    }

    private void fieldSquareMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldSquare, Controller.keyCode.SQUARE);
    }

    private void fieldTriangleMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldTriangle, Controller.keyCode.TRIANGLE);
    }

    private void fieldCircleMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldCircle, Controller.keyCode.CIRCLE);
    }

    private void fieldCrossMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldCross, Controller.keyCode.CROSS);
    }

    private void fieldSelectMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldSelect, Controller.keyCode.SELECT);
    }

    private void fieldStartMouseClicked(MouseEvent evt) {
        this.setKey(this.fieldStart, Controller.keyCode.START);
    }

    private class ControllerPollThread
    extends Thread {
        protected volatile boolean exit = false;

        private ControllerPollThread() {
        }

        @Override
        public void run() {
            while (!this.exit) {
                net.java.games.input.Controller controller = ControlsGUI.this.getSelectedController();
                if (controller != null && controller.poll()) {
                    EventQueue eventQueue = controller.getEventQueue();
                    Event event = new Event();
                    while (eventQueue.getNextEvent(event)) {
                        ControlsGUI.this.onControllerEvent(event);
                    }
                }
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

