/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.GUI;

import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import jpcsp.Emulator;
import jpcsp.filesystems.umdiso.UmdIsoReader;
import jpcsp.media.codec.CodecFactory;
import jpcsp.media.codec.IVideoCodec;
import jpcsp.media.codec.h264.H264Utils;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class UmdBrowserPmf {
    private static Logger log = Emulator.log;
    private UmdIsoReader iso;
    private String fileName;
    private long startTime;
    private Image image;
    private boolean done;
    private boolean endOfVideo;
    private boolean threadExit;
    private JLabel display;
    private PmfDisplayThread displayThread;
    private IVideoCodec videoCodec;
    private int[] videoData = new int[65536];
    private int videoDataOffset;
    private InputStream is;
    private int videoChannel = 0;
    private int frame;
    private int videoWidth;
    private int videoHeight;

    public UmdBrowserPmf(UmdIsoReader iso, String fileName, JLabel display) {
        this.iso = iso;
        this.fileName = fileName;
        this.display = display;
        this.init();
        this.initVideo();
    }

    private int read8(InputStream is) {
        try {
            return is.read();
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    private int read16(InputStream is) {
        return this.read8(is) << 8 | this.read8(is);
    }

    private int read32(InputStream is) {
        return this.read8(is) << 24 | this.read8(is) << 16 | this.read8(is) << 8 | this.read8(is);
    }

    private void skip(InputStream is, int n) {
        if (n > 0) {
            try {
                is.skip(n);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private int skipPesHeader(InputStream is, int startCode) {
        int pesLength = 0;
        int c = this.read8(is);
        ++pesLength;
        while (c == 255) {
            c = this.read8(is);
            ++pesLength;
        }
        if ((c & 0xC0) == 64) {
            this.skip(is, 1);
            c = this.read8(is);
            pesLength += 2;
        }
        if ((c & 0xE0) == 32) {
            this.skip(is, 4);
            pesLength += 4;
            if ((c & 0x10) != 0) {
                this.skip(is, 5);
                pesLength += 5;
            }
        } else if ((c & 0xC0) == 128) {
            this.skip(is, 1);
            int headerLength = this.read8(is);
            pesLength += 2;
            this.skip(is, headerLength);
            pesLength += headerLength;
        }
        if (startCode == 445) {
            int channel = this.read8(is);
            ++pesLength;
            if (channel >= 128 && channel <= 207) {
                this.skip(is, 3);
                pesLength += 3;
                if (channel >= 176 && channel <= 191) {
                    this.skip(is, 1);
                    ++pesLength;
                }
            } else {
                this.skip(is, 3);
                pesLength += 3;
            }
        }
        return pesLength;
    }

    private void addVideoData(InputStream is, int length) {
        if (this.videoDataOffset + length > this.videoData.length) {
            int[] newVideoData = new int[this.videoDataOffset + length];
            System.arraycopy(this.videoData, 0, newVideoData, 0, this.videoDataOffset);
            this.videoData = newVideoData;
        }
        for (int i = 0; i < length; ++i) {
            this.videoData[this.videoDataOffset++] = this.read8(is);
        }
    }

    private boolean readPsmfHeader() {
        try {
            this.is = this.iso.getFile(this.fileName);
        }
        catch (FileNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            log.error((Object)"readPsmfHeader", (Throwable)e);
            return false;
        }
        if (this.read32(this.is) != 1347636550) {
            return false;
        }
        this.skip(this.is, 4);
        int mpegOffset = this.read32(this.is);
        this.skip(this.is, 130);
        this.videoWidth = this.read8(this.is) << 4;
        this.videoHeight = this.read8(this.is) << 4;
        this.skip(this.is, mpegOffset - 143 - 1);
        return true;
    }

    private boolean readPsmfPacket(int videoChannel) {
        int startCode;
        while ((startCode = this.read32(this.is)) != -1) {
            switch (startCode) {
                case 442: {
                    this.skip(this.is, 10);
                    break;
                }
                case 443: {
                    this.skip(this.is, 14);
                    break;
                }
                case 445: 
                case 446: 
                case 447: {
                    int codeLength = this.read16(this.is);
                    this.skip(this.is, codeLength);
                    break;
                }
                case 480: 
                case 481: 
                case 482: 
                case 483: 
                case 484: 
                case 485: 
                case 486: 
                case 487: 
                case 488: 
                case 489: 
                case 490: 
                case 491: 
                case 492: 
                case 493: 
                case 494: 
                case 495: {
                    int codeLength = this.read16(this.is);
                    if (videoChannel < 0 || startCode - 480 == videoChannel) {
                        int pesLength = this.skipPesHeader(this.is, startCode);
                        this.addVideoData(this.is, codeLength -= pesLength);
                        return true;
                    }
                    this.skip(this.is, codeLength);
                }
            }
        }
        return false;
    }

    private void consumeVideoData(int length) {
        if (length >= this.videoDataOffset) {
            this.videoDataOffset = 0;
        } else {
            System.arraycopy(this.videoData, length, this.videoData, 0, this.videoDataOffset - length);
            this.videoDataOffset -= length;
        }
    }

    private int findFrameEnd() {
        for (int i = 5; i < this.videoDataOffset; ++i) {
            int naluType;
            if (this.videoData[i - 4] != 0 || this.videoData[i - 3] != 0 || this.videoData[i - 2] != 0 || this.videoData[i - 1] != 1 || (naluType = this.videoData[i] & 0x1F) != 9) continue;
            return i - 4;
        }
        return -1;
    }

    private void init() {
        this.image = null;
        this.done = false;
        this.threadExit = false;
    }

    private Image getImage() {
        return this.image;
    }

    public final boolean initVideo() {
        if (!this.startVideo()) {
            return false;
        }
        this.displayThread = new PmfDisplayThread();
        this.displayThread.setDaemon(true);
        this.displayThread.setName("UMD Browser - PMF Display Thread");
        this.displayThread.start();
        return true;
    }

    private boolean startVideo() {
        this.endOfVideo = false;
        if (!this.readPsmfHeader()) {
            return false;
        }
        this.videoCodec = CodecFactory.getVideoCodec();
        this.videoCodec.init(null);
        this.startTime = System.currentTimeMillis();
        this.frame = 0;
        return true;
    }

    private void closeVideo() {
        this.videoCodec = null;
        if (this.is != null) {
            try {
                this.is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.is = null;
        }
    }

    private void loopVideo() {
        this.closeVideo();
        this.startVideo();
    }

    private void stopDisplayThread() {
        while (this.displayThread != null && !this.threadExit) {
            this.done = true;
            Utilities.sleep(1, 0);
        }
        this.displayThread = null;
    }

    public void stopVideo() {
        this.stopDisplayThread();
        this.closeVideo();
    }

    public void stepVideo() {
        int[] cr;
        int size2;
        int[] cb;
        int height;
        int width;
        int size;
        int[] luma;
        this.image = null;
        int frameSize = -1;
        do {
            if (!this.readPsmfPacket(this.videoChannel)) {
                if (this.videoDataOffset <= 0) break;
                frameSize = this.findFrameEnd();
                if (frameSize >= 0) continue;
                frameSize = this.videoDataOffset;
                continue;
            }
            frameSize = this.findFrameEnd();
        } while (frameSize <= 0);
        if (frameSize <= 0) {
            this.endOfVideo = true;
            return;
        }
        int consumedLength = this.videoCodec.decode(this.videoData, 0, frameSize);
        if (consumedLength < 0) {
            this.endOfVideo = true;
            return;
        }
        this.consumeVideoData(consumedLength);
        if (this.videoCodec.hasImage() && this.videoCodec.getImage(luma = new int[size = (width = this.videoCodec.getImageWidth()) * (height = this.videoCodec.getImageHeight())], cb = new int[size2 = size >> 2], cr = new int[size2]) == 0) {
            int[] abgr = new int[size];
            H264Utils.YUV2ARGB(width, height, luma, cb, cr, abgr);
            this.image = this.display.createImage(new MemoryImageSource(this.videoWidth, this.videoHeight, abgr, 0, width));
            ++this.frame;
            long now = System.currentTimeMillis();
            long currentDuration = now - this.startTime;
            long videoDuration = (long)this.frame * 100000L / 3003L;
            if (currentDuration < videoDuration) {
                Utilities.sleep((int)(videoDuration - currentDuration), 0);
            }
        }
    }

    private class PmfDisplayThread
    extends Thread {
        private PmfDisplayThread() {
        }

        @Override
        public void run() {
            while (!UmdBrowserPmf.this.done) {
                while (!UmdBrowserPmf.this.endOfVideo && !UmdBrowserPmf.this.done) {
                    UmdBrowserPmf.this.stepVideo();
                    if (UmdBrowserPmf.this.display == null || UmdBrowserPmf.this.getImage() == null) continue;
                    UmdBrowserPmf.this.display.setIcon(new ImageIcon(UmdBrowserPmf.this.getImage()));
                }
                if (UmdBrowserPmf.this.done) continue;
                UmdBrowserPmf.this.loopVideo();
            }
            UmdBrowserPmf.this.threadExit = true;
        }
    }
}

