/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE;

import jpcsp.HLE.ITPointerBase;
import jpcsp.HLE.TPointer32;
import jpcsp.Memory;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.Utilities;

public class TPointer
implements ITPointerBase {
    private Memory memory;
    private int address;
    private boolean isNull;
    public static final TPointer NULL = new TPointer();

    protected TPointer() {
        this.memory = null;
        this.address = 0;
        this.isNull = true;
    }

    public TPointer(Memory memory, int address) {
        this.memory = memory;
        this.address = memory.normalize(address);
        this.isNull = address == 0;
    }

    public TPointer(TPointer base) {
        this.memory = base.getMemory();
        this.address = base.getAddress();
        this.isNull = base.isNull();
    }

    public TPointer(TPointer base, int addressOffset) {
        this.memory = base.getMemory();
        this.address = base.isNull() ? 0 : base.getAddress() + addressOffset;
        this.isNull = base.isNull();
    }

    public TPointer add(int addressOffset) {
        if (this.isNotNull()) {
            this.address += addressOffset;
        }
        return this;
    }

    public TPointer sub(int addressOffset) {
        if (this.isNotNull()) {
            this.address -= addressOffset;
        }
        return this;
    }

    public TPointer alignUp(int alignment) {
        if (this.isNotNull()) {
            this.address = Utilities.alignUp(this.address, alignment);
        }
        return this;
    }

    @Override
    public boolean isAddressGood() {
        return Memory.isAddressGood(this.address);
    }

    @Override
    public boolean isAlignedTo(int offset) {
        return this.address % offset == 0;
    }

    @Override
    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = this.memory.normalize(address);
        this.isNull = address == 0;
    }

    @Override
    public Memory getMemory() {
        return this.memory;
    }

    @Override
    public Memory getNewPointerMemory() {
        return this.memory;
    }

    @Override
    public boolean isNull() {
        return this.isNull;
    }

    @Override
    public boolean isNotNull() {
        return !this.isNull;
    }

    public TPointer forceNonNull() {
        this.isNull = false;
        return this;
    }

    public byte getValue8() {
        return this.getValue8(0);
    }

    public short getValue16() {
        return this.getValue16(0);
    }

    public int getValue32() {
        return this.getValue32(0);
    }

    public long getValue64() {
        return this.getValue64(0);
    }

    public short getUnalignedValue16() {
        return this.getUnalignedValue16(0);
    }

    public int getUnalignedValue32() {
        return this.getUnalignedValue32(0);
    }

    public long getUnalignedValue64() {
        return this.getUnalignedValue64(0);
    }

    public int getUnsignedValue8() {
        return this.getUnsignedValue8(0);
    }

    public int getUnsignedValue16() {
        return this.getUnsignedValue16(0);
    }

    public float getFloat() {
        return this.getFloat(0);
    }

    public void setValue8(byte value) {
        this.setValue8(0, value);
    }

    public void setValue16(short value) {
        this.setValue16(0, value);
    }

    public void setValue32(int value) {
        this.setValue32(0, value);
    }

    public void setValue32(boolean value) {
        this.setValue32(0, value);
    }

    public void setValue64(long value) {
        this.setValue64(0, value);
    }

    public void setUnsignedValue8(int value) {
        this.setUnsignedValue8(0, value);
    }

    public void setUnsignedValue16(int value) {
        this.setUnsignedValue16(0, value);
    }

    public void setFloat(float value) {
        this.setFloat(0, value);
    }

    public byte getValue8(int offset) {
        return (byte)this.getUnsignedValue8(offset);
    }

    public short getValue16(int offset) {
        return (short)this.getUnsignedValue16(offset);
    }

    public int getValue32(int offset) {
        return this.memory.read32(this.address + offset);
    }

    public long getValue64(int offset) {
        return this.memory.read64(this.address + offset);
    }

    public short getUnalignedValue16(int offset) {
        return (short)Utilities.readUnaligned16(this.memory, this.address + offset);
    }

    public int getUnalignedValue32(int offset) {
        return Utilities.readUnaligned32(this.memory, this.address + offset);
    }

    public long getUnalignedValue64(int offset) {
        return Utilities.readUnaligned64(this.memory, this.address + offset);
    }

    public int getUnsignedValue8(int offset) {
        return this.memory.read8(this.address + offset);
    }

    public int getUnsignedValue16(int offset) {
        return this.memory.read16(this.address + offset);
    }

    public float getFloat(int offset) {
        return Float.intBitsToFloat(this.getValue32(offset));
    }

    public void setValue8(int offset, byte value) {
        if (this.isNotNull()) {
            this.memory.write8(this.address + offset, value);
        }
    }

    public void setValue16(int offset, short value) {
        if (this.isNotNull()) {
            this.memory.write16(this.address + offset, value);
        }
    }

    public void setValue32(int offset, int value) {
        if (this.isNotNull()) {
            this.memory.write32(this.address + offset, value);
        }
    }

    public void setValue32(int offset, boolean value) {
        if (this.isNotNull()) {
            this.memory.write32(this.address + offset, value ? 1 : 0);
        }
    }

    public void setValue64(int offset, long value) {
        if (this.isNotNull()) {
            this.memory.write64(this.address + offset, value);
        }
    }

    public void setUnsignedValue8(int offset, int value) {
        if (this.isNotNull()) {
            this.memory.write8(this.address + offset, (byte)value);
        }
    }

    public void setUnsignedValue16(int offset, int value) {
        if (this.isNotNull()) {
            this.memory.write16(this.address + offset, (short)value);
        }
    }

    public void setFloat(int offset, float value) {
        this.setValue32(offset, Float.floatToRawIntBits(value));
    }

    public void incrValue8(int value) {
        this.incrValue8(0, value);
    }

    public void incrValue16(int value) {
        this.incrValue16(0, value);
    }

    public void incrValue32(int value) {
        this.incrValue32(0, value);
    }

    public void incrValue64(long value) {
        this.incrValue64(0, value);
    }

    public void incrValue8(int offset, int value) {
        if (this.isNotNull()) {
            this.memory.write8(this.address + offset, (byte)(this.memory.read8(this.address + offset) + value));
        }
    }

    public void incrValue16(int offset, int value) {
        if (this.isNotNull()) {
            this.memory.write16(this.address + offset, (short)(this.memory.read16(this.address + offset) + value));
        }
    }

    public void incrValue32(int offset, int value) {
        if (this.isNotNull()) {
            this.memory.write32(this.address + offset, this.memory.read32(this.address + offset) + value);
        }
    }

    public void incrValue64(int offset, long value) {
        if (this.isNotNull()) {
            this.memory.write64(this.address + offset, this.memory.read64(this.address + offset) + value);
        }
    }

    public void decrValue8(int value) {
        this.decrValue8(0, value);
    }

    public void decrValue16(int value) {
        this.decrValue16(0, value);
    }

    public void decrValue32(int value) {
        this.decrValue32(0, value);
    }

    public void decrValue64(long value) {
        this.decrValue64(0, value);
    }

    public void decrValue8(int offset, int value) {
        this.incrValue8(offset, -value);
    }

    public void decrValue16(int offset, int value) {
        this.incrValue16(offset, -value);
    }

    public void decrValue32(int offset, int value) {
        this.incrValue32(offset, -value);
    }

    public void decrValue64(int offset, long value) {
        this.incrValue64(offset, -value);
    }

    public String getStringZ() {
        if (this.isNull()) {
            return null;
        }
        return Utilities.readStringZ(this.memory, this.address);
    }

    public String getStringNZ(int n) {
        return this.getStringNZ(0, n);
    }

    public String getStringNZ(int offset, int n) {
        if (this.isNull()) {
            return null;
        }
        return Utilities.readStringNZ(this.memory, this.address + offset, n);
    }

    public void setStringNZ(int n, String s) {
        this.setStringNZ(0, n, s);
    }

    public void setStringNZ(int offset, int n, String s) {
        if (this.isNotNull()) {
            Utilities.writeStringNZ(this.memory, this.address + offset, n, s);
        }
    }

    public void setStringZ(String s) {
        if (this.isNotNull()) {
            Utilities.writeStringZ(this.memory, this.address, s);
        }
    }

    public byte[] getArray8(int n) {
        return this.getArray8(0, n);
    }

    public byte[] getArray8(int offset, int n) {
        return this.getArray8(offset, new byte[n], 0, n);
    }

    public byte[] getArray8(byte[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        return this.getArray8(0, bytes, 0, bytes.length);
    }

    public byte[] getArray8(int offset, byte[] bytes, int bytesOffset, int n) {
        if (this.isNotNull()) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.getMemory(), this.getAddress() + offset, n, 1);
            for (int i = 0; i < n; ++i) {
                bytes[bytesOffset + i] = (byte)memoryReader.readNext();
            }
        }
        return bytes;
    }

    public int[] getArrayUnsigned8(int n) {
        return this.getArrayUnsigned8(0, n);
    }

    public int[] getArrayUnsigned8(int offset, int n) {
        return this.getArrayUnsigned8(offset, new int[n], 0, n);
    }

    public int[] getArrayUnsigned8(int[] bytes) {
        if (bytes == null) {
            return bytes;
        }
        return this.getArrayUnsigned8(0, bytes, 0, bytes.length);
    }

    public int[] getArrayUnsigned8(int offset, int[] bytes, int bytesOffset, int n) {
        if (this.isNotNull()) {
            IMemoryReader memoryReader = MemoryReader.getMemoryReader(this.getMemory(), this.getAddress() + offset, n, 1);
            for (int i = 0; i < n; ++i) {
                bytes[bytesOffset + i] = memoryReader.readNext();
            }
        }
        return bytes;
    }

    public void setArray(byte[] bytes) {
        if (bytes != null) {
            this.setArray(bytes, bytes.length);
        }
    }

    public void setArray(byte[] bytes, int n) {
        this.setArray(0, bytes, n);
    }

    public void setArray(int offset, byte[] bytes) {
        if (bytes != null) {
            this.setArray(offset, bytes, bytes.length);
        }
    }

    public void setArray(int offset, byte[] bytes, int n) {
        this.setArray(offset, bytes, 0, n);
    }

    public void setArray(int offset, byte[] bytes, int bytesOffset, int n) {
        if (this.isNotNull()) {
            IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(this.getMemory(), this.getAddress() + offset, n, 1);
            for (int i = 0; i < n; ++i) {
                memoryWriter.writeNext(bytes[bytesOffset + i] & 0xFF);
            }
            memoryWriter.flush();
        }
    }

    public TPointer getPointer() {
        return this.getPointer(0);
    }

    public TPointer getPointer(int offset) {
        if (this.isNull()) {
            return NULL;
        }
        return new TPointer(this.getNewPointerMemory(), this.getValue32(offset));
    }

    public void setPointer(TPointer value) {
        this.setPointer(0, value);
    }

    public void setPointer(int offset, TPointer value) {
        if (value == null) {
            this.setValue32(offset, 0);
        } else {
            this.setValue32(offset, value.getAddress());
        }
    }

    public void setPointer(TPointer32 value) {
        this.setPointer(0, value);
    }

    public void setPointer(int offset, TPointer32 value) {
        if (value == null) {
            this.setValue32(offset, 0);
        } else {
            this.setValue32(offset, value.getAddress());
        }
    }

    public void memcpy(int src, int length) {
        this.memcpy(0, src, length);
    }

    public void memcpy(int offset, int src, int length) {
        if (this.isNotNull()) {
            this.memory.memcpy(this.getAddress() + offset, src, length);
        }
    }

    public void memcpy(TPointer src, int length) {
        this.memcpy(0, src, length);
    }

    public void memcpy(int offset, TPointer src, int length) {
        if (this.isNotNull()) {
            if (this.memory == src.getMemory()) {
                this.memory.memcpy(this.getAddress() + offset, src.getAddress(), length);
            } else {
                for (int i = 0; i < length; ++i) {
                    this.setValue8(offset + i, src.getValue8(i));
                }
            }
        }
    }

    public void memmove(int src, int length) {
        this.memmove(0, src, length);
    }

    public void memmove(int offset, int src, int length) {
        if (this.isNotNull()) {
            this.memory.memmove(this.getAddress() + offset, src, length);
        }
    }

    public void memset(byte data, int length) {
        this.memset(0, data, length);
    }

    public void memset(int offset, byte data, int length) {
        if (this.isNotNull()) {
            this.memory.memset(this.getAddress() + offset, data, length);
        }
    }

    public void clear(int length) {
        this.clear(0, length);
    }

    public void clear(int offset, int length) {
        this.memset(offset, (byte)0, length);
    }

    public void setUnalignedValue32(int offset, int value) {
        if (this.isNotNull()) {
            Utilities.writeUnaligned32(this.getMemory(), this.getAddress() + offset, value);
        }
    }

    public void setUnalignedValue16(int offset, int value) {
        if (this.isNotNull()) {
            Utilities.writeUnaligned16(this.getMemory(), this.getAddress() + offset, value);
        }
    }

    public void setUnalignedValue64(int offset, long value) {
        if (this.isNotNull()) {
            Utilities.writeUnaligned64(this.getMemory(), this.getAddress() + offset, value);
        }
    }

    public boolean equals(TPointer ptr) {
        return this.getAddress() == ptr.getAddress() && this.getMemory() == ptr.getMemory();
    }

    public String toString() {
        return String.format("0x%08X", this.getAddress());
    }
}

