/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS;

import java.io.IOException;
import java.util.Map;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.util.Utilities;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public abstract class AbstractVirtualFile
implements IVirtualFile {
    protected static Logger log = AbstractVirtualFileSystem.log;
    protected final SeekableDataInput file;
    protected static final int IO_ERROR = -1;
    private final IVirtualFile ioctlFile;

    public AbstractVirtualFile(SeekableDataInput file) {
        this.file = file;
        this.ioctlFile = null;
    }

    public AbstractVirtualFile(SeekableDataInput file, IVirtualFile ioctlFile) {
        this.file = file;
        this.ioctlFile = ioctlFile;
    }

    @Override
    public long getPosition() {
        try {
            return this.file.getFilePointer();
        }
        catch (IOException e) {
            log.error((Object)"getPosition", (Throwable)e);
            return Modules.IoFileMgrForUserModule.getPosition(this);
        }
    }

    protected void setPosition(long position) {
        Modules.IoFileMgrForUserModule.setPosition(this, position);
        this.ioLseek(position);
    }

    @Override
    public int ioClose() {
        try {
            this.file.close();
        }
        catch (IOException e) {
            log.error((Object)"ioClose", (Throwable)e);
            return -1;
        }
        return 0;
    }

    private int getReadLength(int outputLength) {
        int readLength = outputLength;
        long restLength = this.length() - this.getPosition();
        if (restLength < (long)readLength) {
            readLength = (int)restLength;
        }
        return readLength;
    }

    @Override
    public int ioRead(TPointer outputPointer, int outputLength) {
        int readLength = this.getReadLength(outputLength);
        try {
            Utilities.readFully(this.file, outputPointer, readLength);
        }
        catch (IOException e) {
            log.error((Object)"ioRead", (Throwable)e);
            return -2147352272;
        }
        return readLength;
    }

    @Override
    public int ioRead(byte[] outputBuffer, int outputOffset, int outputLength) {
        int readLength = this.getReadLength(outputLength);
        if (readLength > 0) {
            try {
                this.file.readFully(outputBuffer, outputOffset, readLength);
            }
            catch (IOException e) {
                log.error((Object)"ioRead", (Throwable)e);
                return -2147352272;
            }
        } else if (outputLength > 0) {
            return -2147352272;
        }
        return readLength;
    }

    @Override
    public int ioWrite(TPointer inputPointer, int inputLength) {
        return -1;
    }

    @Override
    public int ioWrite(byte[] inputBuffer, int inputOffset, int inputLength) {
        return -1;
    }

    @Override
    public long ioLseek(long offset) {
        try {
            this.file.seek(offset);
        }
        catch (IOException e) {
            log.error((Object)"ioLseek", (Throwable)e);
            return -1L;
        }
        return offset;
    }

    @Override
    public int ioIoctl(int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        if (this.ioctlFile != null) {
            return this.ioctlFile.ioIoctl(command, inputPointer, inputLength, outputPointer, outputLength);
        }
        if (log.isEnabledFor((Priority)Level.WARN)) {
            log.warn((Object)String.format("ioIoctl 0x%08X unsupported command, inlen=%d, outlen=%d", command, inputLength, outputLength));
            if (inputPointer.isAddressGood()) {
                log.warn((Object)String.format("ioIoctl indata: %s", Utilities.getMemoryDump(inputPointer.getAddress(), inputLength)));
            }
            if (outputPointer.isAddressGood()) {
                log.warn((Object)String.format("ioIoctl outdata: %s", Utilities.getMemoryDump(outputPointer.getAddress(), outputLength)));
            }
        }
        return -1;
    }

    @Override
    public long length() {
        try {
            return this.file.length();
        }
        catch (IOException e) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"length", (Throwable)e);
            }
            return 0L;
        }
    }

    @Override
    public boolean isSectorBlockMode() {
        return false;
    }

    @Override
    public IVirtualFile duplicate() {
        return null;
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.defaultTimings;
    }

    public String toString() {
        return this.file == null ? null : this.file.toString();
    }
}

