/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.VFS.xmb;

import java.io.File;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import jpcsp.GUI.UmdBrowser;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.VFS.AbstractVirtualFileSystem;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.VFS.local.LocalVirtualFileSystem;
import jpcsp.HLE.VFS.xmb.XmbIsoVirtualFile;
import jpcsp.HLE.kernel.types.SceIoDirent;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.modules.IoFileMgrForUser;
import jpcsp.MainGUI;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;

public class XmbVirtualFileSystem
extends AbstractVirtualFileSystem {
    public static final String PSP_GAME = "PSP/GAME";
    private static final String EBOOT_PBP = "EBOOT.PBP";
    private static final String DOCUMENT_DAT = "DOCUMENT.DAT";
    private static final String ISO_DIR = Settings.getInstance().getDirectoryMapping("ms0") + "ISO";
    private IVirtualFileSystem vfs;
    private File[] umdPaths;
    private Map<String, IVirtualFileSystem> umdVfs;
    private List<VirtualPBP> umdFiles;

    public XmbVirtualFileSystem(IVirtualFileSystem vfs) {
        this.vfs = vfs;
        this.umdPaths = MainGUI.getUmdPaths(true);
        File isoDir = new File(ISO_DIR);
        if (isoDir.isDirectory()) {
            this.umdPaths = Utilities.add(this.umdPaths, isoDir);
        }
        this.umdVfs = new HashMap<String, IVirtualFileSystem>();
        for (int i = 0; i < this.umdPaths.length; ++i) {
            LocalVirtualFileSystem localVfs = new LocalVirtualFileSystem(this.umdPaths[i].getAbsolutePath() + "/", false);
            this.umdVfs.put(this.umdPaths[i].getAbsolutePath(), localVfs);
        }
        this.umdFiles = new LinkedList<VirtualPBP>();
    }

    private boolean isVirtualFile(String name) {
        return EBOOT_PBP.equals(name) || DOCUMENT_DAT.equals(name);
    }

    private String[] addUmdFileNames(String dirName, File[] files) {
        if (files == null) {
            return null;
        }
        String[] fileNames = new String[files.length];
        for (int i = 0; i < files.length; ++i) {
            VirtualPBP virtualPBP = new VirtualPBP();
            virtualPBP.umdFile = files[i].getAbsolutePath();
            int umdIndex = this.umdFiles.size();
            this.umdFiles.add(virtualPBP);
            fileNames[i] = String.format("@UMD%d", umdIndex);
            if (!log.isDebugEnabled()) continue;
            log.debug((Object)String.format("%s=%s", fileNames[i], files[i].getAbsolutePath()));
        }
        return fileNames;
    }

    private VirtualPBP getVirtualPBP(String fileName, StringBuilder restFileName) {
        int umdMarkerIndex;
        if (fileName != null && (umdMarkerIndex = fileName.indexOf("@UMD")) >= 0) {
            int umdIndex;
            String umdIndexString = fileName.substring(umdMarkerIndex + 4);
            int sepIndex = umdIndexString.indexOf("/");
            if (sepIndex >= 0) {
                if (restFileName != null) {
                    restFileName.append(umdIndexString.substring(sepIndex + 1));
                }
                umdIndexString = umdIndexString.substring(0, sepIndex);
            }
            if ((umdIndex = Integer.parseInt(umdIndexString)) >= 0 && umdIndex < this.umdFiles.size()) {
                return this.umdFiles.get(umdIndex);
            }
        }
        return null;
    }

    private String getUmdFileName(String fileName, StringBuilder restFileName) {
        VirtualPBP virtualPBP = this.getVirtualPBP(fileName, restFileName);
        if (virtualPBP == null) {
            return null;
        }
        return virtualPBP.umdFile;
    }

    private IVirtualFileSystem getUmdVfs(String umdFileName, StringBuilder localFileName) {
        for (String path : this.umdVfs.keySet()) {
            if (!umdFileName.startsWith(path)) continue;
            if (localFileName != null) {
                localFileName.append(umdFileName.substring(path.length() + 1));
            }
            return this.umdVfs.get(path);
        }
        return null;
    }

    private int umdIoGetstat(String umdFileName, String restFileName, SceIoStat stat) {
        StringBuilder localFileName = new StringBuilder();
        IVirtualFileSystem vfs = this.getUmdVfs(umdFileName, localFileName);
        if (vfs != null) {
            int result = vfs.ioGetstat(localFileName.toString(), stat);
            if (restFileName != null && restFileName.length() > 0 && result == 0 && (stat.attr & 0x10) != 0) {
                result = vfs.ioGetstat(localFileName.toString() + "/" + restFileName, stat);
            }
            return result;
        }
        return -1;
    }

    @Override
    public String[] ioDopen(String dirName) {
        String[] entries = null;
        StringBuilder restFileName = new StringBuilder();
        String umdFileName = this.getUmdFileName(dirName, restFileName);
        if (umdFileName != null && restFileName.length() == 0) {
            entries = new String[]{"..", ".", EBOOT_PBP};
        } else if (PSP_GAME.equals(dirName)) {
            for (int i = 0; i < this.umdPaths.length; ++i) {
                File umdPath = this.umdPaths[i];
                if (!umdPath.isDirectory()) continue;
                File[] umdFiles = umdPath.listFiles(new UmdBrowser.UmdFileFilter());
                entries = Utilities.add(entries, this.addUmdFileNames(dirName, umdFiles));
            }
            entries = Utilities.add(this.vfs.ioDopen(dirName), entries);
        } else {
            entries = this.vfs.ioDopen(dirName);
        }
        return entries;
    }

    @Override
    public int ioDread(String dirName, SceIoDirent dir) {
        StringBuilder restFileName = new StringBuilder();
        String umdFileName = this.getUmdFileName(dirName, restFileName);
        if (umdFileName != null && restFileName.length() == 0 && EBOOT_PBP.equals(dir.filename)) {
            int result = this.umdIoGetstat(umdFileName, restFileName.toString(), dir.stat);
            if (result < 0) {
                return result;
            }
            return 1;
        }
        restFileName = new StringBuilder();
        umdFileName = this.getUmdFileName(dir.filename, restFileName);
        if (umdFileName != null && restFileName.length() == 0) {
            int result = this.umdIoGetstat(umdFileName, restFileName.toString(), dir.stat);
            if (result < 0) {
                return result;
            }
            dir.stat.attr = dir.stat.attr & 0xFFFFFFDF | 0x10;
            dir.stat.mode = dir.stat.mode & 0xFFFFDFFF | 0x1000;
            return 1;
        }
        return this.vfs.ioDread(dirName, dir);
    }

    @Override
    public int ioGetstat(String fileName, SceIoStat stat) {
        StringBuilder restFileName = new StringBuilder();
        String umdFileName = this.getUmdFileName(fileName, restFileName);
        if (umdFileName != null && this.isVirtualFile(restFileName.toString())) {
            return this.umdIoGetstat(umdFileName, restFileName.toString(), stat);
        }
        return this.vfs.ioGetstat(fileName, stat);
    }

    @Override
    public IVirtualFile ioOpen(String fileName, int flags, int mode) {
        StringBuilder restFileName = new StringBuilder();
        VirtualPBP virtualPBP = this.getVirtualPBP(fileName, restFileName);
        if (virtualPBP != null && this.isVirtualFile(restFileName.toString())) {
            StringBuilder localFileName;
            IVirtualFileSystem vfs;
            String umdFileName = virtualPBP.umdFile;
            File umdFile = new File(umdFileName);
            if (umdFile.isDirectory() && (vfs = this.getUmdVfs(umdFileName, localFileName = new StringBuilder())) != null) {
                return vfs.ioOpen(localFileName.toString() + "/" + restFileName.toString(), flags, mode);
            }
            if (virtualPBP.vFile == null) {
                virtualPBP.vFile = new XmbIsoVirtualFile(umdFileName);
            }
            if (virtualPBP.vFile.length() > 0L) {
                return virtualPBP.vFile;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("XmbVirtualFileSystem.ioOpen could not open UMD file '%s'", umdFileName));
            }
        }
        return this.vfs.ioOpen(fileName, flags, mode);
    }

    @Override
    public Map<IoFileMgrForUser.IoOperation, IoFileMgrForUser.IoOperationTiming> getTimings() {
        return IoFileMgrForUser.noDelayTimings;
    }

    @Override
    public int ioRename(String oldFileName, String newFileName) {
        return this.vfs.ioRename(oldFileName, newFileName);
    }

    @Override
    public int ioChstat(String fileName, SceIoStat stat, int bits) {
        return this.vfs.ioChstat(fileName, stat, bits);
    }

    @Override
    public int ioRemove(String name) {
        return this.vfs.ioRemove(name);
    }

    @Override
    public int ioMkdir(String name, int mode) {
        return this.vfs.ioMkdir(name, mode);
    }

    @Override
    public int ioRmdir(String name) {
        return this.vfs.ioRmdir(name);
    }

    @Override
    public int ioChdir(String directoryName) {
        return this.vfs.ioChdir(directoryName);
    }

    @Override
    public int ioMount() {
        return this.vfs.ioMount();
    }

    @Override
    public int ioUmount() {
        return this.vfs.ioUmount();
    }

    @Override
    public int ioDevctl(String deviceName, int command, TPointer inputPointer, int inputLength, TPointer outputPointer, int outputLength) {
        return this.vfs.ioDevctl(deviceName, command, inputPointer, inputLength, outputPointer, outputLength);
    }

    private static class VirtualPBP {
        String umdFile;
        IVirtualFile vFile;

        private VirtualPBP() {
        }
    }
}

