/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types;

import jpcsp.HLE.kernel.types.pspAbstractMemoryMappedStructure;
import jpcsp.util.Utilities;

public class SceMp4TrackSampleBuf
extends pspAbstractMemoryMappedStructure {
    public int mp4;
    public int baseBufferAddr;
    public int samplesPut;
    public int sampleSize;
    public int unknown;
    public int currentSample;
    public int timeScale;
    public int duration;
    public int totalNumberSamples;
    public int trackType;
    public int readBufferAddr;
    public int readBufferSize;
    public long currentFileOffset;
    public int sizeAvailableInReadBuffer;
    public int bytesBufferAddr;
    public int bytesBufferLength;
    public SceMp4TrackSampleBufInfo bufBytes;
    public SceMp4TrackSampleBufInfo bufSamples;

    @Override
    protected void read() {
        this.readUnknown(36);
        this.currentSample = this.read32();
        this.timeScale = this.read32();
        this.duration = this.read32();
        this.totalNumberSamples = this.read32();
        this.read32();
        this.read32();
        this.trackType = this.read32();
        this.readUnknown(4);
        this.baseBufferAddr = this.read32();
        this.samplesPut = this.read32();
        this.sampleSize = this.read32();
        this.unknown = this.read32();
        this.bytesBufferAddr = this.read32();
        this.bytesBufferLength = this.read32();
        this.read32();
        this.read32();
        this.bufBytes = new SceMp4TrackSampleBufInfo();
        this.read(this.bufBytes);
        this.bufSamples = new SceMp4TrackSampleBufInfo();
        this.read(this.bufSamples);
        this.read32();
        this.currentFileOffset = this.read64();
        this.read32();
        this.read32();
        this.read32();
        this.read32();
        this.read32();
        this.read32();
        this.read32();
        this.read32();
        this.readBufferAddr = this.read32();
        this.readBufferSize = this.read32();
        this.sizeAvailableInReadBuffer = this.read32();
        this.read32();
    }

    @Override
    protected void write() {
        this.writeUnknown(36);
        this.write32(this.currentSample);
        this.write32(this.timeScale);
        this.write32(this.duration);
        this.write32(this.totalNumberSamples);
        this.write32(this.getBaseAddress() + 240);
        this.write32(this.getBaseAddress() + 72);
        this.write32(this.trackType);
        this.writeUnknown(4);
        this.write32(this.baseBufferAddr);
        this.write32(this.samplesPut);
        this.write32(this.sampleSize);
        this.write32(this.unknown);
        this.write32(this.bytesBufferAddr);
        this.write32(this.bytesBufferLength);
        this.write32(Utilities.alignUp(this.baseBufferAddr, 63));
        this.write32(this.samplesPut << 6);
        this.write(this.bufBytes);
        this.write(this.bufSamples);
        this.write32(this.getBaseAddress() + 184);
        this.write64(this.currentFileOffset);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(this.mp4);
        this.write32(0);
        this.write32(0);
        this.write32(0);
        this.write32(this.readBufferAddr);
        this.write32(this.readBufferSize);
        this.write32(this.sizeAvailableInReadBuffer);
        this.write32(1);
    }

    public boolean isOfType(int trackType) {
        int mask = 48;
        return (this.trackType & mask) == (trackType & mask);
    }

    public boolean isInReadBuffer(int offset) {
        return (long)offset >= this.currentFileOffset && (long)offset < this.currentFileOffset + (long)this.sizeAvailableInReadBuffer;
    }

    private void addBytesToTrackSequential(int addr, int length) {
        if (length > 0) {
            this.mem.memcpy(this.bufBytes.bufferAddr + this.bufBytes.writeOffset, addr, length);
            this.bufBytes.writeOffset += length;
            this.bufBytes.sizeAvailableForRead += length;
        }
    }

    public void addBytesToTrack(int addr, int length) {
        int length1 = Math.min(length, this.bufBytes.totalSize - this.bufBytes.writeOffset);
        this.addBytesToTrackSequential(addr, length1);
        int length2 = length - length1;
        if (length2 > 0) {
            this.bufBytes.writeOffset = 0;
            this.addBytesToTrackSequential(addr + length1, length2);
        }
    }

    public void addSamplesToTrack(int samples) {
        this.bufSamples.sizeAvailableForRead += samples;
        this.currentSample += samples;
    }

    public void readBytes(int addr, int length) {
        if ((length = Math.min(length, this.bufBytes.sizeAvailableForRead)) > 0) {
            int length1 = Math.min(length, this.bufBytes.totalSize - this.bufBytes.readOffset);
            this.mem.memcpy(addr, this.bufBytes.bufferAddr + this.bufBytes.readOffset, length1);
            int length2 = length - length1;
            if (length2 > 0) {
                this.mem.memcpy(addr + length1, this.bufBytes.bufferAddr, length2);
            }
            this.bufBytes.notifyRead(length);
        }
    }

    @Override
    public int sizeof() {
        return 240;
    }

    @Override
    public String toString() {
        return String.format("SceMp4TrackSampleBuf currentSample=0x%X, timeScale=0x%X, duration=0x%X, totalNumberSamples=0x%X, trackType=0x%X, baseBufferAddr=0x%08X, numSamples=0x%X, sampleSize=0x%X, unknown=0x%X, readBufferAddr=0x%08X, readBufferSize=0x%X, currentFileOffset=0x%X, sizeAvailableInReadBuffer=0x%X, bufBytes=%s, bufSamples=%s", this.currentSample, this.timeScale, this.duration, this.totalNumberSamples, this.trackType, this.baseBufferAddr, this.samplesPut, this.sampleSize, this.unknown, this.readBufferAddr, this.readBufferSize, this.currentFileOffset, this.sizeAvailableInReadBuffer, this.bufBytes, this.bufSamples);
    }

    public static class SceMp4TrackSampleBufInfo
    extends pspAbstractMemoryMappedStructure {
        public int totalSize;
        public int readOffset;
        public int writeOffset;
        public int sizeAvailableForRead;
        public int unknown16;
        public int bufferAddr;
        public int callback24;
        public int unknown28;
        public int unknown36;

        @Override
        protected void read() {
            this.totalSize = this.read32();
            this.readOffset = this.read32();
            this.writeOffset = this.read32();
            this.sizeAvailableForRead = this.read32();
            this.unknown16 = this.read32();
            this.bufferAddr = this.read32();
            this.callback24 = this.read32();
            this.unknown28 = this.read32();
            this.readUnknown(4);
            this.unknown36 = this.read32();
        }

        @Override
        protected void write() {
            this.write32(this.totalSize);
            this.write32(this.readOffset);
            this.write32(this.writeOffset);
            this.write32(this.sizeAvailableForRead);
            this.write32(this.unknown16);
            this.write32(this.bufferAddr);
            this.write32(this.callback24);
            this.write32(this.unknown28);
            this.writeUnknown(4);
            this.write32(this.unknown36);
        }

        public int getWritableSpace() {
            return this.totalSize - this.sizeAvailableForRead;
        }

        public void notifyRead(int length) {
            if ((length = Math.min(length, this.sizeAvailableForRead)) > 0) {
                this.readOffset += length;
                if (this.readOffset >= this.totalSize) {
                    this.readOffset -= this.totalSize;
                }
                this.sizeAvailableForRead -= length;
            }
        }

        public void flush() {
            this.readOffset = 0;
            this.writeOffset = 0;
            this.sizeAvailableForRead = 0;
        }

        @Override
        public int sizeof() {
            return 40;
        }

        @Override
        public String toString() {
            return String.format("SceMp4TrackSampleBufInfo[totalSize=0x%X, readOffset=0x%X, writeOffset=0x%X, sizeAvailableForRead=0x%X, bufferAddr=0x%08X]", this.totalSize, this.readOffset, this.writeOffset, this.sizeAvailableForRead, this.bufferAddr);
        }
    }
}

