/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.kernel.types.interrupts;

import jpcsp.Allegrex.CpuState;

public class AbstractAllegrexInterruptHandler {
    private int address;
    private int[] arguments = new int[4];
    private int numberArguments;
    private int gp;

    public AbstractAllegrexInterruptHandler(int address) {
        this.address = address;
        this.numberArguments = 0;
    }

    public AbstractAllegrexInterruptHandler(int address, int argument0) {
        this.address = address;
        this.arguments[0] = argument0;
        this.numberArguments = 1;
    }

    public AbstractAllegrexInterruptHandler(int address, int argument0, int argument1) {
        this.address = address;
        this.arguments[0] = argument0;
        this.arguments[1] = argument1;
        this.numberArguments = 2;
    }

    public AbstractAllegrexInterruptHandler(int address, int argument0, int argument1, int argument2) {
        this.address = address;
        this.arguments[0] = argument0;
        this.arguments[1] = argument1;
        this.arguments[2] = argument2;
        this.numberArguments = 3;
    }

    public AbstractAllegrexInterruptHandler(int address, int argument0, int argument1, int argument2, int argument3) {
        this.address = address;
        this.arguments[0] = argument0;
        this.arguments[1] = argument1;
        this.arguments[2] = argument2;
        this.arguments[3] = argument3;
        this.numberArguments = 4;
    }

    public int getAddress() {
        return this.address;
    }

    public void setAddress(int address) {
        this.address = address;
    }

    public int getArgument(int index) {
        return this.arguments[index];
    }

    public void setArgument(int index, int argument) {
        this.arguments[index] = argument;
        if (index >= this.numberArguments) {
            this.numberArguments = index + 1;
        }
    }

    public int getNumberArguments() {
        return this.numberArguments;
    }

    public int getGp() {
        return this.gp;
    }

    public void setGp(int gp) {
        this.gp = gp;
    }

    public void copyArgumentsToCpu(CpuState cpu) {
        switch (this.numberArguments) {
            case 4: {
                cpu._a3 = this.arguments[3];
            }
            case 3: {
                cpu._a2 = this.arguments[2];
            }
            case 2: {
                cpu._a1 = this.arguments[1];
            }
            case 1: {
                cpu._a0 = this.arguments[0];
            }
        }
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(String.format("0x%08X(", this.getAddress()));
        for (int i = 0; i < this.numberArguments; ++i) {
            if (i > 0) {
                result.append(",");
            }
            result.append(String.format("0x%08X", this.getArgument(i)));
        }
        result.append(")");
        return result.toString();
    }
}

