/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.SceKernelTls;
import jpcsp.Processor;
import org.apache.log4j.Logger;

public class Kernel_Library
extends HLEModule {
    public static Logger log = Modules.getLogger("Kernel_Library");
    private static final int flagInterruptsEnabled = 1;
    private static final int flagInterruptsDisabled = 0;

    @HLEFunction(nid=153708788, version=150)
    public boolean sceKernelCpuSuspendIntr(Processor processor) {
        boolean returnValue = processor.isInterruptsEnabled();
        processor.disableInterrupts();
        return returnValue;
    }

    protected void hleKernelCpuResumeIntr(Processor processor, int flagInterrupts) {
        if (flagInterrupts == 1) {
            processor.enableInterrupts();
        } else if (flagInterrupts == 0) {
            processor.disableInterrupts();
        } else {
            log.warn((Object)String.format("hleKernelCpuResumeIntr unknown flag value 0x%X", flagInterrupts));
        }
    }

    @HLEFunction(nid=1594938374, version=150)
    public void sceKernelCpuResumeIntr(Processor processor, int flagInterrupts) {
        this.hleKernelCpuResumeIntr(processor, flagInterrupts);
    }

    @HLEFunction(nid=998535981, version=150)
    public void sceKernelCpuResumeIntrWithSync(Processor processor, int flagInterrupts) {
        this.hleKernelCpuResumeIntr(processor, flagInterrupts);
    }

    @HLEFunction(nid=1201714985, version=150)
    public boolean sceKernelIsCpuIntrSuspended(int flagInterrupts) {
        return flagInterrupts == 0;
    }

    @HLEFunction(nid=-1252898350, version=150)
    public boolean sceKernelIsCpuIntrEnable(Processor processor) {
        return processor.isInterruptsEnabled();
    }

    @HLEFunction(nid=364266603, version=150, checkInsideInterrupt=true)
    public int sceKernelUnlockLwMutex(TPointer workAreaAddr, int count) {
        return Managers.lwmutex.sceKernelUnlockLwMutex(workAreaAddr, count);
    }

    @HLEFunction(nid=533089801, version=380, checkInsideInterrupt=true)
    public int sceKernelLockLwMutexCB(TPointer workAreaAddr, int count, @CanBeNull TPointer32 timeoutAddr) {
        return Managers.lwmutex.sceKernelLockLwMutexCB(workAreaAddr, count, timeoutAddr);
    }

    @HLEFunction(nid=-1096522727, version=150, checkInsideInterrupt=true)
    public int sceKernelLockLwMutex(TPointer workAreaAddr, int count, @CanBeNull TPointer32 timeoutAddr) {
        return Managers.lwmutex.sceKernelLockLwMutex(workAreaAddr, count, timeoutAddr);
    }

    @HLEFunction(nid=-1049410151, version=380)
    public int sceKernelReferLwMutexStatus(TPointer workAreaAddr, TPointer addr) {
        return Managers.lwmutex.sceKernelReferLwMutexStatus(workAreaAddr, addr);
    }

    @HLEFunctions(value={@HLEFunction(nid=-597086493, version=380, checkInsideInterrupt=true), @HLEFunction(nid=927144009, version=600, checkInsideInterrupt=true)})
    public int sceKernelTryLockLwMutex(TPointer workAreaAddr, int count) {
        return Managers.lwmutex.sceKernelTryLockLwMutex(workAreaAddr, count);
    }

    @HLELogging(level="trace")
    @HLEFunction(nid=406422826, version=150)
    public int sceKernelMemcpy(@BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextNextParameter, usage=BufferInfo.Usage.out) TPointer dst, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.nextParameter, usage=BufferInfo.Usage.in) TPointer src, int length) {
        if (dst.getAddress() != src.getAddress()) {
            dst.getMemory().memcpyWithVideoCheck(dst.getAddress(), src.getAddress(), length);
        }
        return dst.getAddress();
    }

    @HLEFunctions(value={@HLEFunction(nid=-1601573724, version=150), @HLEFunction(nid=-1964542289, version=660)})
    public int sceKernelMemset(TPointer destAddr, int data, int size) {
        destAddr.memset((byte)data, size);
        return 0;
    }

    @HLEFunction(nid=-92054306, version=620)
    public int sceKernel_FA835CDE(int uid) {
        SceKernelTls tls = Modules.ThreadManForUserModule.getKernelTls(uid);
        if (tls == null) {
            return 0;
        }
        int addr = tls.getTlsAddress();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernel_FA835CDE returning 0x%08X", addr));
        }
        return addr;
    }
}

