/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.io.IOException;
import java.nio.ByteBuffer;
import jpcsp.Allegrex.compiler.RuntimeContext;
import jpcsp.Emulator;
import jpcsp.HLE.BufferInfo;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLEFunctions;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEModuleManager;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.PspString;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.VFS.IVirtualFile;
import jpcsp.HLE.VFS.IVirtualFileSystem;
import jpcsp.HLE.kernel.Managers;
import jpcsp.HLE.kernel.types.IAction;
import jpcsp.HLE.kernel.types.SceIoStat;
import jpcsp.HLE.kernel.types.SceKernelLMOption;
import jpcsp.HLE.kernel.types.SceKernelModuleInfo;
import jpcsp.HLE.kernel.types.SceKernelSMOption;
import jpcsp.HLE.kernel.types.SceKernelThreadInfo;
import jpcsp.HLE.kernel.types.SceModule;
import jpcsp.HLE.modules.SysMemUserForUser;
import jpcsp.HLE.modules.ThreadManForUser;
import jpcsp.Loader;
import jpcsp.Memory;
import jpcsp.filesystems.SeekableDataInput;
import jpcsp.filesystems.umdiso.UmdIsoFile;
import jpcsp.format.PSP;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.util.HLEUtilities;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class ModuleMgrForUser
extends HLEModule {
    public static Logger log = Modules.getLogger("ModuleMgrForUser");
    public static final int SCE_HEADER_LENGTH = 64;
    public static final int loadHLEModuleDelay = 50000;
    protected int startModuleHandler;
    private SysMemUserForUser.SysMemInfo startOptionsMem;
    private TPointer startOptions;

    @Override
    public void start() {
        this.startModuleHandler = 0;
        this.startOptionsMem = null;
        this.startOptions = null;
        super.start();
    }

    private int hleKernelLoadHLEModule(LoadModuleContext loadModuleContext) {
        IVirtualFileSystem vfs;
        StringBuilder localFileName;
        String fileName = loadModuleContext.fileName;
        HLEModuleManager moduleManager = HLEModuleManager.getInstance();
        int startPrx = fileName.lastIndexOf("/");
        int endPrx = fileName.toLowerCase().indexOf(".prx");
        loadModuleContext.moduleName = endPrx >= 0 ? fileName.substring(startPrx + 1, endPrx) : fileName;
        this.getModuleInfoFromFileContent(loadModuleContext);
        String modulePrxFileName = moduleManager.getModulePrxFileName(loadModuleContext.moduleName);
        if (modulePrxFileName != null) {
            loadModuleContext.isSignChecked = this.isSignChecked(modulePrxFileName);
            localFileName = new StringBuilder();
            vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(modulePrxFileName, localFileName);
            if (vfs.ioGetstat(localFileName.toString(), new SceIoStat()) == 0) {
                loadModuleContext.fileName = modulePrxFileName;
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("hleKernelLoadModule('%s') file '%s' loaded", loadModuleContext.moduleName, modulePrxFileName));
                }
                return -1;
            }
        }
        if (loadModuleContext.fileName != null && loadModuleContext.fileName.startsWith("flash0:") && (vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(loadModuleContext.fileName, localFileName = new StringBuilder())).ioGetstat(localFileName.toString(), new SceIoStat()) == 0) {
            return -1;
        }
        if (moduleManager.hasFlash0Module(loadModuleContext.moduleName)) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("hleKernelLoadModule(path='%s') HLE module %s loaded", loadModuleContext.fileName, loadModuleContext.moduleName));
            }
            int moduleMemoryPartition = loadModuleContext.lmOption != null && loadModuleContext.lmOption.mpidText != 0 ? loadModuleContext.lmOption.mpidText : 2;
            int moduleMemoryType = loadModuleContext.lmOption != null ? loadModuleContext.lmOption.position : 0;
            return moduleManager.LoadFlash0Module(loadModuleContext.moduleName, loadModuleContext.moduleVersion, loadModuleContext.moduleElfVersion, moduleMemoryPartition, moduleMemoryType);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] readHeader(LoadModuleContext loadModuleContext) {
        byte[] header = new byte[400];
        if (loadModuleContext.buffer != 0) {
            Utilities.readBytes(loadModuleContext.buffer, header.length, header, 0);
        } else {
            SeekableDataInput file = loadModuleContext.byUid ? Modules.IoFileMgrForUserModule.getFile(loadModuleContext.uid) : Modules.IoFileMgrForUserModule.getFile(loadModuleContext.fileName, 1);
            if (file == null) {
                return null;
            }
            try {
                long position = file.getFilePointer();
                file.readFully(header);
                file.seek(position);
            }
            catch (IOException e) {
                byte[] byArray = null;
                return byArray;
            }
            finally {
                if (!loadModuleContext.byUid) {
                    try {
                        file.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return header;
    }

    private void getModuleInfoFromFileContent(LoadModuleContext loadModuleContext) {
        byte[] header = this.readHeader(loadModuleContext);
        if (header == null) {
            return;
        }
        try {
            ByteBuffer f = ByteBuffer.wrap(header);
            int magic = Utilities.readWord(f);
            if (magic == 1162040190) {
                f.position(64);
            } else {
                f.position(0);
            }
            PSP psp = new PSP(f);
            if (psp.isValid()) {
                String libName = psp.getModname();
                if (libName != null && libName.length() > 0) {
                    loadModuleContext.moduleName = libName;
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("getModuleNameFromFileContent %s", loadModuleContext));
                    }
                }
                loadModuleContext.moduleVersion = psp.getDevkitVersion();
            } else {
                SceModule moduleInfo = this.getModuleInfo(loadModuleContext);
                if (moduleInfo != null) {
                    loadModuleContext.moduleName = moduleInfo.modname;
                    loadModuleContext.moduleVersion = moduleInfo.moduleVersion;
                    loadModuleContext.moduleElfVersion = moduleInfo.version;
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int hleKernelLoadModule(LoadModuleContext loadModuleContext) {
        loadModuleContext.thread = Modules.ThreadManForUserModule.getCurrentThread();
        LoadModuleAction delayedLoadModule = new LoadModuleAction(loadModuleContext);
        Modules.ThreadManForUserModule.getCurrentThread().wait.Io_id = -1;
        Modules.ThreadManForUserModule.hleBlockCurrentThread(256);
        Emulator.getScheduler().addAction(Emulator.getClock().microTime() + 100000L, delayedLoadModule);
        return 0;
    }

    public int hleKernelLoadAndStartModule(String name, int startPriority) {
        return this.hleKernelLoadAndStartModule(name, startPriority, null);
    }

    public int hleKernelLoadAndStartModule(String name, int startPriority, IAction onModuleStartAction) {
        return this.hleKernelLoadAndStartModule(name, startPriority, 0, TPointer.NULL, onModuleStartAction);
    }

    public int hleKernelLoadAndStartModule(String name, int startPriority, int argSize, TPointer argp, IAction onModuleStartAction) {
        LoadModuleContext loadModuleContext = new LoadModuleContext();
        loadModuleContext.fileName = name;
        loadModuleContext.allocMem = true;
        loadModuleContext.thread = Modules.ThreadManForUserModule.getCurrentThread();
        loadModuleContext.isSignChecked = this.isSignChecked(name);
        int moduleUid = this.hleKernelLoadModuleNow(loadModuleContext);
        if (moduleUid >= 0) {
            if (this.startOptionsMem == null) {
                int startOptionsSize = 20;
                this.startOptionsMem = Modules.SysMemUserForUserModule.malloc(1, "ModuleStartOptions", 0, 20, 0);
                this.startOptions = new TPointer(Memory.getInstance(), this.startOptionsMem.addr);
                this.startOptions.setValue32(20);
            }
            SceKernelSMOption sceKernelSMOption = new SceKernelSMOption();
            sceKernelSMOption.mpidStack = 0;
            sceKernelSMOption.stackSize = 0;
            sceKernelSMOption.attribute = 0;
            sceKernelSMOption.priority = startPriority;
            sceKernelSMOption.write(this.startOptions);
            this.hleKernelStartModule(moduleUid, argSize, argp, TPointer32.NULL, this.startOptions, false, onModuleStartAction);
        }
        return moduleUid;
    }

    private int hleKernelLoadModuleNow(LoadModuleContext loadModuleContext) {
        int result = this.delayedKernelLoadModule(loadModuleContext);
        if (loadModuleContext.thread != null) {
            loadModuleContext.thread.cpuContext._v0 = result;
            Modules.ThreadManForUserModule.hleUnblockThread(loadModuleContext.thread.uid);
        }
        return result;
    }

    private ByteBuffer getModuleByteBuffer(LoadModuleContext loadModuleContext) {
        if (loadModuleContext.moduleBuffer != null) {
            return loadModuleContext.moduleBuffer;
        }
        if (loadModuleContext.buffer != 0) {
            byte[] bytes = new byte[loadModuleContext.bufferSize];
            Utilities.readBytes(loadModuleContext.buffer, loadModuleContext.bufferSize, bytes, 0);
            return ByteBuffer.wrap(bytes);
        }
        SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(loadModuleContext.fileName, loadModuleContext.flags);
        if (moduleInput != null) {
            try {
                byte[] moduleBytes = new byte[(int)moduleInput.length()];
                moduleInput.readFully(moduleBytes);
                moduleInput.close();
                return ByteBuffer.wrap(moduleBytes);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    public SceModule getModuleInfo(String name, ByteBuffer moduleBuffer, int mpidText, int mpidData, boolean isSignChecked) {
        SceModule module = null;
        try {
            module = Loader.getInstance().LoadModule(name, moduleBuffer, new TPointer(this.getMemory(), 0x8800000), mpidText, mpidData, true, false, true, isSignChecked);
            moduleBuffer.rewind();
        }
        catch (IOException e) {
            log.error((Object)"getModuleRequiredMemorySize", (Throwable)e);
        }
        return module;
    }

    private SceModule getModuleInfo(LoadModuleContext loadModuleContext) {
        int mpidText = loadModuleContext.lmOption != null && loadModuleContext.lmOption.mpidText != 0 ? loadModuleContext.lmOption.mpidText : 2;
        int mpidData = loadModuleContext.lmOption != null && loadModuleContext.lmOption.mpidData != 0 ? loadModuleContext.lmOption.mpidData : 2;
        ByteBuffer moduleBuffer = this.getModuleByteBuffer(loadModuleContext);
        return this.getModuleInfo(loadModuleContext.fileName, moduleBuffer, mpidText, mpidData, loadModuleContext.isSignChecked);
    }

    public int getModuleRequiredMemorySize(SceModule module) {
        if (module == null) {
            return 0;
        }
        return module.loadAddressHigh - module.loadAddressLow;
    }

    private int hleKernelLoadModuleFromModuleBuffer(LoadModuleContext loadModuleContext) throws IOException {
        int result;
        int moduleBase;
        int mpidData;
        int mpidText;
        SysMemUserForUser.SysMemInfo moduleInfo = null;
        if (loadModuleContext.allocMem) {
            SysMemUserForUser.SysMemInfo testInfo;
            mpidText = loadModuleContext.lmOption != null && loadModuleContext.lmOption.mpidText != 0 ? loadModuleContext.lmOption.mpidText : loadModuleContext.basePartition;
            mpidData = loadModuleContext.lmOption != null && loadModuleContext.lmOption.mpidData != 0 ? loadModuleContext.lmOption.mpidData : loadModuleContext.basePartition;
            int allocType = loadModuleContext.lmOption != null ? loadModuleContext.lmOption.position : 0;
            int moduleHeaderSize = 256;
            SceModule testModule = this.getModuleInfo(loadModuleContext.fileName, loadModuleContext.moduleBuffer, mpidText, mpidData, loadModuleContext.isSignChecked);
            int totalAllocSize = 256 + this.getModuleRequiredMemorySize(testModule);
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Module '%s' requires 0x%X bytes memory in partition=%d", loadModuleContext.fileName, totalAllocSize, mpidText));
            }
            if ((loadModuleContext.lmOption == null || loadModuleContext.lmOption.mpidText == 0) && testModule.mpidtext != 0) {
                mpidText = testModule.mpidtext;
            }
            if ((loadModuleContext.lmOption == null || loadModuleContext.lmOption.mpidData == 0) && testModule.mpiddata != 0) {
                mpidData = testModule.mpiddata;
            }
            if ((testInfo = Modules.SysMemUserForUserModule.malloc(mpidText, "ModuleMgr-TestInfo", allocType, totalAllocSize, 0)) == null) {
                log.error((Object)String.format("Failed module allocation of size 0x%08X for '%s' (maxFreeMemSize=0x%08X)", totalAllocSize, loadModuleContext.fileName, Modules.SysMemUserForUserModule.maxFreeMemSize(mpidText)));
                return -1;
            }
            int testBase = testInfo.addr;
            Modules.SysMemUserForUserModule.free(testInfo);
            if (loadModuleContext.needModuleInfo) {
                moduleInfo = Modules.SysMemUserForUserModule.malloc(mpidText, "ModuleMgr", 2, 256, testBase);
                if (moduleInfo == null) {
                    log.error((Object)String.format("Failed module allocation 0x%08X != null for '%s'", testBase, loadModuleContext.fileName));
                    return -1;
                }
                if (moduleInfo.addr != testBase) {
                    log.error((Object)String.format("Failed module allocation 0x%08X != 0x%08X for '%s'", testBase, moduleInfo.addr, loadModuleContext.fileName));
                    return -1;
                }
                moduleBase = moduleInfo.addr + 256;
            } else {
                moduleBase = testBase;
            }
            if ((testModule.attribute & 0x1000) != 0 && testModule.mpidtext == 1) {
                moduleBase |= 0x88000000;
            }
        } else {
            moduleBase = loadModuleContext.baseAddr;
            mpidText = loadModuleContext.basePartition;
            mpidData = loadModuleContext.basePartition;
        }
        SceModule module = Loader.getInstance().LoadModule(loadModuleContext.fileName, loadModuleContext.moduleBuffer, new TPointer(loadModuleContext.mem, moduleBase), mpidText, mpidData, false, loadModuleContext.allocMem, true, loadModuleContext.isSignChecked);
        module.load();
        if ((module.fileFormat & 1) != 0) {
            module.addAllocatedMemory(moduleInfo);
            result = module.modid;
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("hleKernelLoadModule returning uid=0x%X", result));
            }
        } else if ((module.fileFormat & 0x18) != 0) {
            log.info((Object)String.format("hleKernelLoadModule(path='%s') encrypted module not loaded", loadModuleContext.fileName));
            SceModule fakeModule = new SceModule(true);
            fakeModule.modname = loadModuleContext.moduleName;
            fakeModule.addAllocatedMemory(moduleInfo);
            if (moduleInfo != null) {
                fakeModule.write(Memory.getInstance(), moduleInfo.addr);
            }
            Managers.modules.addModule(fakeModule);
            result = fakeModule.modid;
        } else {
            result = -1;
        }
        return result;
    }

    private int delayedKernelLoadModule(LoadModuleContext loadModuleContext) {
        int result = this.hleKernelLoadHLEModule(loadModuleContext);
        if (result >= 0) {
            Modules.ThreadManForUserModule.hleKernelDelayThread(50000, false);
            return result;
        }
        try {
            loadModuleContext.moduleBuffer = null;
            if (loadModuleContext.buffer != 0) {
                byte[] bytes = new byte[loadModuleContext.bufferSize];
                IMemoryReader memoryReader = MemoryReader.getMemoryReader(loadModuleContext.buffer, loadModuleContext.bufferSize, 1);
                for (int i = 0; i < loadModuleContext.bufferSize; ++i) {
                    bytes[i] = (byte)memoryReader.readNext();
                }
                loadModuleContext.moduleBuffer = ByteBuffer.wrap(bytes);
            } else {
                SeekableDataInput moduleInput = Modules.IoFileMgrForUserModule.getFile(loadModuleContext.fileName, loadModuleContext.flags);
                if (moduleInput != null) {
                    UmdIsoFile umdIsoFile;
                    String realFileName;
                    if (moduleInput instanceof UmdIsoFile && (realFileName = (umdIsoFile = (UmdIsoFile)moduleInput).getName()) != null && !loadModuleContext.fileName.endsWith(realFileName)) {
                        loadModuleContext.fileName = realFileName;
                        result = this.hleKernelLoadHLEModule(loadModuleContext);
                        if (result >= 0) {
                            moduleInput.close();
                            return result;
                        }
                    }
                    byte[] moduleBytes = new byte[(int)moduleInput.length()];
                    moduleInput.readFully(moduleBytes);
                    moduleInput.close();
                    loadModuleContext.moduleBuffer = ByteBuffer.wrap(moduleBytes);
                }
            }
            if (loadModuleContext.moduleBuffer == null) {
                log.warn((Object)String.format("hleKernelLoadModule(path='%s') can't find file", loadModuleContext.fileName));
                return -2147418110;
            }
            result = this.hleKernelLoadModuleFromModuleBuffer(loadModuleContext);
        }
        catch (IOException e) {
            log.error((Object)String.format("hleKernelLoadModule - Error while loading module %s", loadModuleContext.fileName), (Throwable)e);
            return -1;
        }
        return result;
    }

    public int hleKernelStartModule(int uid, int argSize, TPointer argp, TPointer32 statusAddr, TPointer optionAddr, boolean waitForThreadEnd, IAction onModuleStartAction) {
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        SceKernelSMOption smOption = null;
        if (optionAddr.isNotNull()) {
            smOption = new SceKernelSMOption();
            smOption.read(optionAddr);
        }
        if (sceModule == null) {
            log.warn((Object)String.format("sceKernelStartModule - unknown module UID 0x%X", uid));
            return -2147352274;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStartModule starting module '%s'", sceModule.modname));
        }
        statusAddr.setValue(0);
        if (sceModule.isFlashModule) {
            if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
                log.info((Object)String.format("IGNORING:sceKernelStartModule HLE module '%s'", sceModule.modname));
            } else {
                log.warn((Object)String.format("IGNORING:sceKernelStartModule flash module '%s'", sceModule.modname));
            }
            sceModule.start();
            return sceModule.modid;
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        int attribute = sceModule.attribute;
        int entryAddr = sceModule.entry_addr;
        if (Memory.isAddressGood(sceModule.module_start_func)) {
            entryAddr = sceModule.module_start_func;
            if (sceModule.module_start_thread_attr != 0) {
                attribute = sceModule.module_start_thread_attr;
            }
        }
        if (Memory.isAddressGood(entryAddr)) {
            int priority = 32;
            if (smOption != null && smOption.priority > 0) {
                priority = smOption.priority;
            } else if (sceModule.module_start_thread_priority > 0) {
                priority = sceModule.module_start_thread_priority;
            }
            int stackSize = 262144;
            if (smOption != null && smOption.stackSize > 0) {
                stackSize = smOption.stackSize;
            } else if (sceModule.module_start_thread_stacksize > 0) {
                stackSize = sceModule.module_start_thread_stacksize;
            }
            int mpidStack = sceModule.mpiddata;
            if (smOption != null && smOption.mpidStack > 0) {
                mpidStack = smOption.mpidStack;
            }
            if (smOption != null && smOption.attribute != 0) {
                attribute = smOption.attribute;
            }
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            SceKernelThreadInfo thread = threadMan.hleKernelCreateThread("SceModmgrStart", entryAddr, priority, stackSize, attribute, 0, mpidStack);
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            if (onModuleStartAction != null) {
                thread.setOnThreadStartAction(onModuleStartAction);
            }
            sceModule.start();
            if (this.startModuleHandler != 0) {
                int numberInstructions = 12;
                int newEntryAddr = thread.getStackAddr() + thread.stackSize - 48;
                int moduleAddr1 = sceModule.address >>> 16;
                int moduleAddr2 = sceModule.address & 0xFFFF;
                if (moduleAddr2 >= 32768) {
                    ++moduleAddr1;
                    moduleAddr2 = moduleAddr2 - 65536 & 0xFFFF;
                }
                IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(newEntryAddr, 48, 4);
                memoryWriter.writeNext(HLEUtilities.ADDIU(29, 29, -16));
                memoryWriter.writeNext(HLEUtilities.SW(4, 29, 0));
                memoryWriter.writeNext(HLEUtilities.SW(5, 29, 4));
                memoryWriter.writeNext(HLEUtilities.SW(31, 29, 8));
                memoryWriter.writeNext(HLEUtilities.LUI(4, moduleAddr1));
                memoryWriter.writeNext(HLEUtilities.JAL(this.startModuleHandler));
                memoryWriter.writeNext(HLEUtilities.ADDIU(4, 4, moduleAddr2));
                memoryWriter.writeNext(HLEUtilities.LW(4, 29, 0));
                memoryWriter.writeNext(HLEUtilities.LW(5, 29, 4));
                memoryWriter.writeNext(HLEUtilities.LW(31, 29, 8));
                memoryWriter.writeNext(HLEUtilities.J(thread.entry_addr));
                memoryWriter.writeNext(HLEUtilities.ADDIU(29, 29, 16));
                memoryWriter.flush();
                thread.entry_addr = newEntryAddr;
                thread.preserveStack = true;
                RuntimeContext.invalidateRange(newEntryAddr, 48);
                if (log.isDebugEnabled()) {
                    log.debug((Object)String.format("sceKernelStartModule installed hook to call startModuleHandler 0x%08X from 0x%08X for sceModule 0x%08X", this.startModuleHandler, newEntryAddr, sceModule.address));
                }
            }
            threadMan.hleKernelStartThread(thread, argSize, argp, sceModule.gp_value);
            if (waitForThreadEnd) {
                threadMan.hleKernelWaitThreadEnd(currentThread, thread.uid, TPointer32.NULL, false, false);
            }
        } else if (entryAddr == 0 || entryAddr == -1) {
            Modules.log.info((Object)"sceKernelStartModule - no entry address");
            sceModule.start();
        } else {
            log.warn((Object)String.format("sceKernelStartModule - invalid entry address 0x%08X", entryAddr));
            return -1;
        }
        return sceModule.modid;
    }

    protected int getSelfModuleId() {
        return Modules.ThreadManForUserModule.getCurrentThread().moduleid;
    }

    protected SceModule getSelfModule() {
        return Managers.modules.getModuleByUID(this.getSelfModuleId());
    }

    public int hleKernelUnloadModule(int uid) {
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        if (sceModule == null) {
            log.warn((Object)String.format("hleKernelUnloadModule unknown module UID 0x%X", uid));
            return -1;
        }
        if (sceModule.isModuleStarted() && !sceModule.isModuleStopped()) {
            log.warn((Object)String.format("hleKernelUnloadModule module 0x%X is still running!", uid));
            return -2147352264;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleKernelUnloadModule '%s'", sceModule.modname));
        }
        sceModule.unload();
        HLEModuleManager.getInstance().UnloadFlash0Module(sceModule);
        return sceModule.modid;
    }

    public boolean isSignChecked(String path) {
        return path != null && path.startsWith("flash0:");
    }

    public int getStartModuleHandler() {
        return this.startModuleHandler;
    }

    public void setStartModuleHandler(int startModuleHandler) {
        this.startModuleHandler = startModuleHandler;
    }

    @HLEFunction(nid=-1208719848, version=150, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelLoadModuleByID(int uid, @CanBeNull TPointer optionAddr) {
        String name = Modules.IoFileMgrForUserModule.getFileFilename(uid);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelLoadModuleByID name='%s'", name));
        }
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleByID options: %s", lmOption));
            }
        }
        LoadModuleContext loadModuleContext = new LoadModuleContext();
        loadModuleContext.fileName = name;
        loadModuleContext.uid = uid;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.byUid = true;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = this.isSignChecked(name);
        return this.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunctions(value={@HLEFunction(nid=-1753357434, version=150, checkInsideInterrupt=true, canModifyCode=true), @HLEFunction(nid=-1818344848, version=150, checkInsideInterrupt=true, canModifyCode=true)})
    public int sceKernelLoadModule(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModule options: %s", lmOption));
            }
        }
        LoadModuleContext loadModuleContext = new LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.flags = flags;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = this.isSignChecked(path.getString());
        return this.hleKernelLoadModule(loadModuleContext);
    }

    @HLEUnimplemented
    @HLEFunction(nid=1896833461, version=150, checkInsideInterrupt=true)
    public int sceKernelLoadModuleMs() {
        return 0;
    }

    @HLEFunction(nid=-114860648, version=150, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelLoadModuleBufferUsbWlan(int bufSize, @BufferInfo(lengthInfo=BufferInfo.LengthInfo.previousParameter, usage=BufferInfo.Usage.in) TPointer buffer, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleBufferUsbWlan options: %s", lmOption));
            }
        }
        LoadModuleContext loadModuleContext = new LoadModuleContext();
        loadModuleContext.fileName = buffer.toString();
        loadModuleContext.flags = flags;
        loadModuleContext.buffer = buffer.getAddress();
        loadModuleContext.bufferSize = bufSize;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        loadModuleContext.isSignChecked = false;
        return Modules.ModuleMgrForUserModule.hleKernelLoadModule(loadModuleContext);
    }

    @HLEFunctions(value={@HLEFunction(nid=1357955564, version=150, checkInsideInterrupt=true), @HLEFunction(nid=1073171953, version=150, checkInsideInterrupt=true)})
    public int sceKernelStartModule(int uid, int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        return this.hleKernelStartModule(uid, argSize, argp, statusAddr, optionAddr, true, null);
    }

    @HLEFunctions(value={@HLEFunction(nid=-771778518, version=150, checkInsideInterrupt=true), @HLEFunction(nid=-438957957, version=150, checkInsideInterrupt=true)})
    public int sceKernelStopModule(int uid, int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        SceKernelSMOption smOption = null;
        if (optionAddr.isNotNull()) {
            smOption = new SceKernelSMOption();
            smOption.read(optionAddr);
        }
        if (sceModule == null) {
            log.warn((Object)("sceKernelStopModule - unknown module UID 0x" + Integer.toHexString(uid)));
            return -2147352274;
        }
        statusAddr.setValue(0);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelStopModule '%s'", sceModule.modname));
        }
        if (sceModule.isFlashModule) {
            if (HLEModuleManager.getInstance().hasFlash0Module(sceModule.modname)) {
                log.info((Object)("IGNORING:sceKernelStopModule HLE module '" + sceModule.modname + "'"));
            } else {
                log.warn((Object)("IGNORING:sceKernelStopModule flash module '" + sceModule.modname + "'"));
            }
            sceModule.stop();
            return 0;
        }
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            int priority = 32;
            if (smOption != null && smOption.priority > 0) {
                priority = smOption.priority;
            } else if (sceModule.module_stop_thread_priority > 0) {
                priority = sceModule.module_stop_thread_priority;
            }
            int stackSize = 262144;
            if (smOption != null && smOption.stackSize > 0) {
                stackSize = smOption.stackSize;
            } else if (sceModule.module_stop_thread_stacksize > 0) {
                stackSize = sceModule.module_stop_thread_stacksize;
            }
            int mpidStack = sceModule.mpiddata;
            if (smOption != null && smOption.mpidStack > 0) {
                mpidStack = smOption.mpidStack;
            }
            int attribute = sceModule.module_stop_thread_attr;
            if (smOption != null) {
                attribute = smOption.attribute;
            }
            ThreadManForUser threadMan = Modules.ThreadManForUserModule;
            SceKernelThreadInfo currentThread = threadMan.getCurrentThread();
            SceKernelThreadInfo thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, priority, stackSize, attribute, 0, mpidStack);
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            sceModule.stop();
            threadMan.hleKernelStartThread(thread, argSize, argp, sceModule.gp_value);
            threadMan.hleKernelWaitThreadEnd(currentThread, thread.uid, TPointer32.NULL, false, false);
        } else if (sceModule.module_stop_func == 0) {
            log.info((Object)"sceKernelStopModule - module has no stop function");
            sceModule.stop();
        } else {
            if (sceModule.isModuleStopped()) {
                log.warn((Object)"sceKernelStopModule - module already stopped");
                return -2147352267;
            }
            log.warn((Object)String.format("sceKernelStopModule - invalid stop function 0x%08X", sceModule.module_stop_func));
            return -1;
        }
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=772346282, version=150, checkInsideInterrupt=true, canModifyCode=true), @HLEFunction(nid=947797161, version=150, checkInsideInterrupt=true, canModifyCode=true)})
    public int sceKernelUnloadModule(int uid) {
        return this.hleKernelUnloadModule(uid);
    }

    @HLEFunction(nid=-696915016, version=150, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelSelfStopUnloadModule(int exitCode, int argSize, @CanBeNull TPointer argp) {
        SceModule sceModule = this.getSelfModule();
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, 0, sceModule.mpiddata);
            thread.moduleid = sceModule.modid;
            thread.unloadModuleAtDeletion = true;
        } else {
            sceModule.stop();
            sceModule.unload();
        }
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argSize, argp, sceModule.gp_value);
        }
        return 0;
    }

    @HLEFunction(nid=-1892812992, version=150, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelStopUnloadSelfModuleWithStatus(int exitCode, int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        SceModule sceModule = this.getSelfModule();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceKernelStopUnloadSelfModuleWithStatus %s, exitCode=0x%X", sceModule, exitCode));
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        statusAddr.setValue(0);
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            statusAddr.setValue(0);
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, optionAddr.getAddress(), sceModule.mpiddata);
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            threadMan.getCurrentThread().exitStatus = exitCode;
            thread.unloadModuleAtDeletion = true;
        } else {
            sceModule.stop();
            sceModule.unload();
        }
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argSize, argp, sceModule.gp_value);
        }
        return 0;
    }

    @HLEFunction(nid=-870500711, version=150, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelStopUnloadSelfModule(int argSize, @CanBeNull TPointer argp, @CanBeNull TPointer32 statusAddr, @CanBeNull TPointer optionAddr) {
        SceModule sceModule = this.getSelfModule();
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("sceKernelStopUnloadSelfModule %s", sceModule));
        }
        ThreadManForUser threadMan = Modules.ThreadManForUserModule;
        SceKernelThreadInfo thread = null;
        statusAddr.setValue(0);
        if (Memory.isAddressGood(sceModule.module_stop_func)) {
            thread = threadMan.hleKernelCreateThread("SceModmgrStop", sceModule.module_stop_func, sceModule.module_stop_thread_priority, sceModule.module_stop_thread_stacksize, sceModule.module_stop_thread_attr, optionAddr.getAddress(), sceModule.mpiddata);
            thread.moduleid = sceModule.modid;
            thread.exitStatusAddr = statusAddr;
            thread.unloadModuleAtDeletion = true;
        } else {
            sceModule.stop();
            sceModule.unload();
        }
        threadMan.hleKernelExitDeleteThread();
        if (thread != null) {
            threadMan.hleKernelStartThread(thread, argSize, argp, sceModule.gp_value);
        }
        return 0;
    }

    @HLEFunction(nid=1682150882, version=150, checkInsideInterrupt=true)
    public int sceKernelGetModuleIdList(TPointer32 resultBuffer, int resultBufferSize, TPointer32 idCountAddr) {
        int idCount = 0;
        int resultBufferOffset = 0;
        for (SceModule module : Managers.modules.values()) {
            if (module.isFlashModule || !module.isLoaded) continue;
            if (resultBufferOffset < resultBufferSize) {
                resultBuffer.setValue(resultBufferOffset, module.modid);
                resultBufferOffset += 4;
            }
            ++idCount;
        }
        idCountAddr.setValue(idCount);
        return 0;
    }

    @HLEFunctions(value={@HLEFunction(nid=1955380953, version=150, checkInsideInterrupt=true), @HLEFunction(nid=582860543, version=150, checkInsideInterrupt=true)})
    public int sceKernelQueryModuleInfo(int uid, TPointer infoAddr) {
        SceModule sceModule = Managers.modules.getModuleByUID(uid);
        if (sceModule == null) {
            log.warn((Object)String.format("sceKernelQueryModuleInfo unknown module UID 0x%X", uid));
            return -1;
        }
        SceKernelModuleInfo moduleInfo = new SceKernelModuleInfo();
        moduleInfo.copy(sceModule);
        moduleInfo.write(infoAddr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelQueryModuleInfo returning %s", Utilities.getMemoryDump(infoAddr.getAddress(), Math.min(96, infoAddr.getValue32()))));
        }
        return 0;
    }

    @HLEFunction(nid=-257793131, version=150, checkInsideInterrupt=true)
    public int sceKernelGetModuleId() {
        int moduleId = this.getSelfModuleId();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("sceKernelGetModuleId returning 0x%X", moduleId));
        }
        return moduleId;
    }

    @HLEFunction(nid=-659082969, version=150, checkInsideInterrupt=true)
    public int sceKernelGetModuleIdByAddress(TPointer addr) {
        SceModule module = Managers.modules.getModuleByAddress(addr.getAddress());
        if (module == null) {
            log.warn((Object)String.format("sceKernelGetModuleIdByAddress addr=%s module not found", addr));
            return -1;
        }
        return module.modid;
    }

    @HLEFunctions(value={@HLEFunction(nid=-1582855080, version=150, canModifyCode=true), @HLEFunction(nid=-838175579, version=660, canModifyCode=true)})
    public int sceKernelLoadModuleDisc(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleDisc options: %s", lmOption));
            }
        }
        LoadModuleContext loadModuleContext = new LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.flags = flags;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.allocMem = true;
        return this.hleKernelLoadModule(loadModuleContext);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-17662527, version=271, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelLoadModuleDNAS(PspString path, TPointer key, int unknown, @CanBeNull TPointer32 optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleDNAS options: %s", lmOption));
            }
        }
        StringBuilder localFileName = new StringBuilder();
        IVirtualFileSystem vfs = Modules.IoFileMgrForUserModule.getVirtualFileSystem(path.getString(), localFileName);
        if (vfs != null) {
            IVirtualFile vFile = vfs.ioOpen(localFileName.toString(), 1, 0);
            if (vFile == null) {
                return -2147418110;
            }
        } else {
            return -2147418093;
        }
        return 0;
    }

    @HLEFunction(nid=-220671564, version=271, canModifyCode=true)
    public int sceKernelLoadModuleNpDrm(PspString path, int flags, @CanBeNull TPointer optionAddr) {
        SceKernelLMOption lmOption = null;
        if (optionAddr.isNotNull()) {
            lmOption = new SceKernelLMOption();
            lmOption.read(optionAddr);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("sceKernelLoadModuleNpDrm options: %s", lmOption));
            }
        }
        if (!Modules.scePspNpDrm_userModule.getDisableDLCStatus()) {
            log.warn((Object)String.format("sceKernelLoadModuleNpDrm detected encrypted DLC module: %s", path.getString()));
            return -2141910766;
        }
        LoadModuleContext loadModuleContext = new LoadModuleContext();
        loadModuleContext.fileName = path.getString();
        loadModuleContext.flags = flags;
        loadModuleContext.lmOption = lmOption;
        loadModuleContext.needModuleInfo = true;
        loadModuleContext.allocMem = true;
        return this.hleKernelLoadModule(loadModuleContext);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-456908516, version=150, checkInsideInterrupt=true, canModifyCode=true)
    public int sceKernelLoadModuleWithBlockOffset(PspString path, int memoryBlockId, int memoryBlockOffset, int flags) {
        return 0;
    }

    @HLEFunction(nid=-755250857, version=150)
    public int sceKernelGetModuleGPByAddress(int address, TPointer32 gpAddr) {
        SceModule module = Managers.modules.getModuleByAddress(address);
        if (module == null) {
            log.warn((Object)String.format("sceKernelGetModuleGPByAddress not found module address=0x%08X", address));
            return -1;
        }
        gpAddr.setValue(module.gp_value);
        return 0;
    }

    private class LoadModuleAction
    implements IAction {
        private LoadModuleContext loadModuleContext;

        public LoadModuleAction(LoadModuleContext loadModuleContext) {
            this.loadModuleContext = loadModuleContext;
        }

        @Override
        public void execute() {
            ModuleMgrForUser.this.hleKernelLoadModuleNow(this.loadModuleContext);
        }
    }

    public static class LoadModuleContext {
        public String fileName;
        public String moduleName;
        public int flags;
        public int uid;
        public int buffer;
        public int bufferSize;
        public SceKernelLMOption lmOption;
        public boolean byUid;
        public boolean needModuleInfo;
        public boolean allocMem;
        public int baseAddr;
        public int basePartition = 2;
        public SceKernelThreadInfo thread;
        public ByteBuffer moduleBuffer;
        public int moduleVersion;
        public int moduleElfVersion;
        public boolean isSignChecked;
        public Memory mem = Emulator.getMemory();

        public String toString() {
            return String.format("fileName='%s', moduleName='%s'", this.fileName, this.moduleName);
        }
    }
}

