/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.HLE.modules;

import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Random;
import javax.imageio.ImageIO;
import jpcsp.HLE.CanBeNull;
import jpcsp.HLE.HLEFunction;
import jpcsp.HLE.HLELogging;
import jpcsp.HLE.HLEModule;
import jpcsp.HLE.HLEUnimplemented;
import jpcsp.HLE.Modules;
import jpcsp.HLE.TPointer;
import jpcsp.HLE.TPointer32;
import jpcsp.HLE.modules.sceDisplay;
import jpcsp.Memory;
import jpcsp.graphics.RE.IRenderingEngine;
import jpcsp.graphics.RE.software.PixelColor;
import jpcsp.graphics.VideoEngine;
import jpcsp.memory.IMemoryReader;
import jpcsp.memory.IMemoryWriter;
import jpcsp.memory.ImageReader;
import jpcsp.memory.MemoryReader;
import jpcsp.memory.MemoryWriter;
import jpcsp.settings.Settings;
import jpcsp.util.Debug;
import jpcsp.util.Utilities;
import org.apache.log4j.Logger;

public class sceJpeg
extends HLEModule {
    public static Logger log = Modules.getLogger("sceJpeg");
    protected static final int PSP_JPEG_MJPEG_DHT_MODE = 0;
    protected static final int PSP_JPEG_MJPEG_NO_DHT_MODE = 1;
    protected int jpegWidth = 480;
    protected int jpegHeight = 272;
    protected HashMap<Integer, BufferedImage> bufferedImages;
    protected static final String uidPurpose = "sceJpeg-BufferedImage";
    protected static final boolean dumpJpegFile = false;

    @Override
    public void start() {
        this.bufferedImages = new HashMap();
        super.start();
    }

    @Override
    public void stop() {
        this.bufferedImages.clear();
        super.stop();
    }

    private static int clamp(float value) {
        return sceJpeg.clamp8bit((int)value);
    }

    public static int clamp8bit(int value) {
        return Math.min(255, Math.max(0, value));
    }

    private static int colorYCbCrToABGR(int y, int cb, int cr) {
        int r = sceJpeg.clamp8bit(y + (cr -= 128) + (cr >> 2) + (cr >> 3) + (cr >> 5));
        int g = sceJpeg.clamp8bit(y - (((cb -= 128) >> 2) + (cb >> 4) + (cb >> 5)) - ((cr >> 1) + (cr >> 3) + (cr >> 4) + (cr >> 5)));
        int b = sceJpeg.clamp8bit(y + cb + (cb >> 1) + (cb >> 2) + (cb >> 6));
        return PixelColor.getColorBGR(b, g, r) | 0xFF000000;
    }

    private static int colorARGBToYCbCr(int argb) {
        int r = argb >> 16 & 0xFF;
        int g = argb >> 8 & 0xFF;
        int b = argb & 0xFF;
        int y = sceJpeg.clamp(0.299f * (float)r + 0.587f * (float)g + 0.114f * (float)b);
        int cb = sceJpeg.clamp(-0.169f * (float)r - 0.331f * (float)g + 0.499f * (float)b + 128.0f);
        int cr = sceJpeg.clamp(0.499f * (float)r - 0.418f * (float)g - 0.0813f * (float)b + 128.0f);
        return PixelColor.getColorBGR(y, cb, cr);
    }

    private static int getY(int ycbcr) {
        return PixelColor.getBlue(ycbcr);
    }

    private static int getCb(int ycbcr) {
        return PixelColor.getGreen(ycbcr);
    }

    private static int getCr(int ycbcr) {
        return PixelColor.getRed(ycbcr);
    }

    protected static BufferedImage readJpegImage(TPointer jpegBuffer, int jpegBufferSize) {
        BufferedImage bufferedImage = null;
        byte[] buffer = sceJpeg.readJpegImageBytes(jpegBuffer, jpegBufferSize);
        ByteArrayInputStream imageInputStream = new ByteArrayInputStream(buffer);
        try {
            bufferedImage = ImageIO.read(imageInputStream);
            ((InputStream)imageInputStream).close();
        }
        catch (IOException e) {
            log.error((Object)"Error reading Jpeg image", (Throwable)e);
        }
        return bufferedImage;
    }

    protected static int getWidthHeight(int width, int height) {
        return width << 16 | height;
    }

    protected static int getWidth(int widthHeight) {
        return widthHeight >> 16 & 0xFFF;
    }

    protected static int getHeight(int widthHeight) {
        return widthHeight & 0xFFF;
    }

    protected static byte[] readJpegImageBytes(TPointer jpegBuffer, int jpegBufferSize) {
        byte[] buffer = new byte[jpegBufferSize];
        IMemoryReader memoryReader = MemoryReader.getMemoryReader(jpegBuffer.getAddress(), jpegBufferSize, 1);
        for (int i = 0; i < buffer.length; ++i) {
            buffer[i] = (byte)memoryReader.readNext();
        }
        return buffer;
    }

    protected static void dumpJpegFile(TPointer jpegBuffer, int jpegBufferSize) {
        byte[] buffer = sceJpeg.readJpegImageBytes(jpegBuffer, jpegBufferSize);
        try {
            FileOutputStream os = new FileOutputStream(String.format("%s%cImage%08X.jpeg", Settings.getInstance().readString("emu.tmppath"), Character.valueOf(File.separatorChar), jpegBuffer.getAddress()));
            ((OutputStream)os).write(buffer);
            ((OutputStream)os).close();
        }
        catch (IOException e) {
            log.error((Object)"Error dumping Jpeg file", (Throwable)e);
        }
    }

    protected void decodeImage(TPointer imageBuffer, BufferedImage bufferedImage, int width, int height, int bufferWidth, int pixelFormat, int startLine) {
        width = Math.min(width, bufferedImage.getWidth());
        height = Math.min(height, bufferedImage.getHeight());
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[pixelFormat];
        int lineWidth = Math.min(width, bufferWidth);
        int skipEndOfLine = Math.max(0, bufferWidth - lineWidth);
        IMemoryWriter memoryWriter = MemoryWriter.getMemoryWriter(imageBuffer.getAddress(), height * bufferWidth * bytesPerPixel, bytesPerPixel);
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = bufferedImage.getRGB(x, y + startLine);
                int abgr = ImageReader.colorARGBtoABGR(argb);
                memoryWriter.writeNext(abgr);
            }
            memoryWriter.skip(skipEndOfLine);
        }
        memoryWriter.flush();
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
    }

    private static void generateFakeImage(int dest_addr, int frameWidth, int imageWidth, int imageHeight, int pixelMode) {
        Memory mem = Memory.getInstance();
        Random random = new Random();
        int pixelSize = 3;
        int bytesPerPixel = sceDisplay.getPixelFormatBytes(pixelMode);
        for (int y = 0; y < imageHeight - 3 + 1; y += 3) {
            int address = dest_addr + y * frameWidth * bytesPerPixel;
            int width = Math.min(imageWidth, frameWidth);
            for (int x = 0; x < width; x += 3) {
                int j;
                int i;
                int n = random.nextInt(256);
                int color = 0xFF000000 | n << 16 | n << 8 | n;
                int pixelColor = Debug.getPixelColor(color, pixelMode);
                if (bytesPerPixel == 4) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write32(address + (i * frameWidth + j) * 4, pixelColor);
                        }
                    }
                } else if (bytesPerPixel == 2) {
                    for (i = 0; i < 3; ++i) {
                        for (j = 0; j < 3; ++j) {
                            mem.write16(address + (i * frameWidth + j) * 2, (short)pixelColor);
                        }
                    }
                }
                address += 3 * bytesPerPixel;
            }
        }
    }

    protected void generateFakeImage(TPointer imageBuffer, int width, int height, int bufferWidth, int pixelFormat) {
        sceJpeg.generateFakeImage(imageBuffer.getAddress(), bufferWidth, width, height, pixelFormat);
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + bufferWidth * height * sceDisplay.getPixelFormatBytes(pixelFormat));
    }

    public int hleGetYCbCrBufferSize(BufferedImage bufferedImage) {
        return (bufferedImage.getWidth() * bufferedImage.getHeight() >> 1) * 3;
    }

    public int hleJpegDecodeYCbCr(BufferedImage bufferedImage, TPointer yCbCrBuffer, int yCbCrBufferSize, int dhtMode) {
        int width = bufferedImage.getWidth();
        int height = bufferedImage.getHeight();
        int sizeY = width * height;
        int sizeCb = sizeY >> 2;
        int addressY = yCbCrBuffer.getAddress();
        int addressCb = addressY + sizeY;
        int addressCr = addressCb + sizeCb;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleJpegDecodeYCbCr 0x%08X, 0x%08X, 0x%08X", addressY, addressCb, addressCr));
        }
        int[] bufferCb = new int[sizeCb];
        int[] bufferCr = new int[sizeCb];
        IMemoryWriter imageWriterY = MemoryWriter.getMemoryWriter(addressY, sizeY, 1);
        for (int y = 0; y < height; ++y) {
            int indexCb = (y >> 1) * (width >> 1);
            for (int x = 0; x < width; x += 2) {
                int argb0 = bufferedImage.getRGB(x, y);
                int yCbCr0 = sceJpeg.colorARGBToYCbCr(argb0);
                int argb1 = bufferedImage.getRGB(x + 1, y);
                int yCbCr1 = sceJpeg.colorARGBToYCbCr(argb1);
                imageWriterY.writeNext(sceJpeg.getY(yCbCr0));
                imageWriterY.writeNext(sceJpeg.getY(yCbCr1));
                int n = indexCb;
                bufferCb[n] = bufferCb[n] + sceJpeg.getCb(yCbCr0);
                int n2 = indexCb;
                bufferCb[n2] = bufferCb[n2] + sceJpeg.getCb(yCbCr1);
                int n3 = indexCb;
                bufferCr[n3] = bufferCr[n3] + sceJpeg.getCr(yCbCr0);
                int n4 = indexCb++;
                bufferCr[n4] = bufferCr[n4] + sceJpeg.getCr(yCbCr1);
            }
        }
        imageWriterY.flush();
        IMemoryWriter imageWriterCb = MemoryWriter.getMemoryWriter(addressCb, sizeCb, 1);
        IMemoryWriter imageWriterCr = MemoryWriter.getMemoryWriter(addressCr, sizeCb, 1);
        for (int i = 0; i < sizeCb; ++i) {
            imageWriterCb.writeNext(bufferCb[i] >> 2);
            imageWriterCr.writeNext(bufferCr[i] >> 2);
        }
        imageWriterCb.flush();
        imageWriterCr.flush();
        return sceJpeg.getWidthHeight(width, height);
    }

    protected int hleJpegDecodeMJpegYCbCr(TPointer jpegBuffer, int jpegBufferSize, TPointer yCbCrBuffer, int yCbCrBufferSize, int dhtMode) {
        BufferedImage bufferedImage = sceJpeg.readJpegImage(jpegBuffer, jpegBufferSize);
        if (bufferedImage == null) {
            yCbCrBuffer.clear(yCbCrBufferSize);
            return sceJpeg.getWidthHeight(0, 0);
        }
        return this.hleJpegDecodeYCbCr(bufferedImage, yCbCrBuffer, yCbCrBufferSize, dhtMode);
    }

    protected int hleJpegCsc(TPointer imageBuffer, TPointer yCbCrBuffer, int widthHeight, int bufferWidth) {
        int height = sceJpeg.getHeight(widthHeight);
        int width = sceJpeg.getWidth(widthHeight);
        int pixelFormat = 3;
        int bytesPerPixel = IRenderingEngine.sizeOfTextureType[pixelFormat];
        int lineWidth = Math.min(width, bufferWidth);
        int skipEndOfLine = Math.max(0, bufferWidth - lineWidth);
        int imageSizeInBytes = height * bufferWidth * bytesPerPixel;
        IMemoryWriter imageWriter = MemoryWriter.getMemoryWriter(imageBuffer.getAddress(), imageSizeInBytes, bytesPerPixel);
        int sizeY = width * height;
        int sizeCb = sizeY >> 2;
        int addressY = yCbCrBuffer.getAddress();
        int addressCb = addressY + sizeY;
        int addressCr = addressCb + sizeCb;
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("hleJpegCsc addressY=0x%08X, addressCb=0x%08X, addressCr=0x%08X", addressY, addressCb, addressCr));
        }
        int[] bufferCb = new int[sizeCb];
        int[] bufferCr = new int[sizeCb];
        IMemoryReader imageReaderCb = MemoryReader.getMemoryReader(addressCb, sizeCb, 1);
        IMemoryReader imageReaderCr = MemoryReader.getMemoryReader(addressCr, sizeCb, 1);
        for (int i = 0; i < sizeCb; ++i) {
            bufferCb[i] = imageReaderCb.readNext();
            bufferCr[i] = imageReaderCr.readNext();
        }
        IMemoryReader imageReaderY = MemoryReader.getMemoryReader(addressY, sizeY, 1);
        for (int y = 0; y < height; ++y) {
            int indexCb = (y >> 1) * (width >> 1);
            int x = 0;
            while (x < width) {
                int y0 = imageReaderY.readNext();
                int y1 = imageReaderY.readNext();
                int cb = bufferCb[indexCb];
                int cr = bufferCr[indexCb];
                int abgr0 = sceJpeg.colorYCbCrToABGR(y0, cb, cr);
                int abgr1 = sceJpeg.colorYCbCrToABGR(y1, cb, cr);
                imageWriter.writeNext(abgr0);
                imageWriter.writeNext(abgr1);
                x += 2;
                ++indexCb;
            }
            imageWriter.skip(skipEndOfLine);
        }
        imageWriter.flush();
        VideoEngine.getInstance().addVideoTexture(imageBuffer.getAddress(), imageBuffer.getAddress() + imageSizeInBytes);
        return 0;
    }

    @HLEFunction(nid=79015426, version=271)
    public int sceJpegMJpegCsc(TPointer imageBuffer, TPointer yCbCrBuffer, int widthHeight, int bufferWidth) {
        return this.hleJpegCsc(imageBuffer, yCbCrBuffer, widthHeight, bufferWidth);
    }

    @HLEFunction(nid=1219887799, version=271)
    public int sceJpegDeleteMJpeg() {
        return 0;
    }

    @HLEFunction(nid=2100247935, version=271)
    public int sceJpegFinishMJpeg() {
        return 0;
    }

    @HLEFunction(nid=-1846618052, version=271)
    public int sceJpegDecodeMJpegYCbCr(TPointer jpegBuffer, int jpegBufferSize, TPointer yCbCrBuffer, int yCbCrBufferSize, int dhtMode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpegYCbCr jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        return this.hleJpegDecodeMJpegYCbCr(jpegBuffer, jpegBufferSize, yCbCrBuffer, yCbCrBufferSize, dhtMode);
    }

    @HLELogging(level="info")
    @HLEFunction(nid=-1656273252, version=271)
    public int sceJpegCreateMJpeg(int width, int height) {
        this.jpegWidth = width;
        this.jpegHeight = height;
        return 0;
    }

    @HLEFunction(nid=-1398902554, version=271)
    public int sceJpegInitMJpeg() {
        return 0;
    }

    @HLEFunction(nid=79248623, version=271)
    public int sceJpegDecodeMJpeg(TPointer jpegBuffer, int jpegBufferSize, TPointer imageBuffer, int dhtMode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpeg jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        int pixelFormat = 3;
        BufferedImage bufferedImage = sceJpeg.readJpegImage(jpegBuffer, jpegBufferSize);
        if (bufferedImage == null) {
            this.generateFakeImage(imageBuffer, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat);
        } else {
            this.decodeImage(imageBuffer, bufferedImage, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat, 0);
        }
        return sceJpeg.getWidthHeight(this.jpegWidth, this.jpegHeight);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1892962286, version=271)
    public int sceJpegGetOutputInfo(TPointer jpegBuffer, int jpegBufferSize, @CanBeNull TPointer32 colorInfoBuffer, int dhtMode) {
        BufferedImage bufferedImage;
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegGetOutputInfo jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        if (colorInfoBuffer.isNotNull()) {
            colorInfoBuffer.setValue(131586);
        }
        if ((bufferedImage = sceJpeg.readJpegImage(jpegBuffer, jpegBufferSize)) == null) {
            return 49152;
        }
        return this.hleGetYCbCrBufferSize(bufferedImage);
    }

    @HLEFunction(nid=1743842692, version=271)
    public int sceJpegCsc(TPointer imageBuffer, TPointer yCbCrBuffer, int widthHeight, int bufferWidth, int colorInfo) {
        return this.hleJpegCsc(imageBuffer, yCbCrBuffer, widthHeight, bufferWidth);
    }

    @HLEFunction(nid=1689713016, version=271)
    public int sceJpegDecodeMJpegSuccessively(TPointer jpegBuffer, int jpegBufferSize, TPointer imageBuffer, int dhtMode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpegSuccessively jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        int pixelFormat = 3;
        BufferedImage bufferedImage = sceJpeg.readJpegImage(jpegBuffer, jpegBufferSize);
        int width = this.jpegWidth;
        int height = this.jpegHeight;
        if (bufferedImage == null) {
            this.generateFakeImage(imageBuffer, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat);
        } else {
            this.decodeImage(imageBuffer, bufferedImage, this.jpegWidth, this.jpegHeight, this.jpegWidth, pixelFormat, 0);
            width = bufferedImage.getWidth();
            height = bufferedImage.getHeight();
        }
        return sceJpeg.getWidthHeight(width, height);
    }

    @HLEFunction(nid=578183895, version=271)
    public int sceJpegDecodeMJpegYCbCrSuccessively(TPointer jpegBuffer, int jpegBufferSize, TPointer yCbCrBuffer, int yCbCrBufferSize, int dhtMode) {
        if (log.isTraceEnabled()) {
            log.trace((Object)String.format("sceJpegDecodeMJpegYCbCrSuccessively jpegBuffer: %s", Utilities.getMemoryDump(jpegBuffer.getAddress(), jpegBufferSize)));
        }
        return this.hleJpegDecodeMJpegYCbCr(jpegBuffer, jpegBufferSize, yCbCrBuffer, yCbCrBufferSize, dhtMode);
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1603635772, version=271)
    public int sceJpeg_A06A75C4(int unknown1, int unknown2, int unknown3, int unknown4, int unknown5) {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=-1690942388, version=271)
    public int sceJpeg_9B36444C() {
        return 0;
    }

    @HLEUnimplemented
    @HLEFunction(nid=69581190, version=271)
    public int sceJpegDecompressAllImage() {
        return 0;
    }
}

