/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.crypto;

import java.nio.ByteBuffer;
import jpcsp.crypto.AES128;
import jpcsp.crypto.CryptoEngine;
import jpcsp.crypto.ECDSA;
import jpcsp.crypto.KeyVault;
import jpcsp.crypto.SHA1;
import jpcsp.settings.Settings;
import jpcsp.util.Utilities;
import libkirk.KirkEngine;

public class KIRK {
    private static final boolean useLibkirk = true;
    private static boolean libkirkInitialized = false;
    private byte[] priv_iv = new byte[16];
    private byte[] prng_data = new byte[20];
    public static final int PSP_KIRK_NOT_ENABLED = 1;
    public static final int PSP_KIRK_INVALID_MODE = 2;
    public static final int PSP_KIRK_INVALID_HEADER_HASH = 3;
    public static final int PSP_KIRK_INVALID_DATA_HASH = 4;
    public static final int PSP_KIRK_INVALID_SIG_CHECK = 5;
    public static final int PSP_KIRK_UNK1 = 6;
    public static final int PSP_KIRK_UNK2 = 7;
    public static final int PSP_KIRK_UNK3 = 8;
    public static final int PSP_KIRK_UNK4 = 9;
    public static final int PSP_KIRK_UNK5 = 10;
    public static final int PSP_KIRK_UNK6 = 11;
    public static final int PSP_KIRK_NOT_INIT = 12;
    public static final int PSP_KIRK_INVALID_OPERATION = 13;
    public static final int PSP_KIRK_INVALID_SEED = 14;
    public static final int PSP_KIRK_INVALID_SIZE = 15;
    public static final int PSP_KIRK_DATA_SIZE_IS_ZERO = 16;
    public static final int PSP_SUBCWR_NOT_16_ALGINED = 2314;
    public static final int PSP_SUBCWR_HEADER_HASH_INVALID = 2336;
    public static final int PSP_SUBCWR_BUFFER_TOO_SMALL = 4096;
    public static final int PSP_KIRK_CMD_DECRYPT_PRIVATE = 1;
    public static final int PSP_KIRK_CMD_ENCRYPT_SIGN = 2;
    public static final int PSP_KIRK_CMD_DECRYPT_SIGN = 3;
    public static final int PSP_KIRK_CMD_ENCRYPT = 4;
    public static final int PSP_KIRK_CMD_ENCRYPT_FUSE = 5;
    public static final int PSP_KIRK_CMD_ENCRYPT_USER = 6;
    public static final int PSP_KIRK_CMD_DECRYPT = 7;
    public static final int PSP_KIRK_CMD_DECRYPT_FUSE = 8;
    public static final int PSP_KIRK_CMD_DECRYPT_USER = 9;
    public static final int PSP_KIRK_CMD_PRIV_SIG_CHECK = 10;
    public static final int PSP_KIRK_CMD_SHA1_HASH = 11;
    public static final int PSP_KIRK_CMD_ECDSA_GEN_KEYS = 12;
    public static final int PSP_KIRK_CMD_ECDSA_MULTIPLY_POINT = 13;
    public static final int PSP_KIRK_CMD_PRNG = 14;
    public static final int PSP_KIRK_CMD_INIT = 15;
    public static final int PSP_KIRK_CMD_ECDSA_SIGN = 16;
    public static final int PSP_KIRK_CMD_ECDSA_VERIFY = 17;
    public static final int PSP_KIRK_CMD_CERT_VERIFY = 18;
    public static final int PSP_KIRK_CMD_MODE_CMD1 = 1;
    public static final int PSP_KIRK_CMD_MODE_CMD2 = 2;
    public static final int PSP_KIRK_CMD_MODE_CMD3 = 3;
    public static final int PSP_KIRK_CMD_MODE_ENCRYPT_CBC = 4;
    public static final int PSP_KIRK_CMD_MODE_DECRYPT_CBC = 5;

    private static int[] getAESKeyFromSeed(int seed) {
        if (seed < 0 || seed >= KeyVault.keyvault.length) {
            return null;
        }
        return KeyVault.keyvault[seed];
    }

    public KIRK() {
    }

    public KIRK(byte[] seed, int seedLength) {
        if (!libkirkInitialized) {
            long fuseId = 5124095577148911L;
            String fuseIdString = Settings.getInstance().readString("sceSysreg.fuseId", null);
            if (fuseIdString != null) {
                fuseId = Settings.parseLong(fuseIdString);
            }
            KirkEngine.kirk_init(fuseId);
            libkirkInitialized = true;
        }
    }

    private int executeKIRKCmd1(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int outPosition = out.position();
        ByteBuffer sigIn = in.duplicate();
        sigIn.order(in.order());
        int headerSize = AES128_CMAC_Header.SIZEOF();
        int headerOffset = in.position();
        AES128_CMAC_Header header = new AES128_CMAC_Header(in);
        if (header.mode != 1) {
            return 2;
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] k = new byte[16];
        for (int i = 0; i < KeyVault.kirkAESKey0.length; ++i) {
            k[i] = (byte)KeyVault.kirkAESKey0[i];
        }
        byte[] encryptedKeys = new byte[32];
        System.arraycopy(header.AES128Key, 0, encryptedKeys, 0, 16);
        System.arraycopy(header.CMACKey, 0, encryptedKeys, 16, 16);
        byte[] decryptedKeys = aes.decrypt(encryptedKeys, k, this.priv_iv);
        int sigCheck = this.executeKIRKCmd10(sigIn, size);
        if (decryptedKeys == null) {
            return sigCheck;
        }
        byte[] aesBuf = new byte[16];
        System.arraycopy(decryptedKeys, 0, aesBuf, 0, aesBuf.length);
        int elfDataSize = header.dataSize;
        int elfDataOffset = header.dataOffset;
        int paddedElfDataSize = Utilities.alignUp(elfDataSize, 15);
        byte[] inBuf = new byte[paddedElfDataSize];
        System.arraycopy(in.array(), elfDataOffset + headerOffset + headerSize, inBuf, 0, paddedElfDataSize);
        byte[] outBuf = aes.decrypt(inBuf, aesBuf, this.priv_iv);
        out.position(outPosition);
        out.put(outBuf, 0, elfDataSize);
        out.limit(elfDataSize);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd4(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int outPosition = out.position();
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 4) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        int[] key = KIRK.getAESKeyFromSeed(header.keySeed);
        if (key == null) {
            return 14;
        }
        byte[] encKey = new byte[16];
        for (int i = 0; i < encKey.length; ++i) {
            encKey[i] = (byte)key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[header.dataSize];
        in.get(inBuf, 0, header.dataSize);
        byte[] outBuf = aes.encrypt(inBuf, encKey, this.priv_iv);
        out.position(outPosition);
        out.putInt(5);
        out.putInt(header.unk1);
        out.putInt(header.unk2);
        out.putInt(header.keySeed);
        out.putInt(header.dataSize);
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd5(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int outPosition = out.position();
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 4) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        byte[] key = null;
        if (header.keySeed != 256) {
            return 15;
        }
        key = this.priv_iv;
        byte[] encKey = new byte[16];
        for (int i = 0; i < encKey.length; ++i) {
            encKey[i] = key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[header.dataSize];
        in.get(inBuf, 0, header.dataSize);
        byte[] outBuf = aes.encrypt(inBuf, encKey, this.priv_iv);
        out.position(outPosition);
        out.putInt(5);
        out.putInt(header.unk1);
        out.putInt(header.unk2);
        out.putInt(header.keySeed);
        out.putInt(header.dataSize);
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd7(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int outPosition = out.position();
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 5) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        int[] key = KIRK.getAESKeyFromSeed(header.keySeed);
        if (key == null) {
            return 14;
        }
        byte[] decKey = new byte[16];
        for (int i = 0; i < decKey.length; ++i) {
            decKey[i] = (byte)key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[header.dataSize];
        in.get(inBuf, 0, header.dataSize);
        byte[] outBuf = aes.decrypt(inBuf, decKey, this.priv_iv);
        out.position(outPosition);
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd8(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int outPosition = out.position();
        AES128_CBC_Header header = new AES128_CBC_Header(in);
        if (header.mode != 5) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        byte[] key = null;
        if (header.keySeed != 256) {
            return 15;
        }
        key = this.priv_iv;
        byte[] decKey = new byte[16];
        for (int i = 0; i < decKey.length; ++i) {
            decKey[i] = key[i];
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] inBuf = new byte[header.dataSize];
        in.get(inBuf, 0, header.dataSize);
        byte[] outBuf = aes.decrypt(inBuf, decKey, this.priv_iv);
        out.position(outPosition);
        out.put(outBuf);
        in.clear();
        return 0;
    }

    private int executeKIRKCmd10(ByteBuffer in, int size) {
        int i;
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int headerOffset = in.position();
        AES128_CMAC_Header header = new AES128_CMAC_Header(in);
        if (header.mode != 1 && header.mode != 2 && header.mode != 3) {
            return 2;
        }
        if (header.dataSize == 0) {
            return 16;
        }
        AES128 aes = new AES128("AES/CBC/NoPadding");
        byte[] k = new byte[16];
        for (int i2 = 0; i2 < KeyVault.kirkAESKey0.length; ++i2) {
            k[i2] = (byte)KeyVault.kirkAESKey0[i2];
        }
        byte[] encryptedKeys = new byte[32];
        System.arraycopy(header.AES128Key, 0, encryptedKeys, 0, 16);
        System.arraycopy(header.CMACKey, 0, encryptedKeys, 16, 16);
        byte[] decryptedKeys = aes.decrypt(encryptedKeys, k, this.priv_iv);
        byte[] cmacHeaderHash = new byte[16];
        byte[] cmacDataHash = new byte[16];
        byte[] cmacBuf = new byte[16];
        System.arraycopy(decryptedKeys, 16, cmacBuf, 0, cmacBuf.length);
        byte[] inBuf = new byte[in.capacity() - 96 - headerOffset];
        System.arraycopy(in.array(), headerOffset + 96, inBuf, 0, inBuf.length);
        aes.doInitCMAC(cmacBuf);
        aes.doUpdateCMAC(inBuf, 0, 48);
        cmacHeaderHash = aes.doFinalCMAC();
        int blockSize = header.dataSize;
        if (blockSize % 16 != 0) {
            blockSize += 16 - blockSize % 16;
        }
        aes.doInitCMAC(cmacBuf);
        aes.doUpdateCMAC(inBuf, 0, 48 + blockSize + header.dataOffset);
        cmacDataHash = aes.doFinalCMAC();
        for (i = 0; i < cmacHeaderHash.length; ++i) {
            if (cmacHeaderHash[i] == header.CMACHeaderHash[i]) continue;
            return 3;
        }
        for (i = 0; i < cmacDataHash.length; ++i) {
            if (cmacDataHash[i] == header.CMACDataHash[i]) continue;
            return 4;
        }
        return 0;
    }

    private int executeKIRKCmd11(ByteBuffer out, ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        int outPosition = out.position();
        SHA1_Header header = new SHA1_Header(in);
        SHA1 sha1 = new SHA1();
        size = size < header.dataSize ? size : header.dataSize;
        header.readData(in, size);
        out.position(outPosition);
        out.put(sha1.doSHA1(header.data, size));
        in.clear();
        return 0;
    }

    private int executeKIRKCmd12(ByteBuffer out, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (size != 60) {
            return 15;
        }
        ECDSA ecdsa = new ECDSA();
        ECDSAKeygenCtx ctx = new ECDSAKeygenCtx(out);
        ecdsa.setCurve();
        ECDSAKeygenCtx.access$2202(ctx, ecdsa.getPrivateKey());
        ctx.public_key = new ECDSAPoint(ecdsa.getPublicKey());
        ctx.write();
        return 0;
    }

    private int executeKIRKCmd13(ByteBuffer out, int outSize, ByteBuffer in, int inSize) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if ((inSize != 60 || outSize != 40) && outSize != inSize) {
            return 15;
        }
        ECDSA ecdsa = new ECDSA();
        ECDSAMultiplyCtx ctx = new ECDSAMultiplyCtx(in, out);
        ecdsa.setCurve();
        ecdsa.multiplyPublicKey(ctx.public_key.toByteArray(), ctx.multiplier);
        ctx.write();
        return 0;
    }

    private int executeKIRKCmd14(ByteBuffer out, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        byte[] temp = new byte[260];
        temp[0] = 0;
        temp[1] = 0;
        temp[2] = 1;
        temp[3] = 0;
        ByteBuffer bTemp = ByteBuffer.wrap(temp);
        byte[] key = new byte[]{-89, 46, 76, -74, -61, 52, -33, -123, 112, 1, 73, -4, -64, -121, -60, 119};
        int systime = (int)System.currentTimeMillis();
        System.arraycopy(this.prng_data, 0, temp, 4, 20);
        temp[24] = (byte)(systime & 0xFF);
        temp[25] = (byte)(systime >> 8 & 0xFF);
        temp[26] = (byte)(systime >> 16 & 0xFF);
        temp[27] = (byte)(systime >> 24 & 0xFF);
        System.arraycopy(key, 0, temp, 28, 16);
        ByteBuffer bPRNG = ByteBuffer.wrap(this.prng_data);
        this.executeKIRKCmd11(bPRNG, bTemp, 260);
        out.put(bPRNG.array());
        for (int i = 0; i < size; i += 20) {
            int remaining = size % 20;
            int block = size / 20;
            if (block > 0) {
                out.put(bPRNG.array());
                this.executeKIRKCmd14(out, i);
                continue;
            }
            if (remaining <= 0) continue;
            out.put(this.prng_data, out.position(), remaining);
            i += remaining;
        }
        out.rewind();
        return 0;
    }

    private int executeKIRKCmd16(ByteBuffer out, int outSize, ByteBuffer in, int inSize) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (inSize != 52 || outSize != 40) {
            return 15;
        }
        return 0;
    }

    private int executeKIRKCmd17(ByteBuffer in, int size) {
        if (!CryptoEngine.getCryptoEngineStatus()) {
            return 12;
        }
        if (size != 100) {
            return 15;
        }
        return 0;
    }

    private int executeKIRKCmd15(ByteBuffer out, int outSize, ByteBuffer in, int inSize) {
        if (outSize != 28 && inSize < 8) {
            return 15;
        }
        long input = Utilities.endianSwap64(in.getLong());
        long output = input + 1L;
        out.putLong(Utilities.endianSwap64(output));
        out.putInt(305419896);
        out.putInt(305419896);
        out.putInt(305419896);
        out.putInt(305419896);
        out.putInt(305419896);
        return 0;
    }

    public int hleUtilsBufferCopyWithRange(ByteBuffer out, int outsize, ByteBuffer in, int insize, int cmd) {
        return this.hleUtilsBufferCopyWithRange(out, outsize, in, insize, insize, cmd);
    }

    public int hleUtilsBufferCopyWithRange(ByteBuffer out, int outsize, ByteBuffer in, int insizeAligned, int insize, int cmd) {
        return this.libkirkUtilsBufferCopyWithRange(out, outsize, in, insizeAligned, insize, cmd);
    }

    private int libkirkUtilsBufferCopyWithRange(ByteBuffer out, int outsize, ByteBuffer in, int insizeAligned, int insize, int cmd) {
        byte[] inbuff = new byte[insize];
        if (insize > 0) {
            int inPosition = in.position();
            in.get(inbuff, 0, insize);
            in.position(inPosition);
        }
        switch (cmd) {
            case 7: 
            case 8: {
                outsize = Utilities.readUnaligned32(inbuff, 16);
                break;
            }
            case 4: 
            case 5: {
                outsize = Utilities.readUnaligned32(inbuff, 16) + 20;
                break;
            }
            case 1: {
                int dataSize = Utilities.readUnaligned32(inbuff, 112);
                outsize = Utilities.alignUp(dataSize, 15);
            }
        }
        byte[] outbuff = new byte[outsize];
        int outPosition = 0;
        if (outsize > 0) {
            outPosition = out.position();
            out.get(outbuff, 0, outsize);
        }
        int result = KirkEngine.sceUtilsBufferCopyWithRange(outbuff, 0, outsize, inbuff, 0, insize, cmd);
        if (outsize > 0) {
            out.position(outPosition);
            out.put(outbuff, 0, outsize);
        }
        return result;
    }

    private static class ECDSAVerifyCtx {
        private ECDSAPoint public_key = new ECDSAPoint();
        private byte[] hash = new byte[20];
        private ECDSASig sig = new ECDSASig();

        private ECDSAVerifyCtx(ByteBuffer buf) {
            buf.get(this.public_key.x, 0, 20);
            buf.get(this.public_key.y, 0, 20);
            buf.get(this.hash, 0, 20);
            buf.get(this.sig.r, 0, 20);
            buf.get(this.sig.s, 0, 20);
        }
    }

    private static class ECDSASignCtx {
        private byte[] enc = new byte[32];
        private byte[] hash = new byte[20];

        private ECDSASignCtx(ByteBuffer buf) {
            buf.get(this.enc, 0, 32);
            buf.get(this.hash, 0, 20);
        }
    }

    private static class ECDSAMultiplyCtx {
        private byte[] multiplier = new byte[20];
        private ECDSAPoint public_key = new ECDSAPoint();
        private ByteBuffer out;

        private ECDSAMultiplyCtx(ByteBuffer input, ByteBuffer output) {
            this.out = output;
            input.get(this.multiplier, 0, 20);
            input.get(this.public_key.x, 0, 20);
            input.get(this.public_key.y, 0, 20);
        }

        public void write() {
            this.out.put(this.multiplier);
            this.out.put(this.public_key.toByteArray());
        }
    }

    private static class ECDSAKeygenCtx {
        private byte[] private_key = new byte[20];
        private ECDSAPoint public_key = new ECDSAPoint();
        private ByteBuffer out;

        private ECDSAKeygenCtx(ByteBuffer output) {
            this.out = output;
        }

        public void write() {
            this.out.put(this.private_key);
            this.out.put(this.public_key.toByteArray());
        }

        static /* synthetic */ byte[] access$2202(ECDSAKeygenCtx x0, byte[] x1) {
            x0.private_key = x1;
            return x1;
        }
    }

    private static class ECDSAPoint {
        private byte[] x = new byte[20];
        private byte[] y = new byte[20];

        private ECDSAPoint() {
        }

        private ECDSAPoint(byte[] data) {
            System.arraycopy(data, 0, this.x, 0, 20);
            System.arraycopy(data, 20, this.y, 0, 20);
        }

        public byte[] toByteArray() {
            byte[] point = new byte[40];
            System.arraycopy(point, 0, this.x, 0, 20);
            System.arraycopy(point, 20, this.y, 0, 20);
            return point;
        }
    }

    private static class ECDSASig {
        private byte[] r = new byte[20];
        private byte[] s = new byte[20];

        private ECDSASig() {
        }
    }

    protected static class AES128_CMAC_ECDSA_Header {
        private byte[] AES128Key = new byte[16];
        private byte[] ECDSAHeaderSig_r = new byte[20];
        private byte[] ECDSAHeaderSig_s = new byte[20];
        private byte[] ECDSADataSig_r = new byte[20];
        private byte[] ECDSADataSig_s = new byte[20];
        protected int mode;
        protected byte useECDSAhash;
        private byte[] unk1 = new byte[11];
        protected int dataSize;
        protected int dataOffset;
        private byte[] unk2 = new byte[8];
        private byte[] unk3 = new byte[16];

        public AES128_CMAC_ECDSA_Header(ByteBuffer buf) {
            buf.get(this.AES128Key, 0, 16);
            buf.get(this.ECDSAHeaderSig_r, 0, 20);
            buf.get(this.ECDSAHeaderSig_s, 0, 20);
            buf.get(this.ECDSADataSig_r, 0, 20);
            buf.get(this.ECDSADataSig_s, 0, 20);
            this.mode = buf.getInt();
            this.useECDSAhash = buf.get();
            buf.get(this.unk1, 0, 11);
            this.dataSize = buf.getInt();
            this.dataOffset = buf.getInt();
            buf.get(this.unk2, 0, 8);
            buf.get(this.unk3, 0, 16);
        }
    }

    protected static class AES128_CMAC_Header {
        private byte[] AES128Key = new byte[16];
        private byte[] CMACKey = new byte[16];
        private byte[] CMACHeaderHash = new byte[16];
        private byte[] CMACDataHash = new byte[16];
        private byte[] unk1 = new byte[32];
        private int mode;
        protected byte useECDSAhash;
        private byte[] unk2 = new byte[11];
        private int dataSize;
        private int dataOffset;
        private byte[] unk3 = new byte[8];
        private byte[] unk4 = new byte[16];

        public AES128_CMAC_Header(ByteBuffer buf) {
            buf.get(this.AES128Key, 0, 16);
            buf.get(this.CMACKey, 0, 16);
            buf.get(this.CMACHeaderHash, 0, 16);
            buf.get(this.CMACDataHash, 0, 16);
            buf.get(this.unk1, 0, 32);
            this.mode = buf.getInt();
            this.useECDSAhash = buf.get();
            buf.get(this.unk2, 0, 11);
            this.dataSize = buf.getInt();
            this.dataOffset = buf.getInt();
            buf.get(this.unk3, 0, 8);
            buf.get(this.unk4, 0, 16);
            if ((this.mode & 0xFFFFFF) == 0) {
                this.mode = Integer.reverseBytes(this.mode);
            }
        }

        public static int SIZEOF() {
            return 144;
        }
    }

    private static class AES128_CBC_Header {
        private int mode;
        private int unk1;
        private int unk2;
        private int keySeed;
        private int dataSize;

        public AES128_CBC_Header(ByteBuffer buf) {
            this.mode = buf.getInt();
            this.unk1 = buf.getInt();
            this.unk2 = buf.getInt();
            this.keySeed = buf.getInt();
            this.dataSize = buf.getInt();
        }
    }

    private class SHA1_Header {
        private int dataSize;
        private byte[] data;

        public SHA1_Header(ByteBuffer buf) {
            this.dataSize = buf.getInt();
        }

        private void readData(ByteBuffer buf, int size) {
            this.data = new byte[size];
            buf.get(this.data, 0, size);
        }
    }
}

