/*
 * Decompiled with CFR 0.152.
 */
package jpcsp.format.rco.vsmx.objects;

import jpcsp.format.rco.vsmx.VSMX;
import jpcsp.format.rco.vsmx.interpreter.VSMXArray;
import jpcsp.format.rco.vsmx.interpreter.VSMXBaseObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXBoolean;
import jpcsp.format.rco.vsmx.interpreter.VSMXInterpreter;
import jpcsp.format.rco.vsmx.interpreter.VSMXNativeObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXNumber;
import jpcsp.format.rco.vsmx.interpreter.VSMXObject;
import jpcsp.format.rco.vsmx.interpreter.VSMXUndefined;
import jpcsp.format.rco.vsmx.objects.BaseNativeObject;
import jpcsp.format.rco.vsmx.objects.Timer;
import org.apache.log4j.Logger;

public class GlobalVariables
extends BaseNativeObject {
    private static final Logger log = VSMX.log;
    private static final Logger logWriteln = Logger.getLogger((String)"writeln");
    private StringBuilder writeBuffer = new StringBuilder();

    public static VSMXNativeObject create(VSMXInterpreter interpreter) {
        GlobalVariables globalVariables = new GlobalVariables(interpreter);
        VSMXNativeObject object = new VSMXNativeObject(interpreter, globalVariables);
        globalVariables.setObject(object);
        object.setPropertyValue("undefined", (VSMXBaseObject)VSMXUndefined.singleton);
        object.setPropertyValue("Array", (VSMXBaseObject)new VSMXArray(interpreter));
        object.setPropertyValue("Object", (VSMXBaseObject)new VSMXObject(interpreter, null));
        object.setPropertyValue("timer", (VSMXBaseObject)Timer.create(interpreter));
        object.setPropertyValue("x", (VSMXBaseObject)new VSMXNumber(interpreter, 0));
        object.setPropertyValue("y", (VSMXBaseObject)new VSMXNumber(interpreter, 0));
        object.setPropertyValue("width", (VSMXBaseObject)new VSMXNumber(interpreter, 480));
        object.setPropertyValue("height", (VSMXBaseObject)new VSMXNumber(interpreter, 272));
        return object;
    }

    private GlobalVariables(VSMXInterpreter interpreter) {
    }

    private void writeln() {
        logWriteln.debug((Object)this.writeBuffer.toString());
        this.writeBuffer.setLength(0);
    }

    private void writeln(VSMXBaseObject object, VSMXBaseObject ... strings) {
        this.write(object, strings);
        this.writeln();
    }

    private void write(VSMXBaseObject object, VSMXBaseObject ... strings) {
        for (int i = 0; i < strings.length; ++i) {
            this.writeBuffer.append(strings[i].getStringValue());
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("write: '%s'", this.writeBuffer.toString()));
        }
    }

    public void write(VSMXBaseObject object, VSMXBaseObject s1) {
        this.write(object, new VSMXBaseObject[]{s1});
    }

    public void writeln(VSMXBaseObject object) {
        this.writeln();
    }

    public void writeln(VSMXBaseObject object, VSMXBaseObject s1) {
        this.writeln(object, new VSMXBaseObject[]{s1});
    }

    public void writeln(VSMXBaseObject object, VSMXBaseObject s1, VSMXBaseObject s2) {
        this.writeln(object, new VSMXBaseObject[]{s1, s2});
    }

    public void writeln(VSMXBaseObject object, VSMXBaseObject s1, VSMXBaseObject s2, VSMXBaseObject s3) {
        this.writeln(object, new VSMXBaseObject[]{s1, s3});
    }

    public void writeln(VSMXBaseObject object, VSMXBaseObject s1, VSMXBaseObject s2, VSMXBaseObject s3, VSMXBaseObject s4) {
        this.writeln(object, new VSMXBaseObject[]{s1, s3, s4});
    }

    public void writeln(VSMXBaseObject object, VSMXBaseObject s1, VSMXBaseObject s2, VSMXBaseObject s3, VSMXBaseObject s4, VSMXBaseObject s5) {
        this.writeln(object, new VSMXBaseObject[]{s1, s3, s4, s5});
    }

    public void writeln(VSMXBaseObject object, VSMXBaseObject s1, VSMXBaseObject s2, VSMXBaseObject s3, VSMXBaseObject s4, VSMXBaseObject s5, VSMXBaseObject s6) {
        this.writeln(object, new VSMXBaseObject[]{s1, s3, s4, s5, s6});
    }

    public VSMXBaseObject parseFloat(VSMXBaseObject object, VSMXBaseObject value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("parseFloat: %s", value));
        }
        return new VSMXNumber(object.getInterpreter(), value.getFloatValue());
    }

    public VSMXBaseObject parseInt(VSMXBaseObject object, VSMXBaseObject value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("parseInt: %s", value));
        }
        return new VSMXNumber(object.getInterpreter(), value.getIntValue());
    }

    public VSMXBaseObject isNaN(VSMXBaseObject object, VSMXBaseObject value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("isNaN: %s", value));
        }
        boolean isNaN = Float.isNaN(value.getFloatValue());
        return VSMXBoolean.getValue(isNaN);
    }

    public VSMXBaseObject Float(VSMXBaseObject object, VSMXBaseObject value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Float: %s", value));
        }
        return new VSMXNumber(object.getInterpreter(), value.getFloatValue());
    }

    public VSMXBaseObject Int(VSMXBaseObject object, VSMXBaseObject value) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Int: %s", value));
        }
        return new VSMXNumber(object.getInterpreter(), value.getIntValue());
    }
}

